/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.lib.xml.parser.handlers.SimpleAttr;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLNode;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDLExtension
extends WSDLNode {
    private String localName;
    private String uri;
    private ArrayList attributes = new ArrayList();
    private ArrayList children = new ArrayList();

    public WSDLExtension() {
    }

    public WSDLExtension(WSDLNode parent) {
        super(parent);
    }

    public void setLocalName(String name) {
        this.localName = name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void addAttribute(Object attrib) {
        this.attributes.add(attrib);
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public SimpleAttr removeAttribute(SimpleAttr obj) {
        int i = 0;
        while (i < this.attributes.size()) {
            SimpleAttr temp = (SimpleAttr)this.attributes.get(i);
            if (temp.localName.equals(obj.localName)) {
                return (SimpleAttr)this.attributes.remove(i);
            }
            ++i;
        }
        return null;
    }

    public void setAttribute(SimpleAttr obj) {
        this.removeAttribute(obj);
        this.addAttribute(obj);
    }

    public String getAttribute(String name) {
        int i = 0;
        while (i < this.attributes.size()) {
            SimpleAttr attr = (SimpleAttr)this.attributes.get(i);
            if (attr.localName.equals(name)) {
                return attr.value;
            }
            ++i;
        }
        return null;
    }

    public void addChild(WSDLNode child) {
        this.children.add(child);
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public WSDLExtension getChild(int index) {
        return (WSDLExtension)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public void loadAttributes(SimpleAttr[] attr, int attrCount) throws WSDLException {
        int i = 0;
        while (i < attrCount) {
            SimpleAttr perm = new SimpleAttr();
            perm.localName = attr[i].localName;
            perm.uri = attr[i].uri;
            perm.value = attr[i].value;
            this.attributes.add(perm);
            ++i;
        }
    }

    public void loadAttributes(Element element) {
        NamedNodeMap elementAttr = element.getAttributes();
        int i = 0;
        while (i < elementAttr.getLength()) {
            Node node = elementAttr.item(i);
            if (node.getNodeType() == 2) {
                SimpleAttr perm = new SimpleAttr();
                Attr attribute = (Attr)node;
                perm.localName = attribute.getLocalName();
                perm.value = attribute.getValue();
                perm.uri = attribute.getNamespaceURI();
                this.attributes.add(perm);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("localName: {" + this.localName + "} uri: {" + this.uri + "} Attributes: {" + this.attributes + "}\n").append("*****Childs*******\n");
        int i = 0;
        while (i < this.children.size()) {
            result.append(this.children.get(i).toString() + "\n");
            ++i;
        }
        result.append("****end Childs****\n");
        return result.toString();
    }

    public void setAttribute(String localName, String value, String uri) {
        this.setAttribute(new SimpleAttr(localName, value, uri));
    }
}

