/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.wsdl.AbstractWSDLDefinitionsParser;
import com.sap.engine.services.webservices.wsdl.SAPFeature;
import com.sap.engine.services.webservices.wsdl.SAPOption;
import com.sap.engine.services.webservices.wsdl.SAPProperty;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLFault;
import com.sap.engine.services.webservices.wsdl.WSDLImport;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLDefinitionsParser
extends AbstractWSDLDefinitionsParser {
    public WSDLDefinitionsParser() {
        this.init();
    }

    public void init() {
        try {
            this.doc = AbstractWSDLDefinitionsParser.factory.newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document parse(WSDLDefinitions def) throws WSDLException {
        this.def = def;
        this.root = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:definitions");
        this.parseDocumentation(this.root, def);
        if (def.getName() != null) {
            this.root.setAttribute("name", def.getName());
        }
        if (def.targetNamespace != null) {
            this.root.setAttribute("targetNamespace", def.targetNamespace);
        }
        if (def.xsdNamespace != null) {
            this.root.setAttribute("xmlns:xs", def.xsdNamespace);
        }
        Hashtable attributes = def.getAdditionalAttributes();
        Enumeration en = attributes.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.root.setAttribute(key, (String)attributes.get(key));
        }
        this.parseDefinitions();
        this.doc.appendChild(this.root);
        return this.doc;
    }

    public void parseDefinitionsToFile(WSDLDefinitions def, File outputFile) throws IOException, WSDLException {
        FileOutputStream out = new FileOutputStream(outputFile);
        try {
            this.writeDefintionsToStream(def, out);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void writeDefintionsToStream(WSDLDefinitions def, OutputStream stream) throws IOException, WSDLException {
        Document doc = this.parse(def);
        try {
            Transformer transformer = AbstractWSDLDefinitionsParser.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(stream));
            stream.flush();
        }
        catch (TransformerConfigurationException e) {
            throw new WSDLException("Invalid transformer configuration", e);
        }
        catch (TransformerException e) {
            throw new WSDLException("Error in transforming", e);
        }
    }

    private void parseDefinitions() throws WSDLException {
        this.doc.appendChild(this.doc.createComment("            Generated by WSDLDefinitionsParser    "));
        ArrayList usedForAll = this.def.getImportDeclaratuions();
        int i = 0;
        while (i < usedForAll.size()) {
            this.parseImport((WSDLImport)usedForAll.get(i));
            ++i;
        }
        this.parseSchema(this.def.getSchemaDefinitions());
        usedForAll = this.def.getMessages();
        i = 0;
        while (i < usedForAll.size()) {
            this.parseMessage((WSDLMessage)usedForAll.get(i));
            ++i;
        }
        usedForAll = this.def.getFeatures();
        i = 0;
        while (i < usedForAll.size()) {
            this.parseFeature((SAPFeature)usedForAll.get(i));
            ++i;
        }
        usedForAll = this.def.portTypes;
        i = 0;
        while (i < usedForAll.size()) {
            this.parsePortType((WSDLPortType)usedForAll.get(i));
            ++i;
        }
        usedForAll = this.def.getBindings();
        i = 0;
        while (i < usedForAll.size()) {
            this.parseBinding((WSDLBinding)usedForAll.get(i));
            ++i;
        }
        usedForAll = this.def.getServices();
        i = 0;
        while (i < usedForAll.size()) {
            this.parseServices((WSDLService)usedForAll.get(i));
            ++i;
        }
    }

    private void parseFeature(SAPFeature feature) {
        Element feElement = this.doc.createElementNS("http://www.sap.com/webas/630/wsdl/features", "sap:Feature");
        String name = feature.getName();
        String uri = feature.getUri();
        feElement.setAttribute("name", name);
        feElement.setAttribute("uri", uri);
        ArrayList propList = feature.getProperties();
        int i = 0;
        while (i < propList.size()) {
            SAPProperty tmpProperty = (SAPProperty)propList.get(i);
            Element propElement = this.doc.createElementNS("http://www.sap.com/webas/630/wsdl/features", "sap:Property");
            propElement.setAttribute("qname", tmpProperty.getQname().getQName());
            ArrayList optionList = tmpProperty.getOptions();
            int j = 0;
            while (j < optionList.size()) {
                Element optionElement = this.doc.createElementNS("http://www.sap.com/webas/630/wsdl/features", "sap:Option");
                SAPOption tmpOption = (SAPOption)optionList.get(j);
                optionElement.setAttribute("value", tmpOption.getValue());
                propElement.appendChild(optionElement);
                ++j;
            }
            feElement.appendChild(propElement);
            ++i;
        }
        this.root.appendChild(feElement);
    }

    private void parseImport(WSDLImport iMport) {
        Element importElement = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:import");
        importElement.setAttribute("location", iMport.getLocation());
        importElement.setAttribute("namespace", iMport.getNamespace());
        this.root.appendChild(importElement);
    }

    private void parseSchema(ArrayList list) {
        if (list != null && list.size() > 0) {
            Element typesElement = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:types");
            int i = 0;
            while (i < list.size()) {
                this.root.appendChild(typesElement);
                Node el = ((DOMSource)list.get(i)).getNode();
                Node el2 = this.root.getOwnerDocument().importNode(el, true);
                typesElement.appendChild(el2);
                ++i;
            }
        }
    }

    private void parseMessage(WSDLMessage mes) throws WSDLException {
        Element elMess = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:message");
        elMess.setAttribute("name", mes.getName());
        this.parseDocumentation(elMess, mes);
        ArrayList parts = mes.getParts();
        int i = 0;
        while (i < parts.size()) {
            this.parsePart((WSDLPart)parts.get(i), elMess);
            ++i;
        }
        this.root.appendChild(elMess);
    }

    private void parsePart(WSDLPart part, Element parent) throws WSDLException {
        String typeEl;
        QName qName = part.getType();
        int style = part.getStyle();
        if (style == 2) {
            typeEl = "type";
        } else if (style == 1) {
            typeEl = "element";
        } else {
            throw new WSDLException("This is not a valid attribute for a part element");
        }
        Element elPart = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:part");
        elPart.setAttribute("name", part.getName());
        elPart.setAttribute(typeEl, qName.getQName());
        parent.appendChild(elPart);
    }

    private void parsePortType(WSDLPortType pType) {
        ArrayList operations = pType.getOperations();
        Element elPortType = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:portType");
        elPortType.setAttribute("name", pType.getName());
        this.parseDocumentation(elPortType, pType);
        this.parseUseFeatures(elPortType, pType.getUseFeatures());
        int i = 0;
        while (i < operations.size()) {
            this.parseOperation((WSDLOperation)operations.get(i), elPortType);
            ++i;
        }
        this.root.appendChild(elPortType);
    }

    private void parseOperation(WSDLOperation operation, Element parent) {
        Element inoutEl;
        WSDLChannel inoutChannel = operation.getInput();
        Element operationEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:operation");
        operationEl.setAttribute("name", operation.getName());
        this.parseDocumentation(operationEl, operation);
        this.parseUseFeatures(operationEl, operation.getUseFeatures());
        if (operation.getParameterOrder() != null && !operation.getParameterOrder().equals("")) {
            operationEl.setAttribute("parameterOrder", operation.getParameterOrder());
        }
        if (inoutChannel != null) {
            inoutEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:input");
            if (inoutChannel.getName() != null) {
                inoutEl.setAttribute("name", inoutChannel.getName());
            }
            this.parseDocumentation(inoutEl, inoutChannel);
            inoutEl.setAttribute("message", inoutChannel.getMessage().getQName());
            operationEl.appendChild(inoutEl);
        }
        if ((inoutChannel = operation.getOutput()) != null) {
            inoutEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:output");
            if (inoutChannel.getName() != null) {
                inoutEl.setAttribute("name", inoutChannel.getName());
            }
            this.parseDocumentation(inoutEl, inoutChannel);
            inoutEl.setAttribute("message", inoutChannel.getMessage().getQName());
            operationEl.appendChild(inoutEl);
        }
        ArrayList faults = operation.getFaultList();
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            Element faultEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:fault");
            if (fault.getName() != null) {
                faultEl.setAttribute("name", fault.getName());
            }
            this.parseDocumentation(faultEl, fault);
            faultEl.setAttribute("message", fault.getMessage().getQName());
            operationEl.appendChild(faultEl);
            ++i;
        }
        parent.appendChild(operationEl);
    }

    private void parseServices(WSDLService service) throws WSDLException {
        Element serviceEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:service");
        serviceEl.setAttribute("name", service.getName());
        this.parseDocumentation(serviceEl, service);
        ArrayList ports = service.getPorts();
        int i = 0;
        while (i < ports.size()) {
            this.parsePort((WSDLPort)ports.get(i), serviceEl);
            ++i;
        }
        this.root.appendChild(serviceEl);
    }

    private void parsePort(WSDLPort port, Element parent) throws WSDLException {
        Element portEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:port");
        portEl.setAttribute("name", port.getName());
        portEl.setAttribute("binding", port.getBinding().getQName());
        this.parseDocumentation(portEl, port);
        WSDLExtension extension = port.getExtension();
        this.parseExtensionElement(extension, portEl);
        parent.appendChild(portEl);
    }
}

