/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.lib.xml.parser.handlers.SimpleAttr;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import com.sap.engine.services.webservices.wsdl.SAPFeature;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitionsParser;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLNamedNode;
import com.sap.engine.services.webservices.wsdl.WSDLNode;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import com.sap.engine.services.webservices.wsdl.WSDLTypes;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDLDefinitions
extends WSDLNamedNode {
    public String targetNamespace;
    public WSDLTypes types;
    public ArrayList messages;
    public ArrayList portTypes;
    public ArrayList bindings;
    public ArrayList services;
    public ArrayList features;
    public ArrayList extensions;
    public ArrayList importDeclaratuions;
    public String xsdNamespace = null;
    private String systemId;
    private ArrayList schemaDefinitions;
    private Hashtable mirrorMapping;
    private Hashtable mirrorLocations;
    private SchemaToJavaGenerator schemaInfo;
    private Hashtable additionalAttrs = new Hashtable();

    public boolean isSapWsdl() {
        Element elementContent;
        WSDLDocumentation documentation = this.getDocumentation();
        return documentation != null && (elementContent = documentation.getElementContent()) != null && elementContent.getLocalName().equals("SAP_WSDL") && "http://www.sap.com/webas".equals(elementContent.getNamespaceURI());
    }

    public boolean isSapOrigin() {
        Element contentElement;
        WSDLDocumentation documentation = this.getDocumentation();
        return documentation != null && (contentElement = documentation.getElementContent()) != null && WSDLDOMLoader.WSDL_SAP_NAMESPACE.equals(contentElement.getNamespaceURI()) && "SAP_WS".equals(contentElement.getLocalName());
    }

    public ArrayList getImportDeclaratuions() {
        return this.importDeclaratuions;
    }

    public void setImportDeclaratuions(ArrayList importDeclaratuions) {
        this.importDeclaratuions = importDeclaratuions;
    }

    public WSDLDefinitions() {
        this.targetNamespace = null;
        this.types = null;
        this.messages = new ArrayList();
        this.portTypes = new ArrayList();
        this.bindings = new ArrayList();
        this.services = new ArrayList();
        this.schemaDefinitions = new ArrayList();
        this.importDeclaratuions = new ArrayList();
        this.features = new ArrayList();
        this.mirrorMapping = null;
        this.mirrorLocations = new Hashtable();
        this.extensions = new ArrayList();
    }

    public void addExtension(WSDLExtension extension) {
        this.extensions.add(extension);
    }

    public ArrayList getExtensions() {
        return this.extensions;
    }

    public WSDLDefinitions(WSDLNode parent) {
        super(parent);
        this.types = null;
        this.messages = new ArrayList();
        this.portTypes = new ArrayList();
        this.bindings = new ArrayList();
        this.services = new ArrayList();
        this.schemaDefinitions = new ArrayList();
        this.importDeclaratuions = new ArrayList();
        this.features = new ArrayList();
        this.mirrorMapping = null;
        this.mirrorLocations = new Hashtable();
        this.extensions = new ArrayList();
    }

    public void setMirrorMapping(Hashtable mirrorMapping) {
        this.mirrorMapping = mirrorMapping;
    }

    public void setMirrorLocation(String localPath, String remoteLocation) {
        this.mirrorLocations.put(localPath, remoteLocation);
    }

    public Hashtable getMirrorLocations() {
        return this.mirrorLocations;
    }

    public Hashtable getMirrorMapping() {
        return this.mirrorMapping;
    }

    private String getSchemaNamespace(Node node) {
        Element element;
        String result = "";
        if (node.getNodeType() == 1 && "http://www.w3.org/2001/XMLSchema".equals((element = (Element)node).getNamespaceURI()) && "schema".equals(element.getLocalName())) {
            result = element.getAttribute("targetNamespace");
        }
        return result;
    }

    public void addSchema(DOMSource schemaSource, String namespace) {
        String currentns = this.getSchemaNamespace(schemaSource.getNode());
        if (currentns.length() == 0) {
            currentns = namespace;
        }
        int i = 0;
        while (i < this.schemaDefinitions.size()) {
            DOMSource source = (DOMSource)this.schemaDefinitions.get(i);
            String onamespace = this.getSchemaNamespace(source.getNode());
            if (onamespace.equals(currentns)) {
                return;
            }
            ++i;
        }
        this.schemaDefinitions.add(schemaSource);
    }

    public void addSchema(DOMSource schemaSource) {
        String currentns = this.getSchemaNamespace(schemaSource.getNode());
        int i = 0;
        while (i < this.schemaDefinitions.size()) {
            DOMSource source = (DOMSource)this.schemaDefinitions.get(i);
            String namespace = this.getSchemaNamespace(source.getNode());
            if (namespace.equals(currentns)) {
                return;
            }
            ++i;
        }
        this.schemaDefinitions.add(schemaSource);
    }

    public ArrayList getSchemaDefinitions() {
        return this.schemaDefinitions;
    }

    public void loadAttributes(SimpleAttr[] attr, int attrCount) throws WSDLException {
        String name = SimpleAttr.getAttribute((String)"name", (SimpleAttr[])attr, (int)attrCount);
        if (name != null) {
            this.name = name;
        }
        this.targetNamespace = SimpleAttr.getAttribute((String)"targetNamespace", (SimpleAttr[])attr, (int)attrCount);
    }

    public void loadAttributes(Element element) throws WSDLException {
        NamedNodeMap nodeMap = element.getAttributes();
        int length = nodeMap.getLength();
        int i = 0;
        while (i < length) {
            Attr attribute = (Attr)nodeMap.item(i);
            if (attribute.getName().equals("name")) {
                super.setName(attribute.getValue());
            } else if (attribute.getName().equals("targetNamespace")) {
                this.targetNamespace = attribute.getValue();
            } else {
                this.addAdditionalAttribute(attribute.getName(), attribute.getValue());
            }
            ++i;
        }
        if (this.targetNamespace == null) {
            throw new WSDLException(" WSDL 'definitions' must have 'targetNamespace' attribute !");
        }
    }

    public WSDLPortType getPortType(String portTypeName, String namespace) {
        int i = 0;
        while (i < this.portTypes.size()) {
            WSDLPortType perm = (WSDLPortType)this.portTypes.get(i);
            if (perm.getName().equals(portTypeName) && (namespace == null ? perm.getNamespace() == null : namespace.equals(perm.getNamespace()))) {
                return perm;
            }
            ++i;
        }
        return null;
    }

    public WSDLMessage getMessage(String messageName, String namespace) {
        int i = 0;
        while (i < this.messages.size()) {
            WSDLMessage perm = (WSDLMessage)this.messages.get(i);
            if (perm.getName().equals(messageName) && (namespace == null ? perm.getNamespace() == null : namespace.equals(perm.getNamespace()))) {
                return perm;
            }
            ++i;
        }
        return null;
    }

    public WSDLMessage getMessage(QName qname) {
        int i = 0;
        while (i < this.messages.size()) {
            WSDLMessage perm = (WSDLMessage)this.messages.get(i);
            if (perm.getName().equals(qname.getLocalName()) && (qname.getURI() == null ? perm.getNamespace() == null : qname.getURI().equals(perm.getNamespace()))) {
                return perm;
            }
            ++i;
        }
        return null;
    }

    public WSDLNode getDocument() {
        return this;
    }

    public void addMessage(WSDLMessage mess) throws WSDLException {
        int i = 0;
        while (i < this.messages.size()) {
            WSDLMessage curMessage = (WSDLMessage)this.messages.get(i);
            if (curMessage.getQName().equals((Object)mess.getQName())) {
                return;
            }
            ++i;
        }
        this.messages.add(mess);
    }

    public void addPortType(WSDLPortType portType) throws WSDLException {
        int i = 0;
        while (i < this.portTypes.size()) {
            WSDLPortType curPortType = (WSDLPortType)this.portTypes.get(i);
            if (curPortType.getQName().equals((Object)portType.getQName())) {
                return;
            }
            ++i;
        }
        this.portTypes.add(portType);
    }

    public void addBinding(WSDLBinding binding) throws WSDLException {
        int i = 0;
        while (i < this.bindings.size()) {
            if (((WSDLBinding)this.bindings.get(i)).getQName().equals((Object)binding.getQName())) {
                return;
            }
            ++i;
        }
        this.bindings.add(binding);
    }

    public void addService(WSDLService service) {
        this.services.add(service);
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public ArrayList getPortTypes() {
        return this.portTypes;
    }

    public ArrayList getBindings() {
        return this.bindings;
    }

    public ArrayList getServices() {
        return this.services;
    }

    public void addAdditionalAttribute(String name, String value) {
        this.additionalAttrs.put(name, value);
    }

    public Hashtable getAdditionalAttributes() {
        return this.additionalAttrs;
    }

    public String getAdditionalAttrValue(String name) {
        return (String)this.additionalAttrs.get(name);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void loadSchemaInfo() throws WSDLException {
        if (this.schemaDefinitions.size() == 0) {
            this.schemaInfo = null;
            return;
        }
        try {
            this.schemaInfo = new SchemaToJavaGenerator();
            int i = 0;
            while (i < this.schemaDefinitions.size()) {
                this.schemaInfo.addSchemaSource((DOMSource)this.schemaDefinitions.get(i));
                ++i;
            }
        }
        catch (SchemaToJavaGeneratorException e) {
            throw new WSDLException("Unable to load Schema information. See nested Exception :", (Exception)((Object)e));
        }
    }

    public WSDLBinding getBinding(String bindingName, String namespace) {
        int i = 0;
        while (i < this.bindings.size()) {
            WSDLBinding binding = (WSDLBinding)this.bindings.get(i);
            if (binding.getName().equals(bindingName) && (namespace == null ? binding.getNamespace() == null : namespace.equals(binding.getNamespace()))) {
                return binding;
            }
            ++i;
        }
        return null;
    }

    public WSDLBinding getBinding(QName name) {
        int i = 0;
        while (i < this.bindings.size()) {
            WSDLBinding binding = (WSDLBinding)this.bindings.get(i);
            if (binding.getName().equals(name.getLocalName()) && (name.getURI() == null ? binding.getNamespace() == null : name.getURI().equals(binding.getNamespace()))) {
                return binding;
            }
            ++i;
        }
        return null;
    }

    public SchemaToJavaGenerator getSchemaInfo() {
        return this.schemaInfo;
    }

    public ArrayList getFeatures() {
        return this.features;
    }

    public void addFeature(SAPFeature feature) {
        this.features.add(feature);
    }

    private boolean qnamesEqual(QName qname, WSDLNamedNode node) {
        boolean flag = false;
        if (qname.getURI() == null && node.getNamespace() == null) {
            flag = true;
        }
        if (qname.getURI() != null && qname.getURI().equals(node.getNamespace())) {
            flag = true;
        }
        if (flag) {
            if (qname.getLocalName() == null && node.getName() == null) {
                return true;
            }
            if (qname.getLocalName() != null && qname.getLocalName().equals(node.getName())) {
                return true;
            }
        }
        return false;
    }

    public SAPFeature getFeatureByName(QName name) {
        int i = 0;
        while (i < this.features.size()) {
            SAPFeature feature = (SAPFeature)this.features.get(i);
            if (this.qnamesEqual(name, feature)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    public SAPFeature getFeatureByName(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.features.size()) {
            SAPFeature feature = (SAPFeature)this.features.get(i);
            if (name.equals(feature.getName())) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    public SAPFeature getFeatureByUri(String uri) {
        int i = 0;
        while (i < this.features.size()) {
            SAPFeature feature = (SAPFeature)this.features.get(i);
            if (feature.getUri().equals(uri)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    public void writeTo(OutputStream out) throws IOException, WSDLException {
        WSDLDefinitionsParser parser = new WSDLDefinitionsParser();
        parser.writeDefintionsToStream(this, out);
    }
}

