/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import com.sap.engine.services.webservices.tools.WSDLDownloadResolver;
import com.sap.engine.services.webservices.wsdl.HashStringtoInt;
import com.sap.engine.services.webservices.wsdl.SAPFeature;
import com.sap.engine.services.webservices.wsdl.SAPOption;
import com.sap.engine.services.webservices.wsdl.SAPProperty;
import com.sap.engine.services.webservices.wsdl.SAPUseFeature;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingChannel;
import com.sap.engine.services.webservices.wsdl.WSDLBindingFault;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLFault;
import com.sap.engine.services.webservices.wsdl.WSDLImport;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLNode;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import com.sap.engine.services.webservices.wsdl.WSDLTypes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLDOMLoader {
    public static String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static String WSDL_SAP_NAMESPACE = "http://www.sap.com/webas/630/wsdl/features";
    public static String SCHEMA_NAMESPACE1 = "http://www.w3.org/2000/10/XMLSchema";
    public static String SCHEMA_NAMESPACE2 = "http://www.w3.org/2001/XMLSchema";
    public static String SCHEMA_NAMESPACE3 = "http://www.w3.org/1999/XMLSchema";
    public static final int DOCUMENT_STATE = -1;
    public static final int EXTENSION_STATE = 0;
    public static final int DEFINITIONS_STATE = 1;
    public static final int TYPES_STATE = 2;
    public static final int SCHEMA_STATE = 3;
    public static final int MESSAGE_STATE = 4;
    public static final int PART_STATE = 5;
    public static final int PORTTYPE_STATE = 6;
    public static final int OPERATION_STATE = 7;
    public static final int INPUT_STATE = 8;
    public static final int OUTPUT_STATE = 9;
    public static final int FAULT_STATE = 10;
    public static final int BINDING_STATE = 11;
    public static final int BOPERATION_STATE = 12;
    public static final int BINPUT_STATE = 13;
    public static final int BOUTPUT_STATE = 14;
    public static final int BFAULT_STATE = 15;
    public static final int SERVICE_STATE = 16;
    public static final int PORT_STATE = 17;
    public static final int DOCUMENTATION_STATE = 18;
    public static final int IMPORT_STATE = 19;
    public static final int SAP_FEATURE_STATE = 20;
    public static final int SAP_PROPERTY_STATE = 21;
    public static final int SAP_OPTION_STATE = 22;
    public static final int SAP_USE_FEATURE_STATE = 23;
    private HashStringtoInt elementMapping;
    private HashStringtoInt elementMapping2;
    private Hashtable systemIdMapping;
    private Hashtable reverseMapping;
    private String documentId;
    private String proxyHost = null;
    private String proxyPort = null;
    private EntityResolver wsdlResolver;
    private HashSet acceptedExtensions = new HashSet();

    public WSDLDOMLoader() {
        this.acceptedExtensions.add("http://schemas.xmlsoap.org/wsdl/http/");
        this.acceptedExtensions.add("http://schemas.xmlsoap.org/wsdl/mime/");
        this.acceptedExtensions.add("http://schemas.xmlsoap.org/wsdl/soap/");
        this.documentId = null;
        this.systemIdMapping = null;
        this.reverseMapping = new Hashtable();
        this.initMapping();
    }

    public void setHttpProxy(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    private void initMapping() {
        this.elementMapping = new HashStringtoInt();
        this.elementMapping.put("definitions", 1);
        this.elementMapping.put("types", 2);
        this.elementMapping.put("schema", 3);
        this.elementMapping.put("message", 4);
        this.elementMapping.put("part", 5);
        this.elementMapping.put("portType", 6);
        this.elementMapping.put("operation", 7);
        this.elementMapping.put("input", 8);
        this.elementMapping.put("output", 9);
        this.elementMapping.put("fault", 10);
        this.elementMapping.put("binding", 11);
        this.elementMapping.put("service", 16);
        this.elementMapping.put("port", 17);
        this.elementMapping.put("documentation", 18);
        this.elementMapping.put("import", 19);
        this.elementMapping2 = new HashStringtoInt();
        this.elementMapping2.put("Feature", 20);
        this.elementMapping2.put("Property", 21);
        this.elementMapping2.put("Option", 22);
        this.elementMapping2.put("useFeature", 23);
    }

    private int getElementCode(String uri, String localName) {
        if (uri == null) {
            return 0;
        }
        if (uri.equals(WSDL_NAMESPACE)) {
            return this.elementMapping.get(localName);
        }
        if (uri.equals(WSDL_SAP_NAMESPACE)) {
            return this.elementMapping2.get(localName);
        }
        if ((uri.equals(SCHEMA_NAMESPACE1) || uri.equals(SCHEMA_NAMESPACE2) || uri.equals(SCHEMA_NAMESPACE3)) && localName.equals("schema")) {
            return 3;
        }
        return 0;
    }

    private URL resolveUri(String baseUri, String relativeUri) throws WSDLException {
        if (this.systemIdMapping != null) {
            try {
                String realBaseUri = baseUri.equals(this.documentId) ? (String)this.systemIdMapping.get("") : (String)this.reverseMapping.get(baseUri);
                String realNewUri = "";
                if (this.systemIdMapping.get("Version") != null) {
                    realNewUri = realBaseUri + "|" + relativeUri;
                } else {
                    URL base = URLLoaderBase.fileOrURLToURL(null, (String)realBaseUri);
                    realNewUri = URLLoaderBase.fileOrURLToURL((URL)base, (String)relativeUri).toString();
                }
                URL realLocalUri = URLLoaderBase.fileOrURLToURL(null, (String)baseUri);
                URL newLocalUri = URLLoaderBase.fileOrURLToURL((URL)realLocalUri, (String)((String)this.systemIdMapping.get(realNewUri)));
                if (newLocalUri == null) {
                    throw new WSDLException("Unable to resolve {" + relativeUri + "} from base uri {" + baseUri + "} using mirror image. Check if you pass correct import mapping to the WSDLDomLoader.");
                }
                this.reverseMapping.put(newLocalUri.toString(), realNewUri.toString());
                return newLocalUri;
            }
            catch (IOException e) {
                throw new WSDLException("Unable to resolve {" + relativeUri + "} from base uri {" + baseUri + "} using mirror image. Check if you pass correct import mapping to the WSDLDomLoader.", e);
            }
        }
        try {
            URL rootURL = URLLoaderBase.fileOrURLToURL(null, (String)baseUri);
            URL locationURL = URLLoaderBase.fileOrURLToURL((URL)rootURL, (String)relativeUri);
            return locationURL;
        }
        catch (IOException i) {
            throw new WSDLException("Unable to resolve {" + relativeUri + "} from base uri {" + baseUri + "} using mirror image. Check if you pass correct import mapping to the WSDLDomLoader.", i);
        }
    }

    public void setWSDLResolver(EntityResolver wsdlResolver) {
        this.wsdlResolver = wsdlResolver;
    }

    private WSDLBindingChannel loadBindingChannel(WSDLNode parent, Element element) throws WSDLException {
        WSDLBindingChannel result = new WSDLBindingChannel(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 0) {
                WSDLExtension extension = this.loadExtension(result, currentElement);
                result.addExtension(extension);
            } else if (elementCode != 18) {
                this.invalidMemberException("bindingChannel", currentElement);
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLBindingFault loadBindingFault(WSDLNode parent, Element element) throws WSDLException {
        WSDLBindingFault result = new WSDLBindingFault(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 0) {
                WSDLExtension extension = this.loadExtension(result, currentElement);
                result.addExtension(extension);
            } else if (elementCode != 18) {
                this.invalidMemberException("bindingFaultChannel", currentElement);
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLBindingOperation loadBOperation(WSDLNode parent, Element element) throws WSDLException {
        WSDLBindingOperation result = new WSDLBindingOperation(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 8: {
                    if (result.getInput() != null) {
                        throw new WSDLException(" WSDL binding operation can not have multiple 'input' elements !");
                    }
                    WSDLBindingChannel input = this.loadBindingChannel(result, currentElement);
                    result.setInput(input);
                    break;
                }
                case 9: {
                    if (result.getOutput() != null) {
                        throw new WSDLException(" WSDL binding operation can not have multiple 'output' elements !");
                    }
                    WSDLBindingChannel output = this.loadBindingChannel(result, currentElement);
                    result.setOutput(output);
                    break;
                }
                case 10: {
                    WSDLBindingFault fault = this.loadBindingFault(result, currentElement);
                    result.addFault(fault);
                    break;
                }
                case 0: {
                    WSDLExtension extension = this.loadExtension(result, currentElement);
                    result.addExtension(extension);
                    break;
                }
                case 18: {
                    break;
                }
                case 23: {
                    SAPUseFeature useFeature = this.loadUseFeatureState(result, currentElement);
                    result.addUseFeatire(useFeature);
                    break;
                }
                default: {
                    this.invalidMemberException("bindingOperation", currentElement);
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLBinding loadBinding(WSDLNode parent, Element element) throws WSDLException {
        WSDLBinding result = new WSDLBinding(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 7: {
                    WSDLBindingOperation operation = this.loadBOperation(result, currentElement);
                    result.addOperation(operation);
                    break;
                }
                case 0: {
                    WSDLExtension extension = this.loadExtension(result, currentElement);
                    result.addExtension(extension);
                    break;
                }
                case 23: {
                    SAPUseFeature useFeature = this.loadUseFeatureState(result, currentElement);
                    result.addUseFeature(useFeature);
                    break;
                }
                case 18: {
                    WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                    result.setDocumentation(documentation);
                    break;
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLPort loadPort(WSDLNode parent, Element element) throws WSDLException {
        WSDLPort result = new WSDLPort(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 0) {
                WSDLExtension extension = this.loadExtension(result, currentElement);
                if (extension.getURI() != null && this.acceptedExtensions.contains(extension.getURI())) {
                    if (result.getExtension() != null) {
                        throw new WSDLException(" WSDL 'port' can not have more than one extension elements ! Check port '" + result.getName() + "' contents !");
                    }
                    result.setExtension(extension);
                }
            } else if (elementCode == 18) {
                WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                result.setDocumentation(documentation);
            } else {
                throw new WSDLException(" Ivalid WSDL file !");
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLExtension loadExtension(WSDLNode parent, Element element) throws WSDLException {
        WSDLExtension result = new WSDLExtension(parent);
        result.setLocalName(element.getLocalName());
        result.setURI(element.getNamespaceURI());
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 0) {
                WSDLExtension extension = this.loadExtension(result, currentElement);
                result.addChild(extension);
            } else if (elementCode != 18) {
                throw new WSDLException(" Incorrect WSDL file ! Please do not mix valid WSDL Element's in wsdl extension elements !");
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private SAPUseFeature loadUseFeatureState(WSDLNode parent, Element element) throws WSDLException {
        SAPUseFeature result = new SAPUseFeature(parent);
        result.loadAttributes(element);
        return result;
    }

    private SAPOption loadOptionState(WSDLNode parent, Element element) throws WSDLException {
        SAPOption result = new SAPOption(parent);
        result.loadAttributes(element);
        return result;
    }

    private SAPProperty loadPropertyState(WSDLNode parent, Element element) throws WSDLException {
        SAPProperty result = new SAPProperty(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 22: {
                    SAPOption option = this.loadOptionState(result, currentElement);
                    result.addOption(option);
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private SAPFeature loadFeatureState(WSDLNode parent, Element element) throws WSDLException {
        SAPFeature result = new SAPFeature(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 21: {
                    SAPProperty property = this.loadPropertyState(result, currentElement);
                    result.addProperty(property);
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLDocumentation loadDocumentation(WSDLNode parent, Element element) throws WSDLException {
        element.normalize();
        WSDLDocumentation result = new WSDLDocumentation(parent);
        Element elementContent = this.getFirstChildElement(element);
        if (elementContent != null) {
            result.setElementContent(elementContent);
        } else {
            Node node = element.getFirstChild();
            if (node != null) {
                StringBuffer content = new StringBuffer();
                while (node != null) {
                    boolean flag = true;
                    if (node.getNodeType() == 3) {
                        content.append(((Text)node).getData());
                        flag = false;
                    }
                    if (node.getNodeType() == 4) {
                        content.append(((CDATASection)node).getData());
                        flag = false;
                    }
                    if (node.getNodeType() == 5) {
                        content.append(node.getNodeValue());
                        flag = false;
                    }
                    if (flag) break;
                    node = node.getNextSibling();
                }
                result.setContent(new CharArray(content.toString().trim()));
            }
        }
        return result;
    }

    private WSDLService loadService(WSDLNode parent, Element element) throws WSDLException {
        WSDLService result = new WSDLService(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 17: {
                    WSDLPort port = this.loadPort(result, currentElement);
                    result.addPort(port);
                    break;
                }
                case 0: {
                    WSDLExtension extension = this.loadExtension(result, currentElement);
                    result.setExtension(extension);
                    break;
                }
                case 18: {
                    WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                    result.setDocumentation(documentation);
                    break;
                }
                default: {
                    this.invalidMemberException("service", currentElement);
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLTypes loadTypes(WSDLDefinitions parent, Element element) throws WSDLException {
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 3) {
                parent.addSchema(new DOMSource(currentElement, parent.getSystemId()), parent.getTargetNamespace());
            } else if (elementCode != 18) {
                this.invalidMemberException("types", currentElement);
            }
            currentElement = this.getNextElement(currentElement);
        }
        return new WSDLTypes(parent);
    }

    private WSDLChannel loadChannel(WSDLNode parent, Element element) throws WSDLException {
        WSDLChannel result = new WSDLChannel(parent);
        result.loadAttributes(element);
        if (this.getFirstChildElement(element) != null) {
            throw new WSDLException(" WSDL 'operation' element can not have child elements !");
        }
        return result;
    }

    private WSDLFault loadFault(WSDLNode parent, Element element) throws WSDLException {
        WSDLFault result = new WSDLFault(parent);
        result.loadAttributes(element);
        if (this.getFirstChildElement(element) != null) {
            throw new WSDLException(" WSDL 'fault' element can not have child elements !");
        }
        return result;
    }

    private WSDLOperation loadOperation(WSDLNode parent, Element element) throws WSDLException {
        WSDLOperation result = new WSDLOperation(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 8: {
                    if (result.getInput() != null) {
                        throw new WSDLException(" More than one WSDL 'input' can not contain in WSDL 'operation' !");
                    }
                    WSDLChannel input = this.loadChannel(result, currentElement);
                    result.setInput(input);
                    break;
                }
                case 9: {
                    if (result.getOutput() != null) {
                        throw new WSDLException(" More than one WSDL 'output' can not contain in WSDL 'operation' !");
                    }
                    WSDLChannel output = this.loadChannel(result, currentElement);
                    result.setOutput(output);
                    break;
                }
                case 10: {
                    WSDLFault fault = this.loadFault(result, currentElement);
                    result.addFault(fault);
                    break;
                }
                case 23: {
                    SAPUseFeature useFeature = this.loadUseFeatureState(result, currentElement);
                    result.addUseFeature(useFeature);
                    break;
                }
                case 18: {
                    WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                    result.setDocumentation(documentation);
                    break;
                }
                default: {
                    this.invalidMemberException("option", currentElement);
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLPortType loadPortType(WSDLNode parent, Element element) throws WSDLException {
        WSDLPortType result = new WSDLPortType(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 7) {
                WSDLOperation operation = this.loadOperation(result, currentElement);
                result.addOperation(operation);
            } else if (elementCode == 23) {
                SAPUseFeature useFeature = this.loadUseFeatureState(result, currentElement);
                result.addUseFeature(useFeature);
            } else if (elementCode == 18) {
                WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                result.setDocumentation(documentation);
            } else {
                this.invalidMemberException("portType", currentElement);
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLPart loadPart(WSDLNode parent, Element element) throws WSDLException {
        WSDLPart result = new WSDLPart(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode != 18) {
                throw new WSDLException(" WSDL 'part' can only have 'documentation' children !");
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private WSDLMessage loadMessage(WSDLNode parent, Element element) throws WSDLException {
        WSDLMessage result = new WSDLMessage(parent);
        result.loadAttributes(element);
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            if (elementCode == 5) {
                WSDLPart part = this.loadPart(result, currentElement);
                result.addPart(part);
            } else if (elementCode == 18) {
                WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                result.setDocumentation(documentation);
            } else {
                this.invalidMemberException("message", currentElement);
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private void loadImportState(WSDLDefinitions definitions, Element importNode) throws WSDLException {
        String rootId = definitions.getSystemId();
        String location = importNode.getAttribute("location");
        if (location.length() == 0) {
            throw new WSDLException(" Error in WSDL 'import' no or empty location attribute !");
        }
        URL locationURL = null;
        locationURL = this.resolveUri(rootId, location);
        DOMSource newDocument = this.loadDOMDocument(locationURL.toExternalForm());
        Element rootElement = (Element)newDocument.getNode();
        int elementCode = this.getElementCode(rootElement.getNamespaceURI(), rootElement.getLocalName());
        switch (elementCode) {
            case 1: {
                if (this.systemIdMapping != null) {
                    definitions.setMirrorLocation(locationURL.toString(), (String)this.reverseMapping.get(locationURL.toString()));
                }
                WSDLDefinitions importedDefinitions = this.loadDefinitions(newDocument);
                this.joinWSDL(definitions, importedDefinitions);
                break;
            }
            case 3: {
                if (this.systemIdMapping != null) {
                    definitions.setMirrorLocation(locationURL.toString(), (String)this.reverseMapping.get(locationURL.toString()));
                }
                definitions.addSchema(new DOMSource(rootElement, locationURL.toExternalForm()));
                break;
            }
            default: {
                throw new WSDLException(" Invalid document imported. It must be valid WSDL File or Schema document !");
            }
        }
        WSDLImport importStatement = new WSDLImport(definitions);
        importStatement.loadAttributes(importNode);
        definitions.getImportDeclaratuions().add(importStatement);
    }

    public WSDLDefinitions loadDefinitions(DOMSource source) throws WSDLException {
        Node node = source.getNode();
        if (node.getNodeType() != 1) {
            throw new WSDLException(" DOM Source passed can not be used to load WSDL Definitions !");
        }
        Element element = (Element)node;
        int nodeCode = this.getElementCode(element.getNamespaceURI(), element.getLocalName());
        if (nodeCode != 1) {
            throw new WSDLException(" Element passed is not WSDLD Document !");
        }
        WSDLDefinitions result = new WSDLDefinitions();
        if (source.getSystemId() != null) {
            try {
                String id = source.getSystemId();
                if (this.wsdlResolver == null) {
                    id = URLLoaderBase.fileOrURLToURL(null, (String)id).toString();
                }
                source.setSystemId(id);
            }
            catch (IOException e) {
                throw new WSDLException("System id " + source.getSystemId() + " can not be converted to url resource !", e);
            }
        }
        result.setSystemId(source.getSystemId());
        result.loadAttributes(element);
        if (this.systemIdMapping != null) {
            result.setMirrorMapping(this.systemIdMapping);
            if (result.getSystemId() != null && this.systemIdMapping.get("") != null && result.getSystemId().equals(this.documentId)) {
                result.setMirrorLocation(result.getSystemId(), (String)this.systemIdMapping.get(""));
            }
        }
        Element currentElement = this.getFirstChildElement(element);
        while (currentElement != null) {
            int elementCode = this.getElementCode(currentElement.getNamespaceURI(), currentElement.getLocalName());
            switch (elementCode) {
                case 2: {
                    WSDLTypes types;
                    result.types = types = this.loadTypes(result, currentElement);
                    break;
                }
                case 4: {
                    WSDLMessage message = this.loadMessage(result, currentElement);
                    result.addMessage(message);
                    break;
                }
                case 6: {
                    WSDLPortType porttype = this.loadPortType(result, currentElement);
                    result.addPortType(porttype);
                    break;
                }
                case 11: {
                    WSDLBinding binding = this.loadBinding(result, currentElement);
                    result.addBinding(binding);
                    break;
                }
                case 16: {
                    WSDLService service = this.loadService(result, currentElement);
                    result.addService(service);
                    break;
                }
                case 19: {
                    this.loadImportState(result, currentElement);
                    break;
                }
                case 18: {
                    WSDLDocumentation documentation = this.loadDocumentation(result, currentElement);
                    result.setDocumentation(documentation);
                    break;
                }
                case 20: {
                    SAPFeature feature = this.loadFeatureState(result, currentElement);
                    result.addFeature(feature);
                    break;
                }
                case 0: {
                    WSDLExtension extension = this.loadExtension(result, currentElement);
                    result.addExtension(extension);
                    break;
                }
                default: {
                    this.invalidMemberException("definitions", currentElement);
                }
            }
            currentElement = this.getNextElement(currentElement);
        }
        return result;
    }

    private Element getFirstChildElement(Element element) {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private Element getNextElement(Element element) {
        Node next = element.getNextSibling();
        while (next != null) {
            if (next.getNodeType() == 1) {
                return (Element)next;
            }
            next = next.getNextSibling();
        }
        return null;
    }

    private void invalidMemberException(String partName, Element element) throws WSDLException {
        throw new WSDLException(" WSDL '" + partName + "' can not have child '" + element.getNodeName() + "' of namespace '" + element.getNamespaceURI() + "' !");
    }

    public void joinWSDL(WSDLDefinitions definitions, WSDLDefinitions new_wsdl) throws WSDLException {
        int i = 0;
        while (i < new_wsdl.bindings.size()) {
            definitions.addBinding((WSDLBinding)new_wsdl.bindings.get(i));
            ++i;
        }
        i = 0;
        while (i < new_wsdl.messages.size()) {
            definitions.addMessage((WSDLMessage)new_wsdl.messages.get(i));
            ++i;
        }
        i = 0;
        while (i < new_wsdl.portTypes.size()) {
            definitions.addPortType((WSDLPortType)new_wsdl.portTypes.get(i));
            ++i;
        }
        i = 0;
        while (i < new_wsdl.services.size()) {
            definitions.addService((WSDLService)new_wsdl.services.get(i));
            ++i;
        }
        ArrayList schemaDefinitions = new_wsdl.getSchemaDefinitions();
        i = 0;
        while (i < schemaDefinitions.size()) {
            definitions.addSchema((DOMSource)schemaDefinitions.get(i), new_wsdl.getTargetNamespace());
            ++i;
        }
        ArrayList features = new_wsdl.getFeatures();
        i = 0;
        while (i < features.size()) {
            definitions.addFeature((SAPFeature)features.get(i));
            ++i;
        }
        if (this.systemIdMapping != null) {
            Hashtable table = new_wsdl.getMirrorLocations();
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)table.get(key);
                definitions.setMirrorLocation(key, value);
            }
        }
        if (new_wsdl.types != null && definitions.types == null) {
            definitions.types = new_wsdl.types;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DOMSource loadDOMDocument(String wsdlLocation) throws WSDLException {
        DOMSource dOMSource;
        String oldPort;
        String oldHost;
        block12: {
            oldHost = "";
            oldPort = "";
            try {
                try {
                    DOMSource source;
                    Document document;
                    DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                    if (this.proxyHost != null) {
                        oldHost = System.getProperty("http.proxyHost");
                        oldPort = System.getProperty("http.proxyPort");
                        System.setProperty("http.proxyHost", this.proxyHost);
                        System.setProperty("http.proxyPort", this.proxyPort);
                    }
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    if (this.wsdlResolver != null) {
                        builder.setEntityResolver(this.wsdlResolver);
                        InputSource source2 = this.wsdlResolver.resolveEntity(null, wsdlLocation);
                        if (source2 == null) {
                            source2 = new InputSource(wsdlLocation);
                        }
                        document = builder.parse(source2);
                    } else {
                        document = builder.parse(wsdlLocation);
                    }
                    Element root = document.getDocumentElement();
                    URL rooturl = new File(".").toURL();
                    URL location = URLLoaderBase.fileOrURLToURL((URL)rooturl, (String)wsdlLocation);
                    dOMSource = source = new DOMSource(root, location.toString());
                    Object var13_16 = null;
                    if (this.proxyHost == null) return dOMSource;
                    if (oldHost != null && oldPort != null) break block12;
                    ((Hashtable)System.getProperties()).remove("http.proxyHost");
                }
                catch (SAXException e) {
                    throw new WSDLException("Parser exception occurred:" + e.getMessage(), e);
                }
                catch (FactoryConfigurationError e) {
                    throw new WSDLException("Factory configuration error occurred:" + e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new WSDLException("Parser configuration exception occurred:" + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new WSDLException("IO Exception occurred while parsing file:" + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (this.proxyHost == null) throw throwable;
                if (oldHost != null && oldPort != null) {
                    System.setProperty("http.proxyHost", oldHost);
                    System.setProperty("http.proxyPort", oldPort);
                    throw throwable;
                }
                ((Hashtable)System.getProperties()).remove("http.proxyHost");
                ((Hashtable)System.getProperties()).remove("http.proxyPort");
                throw throwable;
            }
            ((Hashtable)System.getProperties()).remove("http.proxyPort");
            return dOMSource;
        }
        System.setProperty("http.proxyHost", oldHost);
        System.setProperty("http.proxyPort", oldPort);
        return dOMSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DOMSource loadDOMDocument(InputStream input, String systemId) throws WSDLException {
        DOMSource dOMSource;
        try {
            try {
                DOMSource source;
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(input);
                Element root = document.getDocumentElement();
                dOMSource = source = new DOMSource(root, systemId);
                Object var10_13 = null;
                if (input == null) return dOMSource;
            }
            catch (SAXException e) {
                throw new WSDLException("Parser exception occurred:" + e.getMessage(), e);
            }
            catch (FactoryConfigurationError e) {
                throw new WSDLException("Factory configuration error occurred:" + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new WSDLException("Parser configuration exception occurred:" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new WSDLException("IO Exception occurred while parsing file:" + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException x) {
                throw new WSDLException("Unable to close input stream", x);
            }
        }
        try {}
        catch (IOException x) {
            throw new WSDLException("Unable to close input stream", x);
        }
        input.close();
        return dOMSource;
    }

    public WSDLDefinitions loadWSDLDocument(InputStream input) throws WSDLException {
        this.systemIdMapping = null;
        DOMSource source = this.loadDOMDocument(input, "");
        return this.loadDefinitions(source);
    }

    public WSDLDefinitions loadWSDLDocument(InputStream input, String systemId) throws WSDLException {
        this.systemIdMapping = null;
        DOMSource source = this.loadDOMDocument(input, systemId);
        return this.loadDefinitions(source);
    }

    public WSDLDefinitions loadWSDLDocument(String wsdlFileName) throws WSDLException {
        this.systemIdMapping = null;
        DOMSource source = null;
        source = this.loadDOMDocument(wsdlFileName);
        WSDLDefinitions definitions = this.loadDefinitions(source);
        if (this.wsdlResolver != null && this.wsdlResolver instanceof WSDLDownloadResolver) {
            ((WSDLDownloadResolver)this.wsdlResolver).closeConnections();
        }
        return definitions;
    }

    public WSDLDefinitions loadMirrorWSDLDocument(String wsdlFileName, Hashtable systemIdMap) throws WSDLException {
        this.systemIdMapping = systemIdMap;
        this.reverseMapping.clear();
        try {
            URL rooturl = new File(".").toURL();
            URL location = URLLoaderBase.fileOrURLToURL((URL)rooturl, (String)wsdlFileName);
            this.documentId = location.toString();
        }
        catch (IOException e) {
            throw new WSDLException("Unable to convert path " + wsdlFileName + " to url !", e);
        }
        DOMSource source = null;
        source = this.loadDOMDocument(wsdlFileName);
        return this.loadDefinitions(source);
    }

    public WSDLDefinitions loadMirrorWSDLDocument(InputStream input, String systemId, Hashtable systemIdMap) throws WSDLException {
        this.systemIdMapping = systemIdMap;
        this.reverseMapping.clear();
        try {
            this.documentId = URLLoaderBase.fileOrURLToURL(null, (String)systemId).toString();
        }
        catch (IOException e) {
            throw new WSDLException("Unable to convert path " + systemId + " to url !", e);
        }
        DOMSource source = null;
        source = this.loadDOMDocument(input, systemId);
        return this.loadDefinitions(source);
    }

    private static void generateWSDLTypes(String wsdlPath, String outPath, String outpackage) throws WSDLException {
        File wsdlFile = new File(wsdlPath);
        if (!wsdlFile.isFile()) {
            throw new WSDLException("{" + wsdlPath + "} is not a file !");
        }
        File outDir = new File(outPath);
        if (!outDir.isDirectory()) {
            throw new WSDLException("{" + outPath + "} is not a directory !");
        }
        WSDLDOMLoader loader = new WSDLDOMLoader();
        WSDLDefinitions definitions = loader.loadWSDLDocument(wsdlPath);
        definitions.loadSchemaInfo();
        SchemaToJavaGenerator schema = definitions.getSchemaInfo();
        try {
            if (schema != null) {
                schema.generateAll(outDir, outpackage);
                PackageBuilder builder = new PackageBuilder();
                builder.setPackageRoot(outDir);
                builder.setPackageName(outpackage);
                builder.compilePackage();
            }
        }
        catch (SchemaToJavaGeneratorException e) {
            throw new WSDLException("Schema to java Generator problem when generating files. See nested Exception:", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new WSDLException("Problem in compiling generated files. See nested exception:", e);
        }
    }

    public static void testWSDL(String inputPath, String outPath) throws Exception {
        File wsdlFile = new File(inputPath);
        File outDir = new File(outPath);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new Exception("{" + outPath + "} is not a directory !");
        }
        if (wsdlFile.isFile()) {
            System.out.println("Parsing : " + wsdlFile.getName() + "   {" + wsdlFile.getAbsolutePath() + "}");
            try {
                WSDLDOMLoader.generateWSDLTypes(wsdlFile.getAbsolutePath(), outDir.getCanonicalPath(), wsdlFile.getName().substring(0, wsdlFile.getName().lastIndexOf(".")));
                System.out.println("Success ! ");
            }
            catch (Exception e) {
                System.out.println("Failed ! " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            File[] files = wsdlFile.listFiles();
            int fileFailed = 0;
            int succesCount = 0;
            if (files == null) {
                System.out.println(" File not Found !");
                return;
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile() && files[i].getName().endsWith(".wsdl")) {
                    System.out.println("Parsing : " + wsdlFile.getName() + "   {" + files[i].getAbsolutePath() + "}");
                    try {
                        WSDLDOMLoader.generateWSDLTypes(files[i].getAbsolutePath(), outDir.getAbsolutePath(), files[i].getName().substring(0, files[i].getName().lastIndexOf(".")));
                        ++succesCount;
                        System.out.println("Success ! ");
                    }
                    catch (Exception e) {
                        System.out.println("Failed ! " + e.getMessage());
                        e.printStackTrace();
                        ++fileFailed;
                    }
                }
                ++i;
            }
            System.out.println("----------------------------");
            System.out.println("Parsed : " + (succesCount + fileFailed));
            System.out.println("OK     : " + succesCount);
            System.out.println("Failed : " + fileFailed);
            System.out.println();
        }
    }
}

