/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.wsdl.SAPProperty;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLNamedNode;
import com.sap.engine.services.webservices.wsdl.WSDLNode;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SAPFeature
extends WSDLNamedNode {
    public static final String SAP_FEATURES = "http://www.sap.com/webas/630/wsdl/features";
    protected String uri;
    protected ArrayList properties = new ArrayList();

    public SAPFeature() {
    }

    public SAPFeature(WSDLNode parent) {
        super(parent);
    }

    public void addProperty(SAPProperty property) {
        this.properties.add(property);
    }

    public SAPProperty getProperty(QName qname) {
        int i = 0;
        while (i < this.properties.size()) {
            SAPProperty property = (SAPProperty)this.properties.get(i);
            if (property.getQname().equals((Object)qname)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public ArrayList getProperties() {
        return this.properties;
    }

    public SAPProperty removeProperty(QName propertyQName) {
        int i = 0;
        while (i < this.properties.size()) {
            SAPProperty property = (SAPProperty)this.properties.get(i);
            if (property.getQname().equals((Object)propertyQName)) {
                this.properties.remove(i);
                return property;
            }
            ++i;
        }
        return null;
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SAPFeature)) {
            return false;
        }
        SAPFeature testedFeature = (SAPFeature)obj;
        if (!this.uri.equals(testedFeature.uri)) {
            return false;
        }
        if (this.properties.size() != testedFeature.properties.size()) {
            return false;
        }
        int i = 0;
        while (i < this.properties.size()) {
            SAPProperty property = (SAPProperty)this.properties.get(i);
            if (!property.equals(testedFeature.properties.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void loadAttributes(Element element) throws WSDLException {
        Attr attribute = element.getAttributeNode("name");
        if (attribute == null) {
            throw new WSDLException(" No name attribute found !");
        }
        this.name = attribute.getValue();
        Attr uriAttr = element.getAttributeNode("uri");
        if (uriAttr == null) {
            throw new WSDLException(" SAP Feature must have 'uri' attribute !");
        }
        this.uri = uriAttr.getValue();
    }
}

