/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.parser.handlers.SimpleAttr;
import com.sap.engine.services.webservices.wsdl.SAPUseFeature;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingChannel;
import com.sap.engine.services.webservices.wsdl.WSDLBindingFault;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLNamedNode;
import com.sap.engine.services.webservices.wsdl.WSDLNode;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractWSDLDefinitionsParser {
    protected final String SAPFEATURE_NS = "http://www.sap.com/webas/630/wsdl/features";
    protected final String WSDL_HTTP_NS = "http://schemas.xmlsoap.org/wsdl/http/";
    protected static DocumentBuilderFactory factory = new DocumentBuilderFactoryImpl();
    protected static TransformerFactory transformerFactory;
    Document doc;
    Element root;
    WSDLDefinitions def;

    protected void parseUseFeatures(Element parent, ArrayList useFeatures) {
        if (useFeatures == null || useFeatures.size() == 0) {
            return;
        }
        if (this.root.getAttribute("xmlns:sap").equals("")) {
            this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sap", "http://www.sap.com/webas/630/wsdl/features");
        }
        int i = 0;
        while (i < useFeatures.size()) {
            SAPUseFeature tmpFeature = (SAPUseFeature)useFeatures.get(i);
            Element useFElement = this.doc.createElementNS("http://www.sap.com/webas/630/wsdl/features", "sap:useFeature");
            useFElement.setAttribute("feature", tmpFeature.getFeatureQName().getQName());
            parent.appendChild(useFElement);
            ++i;
        }
    }

    protected void parseDocumentation(Element wsdlElement, WSDLNode node) {
        WSDLNamedNode namedNode;
        WSDLDocumentation wsDocum;
        if (node instanceof WSDLNamedNode && (wsDocum = (namedNode = (WSDLNamedNode)node).getDocumentation()) != null) {
            Element docElement = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:documentation");
            try {
                Element res = factory.newDocumentBuilder().parse(new ByteArrayInputStream(wsDocum.getContent().getBytes())).getDocumentElement();
                Node newNode = this.doc.importNode(res, true);
                docElement.appendChild(newNode);
                wsdlElement.appendChild(docElement);
            }
            catch (Exception e) {
                docElement.appendChild(this.doc.createTextNode(wsDocum.getContent().toString()));
                wsdlElement.appendChild(docElement);
            }
            return;
        }
    }

    protected void parseBinding(WSDLBinding binding) throws WSDLException {
        Element bindingEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:binding");
        bindingEl.setAttribute("name", binding.getName());
        bindingEl.setAttribute("type", binding.getType().getQName());
        this.parseDocumentation(bindingEl, binding);
        this.parseUseFeatures(bindingEl, binding.getUseFeatures());
        ArrayList usedForAll = binding.getExtensions();
        int i = 0;
        while (i < usedForAll.size()) {
            this.parseExtensionElement((WSDLExtension)usedForAll.get(i), bindingEl);
            ++i;
        }
        usedForAll = binding.getOperations();
        i = 0;
        while (i < usedForAll.size()) {
            this.parseBindingOperation((WSDLBindingOperation)usedForAll.get(i), bindingEl);
            ++i;
        }
        this.root.appendChild(bindingEl);
    }

    protected void parseExtensionElement(WSDLExtension extension, Element parent) throws WSDLException {
        if (extension.getURI() == null || extension.getLocalName() == null) {
            throw new WSDLException("Uri or localName element in WSDLException is null\n" + extension);
        }
        String temp = this.getURIMapping(extension.getURI());
        if (temp == null) {
            throw new WSDLException("There is not prefix for this URI:" + extension.getURI());
        }
        if (this.root.getAttribute("xmlns:" + temp).equals("")) {
            this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + temp, extension.getURI());
        }
        Element extensionEl = this.doc.createElementNS(extension.getURI(), temp + ":" + extension.getLocalName());
        ArrayList attrChildren = extension.getAttributes();
        int i = 0;
        while (i < attrChildren.size()) {
            SimpleAttr smpAttr = (SimpleAttr)attrChildren.get(i);
            extensionEl.setAttribute(smpAttr.localName, smpAttr.value);
            ++i;
        }
        attrChildren = extension.getChildren();
        i = 0;
        while (i < attrChildren.size()) {
            this.parseExtensionElement((WSDLExtension)attrChildren.get(i), extensionEl);
            ++i;
        }
        parent.appendChild(extensionEl);
    }

    private String getURIMapping(String uri) {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            return "wsdl";
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            return "soap";
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/mime/")) {
            return "mime";
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/http/")) {
            return "http";
        }
        return null;
    }

    private void parseBindingOperation(WSDLBindingOperation operation, Element parent) throws WSDLException {
        Element inoutChannelEl;
        Element operationEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:operation");
        operationEl.setAttribute("name", operation.getName());
        this.parseDocumentation(operationEl, operation);
        this.parseUseFeatures(operationEl, operation.getUseFeatures());
        ArrayList universal = operation.getExtensions();
        int i = 0;
        while (i < universal.size()) {
            this.parseExtensionElement((WSDLExtension)universal.get(i), operationEl);
            ++i;
        }
        WSDLBindingChannel inoutChannel = operation.getInput();
        if (inoutChannel != null) {
            inoutChannelEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:input");
            if (inoutChannel.getName() != null) {
                inoutChannelEl.setAttribute("name", inoutChannel.getName());
            }
            this.parseDocumentation(inoutChannelEl, inoutChannel);
            universal = inoutChannel.getExtensions();
            i = 0;
            while (i < universal.size()) {
                this.parseExtensionElement((WSDLExtension)universal.get(i), inoutChannelEl);
                ++i;
            }
            operationEl.appendChild(inoutChannelEl);
        }
        if ((inoutChannel = operation.getOutput()) != null) {
            inoutChannelEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:output");
            if (inoutChannel.getName() != null) {
                inoutChannelEl.setAttribute("name", inoutChannel.getName());
            }
            this.parseDocumentation(inoutChannelEl, inoutChannel);
            universal = inoutChannel.getExtensions();
            i = 0;
            while (i < universal.size()) {
                this.parseExtensionElement((WSDLExtension)universal.get(i), inoutChannelEl);
                ++i;
            }
            operationEl.appendChild(inoutChannelEl);
        }
        ArrayList faultList = operation.getFaults();
        i = 0;
        while (i < faultList.size()) {
            WSDLBindingFault bFault = (WSDLBindingFault)faultList.get(i);
            Element faultEl = this.doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:fault");
            if (bFault.getName() != null) {
                faultEl.setAttribute("name", bFault.getName());
            }
            this.parseDocumentation(faultEl, bFault);
            universal = bFault.getExtensions();
            int j = 0;
            while (j < universal.size()) {
                this.parseExtensionElement((WSDLExtension)universal.get(j), faultEl);
                ++j;
            }
            operationEl.appendChild(faultEl);
            ++i;
        }
        parent.appendChild(operationEl);
    }

    static {
        factory.setNamespaceAware(true);
        transformerFactory = new TransformerFactoryImpl();
    }
}

