/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.tools;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationUtil;
import com.sap.engine.services.webservices.jaxrpc.exceptions.InvalidResponseCodeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLDownloadResolver
implements EntityResolver {
    private String username;
    private String password;
    private HTTPProxyResolver proxyResolver;
    private Hashtable socketHash = new Hashtable();
    private HTTPProxy proxyObject = new HTTPProxy();

    public static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyHost() {
        return this.proxyObject.getProxyHost();
    }

    public int getProxyPort() {
        return this.proxyObject.getProxyPort();
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        SerializationUtil.checkAuthenticationInformation(password);
        this.password = password;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyObject.setProxyHost(proxyHost);
    }

    public void setProxyPort(int port) {
        this.proxyObject.setProxyPort(port);
    }

    public void setUsername(String username) {
        SerializationUtil.checkAuthenticationInformation(username);
        this.username = username;
    }

    public void setProxyExcludeList(String proxyExcludeList) {
        this.proxyObject.setExcludeList(proxyExcludeList);
    }

    public void setProxyBypassLocal(boolean flag) {
        this.proxyObject.setBypassLocalAddresses(flag);
    }

    public void setProxyUser(String user) {
        this.proxyObject.setProxyUser(user);
    }

    public void setProxyPass(String pass) {
        this.proxyObject.setProxyPass(pass);
    }

    public void setHTTPProxyResolver(HTTPProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        if (systemID == null) {
            return null;
        }
        if (systemID.startsWith("http://") || systemID.startsWith("https://")) {
            OutputStream out;
            URL url = new URL(systemID);
            HTTPSocket socket = new HTTPSocket(url);
            socket.setIgnoreServerCertificates(true);
            socket.setRequestMethod("GET");
            socket.setHeader("Content-Length", "0");
            socket.setHeader("Connection", "close");
            if (this.proxyObject.getProxyHost() != null) {
                String host = url.getHost();
                if (this.proxyObject.useProxyForAddress(host)) {
                    if (this.proxyObject.getProxyUser() != null && this.proxyObject.getProxyUser().length() != 0) {
                        socket.setProxy(this.proxyObject.getProxyHost(), this.proxyObject.getProxyPort(), this.proxyObject.getProxyUser(), this.proxyObject.getProxyPass());
                    } else {
                        socket.setProxy(this.proxyObject.getProxyHost(), this.proxyObject.getProxyPort());
                    }
                }
            } else if (this.proxyResolver != null) {
                socket.setHTTPProxyResolver(this.proxyResolver);
            }
            if (this.username != null) {
                socket.setHeader("Authorization", "Basic " + WSDLDownloadResolver.encodeAuth(this.username, this.password));
            }
            try {
                out = socket.getOutputStream();
            }
            catch (IOException ioe) {
                StringBuffer buf = new StringBuffer("Cannot connect to ");
                buf.append(systemID);
                if (this.proxyObject.getProxyHost() != null) {
                    buf.append(", passing via http proxy: " + this.proxyObject.getProxyHost() + ":" + this.proxyObject.getProxyPort());
                }
                if (this.username != null) {
                    buf.append(", used user to connect: " + this.username);
                }
                if (ioe.getLocalizedMessage() != null) {
                    buf.append(": " + ioe.getLocalizedMessage());
                }
                throw new IOException(buf.toString());
            }
            out.write("\r\n".getBytes());
            out.flush();
            InputStream in = socket.getInputStream();
            int responseCode = socket.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 301 && socket.getHeader("Location") != null) {
                    String[] location = socket.getHeader("Location");
                    return this.resolveEntity(publicID, location[0]);
                }
                String responseMsg = socket.getResponseMessage();
                Hashtable headers = socket.getHeaders();
                throw new InvalidResponseCodeException(responseCode, responseMsg, headers, url.toString());
            }
            InputSource source = new InputSource(in);
            source.setSystemId(systemID);
            this.socketHash.put(source, socket);
            return source;
        }
        return null;
    }

    public void closeConnections() {
        Enumeration enumeration = this.socketHash.keys();
        while (enumeration.hasMoreElements()) {
            HTTPSocket socket = (HTTPSocket)this.socketHash.get(enumeration.nextElement());
            try {
                socket.disconnect();
            }
            catch (IOException x) {
                Object var2_2 = null;
            }
        }
        this.socketHash.clear();
    }

    public Object clone() {
        WSDLDownloadResolver result = new WSDLDownloadResolver();
        result.setUsername(this.username);
        result.setPassword(this.password);
        result.setHTTPProxyResolver(this.proxyResolver);
        return result;
    }
}

