/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.tools;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.interfaces.webservices.uddi.UDDIServer;
import com.sap.engine.interfaces.webservices.uddi.UDDIServerAdmin;
import com.sap.engine.interfaces.webservices.uddi4j.DispatcherPortsGetter;
import com.sap.engine.interfaces.webservices.uddi4j.SAPTransportInterface;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPBodyImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPConnectionImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.messaging.Endpoint;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAPTransportImpl
implements SAPTransportInterface {
    public static final String NAME = "SAPTransport";
    private HTTPProxyResolver proxyResolver;
    private UDDIServerAdmin uddiServerAdmin;
    private DispatcherPortsGetter dispatcher;

    public SAPTransportImpl() {
    }

    public SAPTransportImpl(HTTPProxyResolver proxyResolver, UDDIServerAdmin uddiServerAdmin, DispatcherPortsGetter dispatcher) {
        this.proxyResolver = proxyResolver;
        this.uddiServerAdmin = uddiServerAdmin;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - void declaration
     */
    public Object send(Hashtable parameters) throws Exception {
        int indexOfXMLNS;
        Element el = (Element)parameters.get("UDDI_ELEMENT");
        URL url = (URL)parameters.get("URL");
        String urlStr = url.toExternalForm();
        boolean http = true;
        boolean local = false;
        if (urlStr.startsWith("http://localhost.sap")) {
            http = true;
            local = true;
        } else if (urlStr.startsWith("https://localhost.sap")) {
            UDDIServer uddiServer = this.uddiServerAdmin.getUDDIServer();
            if (uddiServer == null) {
                throw new IOException("UDDI Server application is not running");
            }
            Properties props = uddiServer.getUDDIServerProperties();
            String allowHTTPProp = props.getProperty("debug.allow.http", "yes");
            http = "yes".equalsIgnoreCase(allowHTTPProp);
            local = true;
        }
        if (local) {
            String schema;
            Object[] hostPort;
            if (http) {
                hostPort = this.dispatcher.getHTTPPort();
                schema = "http://";
            } else {
                hostPort = this.dispatcher.getHTTPSPort();
                schema = "https://";
            }
            InetAddress host = (InetAddress)hostPort[0];
            int port = (Integer)hostPort[1];
            String uri = url.getPath();
            url = new URL(schema + host.getHostAddress() + ":" + port + uri);
        }
        HTTPProxy httpProxy = null;
        if (this.proxyResolver != null) {
            httpProxy = this.proxyResolver.getHTTPProxyForHost(url.getHost());
        }
        SOAPConnectionImpl connection = new SOAPConnectionImpl();
        if (httpProxy != null) {
            connection.setProxy(httpProxy.getProxyHost(), httpProxy.getProxyPort());
        }
        Element base = null;
        String bodyStr = null;
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        Transformer transformer = factory.newTransformer();
        ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(el), new StreamResult(arrayStream));
        bodyStr = arrayStream.toString("utf-8");
        bodyStr = bodyStr.substring(bodyStr.indexOf("?>") + 2);
        while ((indexOfXMLNS = bodyStr.indexOf("xmlns=\"\"")) != -1) {
            void var14_15;
            bodyStr = bodyStr.substring(0, (int)var14_15) + bodyStr.substring((int)(var14_15 + 8));
        }
        MimeHeaders headers = new MimeHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=utf-8");
        ByteArrayInputStream source = new ByteArrayInputStream(new String("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\"><SOAP-ENV:Body>" + bodyStr + "</SOAP-ENV:Body></SOAP-ENV:Envelope>").getBytes("UTF-8"));
        SOAPMessageImpl soapMessage = new SOAPMessageImpl(headers, source);
        soapMessage.setSOAPAction("");
        SOAPMessage reply = connection.call((SOAPMessage)soapMessage, new Endpoint(url.toString()));
        Document document = ((SOAPBodyImpl)reply.getSOAPPart().getEnvelope().getBody()).getOwnerDocument();
        Node envelope = this.getFirstChildNotText(document);
        Node body = this.getFirstChildNotText(envelope);
        base = (Element)this.getFirstChildNotText(body);
        return base;
    }

    private Node getFirstChildNotText(Node node) {
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeType() != 3) {
                return n;
            }
            ++i;
        }
        return null;
    }
}

