/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.tools;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private InputStream input;
    private int chunkLength;

    public ChunkedInputStream(InputStream input) {
        this.input = new DataInputStream(input);
        this.chunkLength = 0;
    }

    public int read() throws IOException {
        byte[] bytes = new byte[1];
        if (this.read(bytes, 0, 1) == -1) {
            return -1;
        }
        return bytes[0];
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int bytesToRead;
        int result;
        if (this.chunkLength <= 0) {
            this.startChunk();
            if (this.chunkLength == 0) {
                this.readLine();
            }
            if (this.chunkLength <= 0) {
                return -1;
            }
        }
        if ((result = this.input.read(bytes, offset, bytesToRead = Math.min(this.chunkLength, length))) != -1) {
            this.chunkLength -= result;
            if (this.chunkLength <= 0 && !"".equals(this.readLine())) {
                throw new IOException("Chunk length higher than specified!");
            }
        }
        return result;
    }

    private void startChunk() throws IOException {
        String line = this.readLine();
        try {
            this.chunkLength = Integer.parseInt(line.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Incorrect chunk length: " + line + ".");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        int b;
        ChunkedInputStream in = new ChunkedInputStream(new FileInputStream("d:/opit.txt"));
        while ((b = in.read()) != -1) {
            void var2_2;
            System.out.print((char)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String readLine() throws IOException {
        int b;
        StringBuffer line = new StringBuffer();
        while ((b = this.input.read()) != -1) {
            int b2;
            void var1_2;
            if (var1_2 != 13 && var1_2 != 10) {
                line.append((char)var1_2);
                continue;
            }
            if (var1_2 == 13 && (b2 = this.input.read()) != 10) {
                throw new IOException("CR found without LF. CRLF should be used for a line termination!");
            }
            return line.toString();
        }
        return "";
    }
}

