/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding;

import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.tokenizer.XMLDOMTokenReaderNew;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.espbase.client.dynamic.WebServiceException;
import com.sap.engine.services.webservices.espbase.client.dynamic.content.ObjectFactory;
import com.sap.engine.services.webservices.jaxm.soap.DetailImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPBodyImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPDocumentImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPElementImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationState;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.exceptions.InvalidResponseCodeException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlMarshalException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProtocolList;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.DefaultProviders;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LocalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientMimeMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransport;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.MimeProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.SoapProtocol;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingChannel;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLNamedNode;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MimeHttpBinding
implements ClientTransportBinding {
    public static final String WSI_CLAIM = "Claim";
    public static final String WSI_NAMESPACE = "http://ws-i.org/schemas/conformanceClaim/";
    public static final String SOAP_BINDING_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String MIME_BINDING_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String SOAP_TRANSPORT = "transport";
    public static final String SOAP_STYLE = "style";
    public static final String RPC_STYLE = "rpc";
    public static final String DOCUMENT_STYLE = "document";
    public static final String SOAP_ACTION = "soapAction";
    public static final String SOAP_ACTION_UPPER = "SOAPAction";
    public static final String OPERATION_NAME = "operationName";
    public static final String SOAP_PARTS = "parts";
    public static final String SOAP_USE = "use";
    public static final String SOAP_ENCODING_STYLE = "encodingStyle";
    public static final String SOAP_OPERATION_NAMESPACE = "namespace";
    public static final String SOAP_OPERATION = "operation";
    public static final String MIME_RELATED = "multipartRelated";
    public static final String SOAP_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_BODY = "Body";
    private static final String SOAP_FAULT = "Fault";
    private static final String SOAP_FAULTCODE = "faultcode";
    private static final String SOAP_FAULTSTRING = "faultstring";
    private static final String SOAP_FAULTACTOR = "faultactor";
    private static final String SOAP_FAULTDETAIL = "detail";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private TypeMappingRegistry registry;
    private ServiceParam[] inputParams;
    private ServiceParam[] outputParams;
    private ServiceParam[] faultParams;
    private ClientMimeMessage message;
    private ByteArrayOutputStream buffer;
    private HTTPTransport transport;
    private HashSet hashSet;
    private SOAPSerializationContext serialziationContext;
    private SOAPDeserializationContext deserializationContext;
    public static final String NAME = "SOAP 1.1 HTTP Binding with Attachments";
    private ClassLoader appClassloader = null;
    private ArrayList faultRefs = new ArrayList();
    private XMLReader saxReader = null;
    private SAXParserFactoryImpl spf = new SAXParserFactoryImpl();

    public MimeHttpBinding() {
        this.message = new ClientMimeMessage();
        this.transport = new HTTPTransport();
        this.buffer = new ByteArrayOutputStream();
        this.hashSet = new HashSet();
        this.serialziationContext = new SOAPSerializationContext();
        this.deserializationContext = new SOAPDeserializationContext();
    }

    public void addConstructorCode(CodeGenerator generator) {
    }

    public void addImport(CodeGenerator generator) {
    }

    public void addVariables(CodeGenerator generator) {
    }

    private boolean checkContentType(String contentType) {
        if (contentType.trim().indexOf("text/plain") != -1) {
            return true;
        }
        if (contentType.trim().indexOf("application/octetstream") != -1) {
            return true;
        }
        return contentType.trim().indexOf("application/octet-stream") != -1;
    }

    private int[] getPartLocation(PropertyContext config, ServiceParam[] parts) throws Exception {
        int i;
        int[] result = new int[parts.length];
        String bodyParts = (String)config.getProperty(SOAP_PARTS);
        if (bodyParts == null) {
            int i2 = 0;
            while (i2 < result.length) {
                result[i2] = 1;
                ++i2;
            }
        } else {
            this.hashSet.clear();
            StringTokenizer st = new StringTokenizer(bodyParts);
            while (st.hasMoreTokens()) {
                this.hashSet.add(st.nextToken());
            }
            i = 0;
            while (i < parts.length) {
                String partName = parts[i].name;
                if (this.hashSet.contains(partName)) {
                    result[i] = 1;
                }
                ++i;
            }
        }
        PropertyContext context = config.getSubContext("mime");
        if (context.isDefined()) {
            i = 0;
            while (i < parts.length) {
                String contentType = (String)context.getProperty(parts[i].name);
                if (contentType != null) {
                    if (this.checkContentType(contentType)) {
                        result[i] = 2;
                    } else {
                        throw new Exception(" Binding does not support content-type :" + contentType);
                    }
                }
                ++i;
            }
        }
        if ((context = config.getSubContext("headers")).isDefined()) {
            i = 0;
            while (i < parts.length) {
                String use = (String)context.getProperty(parts[i].name);
                if (use != null) {
                    result[i] = 3;
                }
                ++i;
            }
        }
        return result;
    }

    private void addAttachment(Object object, String contentType, String contentId, ClientMimeMessage message) throws Exception {
        MimeBodyPart part;
        InternetHeaders headers;
        MimeMultipart multiPart;
        if (contentType.trim().indexOf("text/plain") != -1) {
            multiPart = message.getMultiPartObject();
            headers = new InternetHeaders();
            headers.addHeader("Content-type", contentType);
            headers.addHeader("Content-ID", "<" + contentId + ">");
            part = new MimeBodyPart(headers, ((String)object).getBytes());
            multiPart.addBodyPart((BodyPart)part);
        }
        if (contentType.trim().indexOf("application/octetstream") != -1) {
            multiPart = message.getMultiPartObject();
            headers = new InternetHeaders();
            headers.addHeader("Content-type", contentType);
            headers.addHeader("Content-ID", "<" + contentId + ">");
            headers.addHeader("Content-Transfer-Encoding", "binary");
            part = new MimeBodyPart(headers, (byte[])object);
            multiPart.addBodyPart((BodyPart)part);
        }
    }

    private void addConformanceClaim(PropertyContext config, ClientSOAPMessage message) throws Exception {
        String conforms = (String)config.getProperty("conformsTo");
        if (conforms != null) {
            Element element = message.createSoapHeader(WSI_NAMESPACE, WSI_CLAIM);
            element.setAttribute("conformsTo", conforms);
            message.getHeaders().add(element);
        }
    }

    private void buildRequestRpc(PropertyContext config, ClientMimeMessage message) throws Exception {
        ClientSOAPMessage soapMessage = message.getSOAPMessage();
        XMLTokenWriter writer = soapMessage.getWriter();
        int[] partLocation = this.getPartLocation(config, this.inputParams);
        this.serialziationContext.clearContext();
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
        this.serialziationContext.setTypeMapping(typeMapping);
        String operationName = (String)config.getProperty(OPERATION_NAME);
        String operationNamespace = (String)config.getProperty(SOAP_OPERATION_NAMESPACE);
        String encodingStyle = (String)config.getProperty(SOAP_ENCODING_STYLE);
        String use = (String)config.getProperty(SOAP_USE);
        if (operationName == null) {
            throw new Exception(" Operation name for rpc is not available !");
        }
        this.addConformanceClaim(config, soapMessage);
        writer.enter(SOAP_ENVELOPE, SOAP_BODY);
        this.serialziationContext.setTypeUse(true);
        if ("encoded".equals(use)) {
            this.serialziationContext.setEncoded(true);
            if (encodingStyle != null) {
                writer.writeAttribute(SOAP_ENVELOPE, SOAP_ENCODING_STYLE, encodingStyle);
            } else {
                throw new Exception(" In encoded representation encoding style must be specified !");
            }
        }
        writer.enter(operationNamespace, operationName);
        int i = 0;
        while (i < this.inputParams.length) {
            if (partLocation[i] != 0) {
                String contentType;
                String cid;
                SerializerBase serializer;
                QName elementType;
                if (this.inputParams[i].isElement) {
                    if (partLocation[i] == 1) {
                        if (this.inputParams[i].content != null) {
                            this.inputParams[i].contentClass = this.inputParams[i].content.getClass();
                        }
                        writer.enter(operationNamespace, this.inputParams[i].name);
                        writer.enter(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                        elementType = typeMapping.getTypeForElement(this.inputParams[i].schemaName);
                        serializer = this.serialziationContext.getSerializer(elementType, this.inputParams[i].contentClass);
                        serializer.serialize(this.inputParams[i].content, writer, this.serialziationContext);
                        writer.leave();
                    } else if (partLocation[i] == 3) {
                        boolean flag = this.serialziationContext.isEncoded();
                        this.serialziationContext.setEncoded(false);
                        if (this.inputParams[i].content != null) {
                            this.inputParams[i].contentClass = this.inputParams[i].content.getClass();
                        }
                        QName elementType2 = typeMapping.getTypeForElement(this.inputParams[i].schemaName);
                        SerializerBase serializer2 = this.serialziationContext.getSerializer(elementType2, this.inputParams[i].contentClass);
                        Element headerElement = soapMessage.createSoapHeader(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                        serializer2.serialize(this.inputParams[i].content, headerElement, this.serialziationContext);
                        soapMessage.getHeaders().add(headerElement);
                        this.serialziationContext.setEncoded(flag);
                    } else {
                        writer.enter(operationNamespace, this.inputParams[i].name);
                        writer.enter(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                        if (this.inputParams[i].content == null) {
                            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                            writer.leave();
                        } else {
                            cid = MimeHttpBinding.getCIDUniqueValue() + this.inputParams[i].name;
                            writer.writeAttribute(null, "href", "cid:" + cid);
                            writer.leave();
                            contentType = (String)config.getSubContext("mime").getProperty(this.inputParams[i].name);
                            this.addAttachment(this.inputParams[i].content, contentType, cid, message);
                        }
                        writer.leave();
                    }
                } else if (partLocation[i] == 1) {
                    if (this.inputParams[i].content != null) {
                        this.inputParams[i].contentClass = this.inputParams[i].content.getClass();
                    }
                    writer.enter(null, this.inputParams[i].name);
                    SerializerFactory factory = typeMapping.getSerializer(this.inputParams[i].contentClass, this.inputParams[i].schemaName);
                    serializer = (SerializerBase)factory.getSerializerAs("");
                    serializer.serialize(this.inputParams[i].content, writer, this.serialziationContext);
                } else if (partLocation[i] == 3) {
                    if (this.inputParams[i].content != null) {
                        this.inputParams[i].contentClass = this.inputParams[i].content.getClass();
                    }
                    elementType = typeMapping.getTypeForElement(this.inputParams[i].schemaName);
                    serializer = this.serialziationContext.getSerializer(elementType, this.inputParams[i].contentClass);
                    Element headerElement = soapMessage.createSoapHeader(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                    serializer.serialize(this.inputParams[i].content, headerElement, this.serialziationContext);
                    soapMessage.getHeaders().add(headerElement);
                } else {
                    writer.enter(null, this.inputParams[i].name);
                    if (this.inputParams[i].content == null) {
                        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                        writer.leave();
                    } else {
                        cid = MimeHttpBinding.getCIDUniqueValue() + this.inputParams[i].name;
                        writer.writeAttribute(null, "href", "cid:" + cid);
                        writer.leave();
                        contentType = (String)config.getSubContext("mime").getProperty(this.inputParams[i].name);
                        this.addAttachment(this.inputParams[i].content, contentType, cid, message);
                    }
                }
            }
            ++i;
        }
        writer.leave();
        writer.leave();
        writer.flush();
    }

    private void buildRequestDocument(PropertyContext config, ClientMimeMessage message) throws Exception {
        ClientSOAPMessage soapMessage = message.getSOAPMessage();
        XMLTokenWriter writer = soapMessage.getWriter();
        int[] partLocation = this.getPartLocation(config, this.inputParams);
        SOAPSerializationContext serialziationContext = new SOAPSerializationContext();
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
        serialziationContext.setTypeMapping(typeMapping);
        this.addConformanceClaim(config, soapMessage);
        writer.enter(SOAP_ENVELOPE, SOAP_BODY);
        int i = 0;
        while (i < this.inputParams.length) {
            if (!this.inputParams[i].isElement) {
                throw new Exception(" Document style does not allow type parts !");
            }
            if (partLocation[i] == 1) {
                if (this.inputParams[i].content != null) {
                    this.inputParams[i].contentClass = this.inputParams[i].content.getClass();
                }
                writer.enter(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                QName elementType = typeMapping.getTypeForElement(this.inputParams[i].schemaName);
                SerializerBase serializer = serialziationContext.getSerializer(elementType, this.inputParams[i].contentClass);
                serializer.serialize(this.inputParams[i].content, writer, serialziationContext);
            }
            if (partLocation[i] == 2) {
                writer.enter(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                if (this.inputParams[i] == null) {
                    writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                    writer.leave();
                } else {
                    String cid = MimeHttpBinding.getCIDUniqueValue() + this.inputParams[i].name;
                    writer.writeAttribute("", "href", "cid:" + cid);
                    writer.leave();
                    String contentType = (String)config.getSubContext("mime").getProperty(this.inputParams[i].name);
                    this.addAttachment(this.inputParams[i], contentType, cid, message);
                }
            }
            if (partLocation[i] == 3) {
                boolean flag = serialziationContext.isEncoded();
                serialziationContext.setEncoded(false);
                if (this.inputParams[i].content != null) {
                    this.inputParams[i].contentClass = this.inputParams[i].content.getClass();
                }
                QName elementType = typeMapping.getTypeForElement(this.inputParams[i].schemaName);
                SerializerBase serializer = serialziationContext.getSerializer(elementType, this.inputParams[i].contentClass);
                Element headerElement = soapMessage.createSoapHeader(this.inputParams[i].schemaName.getNamespaceURI(), this.inputParams[i].schemaName.getLocalPart());
                serializer.serialize(this.inputParams[i].content, headerElement, serialziationContext);
                soapMessage.getHeaders().add(headerElement);
                serialziationContext.setEncoded(flag);
            }
            ++i;
        }
        writer.leave();
        writer.flush();
    }

    private String outputMessageSpecial(ClientMimeMessage message, HTTPTransport transport) throws Exception {
        InputStream tempStream;
        Hashtable temp;
        int expectedResponseCode;
        transport.setHeader(CONTENT_TYPE_HEADER, "text/xml; charset=UTF-8");
        this.buffer.reset();
        message.getSOAPMessage().writeTo(this.buffer);
        this.buffer.flush();
        transport.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(this.buffer.size()));
        OutputStream output = transport.getRequestStream();
        output.flush();
        transport.setSocketTimeoutFast(10);
        boolean contentSent = false;
        try {
            expectedResponseCode = transport.getResponseCode();
            transport.resetSocketTimeoutFast();
        }
        catch (InterruptedIOException x) {
            transport.resetSocketTimeoutFast();
            contentSent = true;
            this.buffer.writeTo(output);
            output.flush();
            expectedResponseCode = transport.getResponseCode();
        }
        if (expectedResponseCode == 301 || expectedResponseCode == 302) {
            URL root;
            URL relative;
            temp = new Hashtable(transport.getHeaders());
            tempStream = transport.getResponseStream();
            while (tempStream.read() != -1) {
            }
            String[] headers = transport.getHeader("location");
            transport.closeSession();
            if (headers.length != 0 && (relative = URLLoaderBase.fileOrURLToURL((URL)(root = URLLoaderBase.fileOrURLToURL(null, (String)transport.getEndpoint())), (String)headers[0])) != null) {
                transport.getHeaders().clear();
                transport.setEndpoint(relative.toExternalForm());
                transport.getHeaders().putAll(temp);
                output = transport.getRequestStream();
                this.buffer.writeTo(output);
                output.flush();
                return relative.toExternalForm();
            }
        }
        if (expectedResponseCode == 400 && !contentSent) {
            temp = new Hashtable(transport.getHeaders());
            tempStream = transport.getResponseStream();
            while (tempStream.read() != -1) {
            }
            transport.getHeaders().clear();
            transport.getHeaders().putAll(temp);
            output = transport.getRequestStream();
            this.buffer.writeTo(output);
            output.flush();
        } else if (!contentSent) {
            throw new IOException("The message content was not sent but the server returned answer !");
        }
        return null;
    }

    private String outputMessage(ClientMimeMessage message, HTTPTransport transport, boolean redirectMode) throws Exception {
        int partCount = message.getMultiPartObject().getCount();
        if (partCount > 0) {
            ContentType cntType = new ContentType(message.getMultiPartObject().getContentType());
            String boundaryValue = cntType.getParameter("boundary");
            ParameterList list = new ParameterList();
            list.set("type", "text/xml");
            list.set("boundary", boundaryValue);
            transport.setHeader(CONTENT_TYPE_HEADER, new ContentType("multipart", "related", list).toString());
            this.buffer.reset();
            message.writeTo(this.buffer);
            this.buffer.flush();
            transport.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(this.buffer.size()));
            OutputStream output = transport.getRequestStream();
            this.buffer.writeTo(output);
            output.flush();
            int responseCode = transport.getResponseCode();
            if (responseCode == 301 || responseCode == 302) {
                URL root;
                URL relative;
                Hashtable temp = new Hashtable(transport.getHeaders());
                InputStream tempStream = transport.getResponseStream();
                while (tempStream.read() != -1) {
                }
                String[] headers = transport.getHeader("location");
                transport.closeSession();
                if (headers.length != 0 && (relative = URLLoaderBase.fileOrURLToURL((URL)(root = URLLoaderBase.fileOrURLToURL(null, (String)transport.getEndpoint())), (String)headers[0])) != null) {
                    transport.getHeaders().clear();
                    transport.setEndpoint(relative.toExternalForm());
                    transport.getHeaders().putAll(temp);
                    output = transport.getRequestStream();
                    this.buffer.writeTo(output);
                    output.flush();
                    return relative.toExternalForm();
                }
            }
        } else {
            if (redirectMode) {
                return this.outputMessageSpecial(message, transport);
            }
            transport.setHeader(CONTENT_TYPE_HEADER, "text/xml; charset=UTF-8");
            this.buffer.reset();
            message.getSOAPMessage().writeTo(this.buffer);
            this.buffer.flush();
            transport.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(this.buffer.size()));
            OutputStream output = transport.getRequestStream();
            this.buffer.writeTo(output);
            output.flush();
            int responseCode = transport.getResponseCode();
            if (responseCode == 301 || responseCode == 302) {
                URL root;
                URL relative;
                Hashtable temp = new Hashtable(transport.getHeaders());
                InputStream tempStream = transport.getResponseStream();
                while (tempStream.read() != -1) {
                }
                String[] headers = transport.getHeader("location");
                transport.closeSession();
                if (headers.length != 0 && (relative = URLLoaderBase.fileOrURLToURL((URL)(root = URLLoaderBase.fileOrURLToURL(null, (String)transport.getEndpoint())), (String)headers[0])) != null) {
                    transport.getHeaders().clear();
                    transport.setEndpoint(relative.toExternalForm());
                    transport.getHeaders().putAll(temp);
                    output = transport.getRequestStream();
                    this.buffer.writeTo(output);
                    output.flush();
                    return relative.toExternalForm();
                }
            }
        }
        return null;
    }

    private SOAPFaultException buildFaultException(ClientSOAPMessage message, ArrayList remainingElements) throws Exception {
        XMLTokenReader reader = message.getReader();
        if (reader == null) {
            SOAPBodyImpl soapBody = (SOAPBodyImpl)((Object)message.getSoapBody());
            reader = new XMLDOMTokenReaderNew((Element)((Object)soapBody));
            reader.begin();
        }
        reader.passChars();
        if (reader.getState() != 1) {
            throw new Exception(" Soap Fault reported can not be found in response.");
        }
        if (reader.getLocalName().equals(SOAP_BODY) && SOAP_ENVELOPE.equals(reader.getURI())) {
            reader.next();
            reader.passChars();
        }
        if (reader.getState() != 1) {
            throw new Exception(" Soap Fault reported can not be found in response.");
        }
        String localName = reader.getLocalName();
        String uri = reader.getURI();
        if (!SOAP_FAULT.equals(localName) || !SOAP_ENVELOPE.equals(uri)) {
            throw new Exception(" Soap Fault reported can not be found in response.");
        }
        reader.next();
        reader.passChars();
        QName faultCode = null;
        String faultString = null;
        DetailImpl detailNode = null;
        String faultActor = null;
        while (reader.getState() == 1) {
            boolean flag = false;
            localName = reader.getLocalName();
            uri = reader.getURI();
            if (!flag && SOAP_FAULTCODE.equals(localName) && uri.length() == 0) {
                if (faultCode != null) {
                    throw new Exception(" In SOAP Fault only one fault code node is allowed.");
                }
                flag = true;
                Attributes localAttrs = reader.getAttributes();
                reader.next();
                String qName = reader.getValuePassChars();
                String lName = DOM.qnameToLocalName((String)qName);
                String qNameUri = this.getPrefixUri(DOM.qnameToPrefix((String)qName), localAttrs, reader);
                faultCode = new QName(qNameUri, lName);
                if (reader.getState() != 2) {
                    throw new Exception(" Fault code in the response can not have child elements.");
                }
                reader.next();
                reader.passChars();
            }
            if (!flag && SOAP_FAULTSTRING.equals(localName) && uri.length() == 0) {
                if (faultString != null) {
                    throw new Exception(" In SOAP Fault only one fault string node is allowed.");
                }
                flag = true;
                reader.next();
                faultString = reader.getValuePassChars();
                if (reader.getState() != 2) {
                    throw new Exception(" Fault string in the response can not have child elements.");
                }
                reader.next();
                reader.passChars();
            }
            if (!flag && SOAP_FAULTACTOR.equals(localName) && uri.length() == 0) {
                if (faultActor != null) {
                    throw new Exception(" In SOAP Fault only one fault actor node is allowed.");
                }
                flag = true;
                reader.next();
                faultActor = reader.getValuePassChars();
                if (reader.getState() != 2) {
                    throw new Exception(" Fault actor in the response can not have child elements.");
                }
                reader.next();
                reader.passChars();
            }
            if (!flag && SOAP_FAULTDETAIL.equals(localName) && uri.length() == 0) {
                if (detailNode != null) {
                    throw new Exception(" In SOAP Fault only one detail node is allowed.");
                }
                flag = true;
                SOAPDocumentImpl document = new SOAPDocumentImpl();
                detailNode = new DetailImpl((Document)((Object)document));
                detailNode.init(null, SOAP_FAULTDETAIL, null);
                SOAPElementImpl element = (SOAPElementImpl)((Object)reader.getDOMRepresentation((Document)((Object)document)));
                NamedNodeMap attributes = element.getAttributes();
                int j = 0;
                while (j < attributes.getLength()) {
                    Attr attrib = (Attr)attributes.item(j);
                    attrib = (Attr)detailNode.getOwnerDocument().importNode(attrib, false);
                    detailNode.setAttributeNodeNS(attrib);
                    ++j;
                }
                Iterator elements = element.getChildElements();
                while (elements.hasNext()) {
                    Node next = (Node)elements.next();
                    if (next instanceof SOAPElement) {
                        detailNode.addChildElement((SOAPElement)next);
                    }
                    if (!(next instanceof Text)) continue;
                    detailNode.addTextNode(((Text)next).getValue());
                }
                reader.next();
                reader.passChars();
            }
            if (flag) continue;
            throw new Exception(" Node {" + uri + "}" + localName + " is not allowed in SOAP Fault.");
        }
        if (reader.getState() == 2) {
            reader.next();
            reader.passChars();
        }
        while (reader.getState() == 1) {
            SOAPDocumentImpl document = new SOAPDocumentImpl();
            SOAPElementImpl element = (SOAPElementImpl)((Object)reader.getDOMRepresentation((Document)((Object)document)));
            if (element.getAttribute("id").length() == 0) {
                throw new Exception("SOAP Communication Error. Invalid SOAP Fault returned by the web service. All nodes outside SOAP:Fault must have [id] attribute.");
            }
            remainingElements.add(element);
            reader.next();
            reader.passChars();
        }
        SOAPFaultException result = new SOAPFaultException(faultCode, faultString, faultActor, detailNode);
        while (reader.getState() != 6) {
            reader.next();
        }
        return result;
    }

    private SOAPElement getDetailElement(Detail detail) {
        if (detail == null) {
            return null;
        }
        Iterator it = detail.getDetailEntries();
        SOAPElement result = null;
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof SOAPElement)) continue;
            result = (SOAPElement)next;
            break;
        }
        return result;
    }

    private void processRpcFault(ClientSOAPMessage message, ObjectFactory objFactory) throws Exception {
        this.faultRefs.clear();
        SOAPFaultException exception = this.buildFaultException(message, this.faultRefs);
        SOAPElementImpl element = (SOAPElementImpl)this.getDetailElement(exception.getDetail());
        if (element != null) {
            int i = 0;
            while (i < this.faultParams.length) {
                String name = this.faultParams[i].name;
                if (this.faultParams[i].isElement) {
                    name = this.faultParams[i].schemaName.getLocalPart();
                }
                if (element.getLocalName().equals(name)) {
                    Class faultClass = this.faultParams[i].contentClass;
                    TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
                    QName type = this.faultParams[i].schemaName;
                    if (this.faultParams[i].isElement && (type = typeMapping.getTypeForElement(type)) == null) {
                        if (objFactory != null) {
                            throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
                        }
                        throw exception;
                    }
                    this.deserializationContext.clearContext();
                    this.deserializationContext.setApplicationClassLoader(this.appClassloader);
                    this.deserializationContext.setTypeMapping(typeMapping);
                    if (objFactory != null) {
                        this.deserializationContext.setObjectFactory(objFactory);
                        this.deserializationContext.setObjectFactory(objFactory);
                        Class contentClass = typeMapping.getDefaultJavaClass(type);
                        DeserializerFactory factory = typeMapping.getDeserializer(contentClass, type);
                        if (factory == null) {
                            throw exception;
                        }
                        DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs(null);
                        XMLDOMTokenReaderNew reader = new XMLDOMTokenReaderNew((Element)((Object)element));
                        reader.begin();
                        Object perm = deserializer.deserialize((XMLTokenReader)reader, this.deserializationContext, contentClass);
                        reader.end();
                        WebServiceException wsException = new WebServiceException(exception.getFaultString(), (Throwable)exception, this.faultParams[i].name, perm, type);
                        InvocationTargetException invokeException = new InvocationTargetException(wsException);
                        this.faultParams[i].content = invokeException;
                        throw invokeException;
                    }
                    this.faultParams[i].content = faultClass.newInstance();
                    Class contentClass = ((ProxyException)this.faultParams[i].content).getContentClass();
                    DeserializerFactory factory = typeMapping.getDeserializer(contentClass, type);
                    if (factory == null) {
                        throw exception;
                    }
                    int j = 0;
                    while (j < this.faultRefs.size()) {
                        SOAPElementImpl soapElement = (SOAPElementImpl)((Object)this.faultRefs.get(j));
                        this.deserializationContext.setIdContent(soapElement.getAttribute("id"), (Element)((Object)soapElement));
                        ++j;
                    }
                    DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs("");
                    Object perm = deserializer.deserialize((Node)((Object)element), this.deserializationContext, contentClass);
                    Class[] classes = new Class[]{contentClass};
                    Method method = faultClass.getMethod("init", classes);
                    if (method != null) {
                        method.invoke(this.faultParams[i].content, perm);
                    }
                    ((ProxyException)this.faultParams[i].content)._setFaultActor(exception.getFaultActor());
                    ((ProxyException)this.faultParams[i].content)._setFaultCode(exception.getFaultCode());
                    ((ProxyException)this.faultParams[i].content)._setFaultString(exception.getFaultString());
                    ((Exception)this.faultParams[i].content).fillInStackTrace();
                    return;
                }
                ++i;
            }
            if (objFactory != null) {
                throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
            }
            throw exception;
        }
        if (objFactory != null) {
            throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
        }
        throw exception;
    }

    private void processDocumentFault(ClientSOAPMessage message, ObjectFactory objFactory) throws Exception {
        this.faultRefs.clear();
        SOAPFaultException exception = this.buildFaultException(message, this.faultRefs);
        SOAPElementImpl element = (SOAPElementImpl)this.getDetailElement(exception.getDetail());
        if (element != null) {
            int i = 0;
            while (i < this.faultParams.length) {
                if (element.getLocalName().equals(this.faultParams[i].schemaName.getLocalPart())) {
                    if (!this.faultParams[i].isElement) {
                        throw new Exception(" Document style does not allow type links to parts !");
                    }
                    TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
                    Class faultClass = this.faultParams[i].contentClass;
                    QName type = typeMapping.getTypeForElement(this.faultParams[i].schemaName);
                    if (type == null) {
                        if (objFactory != null) {
                            throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
                        }
                        throw exception;
                    }
                    this.deserializationContext.clearContext();
                    this.deserializationContext.setApplicationClassLoader(this.appClassloader);
                    this.deserializationContext.setTypeMapping(typeMapping);
                    if (objFactory != null) {
                        this.deserializationContext.setObjectFactory(objFactory);
                        Class contentClass = typeMapping.getDefaultJavaClass(type);
                        DeserializerFactory factory = typeMapping.getDeserializer(contentClass, type);
                        if (factory == null) {
                            throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
                        }
                        DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs(null);
                        XMLDOMTokenReaderNew reader = new XMLDOMTokenReaderNew((Element)((Object)element));
                        reader.begin();
                        Object perm = deserializer.deserialize((XMLTokenReader)reader, this.deserializationContext, contentClass);
                        reader.end();
                        WebServiceException wsException = new WebServiceException(exception.getFaultString(), (Throwable)exception, this.faultParams[i].name, perm, type);
                        InvocationTargetException invokeException = new InvocationTargetException(wsException);
                        this.faultParams[i].content = invokeException;
                        throw invokeException;
                    }
                    this.faultParams[i].content = faultClass.newInstance();
                    Class contentClass = ((ProxyException)this.faultParams[i].content).getContentClass();
                    DeserializerFactory factory = typeMapping.getDeserializer(contentClass, type);
                    if (factory == null) {
                        throw exception;
                    }
                    DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs(null);
                    XMLDOMTokenReaderNew reader = new XMLDOMTokenReaderNew((Element)((Object)element));
                    reader.begin();
                    Object perm = deserializer.deserialize((XMLTokenReader)reader, this.deserializationContext, contentClass);
                    reader.end();
                    Class[] classes = new Class[]{contentClass};
                    Method method = faultClass.getMethod("init", classes);
                    if (method != null) {
                        method.invoke(this.faultParams[i].content, perm);
                    }
                    ((ProxyException)this.faultParams[i].content)._setFaultActor(exception.getFaultActor());
                    ((ProxyException)this.faultParams[i].content)._setFaultCode(exception.getFaultCode());
                    ((ProxyException)this.faultParams[i].content)._setFaultString(exception.getFaultString());
                    ((Exception)this.faultParams[i].content).fillInStackTrace();
                    return;
                }
                ++i;
            }
            if (objFactory != null) {
                throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
            }
            throw exception;
        }
        if (objFactory != null) {
            throw new InvocationTargetException((Throwable)exception, exception.getFaultString());
        }
        throw exception;
    }

    private static String getCIDUniqueValue() {
        long ln = System.currentTimeMillis();
        return Long.toString(ln);
    }

    /*
     * WARNING - void declaration
     */
    private int handleResponseMessage(HTTPTransport transport, ClientMimeMessage message) throws Exception {
        int responseCode = transport.getResponseCode();
        String contentType = transport.getContentType();
        if (responseCode == 200) {
            if (this.outputParams != null) {
                message.initDeserializationMode(transport);
            }
            return responseCode;
        }
        if (responseCode == 202) {
            return responseCode;
        }
        if (responseCode == 500) {
            int readBytes;
            if (contentType.indexOf("text/xml") != -1) {
                message.initDeserializationMode(transport);
                return responseCode;
            }
            InputStream response = transport.getResponseStream();
            int maxHTMLToRead = 10240;
            byte[] buffer = new byte[maxHTMLToRead];
            int pos = 0;
            while ((readBytes = response.read(buffer, pos, maxHTMLToRead - pos)) != -1) {
                void var8_11;
                if ((pos += var8_11) >= maxHTMLToRead) break;
            }
            String str = new String(buffer, 0, pos);
            throw new Exception("Call to {" + transport.getEndpoint() + "} returned http code 500 (" + transport.getResponseMessage() + ") with unacceptable content type (" + contentType + ").\n" + str);
        }
        String responseMessage = transport.getResponseMessage();
        Hashtable responseHeaders = transport.getHeaders();
        throw new InvalidResponseCodeException(responseCode, responseMessage, responseHeaders, transport.getEndpoint());
    }

    private Object loadAttachment(String reference, String partName, ClientMimeMessage message) throws Exception {
        BodyPart bodyPart = message.getPart(reference);
        if (bodyPart == null) {
            throw new Exception(" Part '" + partName + "' not found as attachment !");
        }
        String contentType = bodyPart.getContentType();
        if (!this.checkContentType(contentType)) {
            throw new Exception(" Content-type '" + contentType + "' not supported !");
        }
        if (contentType.indexOf("text/plain") != -1) {
            return MimeHttpBinding.createStringFromStream(bodyPart.getInputStream(), contentType);
        }
        if (contentType.indexOf("application/octetstream") != -1) {
            return MimeHttpBinding.createByteArrayFromStream(bodyPart.getInputStream());
        }
        if (contentType.indexOf("application/octet-stream") != -1) {
            return MimeHttpBinding.createByteArrayFromStream(bodyPart.getInputStream());
        }
        return null;
    }

    private static String getHeaderValue(BodyPart part, String headerName) throws Exception {
        try {
            String[] str = part.getHeader(headerName);
            if (str != null && str.length == 1) {
                return str[0];
            }
            return null;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean getResponseDocument(PropertyContext context, ClientMimeMessage message, ObjectFactory objFactory) throws Exception {
        int[] partLocation = this.getPartLocation(context, this.outputParams);
        this.deserializationContext.clearContext();
        this.deserializationContext.setApplicationClassLoader(this.appClassloader);
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
        this.deserializationContext.setTypeMapping(typeMapping);
        this.deserializationContext.setObjectFactory(objFactory);
        ClientSOAPMessage soapMessage = message.getSOAPMessage();
        XMLTokenReader reader = null;
        if (soapMessage.isDOMbuilt()) {
            Element body = soapMessage.getSoapBody();
            reader = new XMLDOMTokenReaderNew(body);
            reader.begin();
        } else {
            reader = soapMessage.getReader();
        }
        reader.passChars();
        if (reader.getState() != 1) throw new Exception(" Can not find soap:Body !");
        if (!reader.getLocalName().equals(SOAP_BODY)) throw new Exception(" Can not find soap:Body !");
        if (!SOAP_ENVELOPE.equals(reader.getURI())) throw new Exception(" Can not find soap:Body !");
        reader.next();
        reader.passChars();
        if (reader.getState() == 1 && SOAP_FAULT.equals(reader.getLocalName()) && SOAP_ENVELOPE.equals(reader.getURI())) {
            this.processDocumentFault(message.getSOAPMessage(), objFactory);
            return false;
        }
        int i = 0;
        while (i < this.outputParams.length) {
            Element element;
            DeserializerBase deserializer;
            DeserializerFactory factory;
            QName elementType;
            if (!this.outputParams[i].isElement) {
                throw new Exception(" Document style does not allow type parts !");
            }
            if (partLocation[i] == 1 || partLocation[i] == 2) {
                reader.passChars();
                if (reader.getState() != 1) {
                    throw new Exception(" Element '{" + this.outputParams[i].schemaName.getNamespaceURI() + "}" + this.outputParams[i].schemaName.getLocalPart() + "' not found in response message.");
                }
                String localName = reader.getLocalName();
                String namespace = reader.getURI();
                if (!localName.equals(this.outputParams[i].schemaName.getLocalPart())) throw new Exception(" Part '" + this.outputParams[i].name + "' not found in response !");
                if (!namespace.equals(this.outputParams[i].schemaName.getNamespaceURI())) throw new Exception(" Part '" + this.outputParams[i].name + "' not found in response !");
                if (partLocation[i] == 1) {
                    elementType = typeMapping.getTypeForElement(this.outputParams[i].schemaName);
                    factory = typeMapping.getDeserializer(this.outputParams[i].contentClass, elementType);
                    deserializer = (DeserializerBase)factory.getDeserializerAs("");
                    this.outputParams[i].content = deserializer.deserialize(reader, this.deserializationContext, this.outputParams[i].contentClass);
                } else if (partLocation[i] == 3) {
                    Element element2 = soapMessage.getSoapHeader(this.outputParams[i].schemaName.getNamespaceURI(), this.outputParams[i].schemaName.getLocalPart());
                    if (element2 != null) {
                        XMLDOMTokenReaderNew headerReader = new XMLDOMTokenReaderNew(element2);
                        headerReader.begin();
                        QName elementType2 = typeMapping.getTypeForElement(this.outputParams[i].schemaName);
                        DeserializerFactory factory2 = typeMapping.getDeserializer(this.outputParams[i].contentClass, elementType2);
                        DeserializerBase deserializer2 = (DeserializerBase)factory2.getDeserializerAs(null);
                        this.outputParams[i].content = deserializer2.deserialize((XMLTokenReader)headerReader, this.deserializationContext, this.outputParams[i].contentClass);
                        headerReader.end();
                    }
                } else {
                    Attributes attributes = reader.getAttributes();
                    String href = attributes.getValue("href");
                    if (href == null) throw new Exception(" Attached part must have href attribute !");
                    this.outputParams[i].content = this.loadAttachment(href, this.outputParams[i].name, message);
                    reader.passChars();
                    if (reader.getState() != 2) {
                        throw new Exception(" Attached part must be empty !");
                    }
                    reader.next();
                }
            }
            if (partLocation[i] == 3 && (element = soapMessage.getSoapHeader(this.outputParams[i].schemaName.getNamespaceURI(), this.outputParams[i].schemaName.getLocalPart())) != null) {
                XMLDOMTokenReaderNew headerReader = new XMLDOMTokenReaderNew(element);
                headerReader.begin();
                elementType = typeMapping.getTypeForElement(this.outputParams[i].schemaName);
                factory = typeMapping.getDeserializer(this.outputParams[i].contentClass, elementType);
                deserializer = (DeserializerBase)factory.getDeserializerAs(null);
                this.outputParams[i].content = deserializer.deserialize(reader, this.deserializationContext, this.outputParams[i].contentClass);
                headerReader.end();
            }
            ++i;
        }
        while (reader.getState() != 6) {
            reader.next();
        }
        return true;
    }

    private boolean getResponseRpc(PropertyContext context, ClientMimeMessage message, ObjectFactory objFactory) throws Exception {
        String parts = (String)context.getProperty(SOAP_PARTS);
        int[] partLocation = this.getPartLocation(context, this.outputParams);
        this.deserializationContext.clearContext();
        this.deserializationContext.setApplicationClassLoader(this.appClassloader);
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.registry.getDefaultTypeMapping();
        this.deserializationContext.setTypeMapping(typeMapping);
        this.deserializationContext.setObjectFactory(objFactory);
        ClientSOAPMessage soapMessage = message.getSOAPMessage();
        String namespace = (String)context.getProperty(SOAP_OPERATION_NAMESPACE);
        XMLTokenReader reader = null;
        if (soapMessage.isDOMbuilt()) {
            Element body = soapMessage.getSoapBody();
            reader = new XMLDOMTokenReaderNew(body);
            reader.begin();
        } else {
            reader = soapMessage.getReader();
        }
        reader.passChars();
        if (reader.getState() != 1 || !reader.getLocalName().equals(SOAP_BODY)) {
            throw new Exception(" Can not find soap:Body !");
        }
        reader.next();
        reader.passChars();
        if (reader.getState() == 1 && SOAP_FAULT.equals(reader.getLocalName()) && SOAP_ENVELOPE.equals(reader.getURI())) {
            this.processRpcFault(message.getSOAPMessage(), objFactory);
            return false;
        }
        if (reader.getState() == 1) {
            reader.next();
            int i = 0;
            while (i < this.outputParams.length) {
                if (partLocation[i] == 1 || partLocation[i] == 2) {
                    String href;
                    Attributes attributes;
                    reader.passChars();
                    if (reader.getState() != 1 || !reader.getLocalName().equals(this.outputParams[i].name)) {
                        throw new Exception(" Can not find part :" + this.outputParams[i].name);
                    }
                    if (this.outputParams[i].isElement) {
                        reader.next();
                        reader.passChars();
                        if (reader.getState() != 1) {
                            throw new Exception(" Unrecognized response !");
                        }
                        if (reader.getLocalName().equals(this.outputParams[i].schemaName.getLocalPart())) {
                            if (partLocation[i] == 1) {
                                QName elementType = typeMapping.getTypeForElement(this.outputParams[i].schemaName);
                                DeserializerFactory factory = typeMapping.getDeserializer(this.outputParams[i].contentClass, elementType);
                                DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs("");
                                this.outputParams[i].content = deserializer.deserialize(reader, this.deserializationContext, this.outputParams[i].contentClass);
                            } else {
                                attributes = reader.getAttributes();
                                href = attributes.getValue("href");
                                if (href == null) {
                                    throw new Exception(" Attached part must have href attribute !");
                                }
                                this.outputParams[i].content = this.loadAttachment(href, this.outputParams[i].name, message);
                                reader.passChars();
                                if (reader.getState() != 2) {
                                    throw new Exception(" Attached part must be empty !");
                                }
                            }
                        } else {
                            throw new Exception(" Unrecognized response !");
                        }
                        reader.next();
                    } else if (partLocation[i] == 1) {
                        DeserializerFactory factory = typeMapping.getDeserializer(this.outputParams[i].contentClass, this.outputParams[i].schemaName);
                        DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs("");
                        this.outputParams[i].content = deserializer.deserialize(reader, this.deserializationContext, this.outputParams[i].contentClass);
                    } else {
                        attributes = reader.getAttributes();
                        href = attributes.getValue("href");
                        if (href == null) {
                            throw new Exception(" Attached part must have href attribute !");
                        }
                        this.outputParams[i].content = this.loadAttachment(href, this.outputParams[i].name, message);
                        reader.next();
                        reader.passChars();
                        if (reader.getState() != 2) {
                            throw new Exception(" Attached part must be empty !");
                        }
                    }
                    reader.next();
                }
                ++i;
            }
            reader.passChars();
            reader.next();
            this.deserializationContext.deserializeRemainingElements(reader);
        }
        while (reader.getState() != 6) {
            reader.next();
        }
        int i = 0;
        while (i < this.outputParams.length) {
            Element element;
            if (this.outputParams[i].content != null && this.outputParams[i].content instanceof SOAPDeserializationState) {
                SOAPDeserializationState state = (SOAPDeserializationState)this.outputParams[i].content;
                if (state.isComplete()) {
                    this.outputParams[i].content = state.getInstance();
                } else {
                    throw new Exception(" Some references in responce could not be resolved !");
                }
            }
            if (partLocation[i] == 3 && (element = soapMessage.getSoapHeader(this.outputParams[i].schemaName.getNamespaceURI(), this.outputParams[i].schemaName.getLocalPart())) != null) {
                XMLDOMTokenReaderNew headerReader = new XMLDOMTokenReaderNew(element);
                headerReader.begin();
                QName elementType = typeMapping.getTypeForElement(this.outputParams[i].schemaName);
                DeserializerFactory factory = typeMapping.getDeserializer(this.outputParams[i].contentClass, elementType);
                DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs(null);
                this.outputParams[i].content = deserializer.deserialize((XMLTokenReader)headerReader, this.deserializationContext, this.outputParams[i].contentClass);
                headerReader.end();
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void call(PropertyContext context, ProtocolList globalProtocols, ProtocolList localProtocols) throws Exception {
        boolean keepAliveFlag22;
        block30: {
            boolean transportInit = false;
            try {
                try {
                    Hashtable table;
                    block35: {
                        ContentHandler saxHandler;
                        block36: {
                            ObjectFactory objFactory;
                            PropertyContext configContext;
                            block37: {
                                String newURI;
                                String style;
                                boolean redirectMode;
                                block32: {
                                    block33: {
                                        block34: {
                                            configContext = context.getSubContext("bindingConfig");
                                            PropertyContext featureContext = context.getSubContext("featureConfig");
                                            objFactory = (ObjectFactory)context.getProperty("objectFactory");
                                            Object object = featureContext.getProperty("saxResponseHandler");
                                            saxHandler = null;
                                            if (object != null && object instanceof ContentHandler) {
                                                saxHandler = (ContentHandler)object;
                                            }
                                            redirectMode = false;
                                            String httpRedirectSpecial = (String)featureContext.getProperty("httpRedirect");
                                            if (httpRedirectSpecial != null && httpRedirectSpecial.length() != 0) {
                                                redirectMode = true;
                                            }
                                            if (!configContext.isDefined()) {
                                                throw new Exception(" No binding configuration provided in context !");
                                            }
                                            String endpoint = (String)configContext.getProperty("endpointUrl");
                                            if (endpoint == null) {
                                                throw new Exception(" Endpoint not specified in binding context !");
                                            }
                                            this.appClassloader = null;
                                            if (context.getProperty("javax.xml.rpc.classloader") != null) {
                                                this.appClassloader = (ClassLoader)context.getProperty("javax.xml.rpc.classloader");
                                            }
                                            this.transport.init(endpoint, "POST", context.getSubContext("featureConfig"));
                                            transportInit = true;
                                            context.setProperty("transportInterface", this.transport);
                                            String soapAction = (String)configContext.getProperty(SOAP_ACTION);
                                            if (soapAction != null) {
                                                this.transport.setHeader(SOAP_ACTION_UPPER, "\"" + soapAction + "\"");
                                            } else {
                                                this.transport.setHeader(SOAP_ACTION_UPPER, "\"\"");
                                            }
                                            table = (Hashtable)context.getProperty("httpRequestHeaders");
                                            if (table != null) {
                                                Enumeration enum1 = table.keys();
                                                while (true) {
                                                    if (!enum1.hasMoreElements()) {
                                                        table.clear();
                                                        break;
                                                    }
                                                    String headerName = (String)enum1.nextElement();
                                                    String[] headerContents = (String[])table.get(headerName);
                                                    this.transport.setHeader(headerName, headerContents);
                                                }
                                            }
                                            if ((table = (Hashtable)context.getProperty("httpResponseHeaders")) != null) {
                                                table.clear();
                                            }
                                            this.message.initSerializationMode();
                                            style = (String)configContext.getProperty(SOAP_STYLE);
                                            if (!style.equals(DOCUMENT_STYLE)) break block32;
                                            this.buildRequestDocument(configContext.getSubContext("input"), this.message);
                                            globalProtocols.handleRequest(this.message, context);
                                            localProtocols.handleRequest(this.message, context);
                                            newURI = this.outputMessage(this.message, this.transport, redirectMode);
                                            if (newURI != null) {
                                                configContext.setProperty("endpointUrl", newURI);
                                            }
                                            if (saxHandler != null) break block33;
                                            int responseCode = this.handleResponseMessage(this.transport, this.message);
                                            if (responseCode != 500) break block34;
                                            this.processDocumentFault(this.message.getSOAPMessage(), objFactory);
                                            globalProtocols.handleFault(this.message, context);
                                            localProtocols.handleFault(this.message, context);
                                            break block35;
                                        }
                                        if (this.outputParams != null) {
                                            globalProtocols.handleResponse(this.message, context);
                                            localProtocols.handleResponse(this.message, context);
                                            if (!this.getResponseDocument(configContext.getSubContext("output"), this.message, objFactory)) {
                                                globalProtocols.handleFault(this.message, context);
                                                localProtocols.handleFault(this.message, context);
                                            }
                                            break block35;
                                        } else {
                                            InputStream is = this.transport.getResponseStream();
                                            while (is.read() != -1) {
                                            }
                                        }
                                        break block35;
                                    }
                                    this.handlerSAXMessage(this.transport, saxHandler);
                                    this.fillOutputParameters();
                                    break block35;
                                }
                                if (!style.equals(RPC_STYLE)) throw new Exception(" Binding configuration Exception !");
                                this.buildRequestRpc(configContext.getSubContext("input"), this.message);
                                globalProtocols.handleRequest(this.message, context);
                                localProtocols.handleRequest(this.message, context);
                                newURI = this.outputMessage(this.message, this.transport, redirectMode);
                                if (newURI != null) {
                                    configContext.setProperty("endpointUrl", newURI);
                                }
                                if (saxHandler != null) break block36;
                                int responseCode = this.handleResponseMessage(this.transport, this.message);
                                if (responseCode != 500) break block37;
                                this.processRpcFault(this.message.getSOAPMessage(), objFactory);
                                globalProtocols.handleFault(this.message, context);
                                localProtocols.handleFault(this.message, context);
                                break block35;
                            }
                            if (this.outputParams != null) {
                                globalProtocols.handleResponse(this.message, context);
                                localProtocols.handleResponse(this.message, context);
                                if (!this.getResponseRpc(configContext.getSubContext("output"), this.message, objFactory)) {
                                    globalProtocols.handleFault(this.message, context);
                                    localProtocols.handleFault(this.message, context);
                                }
                                break block35;
                            } else {
                                InputStream is = this.transport.getResponseStream();
                                while (is.read() != -1) {
                                }
                            }
                            break block35;
                        }
                        this.handlerSAXMessage(this.transport, saxHandler);
                        this.fillOutputParameters();
                    }
                    table = (Hashtable)context.getProperty("httpResponseHeaders");
                    if (table != null) {
                        Hashtable responseHeaders = this.transport.getHeaders();
                        table.putAll(responseHeaders);
                    }
                }
                catch (XmlMarshalException x) {
                    if (!transportInit) throw x;
                    this.transport.closeSession();
                    throw x;
                }
                catch (XmlUnmarshalException y) {
                    if (!transportInit) throw y;
                    this.transport.closeSession();
                    throw y;
                }
                Object var20_24 = null;
                if (!transportInit) return;
                keepAliveFlag22 = false;
                if (!this.transport.featureSet("http://www.sap.com/webas/630/soap/features/http/keepAlive")) break block30;
            }
            catch (Throwable throwable) {
                PropertyContext feature2;
                String keepAlive2;
                Object var20_25 = null;
                if (!transportInit) throw throwable;
                boolean keepAliveFlag22 = false;
                if (this.transport.featureSet("http://www.sap.com/webas/630/soap/features/http/keepAlive") && (keepAlive2 = (String)(feature2 = this.transport.getFeature("http://www.sap.com/webas/630/soap/features/http/keepAlive")).getProperty("keepAliveStatus")) != null && keepAlive2.length() != 0) {
                    keepAliveFlag22 = true;
                }
                if (keepAliveFlag22) throw throwable;
                this.transport.closeSession();
                throw throwable;
            }
            PropertyContext feature2 = this.transport.getFeature("http://www.sap.com/webas/630/soap/features/http/keepAlive");
            String keepAlive2 = (String)feature2.getProperty("keepAliveStatus");
            if (keepAlive2 != null && keepAlive2.length() != 0) {
                keepAliveFlag22 = true;
            }
        }
        if (keepAliveFlag22) return;
        this.transport.closeSession();
    }

    private void fillOutputParameters() {
        if (this.outputParams != null) {
            int i = 0;
            while (i < this.outputParams.length) {
                if (this.outputParams[i].contentClass == Integer.TYPE) {
                    this.outputParams[i].content = new Integer(0);
                }
                if (this.outputParams[i].contentClass == Byte.TYPE) {
                    this.outputParams[i].content = new Byte(0);
                }
                if (this.outputParams[i].contentClass == Short.TYPE) {
                    this.outputParams[i].content = new Short(0);
                }
                if (this.outputParams[i].contentClass == Long.TYPE) {
                    this.outputParams[i].content = new Long(0L);
                }
                if (this.outputParams[i].contentClass == Double.TYPE) {
                    this.outputParams[i].content = new Double(0.0);
                }
                if (this.outputParams[i].contentClass == Float.TYPE) {
                    this.outputParams[i].content = new Float(0.0f);
                }
                if (this.outputParams[i].contentClass == Boolean.TYPE) {
                    this.outputParams[i].content = new Boolean(false);
                }
                ++i;
            }
        }
    }

    private int handlerSAXMessage(HTTPTransport transport, ContentHandler handler) throws Exception {
        if (this.saxReader == null) {
            SAXParser saxParser = this.spf.newSAXParser();
            this.saxReader = saxParser.getXMLReader();
        }
        int responseCode = transport.getResponseCode();
        String contentType = transport.getContentType();
        if (responseCode == 200) {
            byte[] buffer;
            if (contentType.indexOf("text/xml") != -1) {
                if (this.outputParams != null) {
                    this.saxReader.setContentHandler(handler);
                    this.saxReader.parse(new InputSource(transport.getResponseStream()));
                }
                return responseCode;
            }
            InputStream response = transport.getResponseStream();
            int readBytes = response.read(buffer = new byte[1024]);
            if (readBytes == -1) {
                readBytes = 0;
            }
            String str = new String(buffer, 0, readBytes);
            throw new Exception("Call to {" + transport.getEndpoint() + "} returned http code 500 with unacceptable content type (" + contentType + ").\n" + str);
        }
        if (responseCode == 202) {
            return responseCode;
        }
        if (responseCode == 500) {
            byte[] buffer;
            if (contentType.indexOf("text/xml") != -1) {
                this.saxReader.setContentHandler(handler);
                this.saxReader.parse(new InputSource(transport.getResponseStream()));
                return responseCode;
            }
            InputStream response = transport.getResponseStream();
            int readBytes = response.read(buffer = new byte[1024]);
            if (readBytes == -1) {
                readBytes = 0;
            }
            String str = new String(buffer, 0, readBytes);
            throw new Exception("Call to {" + transport.getEndpoint() + "} returned http code 500 with unacceptable content type (" + contentType + ").\n" + str);
        }
        String responseMessage = transport.getResponseMessage();
        Hashtable responseHeaders = transport.getHeaders();
        throw new InvalidResponseCodeException(responseCode, responseMessage, responseHeaders, transport.getEndpoint());
    }

    public void generateCustom(String packageName, File outputDir, WSDLDefinitions definitions, PropertyContext context, WSDLOperation operation) {
    }

    public String getName() {
        return NAME;
    }

    public PropertyContext getConfigurationContext() {
        return null;
    }

    public void getMainBindingConfig(WSDLBinding binding, PropertyContext context) throws WSDLException {
        ArrayList extensions = binding.getExtensions();
        WSDLExtension extensionElement = null;
        int i = 0;
        while (i < extensions.size()) {
            extensionElement = (WSDLExtension)extensions.get(i);
            if (extensionElement.getLocalName().equals("binding") && SOAP_BINDING_NAMESPACE.equals(extensionElement.getURI())) break;
            extensionElement = null;
            ++i;
        }
        if (extensionElement != null) {
            String style = extensionElement.getAttribute(SOAP_STYLE);
            if (style == null) {
                style = DOCUMENT_STYLE;
            }
            context.setProperty(SOAP_STYLE, style);
            String transport = extensionElement.getAttribute(SOAP_TRANSPORT);
            context.setProperty(SOAP_TRANSPORT, transport);
        }
    }

    private void setupSoapHeader(WSDLExtension extension, PropertyContext context, WSDLMessage rootMessage) throws WSDLException {
        String message = extension.getAttribute("message");
        String part = extension.getAttribute("part");
        String use = extension.getAttribute(SOAP_USE);
        if (use == null) {
            use = "literal";
        }
        PropertyContext headerContext = context.getSubContext("headers");
        if (message != null) {
            message = DOM.qnameToLocalName((String)message);
        }
        if (rootMessage.getName().equals(message)) {
            message = null;
        }
        if (message == null && part != null && rootMessage != null) {
            WSDLPart wsdlpart = rootMessage.getPart(part);
            if (wsdlpart == null) {
                throw new WSDLException(" Part [" + part + "] does not exist in message [" + rootMessage.getName() + "] but referenced from soap:header !");
            }
            headerContext.setProperty(part, use);
        }
    }

    private void setupSoapBody(WSDLExtension extension, PropertyContext context) {
        context.setProperty(SOAP_PARTS, extension.getAttribute(SOAP_PARTS));
        context.setProperty(SOAP_USE, extension.getAttribute(SOAP_USE));
        context.setProperty(SOAP_ENCODING_STYLE, extension.getAttribute(SOAP_ENCODING_STYLE));
        context.setProperty(SOAP_OPERATION_NAMESPACE, extension.getAttribute(SOAP_OPERATION_NAMESPACE));
    }

    private void setupMimeRelated(WSDLExtension extension, PropertyContext context, WSDLChannel channel, WSDLDefinitions definitions) throws WSDLException {
        PropertyContext mimeInputContext = context.getSubContext("mime");
        ArrayList mimeParts = extension.getChildren();
        int j = 0;
        while (j < mimeParts.size()) {
            WSDLExtension e = (WSDLExtension)mimeParts.get(j);
            if (e.getLocalName().equals("part") && MIME_BINDING_NAMESPACE.equals(e.getURI())) {
                ArrayList mimeContents = e.getChildren();
                if (mimeContents.size() == 0) {
                    throw new WSDLException(" No content found in mime:part !");
                }
                int k = 0;
                while (k < mimeContents.size()) {
                    WSDLExtension mimeContent = (WSDLExtension)mimeContents.get(k);
                    if (mimeContent.getLocalName().equals("content") && MIME_BINDING_NAMESPACE.equals(mimeContent.getURI())) {
                        String part = mimeContent.getAttribute("part");
                        String type = mimeContent.getAttribute("type");
                        if (part == null || type == null) {
                            throw new WSDLException("'part' and 'type' attributes are nessesary in mime:content !");
                        }
                        mimeInputContext.setProperty(part, type.trim().toLowerCase());
                        break;
                    }
                    if (mimeContent.getLocalName().equals("body") && SOAP_BINDING_NAMESPACE.equals(mimeContent.getURI())) {
                        this.setupSoapBody(mimeContent, context);
                    } else if (mimeContent.getLocalName().equals("header") && SOAP_BINDING_NAMESPACE.equals(mimeContent.getURI())) {
                        WSDLMessage message = null;
                        if (channel != null) {
                            message = definitions.getMessage(channel.getMessage().getName(), channel.getMessage().getURI());
                        }
                        this.setupSoapHeader(mimeContent, context, message);
                    }
                    ++k;
                }
            } else {
                throw new WSDLException(" Mime Binding allows onlw mime:part element's in mime:multipartRelated binding element !");
            }
            ++j;
        }
    }

    private boolean isValidStyle(String style) {
        if (style == null) {
            return false;
        }
        return style.equals(DOCUMENT_STYLE) || style.equals(RPC_STYLE);
    }

    private String getConforms(WSDLNamedNode node) {
        String perm;
        Element element;
        WSDLDocumentation documenation = node.getDocumentation();
        if (documenation != null && documenation.getElementContent() != null && WSI_NAMESPACE.equals((element = documenation.getElementContent()).getNamespaceURI()) && WSI_CLAIM.equals(element.getLocalName()) && (perm = element.getAttribute("conformsTo")).length() != 0) {
            return perm;
        }
        return null;
    }

    private void setupWsiClaims(WSDLDefinitions definitions, PropertyContext oContext, WSDLOperation operation) {
        String conformsTo = null;
        WSDLPortType portType = (WSDLPortType)operation.getParentNode();
        WSDLBinding binding = null;
        ArrayList barr = definitions.getBindings();
        int i = 0;
        while (i < barr.size()) {
            WSDLBinding perm = (WSDLBinding)barr.get(i);
            if (perm.getType().equals((Object)portType.getQName())) {
                binding = perm;
                break;
            }
            ++i;
        }
        WSDLPort port = null;
        if (definitions.getServices().size() != 0 && binding != null) {
            WSDLService service = (WSDLService)definitions.getServices().get(0);
            ArrayList ports = service.getPorts();
            int i2 = 0;
            while (i2 < ports.size()) {
                WSDLPort perm = (WSDLPort)ports.get(i2);
                if (perm.getBinding().equals((Object)binding.getQName())) {
                    port = perm;
                    break;
                }
                ++i2;
            }
        }
        if (port != null) {
            conformsTo = this.getConforms(port);
        }
        if (binding != null && conformsTo == null) {
            conformsTo = this.getConforms(binding);
        }
        if (portType != null && conformsTo == null) {
            conformsTo = this.getConforms(portType);
        }
        if (conformsTo == null) {
            conformsTo = this.getConforms(operation);
        }
        if (operation.getInput() != null && conformsTo == null) {
            WSDLChannel input = operation.getInput();
            WSDLMessage message = definitions.getMessage(input.getMessage());
            conformsTo = this.getConforms(message);
        }
        if (conformsTo != null) {
            oContext.setProperty("conformsTo", conformsTo);
        }
    }

    public void getOperationBindingConfig(WSDLBindingOperation obinding, WSDLOperation operation, PropertyContext context, WSDLDefinitions definitions) throws WSDLException {
        WSDLBindingChannel outputBinding;
        WSDLExtension extension;
        ArrayList operationBiniding = obinding.getExtensions();
        if (operationBiniding.size() > 0 && (extension = (WSDLExtension)operationBiniding.get(0)).getLocalName().equals(SOAP_OPERATION) && SOAP_BINDING_NAMESPACE.equals(extension.getURI())) {
            String soapAction = extension.getAttribute(SOAP_ACTION);
            context.setProperty(SOAP_ACTION, soapAction);
            String style = extension.getAttribute(SOAP_STYLE);
            if (style != null) {
                if (!this.isValidStyle(style)) {
                    throw new WSDLException("Invalis style attribute is set: must be (document/rpc) but (" + style + ") is specified !");
                }
                context.setProperty(SOAP_STYLE, style);
            }
        }
        WSDLBindingChannel inputBinding = obinding.getInput();
        PropertyContext inputContext = context.getSubContext("input");
        inputContext.setProperty(OPERATION_NAME, operation.getName());
        if (inputBinding != null) {
            ArrayList extensions = inputBinding.getExtensions();
            int i = 0;
            while (i < extensions.size()) {
                WSDLExtension extension2 = (WSDLExtension)extensions.get(i);
                if (extension2.getLocalName().equals("body") && SOAP_BINDING_NAMESPACE.equals(extension2.getURI())) {
                    this.setupSoapBody(extension2, inputContext);
                }
                if (extension2.getLocalName().equals("header") && SOAP_BINDING_NAMESPACE.equals(extension2.getURI())) {
                    WSDLMessage message = null;
                    if (operation.getInput() != null) {
                        message = definitions.getMessage(operation.getInput().getMessage().getName(), operation.getInput().getMessage().getURI());
                    }
                    this.setupSoapHeader(extension2, inputContext, message);
                }
                if (extension2.getLocalName().equals(MIME_RELATED) && MIME_BINDING_NAMESPACE.equals(extension2.getURI())) {
                    this.setupMimeRelated(extension2, inputContext, operation.getInput(), definitions);
                }
                ++i;
            }
        }
        if ((outputBinding = obinding.getOutput()) != null) {
            PropertyContext outputContext = context.getSubContext("output");
            outputContext.setProperty(OPERATION_NAME, operation.getName());
            ArrayList extensions = outputBinding.getExtensions();
            int i = 0;
            while (i < extensions.size()) {
                WSDLExtension extension3 = (WSDLExtension)extensions.get(i);
                if (extension3.getLocalName().equals("body") && SOAP_BINDING_NAMESPACE.equals(extension3.getURI())) {
                    this.setupSoapBody(extension3, outputContext);
                }
                if (extension3.getLocalName().equals("header") && SOAP_BINDING_NAMESPACE.equals(extension3.getURI())) {
                    WSDLMessage message = null;
                    if (operation.getOutput() != null) {
                        message = definitions.getMessage(operation.getOutput().getMessage().getName(), operation.getOutput().getMessage().getURI());
                    }
                    this.setupSoapHeader(extension3, outputContext, message);
                }
                if (extension3.getLocalName().equals(MIME_RELATED) && MIME_BINDING_NAMESPACE.equals(extension3.getURI())) {
                    this.setupMimeRelated(extension3, outputContext, operation.getOutput(), definitions);
                }
                ++i;
            }
        }
    }

    public ServiceParam[] getResponseParts() {
        return new ServiceParam[0];
    }

    public ServiceParam[] getFaultParts() {
        return new ServiceParam[0];
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.registry;
    }

    public boolean isCompatible(AbstractProtocol prorocol) {
        if (prorocol instanceof SoapProtocol) {
            return true;
        }
        return prorocol instanceof MimeProtocol;
    }

    public String loadAddress(WSDLExtension extension) throws WSDLException {
        if (extension.getURI().equals(SOAP_BINDING_NAMESPACE) && extension.getLocalName().equals("address")) {
            String location = extension.getAttribute("location");
            if (location == null) {
                throw new WSDLException(" Location not specified ");
            }
            return location;
        }
        throw new WSDLException(" The port SOAP Extension is invalid ");
    }

    public boolean recognizeBinding(WSDLBinding bindingElement) {
        ArrayList extensions = bindingElement.getExtensions();
        if (extensions.size() == 0) {
            return false;
        }
        WSDLExtension extension = null;
        int i = 0;
        while (i < extensions.size()) {
            extension = (WSDLExtension)extensions.get(i);
            if (extension.getLocalName().equals("binding") && SOAP_BINDING_NAMESPACE.equals(extension.getURI())) break;
            extension = null;
            ++i;
        }
        if (extension == null) {
            return false;
        }
        ArrayList operations = bindingElement.getOperations();
        int i2 = 0;
        while (i2 < operations.size()) {
            int j;
            WSDLBindingOperation operation = (WSDLBindingOperation)operations.get(i2);
            WSDLBindingChannel channel = operation.getInput();
            if (channel != null) {
                extensions = channel.getExtensions();
                j = 0;
                while (j < extensions.size()) {
                    extension = (WSDLExtension)extensions.get(j);
                    if (extension.getLocalName().equals(MIME_RELATED) && MIME_BINDING_NAMESPACE.equals(extension.getURI())) {
                        return true;
                    }
                    ++j;
                }
            }
            if ((channel = operation.getOutput()) != null) {
                extensions = channel.getExtensions();
                j = 0;
                while (j < extensions.size()) {
                    extension = (WSDLExtension)extensions.get(j);
                    if (extension.getLocalName().equals(MIME_RELATED) && MIME_BINDING_NAMESPACE.equals(extension.getURI())) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return true;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    protected Element getElementChildNull(String name, Element parent) throws Exception {
        if (parent == null) {
            return null;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getLocalName().equals(name)) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    protected Element getRootElement(Element parent) throws Exception {
        if (parent == null) {
            throw new Exception("Incorrect params passed to getElementChildNull !");
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public void startOperation(ServiceParam[] inputParams, ServiceParam[] outputParams, ServiceParam[] faultParams) {
        this.inputParams = inputParams;
        this.outputParams = outputParams;
        this.faultParams = faultParams;
    }

    private static String getEncoding(String contentTypeValue) {
        int sti = contentTypeValue.indexOf("charset=");
        if (sti > -1) {
            String newValue = contentTypeValue.substring(sti + 8);
            int end = newValue.indexOf(";");
            if (end == -1) {
                return newValue;
            }
            return newValue.substring(0, end);
        }
        return "utf-8";
    }

    /*
     * WARNING - void declaration
     */
    private static String createStringFromStream(InputStream inputStream, String contentTypeValue) throws Exception {
        try {
            int b;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);
            byte[] arr = new byte[128];
            while ((b = inputStream.read(arr)) != -1) {
                void var4_5;
                buffer.write(arr, 0, (int)var4_5);
            }
            inputStream.close();
            String enc = MimeHttpBinding.getEncoding(contentTypeValue);
            return buffer.toString(enc);
        }
        catch (IOException e) {
            throw new Exception("Unable to deserialize attached string !");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] createByteArrayFromStream(InputStream inputStream) throws Exception {
        try {
            int b;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);
            byte[] arr = new byte[128];
            while ((b = inputStream.read(arr)) != -1) {
                void var3_4;
                buffer.write(arr, 0, (int)var3_4);
            }
            inputStream.close();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new Exception(" Unable to deserialize attached byte array !");
        }
    }

    public boolean isFeatureImplemented(String featureName, PropertyContext context) {
        if ("http://www.sap.com/webas/630/soap/features/authentication".equals(featureName)) {
            return true;
        }
        return "http://www.sap.com/webas/630/soap/features/proxy".equals(featureName);
    }

    public String[] getFeatures() {
        return new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush(PropertyContext context, ProtocolList globalProtocols) throws Exception {
        boolean keepAliveFlag22;
        block14: {
            boolean transportInit = false;
            try {
                try {
                    PropertyContext configContext = context.getSubContext("bindingConfig");
                    ObjectFactory objFactory = (ObjectFactory)context.getProperty("objectFactory");
                    if (!configContext.isDefined()) {
                        throw new Exception(" No binding configuration provided in context !");
                    }
                    String endpoint = (String)configContext.getProperty("endpointUrl");
                    if (endpoint == null) {
                        throw new Exception(" Endpoint not specified in binding context !");
                    }
                    this.transport.init(endpoint, "POST", context.getSubContext("featureConfig"));
                    transportInit = true;
                    String soapAction = (String)configContext.getProperty(SOAP_ACTION);
                    if (soapAction != null) {
                        this.transport.setHeader(SOAP_ACTION_UPPER, "\"" + soapAction + "\"");
                    }
                    this.message.initSerializationMode();
                    ClientSOAPMessage soapMessage = this.message.getSOAPMessage();
                    soapMessage.addEmptyBody();
                    globalProtocols.handleRequest(soapMessage, context);
                    this.outputMessage(this.message, this.transport, false);
                    int responseCode = this.handleResponseMessage(this.transport, this.message);
                    if (responseCode == 500) {
                        this.processDocumentFault(this.message.getSOAPMessage(), objFactory);
                        globalProtocols.handleFault(this.message, context);
                    } else {
                        globalProtocols.handleResponse(this.message, context);
                    }
                }
                catch (XmlMarshalException x) {
                    if (!transportInit) throw x;
                    this.transport.closeSession();
                    throw x;
                }
                catch (XmlUnmarshalException y) {
                    if (!transportInit) throw y;
                    this.transport.closeSession();
                    throw y;
                }
                Object var11_12 = null;
                if (!transportInit) return;
                keepAliveFlag22 = false;
                if (!this.transport.featureSet("http://www.sap.com/webas/630/soap/features/http/keepAlive")) break block14;
            }
            catch (Throwable throwable) {
                PropertyContext feature2;
                String keepAlive2;
                Object var11_13 = null;
                if (!transportInit) throw throwable;
                boolean keepAliveFlag22 = false;
                if (this.transport.featureSet("http://www.sap.com/webas/630/soap/features/http/keepAlive") && (keepAlive2 = (String)(feature2 = this.transport.getFeature("http://www.sap.com/webas/630/soap/features/http/keepAlive")).getProperty("keepAliveStatus")) != null && keepAlive2.length() != 0) {
                    keepAliveFlag22 = true;
                }
                if (keepAliveFlag22) throw throwable;
                this.transport.closeSession();
                throw throwable;
            }
            PropertyContext feature2 = this.transport.getFeature("http://www.sap.com/webas/630/soap/features/http/keepAlive");
            String keepAlive2 = (String)feature2.getProperty("keepAliveStatus");
            if (keepAlive2 != null && keepAlive2.length() != 0) {
                keepAliveFlag22 = true;
            }
        }
        if (keepAliveFlag22) return;
        this.transport.closeSession();
    }

    public GlobalFeatures importGlobalFeatures(GlobalFeatures globalFeatures, WSDLBinding binding) {
        PropertyType property;
        FeatureType headersFeature = new FeatureType();
        headersFeature.setName("http://www.sap.com/webas/630/soap/features/headers/");
        String provider = DefaultProviders.getProvider(headersFeature.getName());
        if (provider != null) {
            headersFeature.setProvider(provider);
        }
        globalFeatures.insertFeature(headersFeature);
        if (globalFeatures.getFeature("http://www.sap.com/webas/630/soap/features/authentication") == null) {
            FeatureType securityFeature = new FeatureType();
            securityFeature.setName("http://www.sap.com/webas/630/soap/features/authentication");
            provider = DefaultProviders.getProvider(securityFeature.getName());
            if (provider != null) {
                securityFeature.setProvider(provider);
            }
            securityFeature.setOriginal(false);
            property = new PropertyType();
            property.setName("AuthenticationMechanism");
            property.setValue("None");
            securityFeature.addProperty(property);
            globalFeatures.addFeature(securityFeature);
        }
        if (globalFeatures.getFeature("http://www.sap.com/webas/630/soap/features/session/") == null) {
            FeatureType sessionFeature = new FeatureType();
            sessionFeature.setName("http://www.sap.com/webas/630/soap/features/session/");
            provider = DefaultProviders.getProvider("http://www.sap.com/webas/630/soap/features/session/");
            if (provider != null) {
                sessionFeature.setProvider(provider);
            }
            sessionFeature.setOriginal(false);
            property = new PropertyType();
            property.setName("SessionMethod");
            property.setValue("httpCookies");
            sessionFeature.addProperty(property);
            globalFeatures.addFeature(sessionFeature);
        }
        return globalFeatures;
    }

    public LocalFeatures importLocalFeatures(LocalFeatures features, WSDLBindingOperation operation) {
        return features;
    }

    private String getPrefixUri(String pref, Attributes localAttrs, XMLTokenReader reader) {
        String value = localAttrs.getValue("xmlns:" + pref);
        if (value != null) {
            return value;
        }
        return reader.getPrefixMapping(pref);
    }
}

