/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParameterList;

public class ContentTypeImpl {
    static final String DELIMITER = ";";
    private String originalValue;
    private String baseType;
    private String subType;
    private String primaryType;
    private Hashtable parameters = new Hashtable();

    public ContentTypeImpl(String value) {
        this.init(value);
    }

    private void init(String value) {
        this.originalValue = value.trim();
        if (this.originalValue.indexOf(DELIMITER) == -1) {
            this.baseType = this.originalValue;
            int del = this.baseType.indexOf("/");
            if (del == -1) {
                throw new IllegalArgumentException("Incorrect value: '" + this.originalValue + "'");
            }
            this.primaryType = this.originalValue.substring(0, del);
            this.subType = this.originalValue.substring(del + 1);
            return;
        }
        StringTokenizer tonenizer = new StringTokenizer(this.originalValue, DELIMITER);
        while (tonenizer.hasMoreTokens()) {
            String next = tonenizer.nextToken();
            if (this.baseType == null) {
                this.init(next);
                continue;
            }
            int del = next.indexOf("=");
            if (del != -1) {
                String contentTypeParam = next.substring(del + 1);
                if (contentTypeParam.startsWith("\"") && contentTypeParam.endsWith("\"")) {
                    contentTypeParam = contentTypeParam.substring(1, contentTypeParam.length() - 1);
                }
                this.parameters.put(next.substring(0, del), contentTypeParam);
                continue;
            }
            throw new IllegalArgumentException("Incorrect value: " + this.originalValue + "'");
        }
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public ContentType createStandardType() {
        ParameterList list = new ParameterList();
        Enumeration en = this.parameters.keys();
        while (en.hasMoreElements()) {
            String next = (String)en.nextElement();
            String content = (String)this.parameters.get(next);
            list.set(next, content);
        }
        return new ContentType(this.getPrimaryType(), this.getSubType(), list);
    }

    public String toString() {
        return this.originalValue;
    }
}

