/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterImpl;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.engine.services.webservices.jaxm.soap.SOAPDocumentImpl;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class ClientSOAPMessage
extends AbstractMessage {
    public static final int DESERIALIZATION_MODE = 1;
    public static final int SERIALIZATION_MODE = 2;
    public static final String SOAPENV_PREFIX = "SOAP-ENV";
    private static final int BUFFER_SIZE = 256;
    private static final String BODYTAG = "Body";
    private static final String HEADERTAG = "Header";
    private static final String ENVELOPETAG = "Envelope";
    private static final String STARTENVELOPE_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";
    private static final String ENDENVELOPE_TAG = "</SOAP-ENV:Envelope>";
    private static final String STARTHEADER_TAG = "<SOAP-ENV:Header>";
    private static final String ENDHEADER_TAG = "</SOAP-ENV:Header>";
    private ArrayList headers;
    private Element soapBody;
    private XMLTokenReader reader;
    private XMLTokenWriterImpl writer = new XMLTokenWriterImpl();
    private ByteArrayOutputStream bodyByteArrayBuffer;
    private boolean isBodyDOMbuilt = false;
    private int messageMode = 0;
    private boolean emptyBody = false;
    private Document document = null;
    private DocumentBuilder builder = null;
    private DOMSerializer serializer = null;

    public ClientSOAPMessage() {
        this.headers = new ArrayList();
        this.serializer = new DOMSerializer();
        this.document = new DocumentImpl();
        this.serializer.setOutputProperty("omit-xml-declaration", "yes");
        this.serializer.setOutputProperty("indent", "no");
        DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        dbf.setAttribute("http://sap.com/xml/soap-input", "true");
        dbf.setIgnoringComments(true);
        try {
            this.builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to create sap dom parser instance !");
        }
    }

    public void addEmptyBody() throws Exception {
        this.writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
        this.writer.leave();
        this.emptyBody = true;
    }

    public boolean isEmptyBody() {
        return this.emptyBody;
    }

    public int getLength() {
        return this.bodyByteArrayBuffer.size();
    }

    public XMLTokenWriter initSerializationMode() {
        this.messageMode = 2;
        this.headers.clear();
        this.soapBody = null;
        this.isBodyDOMbuilt = false;
        this.emptyBody = false;
        if (this.bodyByteArrayBuffer == null) {
            this.bodyByteArrayBuffer = new ByteArrayOutputStream(256);
        } else {
            this.bodyByteArrayBuffer.reset();
        }
        try {
            Hashtable<String, String> hash = new Hashtable<String, String>();
            hash.put("http://schemas.xmlsoap.org/soap/envelope/", SOAPENV_PREFIX);
            hash.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            hash.put("http://www.w3.org/2001/XMLSchema", "xs");
            this.writer.init((OutputStream)this.bodyByteArrayBuffer, "utf-8", hash);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating output !");
        }
        return this.writer;
    }

    public XMLTokenReader initDeserializationMode(InputStream inputStream) throws ParserException, Exception {
        this.messageMode = 1;
        this.headers.clear();
        this.soapBody = null;
        this.isBodyDOMbuilt = false;
        if (this.reader == null) {
            this.reader = new XMLTokenReaderImpl(inputStream);
        } else {
            this.reader.init(inputStream);
        }
        this.reader.begin();
        this.checkEnvelope(this.reader);
        this.extractHeaders(this.reader);
        return this.reader;
    }

    private void checkEnvelope(XMLTokenReader reader) throws Exception {
        reader.moveToNextElementStart();
        if (reader.getState() == 1 && reader.getLocalNameCharArray().equals((Object)ENVELOPETAG) && reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) {
            return;
        }
        if (reader.getState() == 1) {
            throw new Exception("The root message element is [" + reader.getLocalName() + "]{" + reader.getURI() + "} but it should be SOAP:Envelope.");
        }
        throw new Exception("Message Envelope not found. Probably empty soap message.");
    }

    public ArrayList getHeaders() {
        return this.headers;
    }

    public boolean isDOMbuilt() {
        return this.isBodyDOMbuilt;
    }

    public Element getSoapBody() throws Exception, ParserException {
        if (!this.isBodyDOMbuilt) {
            if (this.messageMode == 1) {
                this.soapBody = this.buildBodyDOMFromReader();
            } else if (this.messageMode == 2) {
                this.soapBody = this.buildBodyDOMFromByteArray();
            }
            this.isBodyDOMbuilt = true;
        }
        return this.soapBody;
    }

    public XMLTokenReader getReader() {
        if (this.isBodyDOMbuilt) {
            return null;
        }
        return this.reader;
    }

    public XMLTokenWriter getWriter() {
        return this.writer;
    }

    public void setHeaders(Element[] headers) throws Exception {
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                this.headers.add(headers[i]);
                ++i;
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, Exception {
        outputStream.write(STARTENVELOPE_TAG.getBytes());
        if (this.headers.size() > 0) {
            outputStream.write(STARTHEADER_TAG.getBytes());
            int i = 0;
            while (i < this.headers.size()) {
                try {
                    this.serializer.write((Node)this.headers.get(i), outputStream);
                }
                catch (Exception trE) {
                    throw new Exception(trE.getMessage());
                }
                ++i;
            }
            outputStream.write(ENDHEADER_TAG.getBytes());
        }
        if (this.isBodyDOMbuilt) {
            try {
                this.serializer.write((Node)this.soapBody, outputStream);
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
        } else {
            this.writer.flush();
            this.bodyByteArrayBuffer.flush();
            this.bodyByteArrayBuffer.writeTo(outputStream);
        }
        outputStream.write(ENDENVELOPE_TAG.getBytes());
        outputStream.flush();
    }

    private void extractHeaders(XMLTokenReader reader) throws Exception, ParserException {
        block4: while (true) {
            int code = reader.moveToNextElementStart();
            switch (code) {
                case 1: {
                    if (reader.getLocalNameCharArray().equals((Object)HEADERTAG) && reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) {
                        this.loadHeaders(reader);
                        return;
                    }
                    if (!reader.getLocalNameCharArray().equals((Object)BODYTAG) || !reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) continue block4;
                    return;
                }
                case 6: {
                    throw new Exception("Unexpected EOF.");
                }
            }
        }
    }

    private void loadHeaders(XMLTokenReader reader) throws Exception, ParserException {
        Element holder = null;
        holder = this.document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", HEADERTAG);
        int currentLevel = reader.getCurrentLevel();
        while (true) {
            int code = reader.next();
            switch (code) {
                case 1: {
                    Element headerEntry = reader.getDOMRepresentation(this.document);
                    this.headers.add(headerEntry);
                    break;
                }
                case 2: {
                    if (reader.getCurrentLevel() < currentLevel) {
                        code = reader.moveToNextElementStart();
                        if (code == 1) {
                            if (reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/") && reader.getLocalNameCharArray().equals((Object)BODYTAG)) {
                                return;
                            }
                            throw new Exception("Incorrect message content. Body element not found.");
                        }
                        throw new Exception("Unexpected EOF.");
                    }
                    throw new Exception("Error in message structure. SOAP:Header end tag is expected.");
                }
                case 6: {
                    throw new Exception("Unexpected message end.");
                }
            }
        }
    }

    public static Element fillElement(Node parent, XMLTokenReader reader) throws Exception, ParserException {
        Element element = parent.getOwnerDocument().createElementNS(reader.getURI(), reader.getQName());
        Attributes attrs = reader.getAttributes();
        if (attrs == null) {
            throw new Exception("The reader is not on startState");
        }
        int attrsLeght = attrs.getLength();
        int i = 0;
        while (i < attrsLeght) {
            String attribUri = attrs.getURI(i);
            String attribQName = attrs.getQName(i);
            String attribValue = attrs.getValue(i);
            if (!attribUri.equals("http://www.w3.org/2000/xmlns/") && !ClientSOAPMessage.getLocalName(attribQName).equals("xmlns")) {
                element.setAttributeNS(attribUri, attribQName, attribValue);
            }
            ++i;
        }
        while (true) {
            int code = reader.next();
            switch (code) {
                case 5: {
                    element.appendChild(element.getOwnerDocument().createComment(reader.getValue()));
                    break;
                }
                case 3: {
                    element.appendChild(element.getOwnerDocument().createTextNode(reader.getValue()));
                    break;
                }
                case 1: {
                    element.appendChild(ClientSOAPMessage.fillElement(parent, reader));
                    break;
                }
                case 2: {
                    return element;
                }
                case 6: {
                    throw new Exception("Unexpected EOF.");
                }
            }
        }
    }

    private static String getLocalName(String qname) {
        int delimiter = qname.indexOf(58);
        if (delimiter == -1) {
            return qname;
        }
        return qname.substring(delimiter + 1);
    }

    /*
     * Unable to fully structure code
     */
    private Element buildBodyDOMFromReader() throws Exception, ParserException {
        block1: {
            document = new SOAPDocumentImpl();
            this.reader.passChars();
            code = this.reader.getState();
            if (code != 1) break block1;
            if (!this.reader.getLocalNameCharArray().equals((Object)"Body") || !this.reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) ** GOTO lbl9
            return this.reader.getDOMRepresentation((Document)document);
lbl-1000:
            // 1 sources

            {
                this.reader.next();
lbl9:
                // 2 sources

                ** while (this.reader.getState() != 6)
            }
        }
        throw new Exception("Body tag not found !");
    }

    private Element buildBodyDOMFromByteArray() throws Exception {
        try {
            if (this.bodyByteArrayBuffer.size() == 0) {
                Element body = this.document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body");
                return body;
            }
            byte[] bodyStart = STARTENVELOPE_TAG.getBytes("utf-8");
            byte[] bodyEnd = ENDENVELOPE_TAG.getBytes("utf-8");
            byte[] perm = new byte[this.bodyByteArrayBuffer.size() + bodyStart.length + bodyEnd.length];
            System.arraycopy(bodyStart, 0, perm, 0, bodyStart.length);
            System.arraycopy(bodyEnd, 0, perm, perm.length - bodyEnd.length, bodyEnd.length);
            System.arraycopy(this.bodyByteArrayBuffer.toByteArray(), 0, perm, bodyStart.length, this.bodyByteArrayBuffer.size());
            Document docperm = this.builder.parse(new ByteArrayInputStream(perm));
            Element envelope = docperm.getDocumentElement();
            Element result = null;
            Node node = envelope.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    result = (Element)node;
                }
                node = node.getNextSibling();
            }
            return result;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public Element createSoapHeader(String uri, String localName) throws Exception {
        if (this.document == null) {
            this.document = new DocumentBuilderFactoryImpl().newDocumentBuilder().newDocument();
        }
        return this.document.createElementNS(uri, localName);
    }

    public Element getSoapHeader(String uri, String localName) {
        int i = 0;
        while (i < this.headers.size()) {
            Element e = (Element)this.headers.get(i);
            if (e.getLocalName().equals(localName) && (e.getNamespaceURI() != null || e.getNamespaceURI().equals(uri))) {
                return e;
            }
            ++i;
        }
        return null;
    }
}

