/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.httpgetpost;

public class URLEncoder {
    private static final char[] RESERVED_UNSAFED = new char[]{' ', '<', '>', '\"', '#', '%', '{', '}', '|', '\\', '^', '~', '[', ']', '\'', ';', '/', '?', ':', '@', '=', '&', '$', '-', '+', ','};
    private static final int RESERVED_LENGTH = RESERVED_UNSAFED.length;
    private static String[] CODES = new String[RESERVED_UNSAFED.length];

    public static String encode(String str) {
        StringBuffer enStr = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char curr = str.charAt(i);
            if (curr > '\u00ff') {
                throw new IllegalArgumentException("Char at position '" + i + "' is not valud US-ASCII character. Code 0x" + Integer.toHexString(curr) + "");
            }
            if (curr <= '\u001f' || curr >= '\u007f' && curr <= '\u00ff') {
                enStr.append(URLEncoder.doEncode(curr));
            } else {
                boolean found = false;
                int j = 0;
                while (j < RESERVED_LENGTH) {
                    if (curr == RESERVED_UNSAFED[j]) {
                        enStr.append(CODES[j]);
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    enStr.append(curr);
                }
            }
            ++i;
        }
        return enStr.toString();
    }

    private static String doEncode(char c) {
        return "%" + Integer.toHexString(c);
    }

    static {
        URLEncoder.CODES[0] = "+";
        int i = 1;
        while (i < RESERVED_UNSAFED.length) {
            URLEncoder.CODES[i] = URLEncoder.doEncode(RESERVED_UNSAFED[i]);
            ++i;
        }
    }
}

