/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.builtin;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.runtime.component.ClientProtocolFactory;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.services.webservices.espbase.client.api.SOAPHeaderInterface;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientMimeMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapHeadersProtocol
implements AbstractProtocol,
ClientProtocolFactory,
SOAPHeaderInterface {
    public static final String FEATURE_NAME = "http://www.sap.com/webas/630/soap/features/headers/";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NAME = "SoapHeadersProtocol";
    private Hashtable outgoingHeaders = new Hashtable();
    private Hashtable incomingHeaders = new Hashtable();
    private Document document;
    private TypeMappingImpl typeMapping;

    public SoapHeadersProtocol() throws Exception {
        DocumentBuilderFactoryImpl builderFactory = new DocumentBuilderFactoryImpl();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        this.document = builder.newDocument();
    }

    public void init(PropertyContext context) throws ClientProtocolException {
        this.outgoingHeaders.clear();
        this.incomingHeaders.clear();
        this.typeMapping = (TypeMappingImpl)context.getProperty("typeMapping");
        if (this.typeMapping == null) {
            // empty if block
        }
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        ClientSOAPMessage soapmessage = null;
        if (message instanceof ClientSOAPMessage) {
            soapmessage = (ClientSOAPMessage)message;
        }
        if (message instanceof ClientMimeMessage) {
            soapmessage = ((ClientMimeMessage)message).getSOAPMessage();
        }
        if (soapmessage != null) {
            Enumeration e = this.outgoingHeaders.keys();
            ArrayList headers = soapmessage.getHeaders();
            while (e.hasMoreElements()) {
                QName key = (QName)e.nextElement();
                Object value = this.outgoingHeaders.get(key);
                if (!(value instanceof Element)) continue;
                headers.add(value);
            }
            this.outgoingHeaders.clear();
        }
        return true;
    }

    public boolean handleResponse(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        ClientSOAPMessage soapmessage = null;
        if (message instanceof ClientSOAPMessage) {
            soapmessage = (ClientSOAPMessage)message;
        }
        if (message instanceof ClientMimeMessage) {
            soapmessage = ((ClientMimeMessage)message).getSOAPMessage();
        }
        if (soapmessage != null) {
            this.incomingHeaders.clear();
            ArrayList headers = soapmessage.getHeaders();
            int i = 0;
            while (i < headers.size()) {
                Element element = (Element)headers.get(i);
                QName qname = new QName(element.getNamespaceURI(), element.getLocalName());
                this.incomingHeaders.put(qname, element);
                ++i;
            }
        }
        return true;
    }

    public void clear() {
        this.incomingHeaders.clear();
        this.outgoingHeaders.clear();
    }

    public boolean handleFault(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        return true;
    }

    public boolean isFeatureImplemented(String featureName, PropertyContext property) {
        return false;
    }

    public String getName() {
        return NAME;
    }

    public String[] getFeatures() {
        return new String[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOutputHeader(QName headerName, Object object) throws MarshalException {
        if (headerName == null) {
            if (!(object instanceof Element)) throw new MarshalException("DOM Element must be passed when no element name is specified !");
            Element element = (Element)object;
            if (element.getNamespaceURI() == null || element.getNamespaceURI().length() == 0) {
                throw new MarshalException("Header nodes must be namespace qualified !");
            }
            QName qname = new QName(element.getNamespaceURI(), element.getNodeName());
            this.outgoingHeaders.put(qname, element);
            return;
        } else {
            if (headerName.getNamespaceURI() == null || headerName.getNamespaceURI().length() == 0) {
                throw new MarshalException("Header nodes must be namespace qualified !");
            }
            if (this.typeMapping == null) {
                return;
            }
            QName elementType = this.typeMapping.getTypeForElement(headerName);
            if (elementType == null) {
                throw new MarshalException("Element " + headerName.toString() + " not declared in schema !");
            }
            Element outElement = this.document.createElementNS(headerName.getNamespaceURI(), headerName.getLocalPart());
            if (object == null) {
                outElement.setAttributeNS(XSI, "xsi:nil", "true");
            } else {
                SerializerFactory sf = this.typeMapping.getSerializer(object.getClass(), elementType);
                if (sf == null) {
                    throw new MarshalException(" Could not find deserializer for element :" + headerName.toString() + " with schema type " + elementType);
                }
                SerializerBase serializer = (SerializerBase)sf.getSerializerAs(null);
                SOAPSerializationContext context = new SOAPSerializationContext();
                context.setTypeMapping(this.typeMapping);
                serializer.serialize(object, outElement, context);
            }
            this.outgoingHeaders.put(headerName, outElement);
        }
    }

    public Element getInputHeader(QName headerName) {
        if (headerName == null) {
            return null;
        }
        return (Element)this.incomingHeaders.get(headerName);
    }

    public Object getInputHeader(QName headerName, Class headerClass) throws UnmarshalException {
        Element content = this.getInputHeader(headerName);
        if (content == null) {
            return null;
        }
        if (this.typeMapping == null) {
            return null;
        }
        QName elementType = this.typeMapping.getTypeForElement(headerName);
        if (elementType == null) {
            throw new UnmarshalException("Element " + headerName.toString() + " not declared in schema !");
        }
        DeserializerFactory factory = this.typeMapping.getDeserializer(headerClass, elementType);
        if (factory == null) {
            throw new UnmarshalException(" Could not find deserializer for element :" + headerName.toString() + " with schema type " + elementType);
        }
        DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs(null);
        SOAPDeserializationContext context = new SOAPDeserializationContext();
        context.setTypeMapping(this.typeMapping);
        return deserializer.deserialize(content, context, headerClass);
    }

    public ClientFeatureProvider newInstance() {
        try {
            return new SoapHeadersProtocol();
        }
        catch (Exception e) {
            return null;
        }
    }
}

