/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.builtin;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.runtime.component.ClientProtocolFactory;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientMimeMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransportInterface;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SessionProtocol
implements AbstractProtocol,
ClientProtocolFactory {
    public static final String NAME = "SessionProtocol";
    private Document document;
    private boolean maintainSession = true;
    private boolean isPropertySet = false;

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void closeSession() {
        this.maintainSession = false;
        this.isPropertySet = true;
    }

    public SessionProtocol() throws Exception {
        DocumentBuilderFactoryImpl builderFactory = new DocumentBuilderFactoryImpl();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        this.document = builder.newDocument();
    }

    public void init(PropertyContext context) throws ClientProtocolException {
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        PropertyContext features;
        PropertyContext feature;
        ClientSOAPMessage msg = null;
        if (message instanceof ClientMimeMessage) {
            msg = ((ClientMimeMessage)message).getSOAPMessage();
        }
        if (message instanceof ClientSOAPMessage) {
            msg = (ClientSOAPMessage)message;
        }
        if (msg != null && (feature = (features = context.getSubContext("featureConfig")).getSubContext("http://www.sap.com/webas/630/soap/features/session/")).isDefined() && "httpCookies".equals(feature.getProperty("SessionMethod"))) {
            if (this.isPropertySet) {
                if (this.maintainSession) {
                    feature.setProperty("maintainSession", "yes");
                } else {
                    this.maintainSession = true;
                    feature.setProperty("maintainSession", "no");
                }
            }
            boolean mSession = true;
            if ("no".equals(feature.getProperty("maintainSession"))) {
                mSession = false;
            }
            if (!mSession) {
                if ("yes".equals(feature.getProperty("abapSession"))) {
                    Object transportInterface = context.getProperty("transportInterface");
                    if (transportInterface instanceof HTTPTransportInterface) {
                        HTTPTransportInterface http = (HTTPTransportInterface)transportInterface;
                        String endpoint = http.getEndpoint();
                        endpoint = endpoint.indexOf("?") != -1 ? endpoint + "&session_mode=2" : endpoint + "?session_mode=2";
                        try {
                            http.setEndpoint(endpoint);
                        }
                        catch (Exception e) {
                            throw new ClientProtocolException("Can not set transport Endpoint to [" + endpoint + "]");
                        }
                    }
                    feature.setProperty("maintainSession", "no");
                } else if (msg.isEmptyBody()) {
                    if (feature.getProperty("SessionCoockie") != null) {
                        Element header = this.document.createElementNS("http://www.sap.com/webas/630/soap/features/session/", "sapsess:Session");
                        Element enabled = this.document.createElement("enableSession");
                        Text content = this.document.createTextNode("false");
                        enabled.appendChild(content);
                        header.appendChild(enabled);
                        msg.getHeaders().add(header);
                    }
                } else {
                    feature.clearProperty("SessionCoockie");
                    feature.setProperty("maintainSession", "yes");
                }
            } else if ("yes".equals(feature.getProperty("abapSession"))) {
                Object transportInterface;
                if (feature.getProperty("SessionCoockie") == null && (transportInterface = context.getProperty("transportInterface")) instanceof HTTPTransportInterface) {
                    HTTPTransportInterface http = (HTTPTransportInterface)transportInterface;
                    String endpoint = http.getEndpoint();
                    endpoint = endpoint.indexOf("?") != -1 ? endpoint + "&session_mode=1" : endpoint + "?session_mode=1";
                    try {
                        http.setEndpoint(endpoint);
                    }
                    catch (Exception e) {
                        throw new ClientProtocolException("Can not set transport Endpoint to [" + endpoint + "]");
                    }
                }
            } else if (feature.getProperty("SessionCoockie") == null) {
                Element header = this.document.createElementNS("http://www.sap.com/webas/630/soap/features/session/", "sapsess:Session");
                Element enabled = this.document.createElement("enableSession");
                Text content = this.document.createTextNode("true");
                enabled.appendChild(content);
                header.appendChild(enabled);
                msg.getHeaders().add(header);
            }
        }
        return true;
    }

    public boolean handleResponse(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        return true;
    }

    public boolean handleFault(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        return true;
    }

    public boolean isFeatureImplemented(String featureName, PropertyContext property) {
        return "http://www.sap.com/webas/630/soap/features/session/".equals(featureName);
    }

    public String getName() {
        return NAME;
    }

    public String[] getFeatures() {
        return new String[]{"http://www.sap.com/webas/630/soap/features/session/"};
    }

    public ClientFeatureProvider newInstance() {
        try {
            return new SessionProtocol();
        }
        catch (Exception e) {
            return null;
        }
    }
}

