/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.interfaces.webservices.server.SLDLogicalPort;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.exceptions.LogicalPortException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.WebserviceClientException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.BaseGeneratedStub;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolAppStateEvents;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolDeployAppEvents;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolStartAppEvent;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.RuntimeInformation;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.SLDPort;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBase;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LocalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.OperationType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.InputStream;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class ServiceBaseServer
extends ServiceBase {
    private Hashtable lportProtocols = null;
    private Hashtable lportRuntimeInfo = null;
    protected ClassLoader applicationLoader = null;
    private LogicalPortFactory factory = new LogicalPortFactory();
    private String logLocation = null;

    public ServiceBaseServer() {
    }

    public ServiceBaseServer(InputStream input, ClientComponentFactory factory, ClassLoader applicationLoader) throws Exception {
        super(input);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
    }

    public ServiceBaseServer(File input, ClientComponentFactory factory, ClassLoader applicationLoader) throws Exception {
        super(input);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
    }

    public ServiceBaseServer(String input, ClientComponentFactory factory, ClassLoader applicationLoader) throws Exception {
        super(input);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
    }

    public ServiceBaseServer(File input, ClientComponentFactory factory, ClassLoader applicationLoader, TypeMappingRegistry registry) throws Exception {
        super(input);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
        this._typeRegistry = (TypeMappingRegistryImpl)registry;
    }

    public ServiceBaseServer(String input, ClientComponentFactory factory, ClassLoader applicationLoader, TypeMappingRegistry registry) throws Exception {
        super(input);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
        this._typeRegistry = (TypeMappingRegistryImpl)registry;
    }

    public void init(InputStream input, ClientComponentFactory factory, ClassLoader applicationLoader) throws Exception {
        super.init(input);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
    }

    public void init(LogicalPorts lports, ClientComponentFactory factory, ClassLoader applicationLoader) throws Exception {
        super.init(lports);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
    }

    public void init(LogicalPorts lports, ClientComponentFactory factory, ClassLoader applicationLoader, String location) throws Exception {
        super.init(lports);
        this.applicationLoader = applicationLoader;
        this.componentFactory = factory;
        this.logLocation = location;
    }

    public void init(InputStream input, ClientComponentFactory factory, ClassLoader applicationLoader, TypeMappingRegistry registry) throws Exception {
        this.init(input, factory, applicationLoader);
        this._typeRegistry = (TypeMappingRegistryImpl)registry;
    }

    public void init(LogicalPorts lports, ClientComponentFactory factory, ClassLoader applicationLoader, TypeMappingRegistry registry) throws Exception {
        this.init(lports, factory, applicationLoader);
        this._typeRegistry = (TypeMappingRegistryImpl)registry;
    }

    private void processFeatures(FeatureType[] features, PropertyContext pContext, HashSet usedProtocols, Hashtable protocols) {
        int i = 0;
        while (i < features.length) {
            Object aProtocol;
            this.loadProperties(features[i].getProperty(), pContext.getSubContext(features[i].getName()));
            String providerName = features[i].getProvider();
            if (providerName != null && (aProtocol = protocols.get(providerName)) != null) {
                usedProtocols.add(aProtocol);
            }
            ++i;
        }
    }

    private void initRuntimeInformation(RuntimeInformation runtimeInformation) {
        this.lportProtocols = new Hashtable();
        this.lportRuntimeInfo = new Hashtable();
        LogicalPortType[] logicalPorts = this.logicalPorts.getLogicalPort();
        int i = 0;
        while (i < logicalPorts.length) {
            String lportName = logicalPorts[i].getName();
            String endpoint = logicalPorts[i].getEndpoint();
            RuntimeInformation runtimeInfonew = new RuntimeInformation();
            runtimeInfonew.setApplicationName(runtimeInformation.getApplicationName());
            runtimeInfonew.setEndpoint(endpoint);
            runtimeInfonew.setLogicalPortName(lportName);
            runtimeInfonew.setSLDSystemName(logicalPorts[i].getSystemName());
            runtimeInfonew.setSLDWServiceName(logicalPorts[i].getSLDWS());
            runtimeInfonew.setSLDWServicePort(logicalPorts[i].getSLDWSPort());
            runtimeInfonew.setLogicalPortType(logicalPorts[i]);
            runtimeInfonew.setJndiName(runtimeInformation.getJndiName());
            runtimeInfonew.setArchiveName(runtimeInformation.getArchiveName());
            this.lportRuntimeInfo.put(lportName, runtimeInfonew);
            ClientFeatureProvider[] protocols = this.componentFactory.listClientProtocolInterfaces();
            this.lportProtocols.put(lportName, protocols);
            ++i;
        }
    }

    public void setRuntimeInformation(RuntimeInformation runtimeInformation) {
        this.initRuntimeInformation(runtimeInformation);
        Hashtable<String, ClientFeatureProvider> perm = new Hashtable<String, ClientFeatureProvider>();
        LogicalPortType[] logicalPorts = this.logicalPorts.getLogicalPort();
        HashSet usedProtocols = new HashSet();
        PropertyContext propertyContext = new PropertyContext();
        int i = 0;
        while (i < logicalPorts.length) {
            perm.clear();
            usedProtocols.clear();
            propertyContext.clear();
            LogicalPortType logicalPort = logicalPorts[i];
            ClientFeatureProvider[] protocols = (ClientFeatureProvider[])this.lportProtocols.get(logicalPort.getName());
            int j = 0;
            while (j < protocols.length) {
                perm.put(((AbstractProtocol)protocols[j]).getName(), protocols[j]);
                ++j;
            }
            RuntimeInformation runtimeInfo = (RuntimeInformation)this.lportRuntimeInfo.get(logicalPort.getName());
            GlobalFeatures globalFeatures = logicalPort.getGlobalFeatures();
            this.processFeatures(globalFeatures.getFeature(), propertyContext, usedProtocols, perm);
            propertyContext.setProperty("RuntimeInfo", runtimeInfo);
            Iterator it = usedProtocols.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof ClientProtocolStartAppEvent) {
                    ((ClientProtocolStartAppEvent)obj).onStartApplication(propertyContext);
                }
                if (!(obj instanceof ClientProtocolAppStateEvents)) continue;
                ((ClientProtocolAppStateEvents)obj).onStartApplication(propertyContext);
            }
            ++i;
        }
    }

    private void extractProviders(FeatureType[] features, HashSet providers) {
        if (features != null) {
            int i = 0;
            while (i < features.length) {
                if (features[i].getProvider() != null) {
                    providers.add(features[i].getProvider());
                }
                ++i;
            }
        }
    }

    public Hashtable getUsedProtocols() {
        Hashtable result = new Hashtable();
        LogicalPortType[] logicalPorts = this.logicalPorts.getLogicalPort();
        int i = 0;
        while (i < logicalPorts.length) {
            LocalFeatures local;
            HashSet protocols = new HashSet();
            LogicalPortType port = logicalPorts[i];
            GlobalFeatures global = port.getGlobalFeatures();
            if (global != null) {
                FeatureType[] features = global.getFeature();
                this.extractProviders(features, protocols);
            }
            if ((local = port.getLocalFeatures()) != null) {
                OperationType[] operations = local.getOperation();
                int j = 0;
                while (j > operations.length) {
                    FeatureType[] features = operations[j].getFeature();
                    this.extractProviders(features, protocols);
                    ++j;
                }
            }
            result.put(port.getName(), protocols);
            ++i;
        }
        return result;
    }

    public Hashtable getConfigurationData(RuntimeInformation runtimeInformation) {
        Hashtable<String, PropertyContext> result = new Hashtable<String, PropertyContext>();
        this.initRuntimeInformation(runtimeInformation);
        LogicalPortType[] logicalPorts = this.logicalPorts.getLogicalPort();
        int i = 0;
        while (i < logicalPorts.length) {
            PropertyContext propertyContext = new PropertyContext();
            LogicalPortType logicalPort = logicalPorts[i];
            RuntimeInformation runtimeInfo = (RuntimeInformation)this.lportRuntimeInfo.get(logicalPort.getName());
            GlobalFeatures globalFeatures = logicalPort.getGlobalFeatures();
            if (globalFeatures != null) {
                FeatureType[] features = globalFeatures.getFeature();
                int j = 0;
                while (j < features.length) {
                    this.loadProperties(features[j].getProperty(), propertyContext.getSubContext(features[j].getName()));
                    ++j;
                }
            }
            propertyContext.setProperty("RuntimeInfo", runtimeInfo);
            PropertyContext operationsContext = propertyContext.getSubContext("operations");
            LocalFeatures localFeatures = logicalPort.getLocalFeatures();
            if (localFeatures != null) {
                OperationType[] operations = localFeatures.getOperation();
                int j = 0;
                while (j < operations.length) {
                    PropertyContext opContext = operationsContext.getSubContext(operations[j].getName());
                    FeatureType[] features = operations[j].getFeature();
                    int k = 0;
                    while (k < features.length) {
                        this.loadProperties(features[k].getProperty(), opContext.getSubContext(features[k].getName()));
                        ++k;
                    }
                    ++j;
                }
            }
            result.put(logicalPort.getName(), propertyContext);
            ++i;
        }
        return result;
    }

    public void onStopApplication(RuntimeInformation runtimeInformation) {
        this.initRuntimeInformation(runtimeInformation);
        Hashtable<String, ClientFeatureProvider> perm = new Hashtable<String, ClientFeatureProvider>();
        LogicalPortType[] logicalPorts = this.logicalPorts.getLogicalPort();
        HashSet usedProtocols = new HashSet();
        PropertyContext propertyContext = new PropertyContext();
        int i = 0;
        while (i < logicalPorts.length) {
            perm.clear();
            usedProtocols.clear();
            propertyContext.clear();
            LogicalPortType logicalPort = logicalPorts[i];
            ClientFeatureProvider[] protocols = (ClientFeatureProvider[])this.lportProtocols.get(logicalPort.getName());
            int j = 0;
            while (j < protocols.length) {
                perm.put(((AbstractProtocol)protocols[j]).getName(), protocols[j]);
                ++j;
            }
            RuntimeInformation runtimeInfo = (RuntimeInformation)this.lportRuntimeInfo.get(logicalPort.getName());
            GlobalFeatures globalFeatures = logicalPort.getGlobalFeatures();
            this.processFeatures(globalFeatures.getFeature(), propertyContext, usedProtocols, perm);
            propertyContext.setProperty("RuntimeInfo", runtimeInfo);
            Iterator it = usedProtocols.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof ClientProtocolAppStateEvents)) continue;
                ((ClientProtocolAppStateEvents)obj).onStopApplication(propertyContext);
            }
            ++i;
        }
    }

    public void onDeployApplication(RuntimeInformation runtimeInformation) {
        this.initRuntimeInformation(runtimeInformation);
        Hashtable<String, ClientFeatureProvider> perm = new Hashtable<String, ClientFeatureProvider>();
        LogicalPortType[] logicalPorts = this.logicalPorts.getLogicalPort();
        HashSet usedProtocols = new HashSet();
        PropertyContext propertyContext = new PropertyContext();
        int i = 0;
        while (i < logicalPorts.length) {
            perm.clear();
            usedProtocols.clear();
            propertyContext.clear();
            LogicalPortType logicalPort = logicalPorts[i];
            ClientFeatureProvider[] protocols = (ClientFeatureProvider[])this.lportProtocols.get(logicalPort.getName());
            int j = 0;
            while (j < protocols.length) {
                perm.put(((AbstractProtocol)protocols[j]).getName(), protocols[j]);
                ++j;
            }
            RuntimeInformation runtimeInfo = (RuntimeInformation)this.lportRuntimeInfo.get(logicalPort.getName());
            GlobalFeatures globalFeatures = logicalPort.getGlobalFeatures();
            this.processFeatures(globalFeatures.getFeature(), propertyContext, usedProtocols, perm);
            propertyContext.setProperty("RuntimeInfo", runtimeInfo);
            Iterator it = usedProtocols.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof ClientProtocolDeployAppEvents)) continue;
                ((ClientProtocolDeployAppEvents)obj).onDeployApplication(propertyContext);
            }
            ++i;
        }
    }

    public void loadProperties(PropertyType[] properties, PropertyContext context) {
        int i = 0;
        while (i < properties.length) {
            if (properties[i].getName() != null) {
                if (properties[i].getValue() != null) {
                    context.setProperty(properties[i].getName(), properties[i].getValue());
                }
                if (properties[i].getProperty().length != 0) {
                    this.loadProperties(properties[i].getProperty(), context.getSubContext(properties[i].getName()));
                }
            }
            ++i;
        }
    }

    public synchronized Remote getPort(QName portName, Class sdiInterface) throws ServiceException {
        if (!this.lportRuntimeInfo.containsKey(portName.getLocalPart())) {
            throw new WebserviceClientException("webservices_3600", portName.getLocalPart(), this.getClass().getName());
        }
        BaseGeneratedStub stub = null;
        LogicalPortType[] lports = this.logicalPorts.getLogicalPort();
        int i = 0;
        while (i < lports.length) {
            if (lports[i].getName().equals(portName.getLocalPart())) {
                LogicalPortType lport = lports[i];
                if (!lport.getValid()) {
                    throw new WebserviceClientException("webservices_3601", lport.getName(), this.getClass().getName());
                }
                RuntimeInformation rinfo = (RuntimeInformation)this.lportRuntimeInfo.get(lport.getName());
                try {
                    stub = this.factory.getConfiguredStub(lport, rinfo, this.componentFactory, this.applicationLoader, this._typeRegistry);
                }
                catch (Exception e) {
                    throw new WebserviceClientException("webservices_3606", e);
                }
            }
            ++i;
        }
        if (stub == null) {
            throw new WebserviceClientException("webservices_3600", portName.getLocalPart(), this.getClass().getName());
        }
        BaseGeneratedStub baseGenStub = stub;
        if (this.proxyResolver != null) {
            baseGenStub._setHTTPProxyResolver(this.proxyResolver);
        }
        if (this.globalSettings != null) {
            baseGenStub._setGlobalClientSettings(this.globalSettings);
        }
        if (this.logLocation != null) {
            baseGenStub._setLogLocation(Location.getLocation((String)this.logLocation));
        }
        return stub;
    }

    public synchronized Remote getLogicalPort(Class aClass) throws ServiceException {
        LogicalPortType[] lports = this.logicalPorts.getLogicalPort();
        if (lports.length == 0) {
            throw new WebserviceClientException("webservices_3607", this.getClass().getName());
        }
        int defaultIndex = 0;
        int i = 0;
        while (i < lports.length) {
            if (lports[i].getDefault()) {
                defaultIndex = i;
            }
            ++i;
        }
        LogicalPortType lport = lports[defaultIndex];
        BaseGeneratedStub stub = null;
        if (!lport.getValid()) {
            throw new WebserviceClientException("webservices_3601", lport.getName(), this.getClass().getName());
        }
        RuntimeInformation rinfo = (RuntimeInformation)this.lportRuntimeInfo.get(lport.getName());
        if (lport.getSystemName() != null && lport.getSLDWS() != null && lport.getSLDWSPort() != null && this.getSLDConnection() != null) {
            SLDPort port = null;
            try {
                port = this.sldConnection.getFromSLD(lport.getSystemName(), lport.getSLDWS(), lport.getSLDWSPort());
            }
            catch (Exception e) {
                throw new WebserviceClientException("webservices_3602", e, lport.getName(), this.getClass().getName(), lport.getSystemName(), lport.getSLDWS(), lport.getSLDWSPort());
            }
            if (port == null) {
                throw new WebserviceClientException("webservices_3603", lport.getName(), this.getClass().getName(), lport.getSystemName(), lport.getSLDWS(), lport.getSLDWSPort());
            }
            WSDLDefinitions definitions = null;
            try {
                definitions = port.getAsDefinitions(this.proxyResolver);
            }
            catch (Exception e) {
                throw new WebserviceClientException("webservices_3604", port.getWsdl(), lport.getName(), this.getClass().getName());
            }
            try {
                QName wsdlPortName = QName.valueOf(port.getPortName());
                LogicalPortFactory.updateLogicalPort(lport, definitions, wsdlPortName, this.componentFactory);
            }
            catch (LogicalPortException e) {
                throw new WebserviceClientException("webservices_3605", (Throwable)((Object)e), lport.getName(), this.getClass().getName());
            }
            rinfo.setEndpoint(lport.getEndpoint());
        }
        try {
            stub = this.factory.getConfiguredStub(lport, rinfo, this.componentFactory, this.applicationLoader, this._typeRegistry);
        }
        catch (Exception e) {
            throw new WebserviceClientException("webservices_3606", e);
        }
        if (stub == null) {
            throw new WebserviceClientException("webservices_3600", lport.getName(), this.getClass().getName());
        }
        BaseGeneratedStub baseGenStub = stub;
        if (this.proxyResolver != null) {
            baseGenStub._setHTTPProxyResolver(this.proxyResolver);
        }
        if (this.globalSettings != null) {
            baseGenStub._setGlobalClientSettings(this.globalSettings);
        }
        if (this.logLocation != null) {
            baseGenStub._setLogLocation(Location.getLocation((String)this.logLocation));
        }
        return stub;
    }

    private LogicalPortType getLP(String lpName) throws WebserviceClientException {
        LogicalPortType[] lports = this.logicalPorts.getLogicalPort();
        int i = 0;
        while (i < lports.length) {
            if (lpName.equals(lports[i].getName())) {
                return lports[i];
            }
            ++i;
        }
        throw new WebserviceClientException("webservices_4101", lpName);
    }

    public LogicalPortType updateLPTypeFromSLD(String lpName, SLDLogicalPort sldLP) throws WebserviceClientException {
        LogicalPortType lport = this.getLP(lpName);
        SLDPort port = null;
        try {
            port = this.sldConnection.getFromSLD(sldLP.getSystemName(), sldLP.getWSName(), sldLP.getWSPortName());
        }
        catch (Exception e) {
            throw new WebserviceClientException("webservices_3602", e, lpName, this.getClass().getName(), sldLP.getSystemName(), sldLP.getWSName(), sldLP.getWSPortName());
        }
        if (port == null) {
            throw new WebserviceClientException("webservices_3603", lpName, this.getClass().getName(), sldLP.getSystemName(), sldLP.getWSName(), sldLP.getWSPortName());
        }
        WSDLDefinitions definitions = null;
        try {
            definitions = port.getAsDefinitions(this.proxyResolver);
        }
        catch (Exception e) {
            throw new WebserviceClientException("webservices_3604", port.getWsdl(), lport.getName(), this.getClass().getName());
        }
        try {
            QName wsdlPortName = QName.valueOf(port.getPortName());
            LogicalPortFactory.updateLogicalPort(lport, definitions, wsdlPortName, this.componentFactory);
        }
        catch (LogicalPortException e) {
            throw new WebserviceClientException("webservices_3605", (Throwable)((Object)e), lport.getName(), this.getClass().getName());
        }
        RuntimeInformation rinfo = (RuntimeInformation)this.lportRuntimeInfo.get(lpName);
        rinfo.setEndpoint(lport.getEndpoint());
        return lport;
    }

    public void changeEndpointURL(String lpName, String newURL) throws WebserviceClientException {
        LogicalPortType lport = this.getLP(lpName);
        lport.setEndpoint(newURL);
    }
}

