/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class QNameManager {
    private HashSet usedPortTypes;
    private Hashtable qnameToJavaMapping;
    private Hashtable qnameToJavaQMapping;
    private NameConvertor convertor = new NameConvertor();

    public QNameManager() {
        this.usedPortTypes = new HashSet();
        this.qnameToJavaMapping = new Hashtable();
        this.qnameToJavaQMapping = new Hashtable();
    }

    public void clear() {
        this.usedPortTypes.clear();
        this.qnameToJavaMapping.clear();
    }

    public boolean isQNameUsed(QName qname) {
        return this.usedPortTypes.contains(qname);
    }

    public void useQName(QName qname) {
        this.usedPortTypes.add(qname);
    }

    public String getNewJavaName(QName qname, String packageName) {
        String interfaceName;
        if (this.qnameToJavaMapping.containsKey(qname)) {
            return (String)this.qnameToJavaMapping.get(qname);
        }
        String javaQName = interfaceName = this.convertor.attributeToClassName(qname.getLocalPart());
        if (packageName != null && packageName.length() != 0) {
            javaQName = packageName + "." + javaQName;
        }
        while (this.qnameToJavaQMapping.containsValue(javaQName)) {
            interfaceName = interfaceName + "X";
            javaQName = javaQName + "X";
        }
        this.qnameToJavaMapping.put(qname, interfaceName);
        this.qnameToJavaQMapping.put(qname, javaQName);
        return interfaceName;
    }

    public String getNewJavaQName(QName qname, String packageName) {
        String interfaceName;
        if (this.qnameToJavaMapping.containsKey(qname)) {
            return (String)this.qnameToJavaMapping.get(qname);
        }
        String javaQName = interfaceName = this.convertor.attributeToClassName(qname.getLocalPart());
        if (packageName != null && packageName.length() != 0) {
            javaQName = packageName + "." + javaQName;
        }
        while (this.qnameToJavaQMapping.containsValue(javaQName)) {
            interfaceName = interfaceName + "X";
            javaQName = javaQName + "X";
        }
        this.qnameToJavaMapping.put(qname, interfaceName);
        this.qnameToJavaQMapping.put(qname, javaQName);
        return javaQName;
    }

    public String getJavaName(QName qname) {
        return (String)this.qnameToJavaMapping.get(qname);
    }

    public String getJavaQName(QName qname) {
        return (String)this.qnameToJavaQMapping.get(qname);
    }

    public boolean containsJavaName(String javaName) {
        return this.qnameToJavaMapping.containsValue(javaName);
    }

    public String resolveJavaName(String javaName, String resolveString) {
        while (this.qnameToJavaMapping.containsValue(javaName)) {
            javaName = javaName + resolveString;
        }
        return javaName;
    }

    public String resolveJavaQName(String javaName, String resolveString) {
        while (this.qnameToJavaQMapping.containsValue(javaName)) {
            javaName = javaName + resolveString;
        }
        return javaName;
    }
}

