/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import java.util.ArrayList;

public class ProtocolList
extends ArrayList {
    public boolean add(Object object) {
        if (object instanceof AbstractProtocol) {
            super.add(object);
            return true;
        }
        throw new IllegalArgumentException(" Only Abstract Protocols can be added in protocol list !");
    }

    public AbstractProtocol getProtocol(int i) {
        return (AbstractProtocol)super.get(i);
    }

    public AbstractProtocol getProtocol(String protocolName) {
        int i = 0;
        while (i < super.size()) {
            AbstractProtocol protocol = (AbstractProtocol)super.get(i);
            if (protocol.getName() != null && protocol.getName().equals(protocolName)) {
                return protocol;
            }
            if (protocol.getName() == protocolName) {
                return protocol;
            }
            ++i;
        }
        return null;
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        int i = 0;
        while (i < super.size()) {
            AbstractProtocol protocol = (AbstractProtocol)super.get(i);
            if (!protocol.handleRequest(message, context)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleResponse(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        int i = super.size() - 1;
        while (i >= 0) {
            AbstractProtocol protocol = (AbstractProtocol)super.get(i);
            if (!protocol.handleResponse(message, context)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean handleFault(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        int i = super.size() - 1;
        while (i >= 0) {
            AbstractProtocol protocol = (AbstractProtocol)super.get(i);
            if (!protocol.handleFault(message, context)) {
                return false;
            }
            --i;
        }
        return true;
    }
}

