/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.interfaces.webservices.server.deploy.wsclient.LPPropertyContext;
import java.util.Enumeration;
import java.util.Hashtable;

public class PropertyContext
implements LPPropertyContext {
    private Hashtable properties = new Hashtable();
    private Hashtable subContexts = new Hashtable();
    private boolean isDefined = false;

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setSubContext(String key, PropertyContext context) {
        if (key != null && context != null) {
            this.subContexts.put(key, context);
        }
        this.isDefined = true;
    }

    public void setProperty(String key, Object content) {
        if (key != null && content != null) {
            this.properties.put(key, content);
            this.isDefined = true;
        }
    }

    public void clear() {
        this.properties.clear();
        this.subContexts.clear();
        this.isDefined = false;
    }

    public PropertyContext getSubContext(String key) {
        PropertyContext result = (PropertyContext)this.subContexts.get(key);
        if (result == null) {
            result = new PropertyContext();
            this.subContexts.put(key, result);
        }
        this.isDefined = true;
        return result;
    }

    public Enumeration getProperyKeys() {
        return this.properties.keys();
    }

    public Enumeration getSubcontextKeys() {
        return this.subContexts.keys();
    }

    public void define() {
        this.isDefined = true;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void joinProperyContext(String key, PropertyContext context) {
        PropertyContext perm = this.getSubContext(key);
        if (perm.isDefined()) {
            Object value;
            String pkey;
            Enumeration keys = context.getProperyKeys();
            while (keys.hasMoreElements()) {
                pkey = (String)keys.nextElement();
                value = context.getProperty(pkey);
                perm.setProperty(pkey, value);
            }
            keys = context.getSubcontextKeys();
            while (keys.hasMoreElements()) {
                pkey = (String)keys.nextElement();
                value = context.getSubContext(pkey);
                perm.joinProperyContext(pkey, (PropertyContext)value);
            }
        } else {
            this.setSubContext(key, context);
        }
    }

    public PropertyContext getClone() {
        PropertyContext result = new PropertyContext();
        result.loadFrom(this);
        return result;
    }

    public void clearSubcontext(String key) {
        this.subContexts.remove(key);
    }

    public void clearProperty(String key) {
        this.properties.remove(key);
    }

    private void loadFrom(PropertyContext inputContext) {
        String key;
        this.clear();
        Enumeration keys = inputContext.getSubcontextKeys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            PropertyContext context = inputContext.getSubContext(key);
            PropertyContext newContext = this.getSubContext(key);
            this.setSubContext(key, newContext);
            newContext.loadFrom(context);
        }
        keys = inputContext.getProperyKeys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            Object content = inputContext.getProperty(key);
            this.setProperty(key, content);
        }
    }

    private String toString(int level) {
        StringBuffer result = new StringBuffer();
        StringBuffer indent = new StringBuffer();
        int i = 0;
        while (i < level) {
            indent.append(' ');
            ++i;
        }
        String indentS = indent.toString();
        if (!this.isDefined) {
            return indent + "<empty>\n";
        }
        Enumeration propertyKeys = this.properties.keys();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            Object value = this.properties.get(key);
            result.append(indentS);
            result.append(key);
            result.append(" = ");
            result.append('\'');
            result.append(value.toString());
            result.append('\'');
            result.append("\n");
        }
        Enumeration subContextKeys = this.subContexts.keys();
        while (subContextKeys.hasMoreElements()) {
            String key = (String)subContextKeys.nextElement();
            PropertyContext value = (PropertyContext)this.subContexts.get(key);
            result.append(indentS);
            result.append(key);
            result.append(" = ");
            result.append("{\n");
            result.append(value.toString(level + 1));
            result.append(indentS);
            result.append("}\n");
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public static void main(String[] args) {
        PropertyContext pc = new PropertyContext();
        pc.setProperty("prop1", "value1");
        pc.setProperty("prop2", "value2");
        pc.setProperty("prop3", "value3");
        PropertyContext pc1 = pc.getSubContext("prop1");
        pc1.setProperty("prop1", "value1");
        pc1.setProperty("prop2", "value2");
        pc1.setProperty("prop3", "value3");
        PropertyContext pc2 = pc.getSubContext("prop2");
        pc2.setProperty("prop1", "value1");
        pc2.setProperty("prop2", "value2");
        pc2.setProperty("prop3", "value3");
        PropertyContext pc3 = pc1.getSubContext("prop1");
        pc3.setProperty("prop1", "value1");
        pc3.setProperty("prop2", "value2");
        pc3.setProperty("prop3", "value3");
        System.out.println(pc.toString());
    }
}

