/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClassDefinition;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.GeneratorEnvironment;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceDefinition;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceHandler;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class PortalHandler
implements InterfaceHandler {
    private String defaultName = "PortalService";
    private InterfaceDefinition idefinition;
    private ClassDefinition cdefinition;

    public PortalHandler() {
    }

    public PortalHandler(String defaultName) {
        this.defaultName = defaultName;
    }

    public boolean startGenreration(GeneratorEnvironment environment) {
        NameConvertor convertor = environment.convertor;
        WSDLDefinitions definitions = environment.definitions;
        ArrayList services = definitions.getServices();
        if (services.size() != 0) {
            WSDLService service = (WSDLService)services.get(0);
            this.defaultName = convertor.attributeToClassName(service.getName());
        }
        this.idefinition = new InterfaceDefinition();
        this.cdefinition = new ClassDefinition();
        this.idefinition.setPackageName(environment.outputPackage);
        this.cdefinition.setPackageName(environment.outputPackage);
        while (convertor.conains(environment.outputPackage, this.defaultName)) {
            this.defaultName = this.defaultName + "Service";
        }
        convertor.addClassName(environment.outputPackage, this.defaultName);
        String implName = this.defaultName + "Impl";
        while (convertor.conains(environment.outputPackage, implName)) {
            implName = implName + "Impl";
        }
        convertor.addClassName(environment.outputPackage, implName);
        this.idefinition.setInterfaceName(this.defaultName);
        this.cdefinition.setClassName(implName);
        this.idefinition.setImports(this.getIImports());
        this.cdefinition.setImports(this.getImplImports(this.defaultName));
        this.idefinition.setExtendsInterfaces(new String[]{"IService"});
        this.cdefinition.setImplInterfaces(new String[]{this.idefinition.getQualifiedName()});
        this.fillImplementation(this.cdefinition.getContent());
        this.fillInterface(this.idefinition.getContent());
        return true;
    }

    public boolean endGeneration(GeneratorEnvironment environment) {
        try {
            this.idefinition.save(environment.outputRootDir);
            this.cdefinition.save(environment.outputRootDir);
        }
        catch (ProxyGeneratorException e) {
            environment.generateException = e;
            return false;
        }
        return true;
    }

    public boolean processPortType(WSDLPortType portType, GeneratorEnvironment environment) {
        environment.registerInterfaceName(new QName(portType.getNamespace(), portType.getName()), this.idefinition.getQualifiedName());
        CodeGenerator icontent = this.idefinition.getContent();
        CodeGenerator ccontent = this.cdefinition.getContent();
        NameConvertor convertor = environment.convertor;
        ArrayList operations = portType.getOperations();
        try {
            int i = 0;
            while (i < operations.size()) {
                WSDLOperation operation = (WSDLOperation)operations.get(i);
                environment.iGenerator.checkParams(operation);
                String methodName = convertor.attributeToMethodName(operation.getName());
                String methodHeader = environment.iGenerator.generateOperationHeader(methodName, operation);
                String[] methodExceptions = environment.iGenerator.getExceptions(operation.getFaultList(), methodName);
                environment.registerInterfaceMethod(this.idefinition.getQualifiedName(), environment.iGenerator.fillOperationInfo(methodName, operation));
                icontent.addIndent();
                ccontent.addIndent();
                icontent.add(methodHeader);
                ccontent.add(methodHeader);
                StringBuffer throwsExpression = new StringBuffer();
                if (methodExceptions.length != 0) {
                    throwsExpression.append(" throws ");
                    int j = 0;
                    while (j < methodExceptions.length) {
                        if (j != 0) {
                            throwsExpression.append(",");
                        }
                        throwsExpression.append(methodExceptions[j]);
                        ++j;
                    }
                }
                icontent.add(throwsExpression.toString());
                ccontent.add(throwsExpression.toString());
                icontent.add(";");
                icontent.addNewLine();
                ccontent.add(" {");
                ccontent.addNewLine();
                if (environment.returnType != null) {
                    String result = environment.iGenerator.getNull(environment.returnType);
                    ccontent.addLine("  return " + result + ";");
                }
                ccontent.addLine("}");
                ++i;
            }
        }
        catch (ProxyGeneratorException e) {
            environment.generateException = e;
        }
        return true;
    }

    public String[] getIImports() {
        return new String[]{"com.sapportals.portal.prt.service.IService"};
    }

    public String[] getImplImports(String interfaceName) {
        String[] result = new String[]{"com.sapportals.portal.prt.service.IServiceConfiguration", "com.sapportals.portal.prt.service.IServiceContext", "com.sapportals.portal.prt.resource.IResource"};
        return result;
    }

    private void fillInterface(CodeGenerator generator) {
        generator.addLine("public static final String KEY =\"" + this.cdefinition.getQualifiedName() + "\";");
    }

    private void fillImplementation(CodeGenerator generator) {
        generator.addLine("IServiceContext mm_serviceContext;");
        generator.addLine("public IServiceContext getContext() {");
        generator.addLine("  return mm_serviceContext;");
        generator.addLine("}");
        generator.addLine("public String getKey() {");
        generator.addLine("  return " + this.idefinition.getQualifiedName() + ".KEY;");
        generator.addLine("}");
        generator.addLine("public void afterInit() {");
        generator.addLine("}");
        generator.addLine("public void configure(IServiceConfiguration configuration) {");
        generator.addLine("}");
        generator.addLine("public void destroy() {");
        generator.addLine("}");
        generator.addLine("public void init(IServiceContext serviceContext) {");
        generator.addLine("  mm_serviceContext = serviceContext;");
        generator.addLine("}");
        generator.addLine("public void release() {");
        generator.addLine("}");
        generator.addLine("// Service implementation");
    }
}

