/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.HolderInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class HolderGenerator {
    private NameConvertor nameConvertor;
    private String packageName;

    public HolderGenerator(NameConvertor nameConvertor) {
        this.nameConvertor = nameConvertor;
    }

    public File[] generateHolders(File workDir, String packageName, ArrayList holders) throws Exception {
        File holderPackageDir = new File(workDir, this.nameConvertor.packageToPath(packageName));
        this.packageName = packageName;
        File[] result = new File[holders.size()];
        if (holders.size() > 0) {
            holderPackageDir.mkdirs();
            int i = 0;
            while (i < holders.size()) {
                File outFile;
                HolderInfo holderInfo = (HolderInfo)holders.get(i);
                String className = holderInfo.getName();
                result[i] = outFile = new File(holderPackageDir, className + ".java");
                CodeGenerator generator = new CodeGenerator();
                this.generateHolder(generator, holderInfo);
                PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
                output.print(generator.toString());
                output.close();
                ++i;
            }
        }
        return result;
    }

    private void generateHolder(CodeGenerator output, HolderInfo info) throws Exception {
        output.addLine("package " + this.packageName + ";");
        output.addLine();
        output.addLine("public final class " + info.getName() + " implements javax.xml.rpc.holders.Holder {");
        output.addLine();
        output.startSection();
        output.addLine("public " + info.getType() + " value;");
        output.addLine();
        output.addLine("public " + info.getName() + "() {");
        output.addLine("}");
        output.addLine();
        output.addLine("public " + info.getName() + "(" + info.getType() + " value) {");
        output.addLine("  this.value = value;");
        output.addLine("}");
        output.endSection();
        output.addLine();
        output.addLine("}");
    }
}

