/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.OperationInterface;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class GeneratorEnvironment {
    public File outputRootDir;
    public String outputPackage;
    public NameConvertor convertor = new NameConvertor();
    public WSDLDefinitions definitions;
    public SchemaToJavaGenerator schema;
    public ArrayList outputFiles = new ArrayList();
    public Throwable generateException;
    public InterfaceGenerator iGenerator;
    public String returnType;
    private Hashtable interfaces = new Hashtable();
    private Hashtable portTypes = new Hashtable();
    public Hashtable javaToSchemaMapping;

    public void clear() {
        this.convertor.clear();
        this.outputFiles.clear();
        this.interfaces.clear();
        this.portTypes.clear();
    }

    public void registerInterfaceName(QName portType, String interfaceName) {
        this.portTypes.put(portType, interfaceName);
    }

    public void registerInterfaceMethod(String interfaceName, OperationInterface operation) {
        ArrayList<OperationInterface> operations = null;
        operations = (ArrayList<OperationInterface>)this.interfaces.get(interfaceName);
        if (operations == null) {
            operations = new ArrayList<OperationInterface>();
            this.interfaces.put(interfaceName, operations);
        }
        operations.add(operation);
    }

    public OperationInterface[] getInterfaceMethods(String interfaceName) {
        ArrayList operations = (ArrayList)this.interfaces.get(interfaceName);
        if (operations == null) {
            return null;
        }
        OperationInterface[] result = new OperationInterface[operations.size()];
        int i = 0;
        while (i < operations.size()) {
            result[i] = (OperationInterface)operations.get(i);
            ++i;
        }
        return result;
    }

    public ArrayList getInterfaceMethodsAL(String interfaceName) {
        return (ArrayList)this.interfaces.get(interfaceName);
    }

    public String getPortTypeInterface(QName portType) {
        return (String)this.portTypes.get(portType);
    }

    public QName[] getPortTypes() {
        return this.portTypes.keySet().toArray(new QName[0]);
    }

    public String[] getInterfaces() {
        return this.interfaces.keySet().toArray(new String[0]);
    }

    public void printInterfaces() {
        String[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            System.out.println(" \\ Interface Name :" + interfaces[i]);
            OperationInterface[] operations = this.getInterfaceMethods(interfaces[i]);
            int j = 0;
            while (j < operations.length) {
                System.out.print("  +-- " + operations[j].operationJavaName);
                System.out.print("(");
                if (operations[j].inputParams != null) {
                    int k = 0;
                    while (k < operations[j].inputParams.length) {
                        if (k != 0) {
                            System.out.print(",");
                        }
                        System.out.print(operations[j].inputParams[k].contentClassName);
                        ++k;
                    }
                }
                System.out.print("):");
                if (operations[j].outputParams != null && operations[j].outputParams.length != 0) {
                    System.out.println(operations[j].outputParams[0].contentClassName);
                } else {
                    System.out.println("void");
                }
                ++j;
            }
            ++i;
        }
    }

    public static File getNewJavaFile(File baseDir, String packageName, String className) throws ProxyGeneratorException {
        if (packageName != null && packageName.length() != 0) {
            className = packageName + "." + className;
        }
        return GeneratorEnvironment.getNewJavaFile(baseDir, className);
    }

    public static File getNewJavaFile(File baseDir, String className) throws ProxyGeneratorException {
        File f = new File(baseDir, className.replace('.', File.separatorChar) + ".java");
        try {
            File fParent = f.getParentFile();
            if (!fParent.exists()) {
                fParent.mkdirs();
            }
            f.createNewFile();
        }
        catch (IOException e) {
            throw new ProxyGeneratorException("webservices_3207", e, f.getAbsolutePath());
        }
        return f;
    }
}

