/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.inqmy.lib.xml.dom.DOM;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.HolderGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.HolderInfo;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.QNameManager;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.DefaultProviders;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LocalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.OperationType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.engine.services.webservices.wsdl.SAPFeature;
import com.sap.engine.services.webservices.wsdl.SAPOption;
import com.sap.engine.services.webservices.wsdl.SAPProperty;
import com.sap.engine.services.webservices.wsdl.SAPUseFeature;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLFault;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Node;

public class ClassGenerator {
    protected WSDLDefinitions definitions = null;
    protected SchemaToJavaGenerator schema = null;
    protected File workDir = null;
    protected String packageName = null;
    protected String holderPackage = null;
    protected NameConvertor nameConvertor = null;
    protected File packageDir = null;
    protected ArrayList holders;
    protected HolderGenerator holderGenerator;
    private ClientTransportBinding[] bindings;
    protected TypeMappingRegistryImpl registry;
    private boolean isRegistryUsed = false;
    private String registryPath;
    private String typeMappingFile = "types.xml";
    private String logicalPortFile = "lports.xml";
    private String protocolsFile = "protocols.txt";
    private String lPortOutputPath = null;
    private ArrayList exceptionMessages;
    private ArrayList files;
    private ArrayList seiGenerated;
    private ArrayList serviceInterfaces;
    private boolean showWarnings = false;
    private LogicalPortFactory lpFactory = new LogicalPortFactory();
    private String defaultServiceName = "DefaultService";
    private String customServiceName = null;
    private javax.xml.namespace.QName isolatePortType = null;
    private String schemaFrameworkPath = null;
    private boolean genericMode = false;
    private boolean alternativeMethods = false;
    private boolean containerMode = false;
    private boolean generateGetPorts = false;
    private QNameManager portManager = new QNameManager();
    private QNameManager stubManager = new QNameManager();
    private Properties uriToPackageMapping = null;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$javax$xml$rpc$Stub;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$DynamicInterface;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$client$dynamic$content$ObjectFactory;
    static /* synthetic */ Class class$java$lang$reflect$InvocationTargetException;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$xml$rpc$soap$SOAPFaultException;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$client$dynamic$content$impl$GenericObjectImpl;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext;
    static /* synthetic */ Class class$com$sap$engine$interfaces$webservices$runtime$component$ClientComponentFactory;
    static /* synthetic */ Class class$javax$xml$rpc$Service;

    public void setGenericMode(boolean flag) {
        this.genericMode = flag;
    }

    public void setContainerMode(boolean mode) {
        this.containerMode = mode;
    }

    public void setUseGetPortMethods(boolean flag) {
        this.generateGetPorts = flag;
    }

    public void setSchemaFrameworkPath(String schemaFrameworkPath) {
        this.schemaFrameworkPath = schemaFrameworkPath;
    }

    public String getSchemaFrameworkPath() {
        return this.schemaFrameworkPath;
    }

    public void setCustomServiceName(String serviceName) {
        this.customServiceName = serviceName;
    }

    public void setIsolatedPortType(javax.xml.namespace.QName portType) {
        this.isolatePortType = portType;
    }

    public void setAlternativeMethods(boolean flag) {
        this.alternativeMethods = flag;
    }

    public void setLogicalPortName(String newLPName) {
        this.logicalPortFile = newLPName;
    }

    public void showWarings() {
        this.showWarnings = true;
    }

    public void hideWarning() {
        this.showWarnings = false;
    }

    public ClassGenerator() {
        this.nameConvertor = new NameConvertor();
        this.holders = new ArrayList();
        this.holderGenerator = new HolderGenerator(this.nameConvertor);
        this.exceptionMessages = new ArrayList();
        this.files = new ArrayList();
        this.seiGenerated = new ArrayList();
        this.serviceInterfaces = new ArrayList();
    }

    public void init(WSDLDefinitions definitions, File workDir, String packageName, ClientTransportBinding[] bindings) throws Exception {
        if (!workDir.isDirectory()) {
            throw new Exception(" Parameter given is not a directory !");
        }
        this.definitions = definitions;
        this.definitions.loadSchemaInfo();
        this.schema = definitions.getSchemaInfo();
        this.workDir = workDir;
        this.packageName = packageName;
        this.customServiceName = null;
        this.holderPackage = "holders";
        if (packageName != null && packageName.length() != 0) {
            this.holderPackage = packageName + ".holders";
            this.packageDir = new File(workDir, this.nameConvertor.packageToPath(packageName));
        } else {
            this.packageDir = workDir;
        }
        this.containerMode = false;
        this.isolatePortType = null;
        this.packageDir.mkdirs();
        this.bindings = bindings;
        this.isRegistryUsed = false;
        this.registryPath = null;
        this.exceptionMessages.clear();
        this.files.clear();
        this.seiGenerated.clear();
        this.serviceInterfaces.clear();
        if (!this.packageDir.isDirectory()) {
            throw new Exception(" Package name is not correct !");
        }
        this.nameConvertor.clear();
        this.portManager.clear();
        this.stubManager.clear();
    }

    public void setLogicalPortPath(String outputPath) {
        this.lPortOutputPath = outputPath;
    }

    public void clearLogicalPortPath() {
        this.lPortOutputPath = null;
    }

    public String getLogicalPortPath() {
        return this.lPortOutputPath;
    }

    public File[] getFileList() {
        File[] result = new File[this.files.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (File)this.files.get(i);
            ++i;
        }
        return result;
    }

    public File[] getGeneratedSeiList() {
        File[] result = new File[this.seiGenerated.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (File)this.seiGenerated.get(i);
            ++i;
        }
        return result;
    }

    public File[] getGeneratedServiceInterfaces() {
        File[] result = new File[this.serviceInterfaces.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (File)this.serviceInterfaces.get(i);
            ++i;
        }
        return result;
    }

    public int operationBindingInitialization(String contextName, PropertyContext context, CodeGenerator output, int level, int maxlevel) {
        Enumeration keys = context.getProperyKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = context.getProperty(key);
            if (!(value instanceof String)) continue;
            output.addLine(contextName + ".setProperty(\"" + key + "\",\"" + value + "\");");
        }
        keys = context.getSubcontextKeys();
        if (keys.hasMoreElements()) {
            String newContextName = contextName + "X";
            int perm = maxlevel;
            if (++level > maxlevel) {
                output.addLine("PropertyContext " + newContextName + ";");
                perm = level;
            }
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                PropertyContext content = context.getSubContext(key);
                output.addLine(newContextName + " = " + contextName + ".getSubContext(\"" + key + "\");");
                int permX = this.operationBindingInitialization(newContextName, content, output, level, perm);
                if (permX <= perm) continue;
                perm = permX;
            }
            return perm;
        }
        return level;
    }

    private void fillFeature(FeatureType feature, SAPFeature sapFeature) {
        String provider = DefaultProviders.getProvider(feature.getName());
        if (provider != null) {
            feature.setProvider(provider);
        }
        feature.setOriginal(true);
        ArrayList sapProperties = sapFeature.getProperties();
        int i = 0;
        while (i < sapProperties.size()) {
            PropertyType lproperty = new PropertyType();
            SAPProperty property = (SAPProperty)sapProperties.get(i);
            QName qname = property.getQname();
            lproperty.setName(qname.getLocalName());
            if (property.getOptions().size() != 0) {
                SAPOption option = (SAPOption)property.getOptions().get(0);
                lproperty.setValue(option.getValue());
            }
            feature.addProperty(lproperty);
            ++i;
        }
    }

    public void fillLogicalPortTemplate(LogicalPortType lpTemplate, WSDLPortType portType) throws WSDLException {
        if (lpTemplate.getName() == null) {
            lpTemplate.setName(portType.getName());
        }
        GlobalFeatures globalFeatures = null;
        if (lpTemplate.hasGlobalFeatures()) {
            globalFeatures = lpTemplate.getGlobalFeatures();
        }
        ArrayList global = portType.getUseFeatures();
        int i = 0;
        while (i < global.size()) {
            SAPUseFeature useFeature = (SAPUseFeature)global.get(i);
            SAPFeature sapFeature = this.definitions.getFeatureByName(useFeature.getFeatureQName());
            if (sapFeature == null) {
                throw new WSDLException(" Unrecognized WSDL feature '" + useFeature.getFeature() + "' !");
            }
            FeatureType feature = null;
            if (globalFeatures != null) {
                feature = globalFeatures.getFeature(sapFeature.getUri());
            } else {
                globalFeatures = new GlobalFeatures();
                lpTemplate.setGlobalFeatures(globalFeatures);
            }
            if (feature == null) {
                feature = new FeatureType();
                feature.setName(sapFeature.getUri());
            }
            this.fillFeature(feature, sapFeature);
            globalFeatures.addFeature(feature);
            ++i;
        }
        LocalFeatures localFeatures = lpTemplate.getLocalFeatures();
        if (localFeatures == null) {
            localFeatures = new LocalFeatures();
            lpTemplate.setLocalFeatures(localFeatures);
        }
        ArrayList operations = portType.getOperations();
        int i2 = 0;
        while (i2 < operations.size()) {
            WSDLOperation operation = (WSDLOperation)operations.get(i2);
            OperationType loperation = localFeatures.getOperation(operation.getName());
            if (loperation == null) {
                loperation = new OperationType();
                loperation.setName(operation.getName());
                localFeatures.addOperation(loperation);
            }
            if (operation.getUseFeatures().size() != 0) {
                ArrayList ouseFeatures = operation.getUseFeatures();
                int j = 0;
                while (j < ouseFeatures.size()) {
                    SAPUseFeature sapUseFeature = (SAPUseFeature)ouseFeatures.get(j);
                    SAPFeature sapFeature = this.definitions.getFeatureByName(sapUseFeature.getFeatureQName());
                    if (sapFeature == null) {
                        throw new WSDLException(" Unrecognized WSDL feature '" + sapUseFeature.getFeature() + "' !");
                    }
                    FeatureType feature = loperation.getFeature(sapFeature.getUri());
                    if (feature == null) {
                        feature = new FeatureType();
                        feature.setName(sapFeature.getUri());
                    }
                    this.fillFeature(feature, sapFeature);
                    loperation.addFeature(feature);
                    ++j;
                }
            }
            ++i2;
        }
    }

    public void fillLogicalPort(String stubName, String endpoint, WSDLBinding binding, LogicalPortType lport, ClientTransportBinding tbinding) throws WSDLException {
        if (endpoint != null) {
            lport.setEndpoint(endpoint);
        }
        if (stubName != null) {
            lport.setStubName(stubName);
        }
        if (lport.getName() == null) {
            lport.setName(binding.getName());
        }
        GlobalFeatures globalFeatures = null;
        if (lport.hasGlobalFeatures()) {
            globalFeatures = lport.getGlobalFeatures();
        }
        if (globalFeatures == null) {
            globalFeatures = new GlobalFeatures();
        }
        tbinding.importGlobalFeatures(globalFeatures, binding);
        ArrayList global = binding.getUseFeatures();
        int i = 0;
        while (i < global.size()) {
            SAPUseFeature useFeature = (SAPUseFeature)global.get(i);
            SAPFeature sapFeature = this.definitions.getFeatureByName(useFeature.getFeatureQName());
            if (sapFeature == null) {
                throw new WSDLException(" Unrecognized WSDL feature '" + useFeature.getFeature() + "' !");
            }
            FeatureType feature = null;
            if (globalFeatures != null) {
                feature = globalFeatures.getFeature(sapFeature.getUri());
            } else {
                globalFeatures = new GlobalFeatures();
                lport.setGlobalFeatures(globalFeatures);
            }
            if (feature == null) {
                feature = new FeatureType();
                feature.setName(sapFeature.getUri());
            }
            this.fillFeature(feature, sapFeature);
            globalFeatures.addFeature(feature);
            ++i;
        }
        lport.setGlobalFeatures(globalFeatures);
        LocalFeatures localFeatures = lport.getLocalFeatures();
        if (localFeatures == null) {
            localFeatures = new LocalFeatures();
            lport.setLocalFeatures(localFeatures);
        }
        ArrayList operations = binding.getOperations();
        int i2 = 0;
        while (i2 < operations.size()) {
            WSDLBindingOperation operation = (WSDLBindingOperation)operations.get(i2);
            OperationType loperation = localFeatures.getOperation(operation.getName());
            if (loperation == null) {
                loperation = new OperationType();
                loperation.setName(operation.getName());
                localFeatures.addOperation(loperation);
            }
            if (operation.getUseFeatures().size() != 0) {
                ArrayList ouseFeatures = operation.getUseFeatures();
                int j = 0;
                while (j < ouseFeatures.size()) {
                    SAPUseFeature sapUseFeature = (SAPUseFeature)ouseFeatures.get(j);
                    SAPFeature sapFeature = this.definitions.getFeatureByName(sapUseFeature.getFeatureQName());
                    if (sapFeature == null) {
                        throw new WSDLException(" Unrecognized WSDL feature '" + sapUseFeature.getFeature() + "' !");
                    }
                    FeatureType feature = loperation.getFeature(sapFeature.getUri());
                    if (feature == null) {
                        feature = new FeatureType();
                        feature.setName(sapFeature.getUri());
                    }
                    this.fillFeature(feature, sapFeature);
                    loperation.addFeature(feature);
                    ++j;
                }
            }
            ++i2;
        }
    }

    private void generateSchema() throws Exception {
        if (this.schema == null) {
            this.schema = new SchemaToJavaGenerator();
            if (this.genericMode) {
                this.schema.setUnwrapArrays(false);
                this.schema.setGenericFrm(true);
            }
            this.schema.prepareAll(this.packageName);
        } else {
            this.schema.setMirrorLocations(this.definitions.getMirrorLocations());
            this.schema.setMirrorMapping(this.definitions.getMirrorMapping());
            if (this.genericMode) {
                this.schema.setUnwrapArrays(false);
                this.schema.setGenericFrm(true);
            }
            if (this.uriToPackageMapping != null) {
                this.schema.setUriToPackagetMapping(this.uriToPackageMapping);
            }
            String typesPackage = "types";
            if (this.packageName != null && this.packageName.length() != 0) {
                typesPackage = this.packageName + "." + typesPackage;
            }
            File outputDir = this.workDir;
            if (this.schemaFrameworkPath != null) {
                outputDir = new File(this.schemaFrameworkPath);
                outputDir.mkdirs();
                this.schema.generateAll(outputDir, typesPackage);
            } else {
                this.schema.setContainerMode(this.containerMode);
                this.schema.generateAll(this.workDir, typesPackage);
            }
            if (!this.containerMode || this.schemaFrameworkPath != null) {
                this.registry = this.genericMode ? new TypeMappingRegistryImpl(1, null, null) : new TypeMappingRegistryImpl();
                this.schema.registerTypes((ExtendedTypeMapping)this.registry.getDefaultTypeMapping());
                String outputFileName = this.typeMappingFile;
                if (this.packageName != null && this.packageName.length() != 0) {
                    outputFileName = this.nameConvertor.packageToPath(this.packageName) + File.separatorChar + this.typeMappingFile;
                }
                File outputxml = new File(outputDir, outputFileName);
                this.files.add(outputxml);
                this.registry.toXmlFile(outputxml);
                this.registry = null;
                this.isRegistryUsed = true;
                this.registryPath = this.packageName != null && this.packageName.length() != 0 ? this.escapeString(this.packageName + ".") + this.typeMappingFile : this.typeMappingFile;
                File[] filesArr = this.schema.getFileList();
                int i = 0;
                while (i < filesArr.length) {
                    this.files.add(filesArr[i]);
                    ++i;
                }
            }
        }
    }

    private void printWarining(String warningMessage) {
        if (this.showWarnings) {
            System.out.println("Waring : " + warningMessage);
        }
    }

    private String getLPath() {
        String lpath = this.packageName != null && this.packageName.length() != 0 ? this.escapeString(this.packageName + ".") + this.logicalPortFile : this.logicalPortFile;
        return lpath;
    }

    private File getLPFile() {
        if (this.lPortOutputPath != null) {
            return new File(this.lPortOutputPath, this.logicalPortFile);
        }
        String lpath = this.packageName != null && this.packageName.length() != 0 ? this.escapeString(this.packageName + ".") + this.logicalPortFile : this.logicalPortFile;
        return new File(this.workDir, lpath);
    }

    private boolean checkPortType(WSDLPortType portType) {
        if (this.isolatePortType != null) {
            if (!this.isolatePortType.getLocalPart().equals(portType)) {
                return false;
            }
            if (this.isolatePortType.getNamespaceURI() != null ? !this.isolatePortType.getNamespaceURI().equals(portType.getNamespace()) : portType.getNamespace() != null) {
                return false;
            }
        }
        return true;
    }

    public void generateInterfaces() throws Exception {
        if (this.definitions.services.size() > 1) {
            this.printWarining("More than one service in wsdl is not supported so only first service will be used !");
        }
        if (this.definitions.services.size() == 0) {
            this.printWarining("No service tag found. Switching to binding mapping mode.");
        }
        this.generateSchema();
        if (this.definitions.services.size() != 0) {
            WSDLService service = (WSDLService)this.definitions.services.get(0);
            if (service.getPorts().size() == 0) {
                throw new Exception(" At least one port of the service must be specified !");
            }
            ArrayList ports = service.getPorts();
            LogicalPorts lports = new LogicalPorts();
            if (this.customServiceName != null) {
                lports.setName(this.customServiceName);
            } else {
                lports.setName(service.getName());
            }
            int i = 0;
            while (i < ports.size()) {
                WSDLPort port = (WSDLPort)ports.get(i);
                WSDLBinding portbinding = this.definitions.getBinding(port.getBinding());
                if (portbinding == null) {
                    throw new Exception(" Port points to unknown Binding " + port.getBinding().getName());
                }
                LogicalPortType lport = new LogicalPortType();
                lport.setName(port.getName());
                lport.setBindingName(port.getBinding().getLocalName());
                lport.setBindingUri(port.getBinding().getURI());
                ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
                if (bindingImplementation == null) {
                    this.printWarining("No available binding implementation can recognize: " + port.getBinding().getName() + " binding not used.");
                } else {
                    String outputAddress = bindingImplementation.loadAddress(port.getExtension());
                    WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
                    if (this.checkPortType(portType)) {
                        if (portType == null) {
                            throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
                        }
                        lport = this.generateSDI(portType, portbinding, lport);
                        lport.setBindingImplementation(bindingImplementation.getName());
                        this.fillLogicalPort(null, outputAddress, portbinding, lport, bindingImplementation);
                        lports.addLogicalPort(lport);
                    }
                }
                ++i;
            }
            File[] fileArr = this.holderGenerator.generateHolders(this.workDir, this.holderPackage, this.holders);
            int i2 = 0;
            while (i2 < fileArr.length) {
                this.files.add(fileArr[i2]);
                ++i2;
            }
            this.generateExceptions(this.exceptionMessages);
            this.generateServiceInterfaces(lports, this.generateGetPorts);
            File lpFile = this.getLPFile();
            this.files.add(lpFile);
            this.lpFactory.saveLogicalPorts(lports, lpFile);
        } else {
            ArrayList bindings = this.definitions.getBindings();
            if (bindings.size() != 0) {
                LogicalPorts lports = new LogicalPorts();
                if (this.customServiceName != null) {
                    lports.setName(this.customServiceName);
                } else {
                    lports.setName(this.definitions.getName());
                    if (lports.getName() == null) {
                        lports.setName(this.defaultServiceName);
                    }
                }
                int i = 0;
                while (i < bindings.size()) {
                    WSDLBinding portbinding = (WSDLBinding)bindings.get(i);
                    LogicalPortType lport = new LogicalPortType();
                    lport.setName(portbinding.getName());
                    lport.setBindingName(portbinding.getName());
                    lport.setBindingUri(portbinding.getNamespace());
                    ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
                    if (bindingImplementation == null) {
                        throw new Exception(" No available binding can recognize this binding : " + portbinding.getName());
                    }
                    WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
                    if (this.checkPortType(portType)) {
                        if (portType == null) {
                            throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
                        }
                        lport = this.generateSDI(portType, portbinding, lport);
                        lport.setBindingImplementation(bindingImplementation.getName());
                        this.fillLogicalPort(null, null, portbinding, lport, bindingImplementation);
                        lports.addLogicalPort(lport);
                    }
                    ++i;
                }
                File[] fileArr = this.holderGenerator.generateHolders(this.workDir, this.holderPackage, this.holders);
                int i3 = 0;
                while (i3 < fileArr.length) {
                    this.files.add(fileArr[i3]);
                    ++i3;
                }
                this.generateExceptions(this.exceptionMessages);
                this.generateServiceInterfaces(lports, false);
                File lpFile = this.getLPFile();
                this.files.add(lpFile);
                this.lpFactory.saveLogicalPorts(lports, lpFile);
            } else {
                this.printWarining("No binding found. Switching to portType mapping mode.");
                LogicalPorts lports = new LogicalPorts();
                if (this.customServiceName != null) {
                    lports.setName(this.customServiceName);
                } else {
                    lports.setName(this.definitions.getName());
                    if (lports.getName() == null) {
                        lports.setName(this.defaultServiceName);
                    }
                }
                ArrayList portTypes = this.definitions.getPortTypes();
                if (portTypes.size() == 0) {
                    throw new Exception(" No PortTypes found. This WSDL is completly unusable !");
                }
                int i = 0;
                while (i < portTypes.size()) {
                    WSDLPortType portType = (WSDLPortType)portTypes.get(i);
                    if (this.checkPortType(portType)) {
                        this.generateSDI(portType, null, null);
                    }
                    ++i;
                }
                File[] fileArr = this.holderGenerator.generateHolders(this.workDir, this.holderPackage, this.holders);
                int i4 = 0;
                while (i4 < fileArr.length) {
                    this.files.add(fileArr[i4]);
                    ++i4;
                }
                this.generateExceptions(this.exceptionMessages);
                this.generateServiceInterfaces(lports, false);
                File lpFile = this.getLPFile();
                this.files.add(lpFile);
                this.lpFactory.saveLogicalPorts(lports, lpFile);
            }
        }
    }

    private void prepareSchema() throws Exception {
        String typesPackage = "types";
        if (this.packageName != null && this.packageName.length() != 0) {
            typesPackage = this.packageName + "." + typesPackage;
        }
        if (this.schema == null) {
            this.schema = new SchemaToJavaGenerator();
            if (this.uriToPackageMapping != null) {
                this.schema.setUriToPackagetMapping(this.uriToPackageMapping);
            }
            if (this.genericMode) {
                this.schema.setUnwrapArrays(false);
                this.schema.setGenericFrm(true);
            }
            this.schema.prepareAll(typesPackage);
        } else {
            this.schema.setContainerMode(this.containerMode);
            this.schema.setMirrorLocations(this.definitions.getMirrorLocations());
            this.schema.setMirrorMapping(this.definitions.getMirrorMapping());
            if (this.genericMode) {
                this.schema.setUnwrapArrays(false);
                this.schema.setGenericFrm(true);
            }
            if (!this.schema.isLoaded() || this.uriToPackageMapping != null) {
                if (this.uriToPackageMapping != null) {
                    this.schema.setUriToPackagetMapping(this.uriToPackageMapping);
                }
                this.schema.prepareAll(typesPackage);
                this.isRegistryUsed = true;
                this.registryPath = this.packageName != null && this.packageName.length() != 0 ? this.escapeString(this.packageName + ".") + this.typeMappingFile : this.typeMappingFile;
            }
        }
    }

    public Properties getDefaultSchemaMapping() throws Exception {
        this.prepareSchema();
        this.uriToPackageMapping = this.schema.getUriToPackageMapping();
        return this.uriToPackageMapping;
    }

    public void setDefaultSchemaMapping(Properties defaultMapping) throws Exception {
        this.uriToPackageMapping = defaultMapping;
    }

    public LogicalPorts generateStubs(LogicalPorts logicalPorts) throws Exception {
        this.prepareSchema();
        LogicalPortType[] ports = logicalPorts.getLogicalPort();
        int i = 0;
        while (i < ports.length) {
            String bindingNamespace;
            String bindingName = ports[i].getBindingName();
            WSDLBinding portbinding = this.definitions.getBinding(bindingName, bindingNamespace = ports[i].getBindingUri());
            if (portbinding == null) {
                throw new Exception(" Logical Port [" + ports[i].getName() + "] points to unavailable binding {" + bindingNamespace + "}" + bindingName);
            }
            ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
            if (bindingImplementation == null) {
                throw new Exception(" No available binding implementation can recognize this binding : " + ports[i].getBindingName());
            }
            String outputAddress = ports[i].getEndpoint();
            WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
            if (portType == null) {
                throw new Exception("PortType with name {" + portbinding.getType().getURI() + "}" + portbinding.getType().getName() + " not found !");
            }
            this.stubGenerate(portType, portbinding, outputAddress, bindingImplementation, ports[i], false);
            ++i;
        }
        return logicalPorts;
    }

    public LogicalPorts generateImplementation(LogicalPorts logicalPorts, boolean serverHosted) throws Exception {
        if (this.containerMode && this.schemaFrameworkPath != null) {
            this.generateSchema();
        } else {
            this.prepareSchema();
        }
        LogicalPortType[] ports = logicalPorts.getLogicalPort();
        int i = 0;
        while (i < ports.length) {
            String bindingNamespace;
            String bindingName = ports[i].getBindingName();
            WSDLBinding portbinding = this.definitions.getBinding(bindingName, bindingNamespace = ports[i].getBindingUri());
            if (portbinding == null) {
                throw new Exception(" Logical Port [" + ports[i].getName() + "] points to unavailable binding {" + bindingNamespace + "}" + bindingName);
            }
            ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
            if (bindingImplementation == null) {
                throw new Exception(" No available binding implementation can recognize this binding : {" + ports[i].getBindingUri() + "}" + ports[i].getBindingName());
            }
            String outputAddress = ports[i].getEndpoint();
            WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
            if (portType == null) {
                throw new Exception(" PortType with qname {" + portbinding.getType().getURI() + "}" + portbinding.getType().getName() + " not found !");
            }
            this.stubGenerate(portType, portbinding, outputAddress, bindingImplementation, ports[i], serverHosted);
            ++i;
        }
        this.generateServiceImpl(logicalPorts, null, serverHosted);
        return logicalPorts;
    }

    public LogicalPorts generateStubs() throws Exception {
        if (this.definitions.services.size() == 0) {
            throw new Exception(" At least one service must be defined to generate Proxy !");
        }
        if (this.definitions.services.size() > 1) {
            throw new Exception(" More than one service at a time not supported yet !");
        }
        this.prepareSchema();
        WSDLService service = (WSDLService)this.definitions.services.get(0);
        if (service.getPorts().size() == 0) {
            throw new Exception("At least one port of the service must be specified !");
        }
        ArrayList ports = service.getPorts();
        LogicalPorts lports = new LogicalPorts();
        lports.setName(service.getName());
        int i = 0;
        while (i < ports.size()) {
            WSDLPort port = (WSDLPort)ports.get(i);
            WSDLBinding portbinding = this.definitions.getBinding(port.getBinding());
            if (portbinding == null) {
                throw new Exception(" Port points to unknown Binding " + port.getBinding().getName());
            }
            LogicalPortType lport = new LogicalPortType();
            lport.setName(port.getName());
            lport.setBindingName(port.getBinding().getLocalName());
            lport.setBindingUri(port.getBinding().getURI());
            ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
            if (bindingImplementation == null) {
                throw new Exception(" No available implementation can recognize this binding : " + port.getBinding().getName());
            }
            String outputAddress = bindingImplementation.loadAddress(port.getExtension());
            WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
            if (portType == null) {
                throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
            }
            lport = this.stubGenerate(portType, portbinding, outputAddress, bindingImplementation, lport, false);
            lports.addLogicalPort(lport);
            ++i;
        }
        String lpath = this.packageName != null && this.packageName.length() != 0 ? this.escapeString(this.packageName + ".") + this.logicalPortFile : this.logicalPortFile;
        File lpFile = new File(this.workDir, lpath);
        LogicalPortFactory factory = new LogicalPortFactory();
        factory.saveLogicalPorts(lports, lpFile);
        this.generateServiceImpl(lports, lpath, false);
        return lports;
    }

    public void generateLogicalPorts() throws Exception {
        if (this.definitions.services.size() > 1) {
            // empty if block
        }
        if (this.definitions.services.size() == 0) {
            System.out.println(" Warning : No service tag found - switching to binding mapping mode !");
        }
        this.generateSchema();
        if (this.definitions.services.size() != 0) {
            WSDLService service = (WSDLService)this.definitions.services.get(0);
            if (service.getPorts().size() == 0) {
                throw new Exception("At least one port of the service must be specified !");
            }
            ArrayList ports = service.getPorts();
            LogicalPorts lports = new LogicalPorts();
            lports.setName(service.getName());
            int i = 0;
            while (i < ports.size()) {
                WSDLPort port = (WSDLPort)ports.get(i);
                WSDLBinding portbinding = this.definitions.getBinding(port.getBinding());
                if (portbinding == null) {
                    throw new Exception(" Port points to unknown Binding " + port.getBinding().getName());
                }
                LogicalPortType lport = new LogicalPortType();
                lport.setName(port.getName());
                lport.setBindingName(port.getBinding().getLocalName());
                lport.setBindingUri(port.getBinding().getURI());
                ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
                if (bindingImplementation == null) {
                    System.out.println(" No available binding implementation can recognize this binding : " + port.getBinding().getName());
                } else {
                    String outputAddress = bindingImplementation.loadAddress(port.getExtension());
                    WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
                    if (portType == null) {
                        throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
                    }
                    this.fillLogicalPortTemplate(lport, portType);
                    lport.setBindingImplementation(bindingImplementation.getName());
                    this.fillLogicalPort(null, outputAddress, portbinding, lport, bindingImplementation);
                    lports.addLogicalPort(lport);
                }
                ++i;
            }
            File lpFile = this.getLPFile();
            this.files.add(lpFile);
            this.lpFactory.saveLogicalPorts(lports, lpFile);
        } else {
            ArrayList bindings = this.definitions.getBindings();
            if (bindings.size() != 0) {
                LogicalPorts lports = new LogicalPorts();
                lports.setName(this.definitions.getName());
                if (lports.getName() == null) {
                    lports.setName(this.defaultServiceName);
                }
                int i = 0;
                while (i < bindings.size()) {
                    WSDLBinding portbinding = (WSDLBinding)bindings.get(i);
                    LogicalPortType lport = new LogicalPortType();
                    lport.setName(portbinding.getName());
                    lport.setBindingName(portbinding.getName());
                    lport.setBindingUri(portbinding.getNamespace());
                    ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
                    if (bindingImplementation == null) {
                        throw new Exception(" No available binding implementation can recognize this binding : " + portbinding.getName());
                    }
                    WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
                    if (portType == null) {
                        throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
                    }
                    this.fillLogicalPortTemplate(lport, portType);
                    lport.setBindingImplementation(bindingImplementation.getName());
                    this.fillLogicalPort(null, null, portbinding, lport, bindingImplementation);
                    lports.addLogicalPort(lport);
                    ++i;
                }
                File lpFile = this.getLPFile();
                this.files.add(lpFile);
                this.lpFactory.saveLogicalPorts(lports, lpFile);
            }
        }
    }

    public void generateAll() throws Exception {
        if (this.definitions.services.size() > 1) {
            // empty if block
        }
        if (this.definitions.services.size() == 0) {
            System.out.println(" Warning : No service tag found - switching to binding mapping mode !");
        }
        this.generateSchema();
        if (this.definitions.services.size() != 0) {
            WSDLService service = (WSDLService)this.definitions.services.get(0);
            if (service.getPorts().size() == 0) {
                throw new Exception("At least one port of the service must be specified !");
            }
            ArrayList ports = service.getPorts();
            LogicalPorts lports = new LogicalPorts();
            if (this.customServiceName != null) {
                lports.setName(this.customServiceName);
            } else {
                lports.setName(service.getName());
            }
            int i = 0;
            while (i < ports.size()) {
                WSDLPortType portType;
                WSDLPort port = (WSDLPort)ports.get(i);
                WSDLBinding portbinding = this.definitions.getBinding(port.getBinding());
                if (portbinding == null) {
                    throw new Exception(" Port points to unknown Binding " + port.getBinding().getName());
                }
                LogicalPortType lport = new LogicalPortType();
                lport.setName(port.getName());
                lport.setBindingName(port.getBinding().getLocalName());
                lport.setBindingUri(port.getBinding().getURI());
                ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
                if (bindingImplementation == null) {
                    System.out.println(" No available binding can recognize this binding : " + port.getBinding().getName());
                } else if ((!this.genericMode || bindingImplementation.getName().equals("SOAP 1.1 HTTP Binding with Attachments")) && this.checkPortType(portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI()))) {
                    String outputAddress = bindingImplementation.loadAddress(port.getExtension());
                    if (portType == null) {
                        throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
                    }
                    lport = this.generateSDI(portType, portbinding, lport);
                    lport = this.stubGenerate(portType, portbinding, outputAddress, bindingImplementation, lport, false);
                    lports.addLogicalPort(lport);
                }
                ++i;
            }
            this.holderGenerator.generateHolders(this.workDir, this.holderPackage, this.holders);
            this.generateExceptions(this.exceptionMessages);
            this.generateServiceInterfaces(lports, this.generateGetPorts);
            File lpFile = this.getLPFile();
            this.files.add(lpFile);
            this.generateServiceImpl(lports, this.getLPath(), false);
            this.lpFactory.saveLogicalPorts(lports, lpFile);
            File outputDir = this.workDir;
            if (this.packageName != null && this.packageName.length() != 0) {
                outputDir = new File(this.workDir, this.nameConvertor.packageToPath(this.packageName));
            }
            File outputFile = new File(outputDir, this.protocolsFile);
            this.files.add(outputFile);
            Properties implementations = DefaultProviders.getProtocolImplementations();
            FileOutputStream outputFileStream = new FileOutputStream(outputFile);
            implementations.store(outputFileStream, "Default Protocol implementations");
            ((OutputStream)outputFileStream).close();
        } else {
            ArrayList bindings = this.definitions.getBindings();
            if (bindings.size() != 0) {
                LogicalPorts lports = new LogicalPorts();
                if (this.customServiceName != null) {
                    lports.setName(this.customServiceName);
                } else {
                    lports.setName(this.definitions.getName());
                    if (lports.getName() == null) {
                        lports.setName(this.defaultServiceName);
                    }
                }
                int i = 0;
                while (i < bindings.size()) {
                    WSDLBinding portbinding = (WSDLBinding)bindings.get(i);
                    LogicalPortType lport = new LogicalPortType();
                    lport.setName(portbinding.getName());
                    lport.setBindingName(portbinding.getName());
                    ClientTransportBinding bindingImplementation = this.getBindingImplementation(portbinding);
                    if (!this.genericMode || bindingImplementation.getName().equals("SOAP 1.1 HTTP Binding with Attachments")) {
                        if (bindingImplementation == null) {
                            throw new Exception(" No available binding can recognize this binding : " + portbinding.getName());
                        }
                        WSDLPortType portType = this.definitions.getPortType(portbinding.getType().getName(), portbinding.getType().getURI());
                        if (this.checkPortType(portType)) {
                            if (portType == null) {
                                throw new Exception("PortType with name " + portbinding.getType().getName() + " not found !");
                            }
                            lport = this.generateSDI(portType, portbinding, lport);
                            lport = this.stubGenerate(portType, portbinding, null, bindingImplementation, lport, false);
                            lports.addLogicalPort(lport);
                        }
                    }
                    ++i;
                }
                this.holderGenerator.generateHolders(this.workDir, this.holderPackage, this.holders);
                this.generateExceptions(this.exceptionMessages);
                this.generateServiceInterfaces(lports, false);
                File lpFile = this.getLPFile();
                this.files.add(lpFile);
                this.generateServiceImpl(lports, this.getLPath(), false);
                this.lpFactory.saveLogicalPorts(lports, lpFile);
                File outputDir = this.workDir;
                if (this.packageName != null && this.packageName.length() != 0) {
                    outputDir = new File(this.workDir, this.nameConvertor.packageToPath(this.packageName));
                }
                File outputFile = new File(outputDir, this.protocolsFile);
                this.files.add(outputFile);
                Properties implementations = DefaultProviders.getProtocolImplementations();
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                implementations.store(outputFileStream, "Default Protocol implementations");
                ((OutputStream)outputFileStream).close();
            } else {
                if (this.genericMode) {
                    throw new Exception("WSDL does not contain enough information to load WS Client.");
                }
                System.out.println(" Warning : No binding found - switching to portType mapping mode !");
                LogicalPorts lports = new LogicalPorts();
                if (this.customServiceName != null) {
                    lports.setName(this.customServiceName);
                } else {
                    lports.setName(this.definitions.getName());
                    if (lports.getName() == null) {
                        lports.setName(this.defaultServiceName);
                    }
                }
                ArrayList portTypes = this.definitions.getPortTypes();
                if (portTypes.size() == 0) {
                    throw new Exception(" No PortTypes found. This WSDL is completly unusable !");
                }
                LogicalPortType perm = null;
                int i = 0;
                while (i < portTypes.size()) {
                    WSDLPortType portType = (WSDLPortType)portTypes.get(i);
                    perm = this.generateSDI(portType, null, null);
                    ++i;
                }
                this.holderGenerator.generateHolders(this.workDir, this.holderPackage, this.holders);
                this.generateExceptions(this.exceptionMessages);
                lports.addLogicalPort(perm);
                this.generateServiceInterfaces(lports, false);
                lports.setLogicalPort(new LogicalPortType[0]);
                File lpFile = this.getLPFile();
                this.files.add(lpFile);
                this.lpFactory.saveLogicalPorts(lports, lpFile);
            }
        }
    }

    private ClientTransportBinding getBindingImplementation(WSDLBinding binding) {
        int i = 0;
        while (i < this.bindings.length) {
            if (this.bindings[i].recognizeBinding(binding)) {
                return this.bindings[i];
            }
            ++i;
        }
        return null;
    }

    public LogicalPortType generateSDI(WSDLPortType portType, WSDLBinding binding, LogicalPortType logicalPort) throws Exception {
        if (logicalPort == null) {
            logicalPort = new LogicalPortType();
        }
        this.fillLogicalPortTemplate(logicalPort, portType);
        logicalPort.setPTName("{" + portType.getQName().getURI() + "}" + portType.getQName().getLocalName());
        javax.xml.namespace.QName portName = new javax.xml.namespace.QName(portType.getNamespace(), portType.getName());
        String interfaceName = this.portManager.getNewJavaName(portName, this.packageName);
        logicalPort.setInterfaceName(this.portManager.getJavaQName(portName));
        if (this.portManager.isQNameUsed(portName)) {
            return logicalPort;
        }
        this.portManager.useQName(portName);
        if (this.genericMode) {
            logicalPort.setInterfaceName((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ClassGenerator.class$("java.rmi.Remote")) : class$java$rmi$Remote).getName());
            return logicalPort;
        }
        File outFile = new File(this.packageDir, interfaceName + ".java");
        try {
            outFile.createNewFile();
        }
        catch (Exception e) {
            throw new Exception(" Output file " + interfaceName + ".java could not be created !");
        }
        this.files.add(outFile);
        this.seiGenerated.add(outFile);
        CodeGenerator generator = new CodeGenerator();
        this.writePackage(this.packageName, generator);
        generator.addLine();
        generator.addLine("/**");
        generator.addLine(" * Service Endpoint Interface (generated by SAP WSDL to Java generator).");
        generator.addLine(" */");
        generator.addNewLine();
        generator.addLine("public interface " + interfaceName + " extends java.rmi.Remote,javax.xml.rpc.Stub {");
        generator.addNewLine();
        generator.startSection();
        ArrayList operations = portType.getOperations();
        int i = 0;
        while (i < operations.size()) {
            String methodName;
            WSDLOperation operation = (WSDLOperation)operations.get(i);
            WSDLDocumentation doc = operation.getDocumentation();
            if (doc != null && doc.getContent() != null && doc.getContent().length() != 0) {
                generator.addLine("/**");
                generator.addLine(" * " + doc.getContent());
                generator.addLine(" */");
            }
            if (operation.getInput() == null) {
                methodName = this.nameConvertor.attributeToMethodName(operation.getName());
                if (operation.getOutput() != null) {
                    generator.addComment(" " + methodName + " is a notification operation and is unsupported.");
                } else {
                    generator.addLine("public void " + methodName + "();");
                }
            } else {
                this.markParams(operation);
                if (!this.alternativeMethods || !this.isDocumentStyle(operation)) {
                    methodName = this.nameConvertor.attributeToMethodName(operation.getName());
                    this.generateOperationHeader(generator, methodName, operation);
                    generator.add(";");
                    generator.addNewLine();
                } else {
                    this.processAlternativeOperation(generator, operation, false);
                }
            }
            ++i;
        }
        generator.addNewLine();
        generator.endSection();
        generator.addLine("}");
        PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
        output.write(generator.toString());
        output.close();
        return logicalPort;
    }

    public void generateOperationHeader(CodeGenerator generator, String methodName, WSDLOperation operation) throws Exception {
        StringBuffer returnParams = new StringBuffer();
        generator.unRegisterName("returnType");
        generator.unRegisterName("returnName");
        generator.addIndent();
        generator.add("public ");
        WSDLChannel input = operation.getInput();
        WSDLChannel output = operation.getOutput();
        this.nameConvertor.disableCustomReserved();
        this.nameConvertor.clearCustomReserved();
        if (output != null) {
            QName messagelink = output.getMessage();
            WSDLMessage message = this.getMessage(messagelink, operation.getName());
            ArrayList parts = message.getParts();
            if (parts.size() == 1 && !((WSDLPart)parts.get((int)0)).inout) {
                WSDLPart part = (WSDLPart)parts.get(0);
                TypeDefinitionBase type = this.getPartType(part);
                String paramType = this.schema.getJavaPrimitive(type);
                generator.add(paramType + " ");
                generator.registerName("returnType", paramType);
                generator.registerName("returnName", this.nameConvertor.attributeToIdentifier(part.getName()));
            } else {
                generator.add("void ");
                int i = 0;
                while (i < parts.size()) {
                    WSDLPart part = (WSDLPart)parts.get(i);
                    if (!part.inout) {
                        TypeDefinitionBase type = this.getPartType(part);
                        String paramType = this.getHolder(type);
                        if (returnParams.length() != 0) {
                            returnParams.append(", ");
                        }
                        returnParams.append(paramType + " " + this.nameConvertor.attributeToIdentifier(part.getName()));
                        this.nameConvertor.addCustomReserved(this.nameConvertor.attributeToIdentifier(part.getName()));
                    }
                    ++i;
                }
            }
        } else {
            generator.add("void ");
        }
        generator.add(methodName + "(");
        boolean hasInputParams = false;
        if (input != null) {
            QName messagelink = input.getMessage();
            WSDLMessage message = this.getMessage(messagelink, operation.getName());
            ArrayList parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                WSDLPart part = (WSDLPart)parts.get(i);
                TypeDefinitionBase type = this.getPartType(part);
                String paramType = part.inout ? this.getHolder(type) : this.schema.getJavaPrimitive(type);
                if (i != 0) {
                    generator.add(", ");
                }
                generator.add(paramType + " " + this.nameConvertor.attributeToIdentifier(part.getName()));
                this.nameConvertor.addCustomReserved(this.nameConvertor.attributeToIdentifier(part.getName()));
                hasInputParams = true;
                ++i;
            }
        }
        if (returnParams.length() != 0) {
            if (hasInputParams) {
                generator.add(", " + returnParams.toString());
            } else {
                generator.add(returnParams.toString());
            }
        }
        generator.add(")");
        generator.add(" throws java.rmi.RemoteException");
        ArrayList faults = operation.getFaultList();
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            QName messageName = fault.getMessage();
            WSDLMessage message = this.definitions.getMessage(messageName.getLocalName(), messageName.getURI());
            if (message == null) {
                throw new Exception(" Unable to find message named " + messageName + " linked to wsdl:fault " + fault.getName());
            }
            this.addExceptionMessage(message);
            generator.add(",");
            generator.add(this.getExceptionClassName(message, true));
            ++i;
        }
    }

    private void addExceptionMessage(WSDLMessage message) throws Exception {
        WSDLPart part;
        TypeDefinitionBase type;
        int i = 0;
        while (i < this.exceptionMessages.size()) {
            WSDLMessage cmessage = (WSDLMessage)this.exceptionMessages.get(i);
            if (message == cmessage) {
                return;
            }
            ++i;
        }
        ArrayList messageParts = message.getParts();
        if (messageParts.size() == 1 && !this.schema.isSimple(type = this.getPartType(part = (WSDLPart)messageParts.get(0))) && !this.schema.isSoapArray(type)) {
            int i2 = 0;
            while (i2 < this.exceptionMessages.size()) {
                WSDLPart cpart;
                TypeDefinitionBase ctype;
                WSDLMessage cmessage = (WSDLMessage)this.exceptionMessages.get(i2);
                if (cmessage.getPartCount() == 1 && (ctype = this.getPartType(cpart = cmessage.getPart(0))) == type) {
                    return;
                }
                ++i2;
            }
        }
        this.exceptionMessages.add(message);
    }

    private String escapeUri(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                result.append("\\\\");
            } else if (s.charAt(i) == '\'') {
                result.append("\\'");
            } else if (s.charAt(i) == '\"') {
                result.append("\\\"");
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    private String escapeString(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '.') {
                result.append("/");
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public void generateOperationInit(WSDLPortType portType, CodeGenerator generator) {
        int i = 0;
        while (i < portType.getOperationCount()) {
            WSDLOperation operation = portType.getOperation(i);
            generator.addLine("  this.localProtocols.put(\"" + operation.getName() + "\",new com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProtocolList());");
            generator.addLine("  this.localFeatures.put(\"" + operation.getName() + "\",new PropertyContext());");
            ++i;
        }
    }

    public LogicalPortType stubGenerate(WSDLPortType portType, WSDLBinding wsdlbinding, String endpoint, ClientTransportBinding tbinding, LogicalPortType lport, boolean server) throws Exception {
        if (lport == null) {
            lport = new LogicalPortType();
        }
        javax.xml.namespace.QName bindingName = new javax.xml.namespace.QName(wsdlbinding.getNamespace(), wsdlbinding.getName() + "_Stub");
        String className = this.stubManager.getNewJavaName(bindingName, this.packageName);
        lport.setBindingImplementation(tbinding.getName());
        if (server) {
            LocalFeatures localFeatures;
            if (endpoint != null && lport.getEndpoint() == null) {
                lport.setEndpoint(endpoint);
            }
            if (this.stubManager.getJavaQName(bindingName) != null && lport.getStubName() == null) {
                lport.setStubName(this.stubManager.getJavaQName(bindingName));
            }
            if (lport.getName() == null) {
                lport.setName(wsdlbinding.getName());
            }
            if ((localFeatures = lport.getLocalFeatures()) == null) {
                localFeatures = new LocalFeatures();
                lport.setLocalFeatures(localFeatures);
            }
            ArrayList operations = wsdlbinding.getOperations();
            int i = 0;
            while (i < operations.size()) {
                WSDLBindingOperation operation = (WSDLBindingOperation)operations.get(i);
                OperationType loperation = localFeatures.getOperation(operation.getName());
                if (loperation == null) {
                    loperation = new OperationType();
                    loperation.setName(operation.getName());
                    localFeatures.addOperation(loperation);
                }
                ++i;
            }
            GlobalFeatures globalFeatures = null;
            if (lport.hasGlobalFeatures()) {
                globalFeatures = lport.getGlobalFeatures();
            }
            if (globalFeatures == null) {
                globalFeatures = new GlobalFeatures();
            }
            tbinding.importGlobalFeatures(globalFeatures, wsdlbinding);
        } else {
            this.fillLogicalPort(this.stubManager.getJavaQName(bindingName), endpoint, wsdlbinding, lport, tbinding);
        }
        String interfaceName = this.portManager.getNewJavaQName(new javax.xml.namespace.QName(portType.getNamespace(), portType.getName()), this.packageName);
        if (lport.hasInterfaceName()) {
            interfaceName = lport.getInterfaceName();
        }
        if (this.genericMode) {
            interfaceName = (class$javax$xml$rpc$Stub == null ? (class$javax$xml$rpc$Stub = ClassGenerator.class$("javax.xml.rpc.Stub")) : class$javax$xml$rpc$Stub).getName();
        }
        if (this.stubManager.isQNameUsed(bindingName)) {
            return lport;
        }
        this.portManager.useQName(bindingName);
        File outFile = new File(this.packageDir, className + ".java");
        outFile.createNewFile();
        this.files.add(outFile);
        this.seiGenerated.add(outFile);
        CodeGenerator codeGenerator = new CodeGenerator();
        this.writePackage(this.packageName, codeGenerator);
        codeGenerator.addNewLine();
        this.generateImports(codeGenerator);
        codeGenerator.addNewLine();
        if (this.genericMode) {
            codeGenerator.addLine("public class " + className + " extends com.sap.engine.services.webservices.jaxrpc.wsdl2java.BaseGeneratedStub implements " + interfaceName + "," + (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$DynamicInterface == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$DynamicInterface = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.dynamic.DynamicInterface")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$DynamicInterface).getName() + " {");
        } else {
            codeGenerator.addLine("public class " + className + " extends com.sap.engine.services.webservices.jaxrpc.wsdl2java.BaseGeneratedStub implements " + interfaceName + " {");
        }
        codeGenerator.addNewLine();
        codeGenerator.startSection();
        this.generateVariables(codeGenerator, tbinding);
        codeGenerator.addNewLine();
        codeGenerator.addLine("public " + className + "() {");
        codeGenerator.addLine("  super();");
        if (endpoint != null) {
            codeGenerator.addLine("  super._setEndpoint(\"" + this.escapeUri(endpoint) + "\");");
        }
        if (!server) {
            codeGenerator.addLine("  this.transportBinding = new " + tbinding.getClass().getName() + "();");
        }
        this.generateOperationInit(portType, codeGenerator);
        codeGenerator.addLine("}");
        codeGenerator.addNewLine();
        codeGenerator.addLine("public void _setTransportBinding(com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding binding) {");
        codeGenerator.addLine("  super._setTransportBinding(binding);");
        codeGenerator.addLine("  if (this.transportBinding.getTypeMappingRegistry() == null && this.typeRegistry != null) {");
        codeGenerator.addLine("    this.transportBinding.setTypeMappingRegistry(this.typeRegistry);");
        codeGenerator.addLine("  }");
        codeGenerator.addLine("  if (this.typeRegistry == null && this.transportBinding.getTypeMappingRegistry() != null) {");
        codeGenerator.addLine("    this.typeRegistry = (com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl) this.transportBinding.getTypeMappingRegistry();");
        codeGenerator.addLine("  }");
        codeGenerator.addLine("}");
        codeGenerator.addNewLine();
        codeGenerator.addLine("public void _setTypeRegistry(" + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + " _registry) {");
        codeGenerator.addLine("  this.typeRegistry =  _registry;");
        codeGenerator.addLine("  if (this.transportBinding != null && this.typeRegistry != null) {");
        codeGenerator.addLine("    this.transportBinding.setTypeMappingRegistry(this.typeRegistry);");
        codeGenerator.addLine("  }");
        codeGenerator.addLine("  this.featureConfiguration.setProperty(\"typeMapping\",this.typeRegistry.getDefaultTypeMapping());");
        codeGenerator.addLine("}");
        codeGenerator.addNewLine();
        ArrayList operations = portType.getOperations();
        int i = 0;
        while (i < operations.size()) {
            WSDLOperation currentOperation = (WSDLOperation)operations.get(i);
            WSDLDocumentation doc = currentOperation.getDocumentation();
            if (doc != null && doc.getContent() != null && doc.getContent().length() != 0) {
                codeGenerator.addLine("/**");
                codeGenerator.addLine(" * " + doc.getContent());
                codeGenerator.addLine(" */");
            }
            if (currentOperation.getInput() == null) {
                String methodName = this.nameConvertor.attributeToMethodName(currentOperation.getName());
                if (currentOperation.getOutput() != null) {
                    codeGenerator.addLine();
                    codeGenerator.addComment(" " + methodName + " is a notification operation and is unsupported.");
                    codeGenerator.addLine();
                } else {
                    codeGenerator.addLine();
                    codeGenerator.addLine("public void " + methodName + "() {");
                    codeGenerator.addLine("}");
                    codeGenerator.addLine();
                }
            } else if (!this.genericMode) {
                this.markParams(currentOperation);
                this.processOperation(codeGenerator, currentOperation, wsdlbinding, tbinding);
                this.processAlternativeOperation(codeGenerator, currentOperation, true);
            }
            ++i;
        }
        codeGenerator.addNewLine();
        if (this.genericMode) {
            codeGenerator.addLine("public " + (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.dynamic.OperationStructure")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure).getName() + " _getOpMetadata(java.lang.String opName) {");
            codeGenerator.startSection();
            int i2 = 0;
            while (i2 < operations.size()) {
                WSDLOperation currentOperation = (WSDLOperation)operations.get(i2);
                if (currentOperation.getInput() != null) {
                    this.provideOpMetadata(codeGenerator, currentOperation, wsdlbinding, tbinding, "opName");
                }
                ++i2;
            }
            codeGenerator.addLine("return null;");
            codeGenerator.endSection();
            codeGenerator.addLine("}");
            codeGenerator.addNewLine();
            codeGenerator.addLine("public java.lang.String[] _getOpNames() {");
            codeGenerator.startSection();
            codeGenerator.addLine("java.lang.String[] result = new java.lang.String[" + operations.size() + "];");
            int i3 = 0;
            while (i3 < operations.size()) {
                WSDLOperation currentOperation = (WSDLOperation)operations.get(i3);
                codeGenerator.addLine("result[" + i3 + "] = \"" + this.escapeString(currentOperation.getName()) + "\";");
                ++i3;
            }
            codeGenerator.addLine("return result;");
            codeGenerator.endSection();
            codeGenerator.addLine("}");
            codeGenerator.addNewLine();
            codeGenerator.addLine("public void _invoke(" + (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.dynamic.OperationStructure")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure).getName() + " opStruct," + (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$ObjectFactory == null ? (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$ObjectFactory = ClassGenerator.class$("com.sap.engine.services.webservices.espbase.client.dynamic.content.ObjectFactory")) : class$com$sap$engine$services$webservices$espbase$client$dynamic$content$ObjectFactory).getName() + " objectFactory ) throws " + (class$java$lang$reflect$InvocationTargetException == null ? (class$java$lang$reflect$InvocationTargetException = ClassGenerator.class$("java.lang.reflect.InvocationTargetException")) : class$java$lang$reflect$InvocationTargetException).getName() + "," + (class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = ClassGenerator.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException).getName() + " {");
            codeGenerator.startSection();
            codeGenerator.addLine("try {");
            codeGenerator.startSection();
            codeGenerator.addComment(" Operation input initialization");
            codeGenerator.addLine("this.inputParams = opStruct.inputParams;");
            codeGenerator.addComment(" Operation output params initialization");
            codeGenerator.addLine("this.outputParams = opStruct.outputParams;");
            codeGenerator.addComment(" Operation faults initialization");
            codeGenerator.addLine("this.faultParams = opStruct.faultParams;");
            codeGenerator.addLine("this.transportBinding.setTypeMappingRegistry(this.typeRegistry);");
            codeGenerator.addLine("this.transportBinding.startOperation(this.inputParams,this.outputParams,this.faultParams);");
            codeGenerator.addComment(" Binding Context initialization");
            codeGenerator.addLine("this.bindingConfiguration = opStruct.bindingConfig;");
            codeGenerator.addLine("super._fillEndpoint(bindingConfiguration);");
            codeGenerator.addLine("_buildOperationContext(opStruct.operationName,this.transportBinding);");
            codeGenerator.addLine("this.stubConfiguration.setProperty(OBJECT_FACTORY,objectFactory);");
            codeGenerator.addLine("this.transportBinding.call(this.stubConfiguration,this.globalProtocols,_getOperationProtocols(opStruct.operationName));");
            codeGenerator.addLine("_setEndpoint((String) bindingConfiguration.getProperty(com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding.ENDPOINT));");
            codeGenerator.endSection();
            codeGenerator.addLine("} catch (" + (class$javax$xml$rpc$soap$SOAPFaultException == null ? (class$javax$xml$rpc$soap$SOAPFaultException = ClassGenerator.class$("javax.xml.rpc.soap.SOAPFaultException")) : class$javax$xml$rpc$soap$SOAPFaultException).getName() + " x) {");
            codeGenerator.addLine("  throw new " + (class$java$lang$reflect$InvocationTargetException == null ? (class$java$lang$reflect$InvocationTargetException = ClassGenerator.class$("java.lang.reflect.InvocationTargetException")) : class$java$lang$reflect$InvocationTargetException).getName() + "(x,x.getFaultString());");
            codeGenerator.addLine("} catch (" + (class$java$lang$reflect$InvocationTargetException == null ? (class$java$lang$reflect$InvocationTargetException = ClassGenerator.class$("java.lang.reflect.InvocationTargetException")) : class$java$lang$reflect$InvocationTargetException).getName() + " x) {");
            codeGenerator.addLine("  throw x;");
            codeGenerator.addLine("} catch (" + (class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = ClassGenerator.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException).getName() + " x) {");
            codeGenerator.addLine("  throw x;");
            codeGenerator.addLine("} catch (" + (class$java$lang$Exception == null ? (class$java$lang$Exception = ClassGenerator.class$("java.lang.Exception")) : class$java$lang$Exception).getName() + " e) {");
            codeGenerator.addLine("  throw new " + (class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = ClassGenerator.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException).getName() + "(e.getMessage(),e);");
            codeGenerator.addLine("}");
            codeGenerator.endSection();
            codeGenerator.addLine("}");
            codeGenerator.addNewLine();
        }
        codeGenerator.endSection();
        codeGenerator.addLine("}");
        PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
        output.print(codeGenerator.toString());
        output.close();
        className = this.packageName + "." + className;
        return lport;
    }

    public WSDLMessage getMessage(QName messageLink, String operationName) throws ProxyGeneratorException {
        WSDLMessage message = this.definitions.getMessage(messageLink.getLocalName(), messageLink.getURI());
        if (message == null) {
            throw new ProxyGeneratorException("webservices_3208", messageLink.toString(), operationName);
        }
        return message;
    }

    public TypeDefinitionBase getPartType(WSDLPart part) throws Exception {
        TypeDefinitionBase type;
        QName typeLink = part.getType();
        String linkType = "type";
        if (part.getStyle() == 2) {
            linkType = "type";
            type = this.schema.getType(typeLink.getURI(), typeLink.getLocalName());
        } else {
            linkType = "element";
            type = this.schema.getElementType(typeLink.getURI(), typeLink.getLocalName());
        }
        if (type == null) {
            throw new Exception(" WSDL part <" + part.getName() + "> points to unavailable " + linkType + " with qname: " + "{" + typeLink.getURI() + "}<" + typeLink.getLocalName() + ">");
        }
        return type;
    }

    public String getHolder(TypeDefinitionBase type) throws Exception {
        String paramType = this.schema.getJavaPrimitive(type);
        if (this.schema.isSoapArray(type)) {
            paramType = this.nameConvertor.attributeToClassName(type.getName()) + "Holder";
            this.addHolder(paramType, this.schema.getJavaPrimitive(type));
            paramType = this.holderPackage + "." + paramType;
        } else if (this.schema.isSimple(type)) {
            paramType = this.nameConvertor.primitiveToHolder(paramType);
        } else if (type instanceof ComplexTypeDefinition && this.schema.isDocumentArray((ComplexTypeDefinition)type)) {
            paramType = this.nameConvertor.complexToHolder(paramType);
            this.addHolder(paramType, this.schema.getJavaPrimitive(type));
            paramType = this.holderPackage + "." + paramType;
        } else {
            paramType = this.nameConvertor.complexToHolder(paramType);
            this.addHolder(paramType, this.schema.getJavaPrimitive(type));
            paramType = this.holderPackage + "." + paramType;
        }
        return paramType;
    }

    public void addHolder(String holderName, String holderType) {
        int i = 0;
        while (i < this.holders.size()) {
            HolderInfo holderInfo = (HolderInfo)this.holders.get(i);
            if (holderInfo.getName().equals(holderName)) {
                return;
            }
            ++i;
        }
        this.holders.add(new HolderInfo(holderName, holderType));
    }

    private void generateImports(CodeGenerator generator) {
        generator.addComment("Import libraries");
        generator.addLine("import javax.xml.rpc.holders.*;");
        generator.addLine("import java.rmi.RemoteException;");
        generator.addLine("import javax.xml.rpc.encoding.*;");
        generator.addLine("import javax.xml.namespace.QName;");
        generator.addLine("import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;");
        generator.addLine("import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;");
        generator.addLine("import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;");
        generator.addLine("import com.sap.engine.services.webservices.jaxrpc.exceptions.accessors.XmlSerializationResourceAccessor;");
        generator.addLine("import com.sap.exception.BaseRuntimeException;");
    }

    private void generateVariables(CodeGenerator generator, ClientTransportBinding binding) {
        generator.addComment("Proxy variables");
        if (!this.containerMode) {
            generator.addLine("private " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + " typeRegistry;");
        }
        binding.addVariables(generator);
    }

    private void inputPartsParse(ArrayList parts, CodeGenerator generator, String strName) throws Exception {
        generator.addComment("Operation input params initialization");
        generator.addLine(strName + ".inputParams = new ServiceParam[" + parts.size() + "];");
        int i = 0;
        while (i < parts.size()) {
            generator.addLine(strName + ".inputParams[" + i + "] = new ServiceParam();");
            WSDLPart part = (WSDLPart)parts.get(i);
            TypeDefinitionBase type = this.getPartType(part);
            if (part.getStyle() == 1) {
                generator.addLine(strName + ".inputParams[" + i + "].isElement = true;");
            }
            String paramName = this.nameConvertor.attributeToIdentifier(part.getName());
            String paramType = this.schema.getJavaPrimitive(type);
            String typeUri = part.getType().getURI();
            String typeName = part.getType().getLocalName();
            generator.addLine(strName + ".inputParams[" + i + "].schemaName = new QName(\"" + typeUri + "\",\"" + typeName + "\");");
            generator.addLine(strName + ".inputParams[" + i + "].name = \"" + part.getName() + "\";");
            generator.addLine(strName + ".inputParams[" + i + "].contentClass = " + paramType + ".class;");
            if ("this".equals(strName)) {
                if (part.inout) {
                    paramName = paramName + ".value";
                }
                if (this.nameConvertor.isPrimitive(paramType)) {
                    generator.addLine("this.inputParams[" + i + "].content = new " + this.nameConvertor.wrap(paramType) + "(" + paramName + ");");
                } else {
                    generator.addLine("this.inputParams[" + i + "].content = " + paramName + ";");
                }
            }
            ++i;
        }
    }

    private void outputPartsParse(ArrayList parts, CodeGenerator generator, String strName) throws Exception {
        generator.addComment("Operation output params initialization");
        generator.addLine(strName + ".outputParams = new ServiceParam[" + parts.size() + "];");
        int i = 0;
        while (i < parts.size()) {
            generator.addLine(strName + ".outputParams[" + i + "] = new ServiceParam();");
            WSDLPart part = (WSDLPart)parts.get(i);
            TypeDefinitionBase type = this.getPartType(part);
            if (part.getStyle() == 1) {
                generator.addLine(strName + ".outputParams[" + i + "].isElement = true;");
            }
            String paramType = this.schema.getJavaPrimitive(type);
            String typeUri = part.getType().getURI();
            String typeName = part.getType().getLocalName();
            generator.addLine(strName + ".outputParams[" + i + "].schemaName = new QName(\"" + typeUri + "\",\"" + typeName + "\");");
            generator.addLine(strName + ".outputParams[" + i + "].name = \"" + part.getName() + "\";");
            generator.addLine(strName + ".outputParams[" + i + "].contentClass = " + paramType + ".class;");
            ++i;
        }
    }

    private void faultPartsParse(ArrayList faults, CodeGenerator generator, String strName) throws Exception {
        generator.addComment("Operation faults initialization");
        generator.addLine(strName + ".faultParams = new ServiceParam[" + faults.size() + "];");
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            QName messageLink = fault.getMessage();
            WSDLMessage message = this.definitions.getMessage(messageLink);
            ArrayList parts = this.getMessageParts(messageLink.getLocalName(), messageLink.getURI());
            WSDLPart part = (WSDLPart)parts.get(0);
            generator.addLine(strName + ".faultParams[" + i + "] = new ServiceParam();");
            if (part.getStyle() == 1) {
                generator.addLine(strName + ".faultParams[" + i + "].isElement = true;");
            }
            String paramType = this.getExceptionClassName(message, true);
            if (this.genericMode) {
                paramType = (class$java$lang$reflect$InvocationTargetException == null ? ClassGenerator.class$("java.lang.reflect.InvocationTargetException") : class$java$lang$reflect$InvocationTargetException).getName();
            }
            String typeUri = part.getType().getURI();
            String typeName = part.getType().getLocalName();
            generator.addLine(strName + ".faultParams[" + i + "].schemaName = new QName(\"" + typeUri + "\",\"" + typeName + "\");");
            generator.addLine(strName + ".faultParams[" + i + "].name = \"" + part.getName() + "\";");
            generator.addLine(strName + ".faultParams[" + i + "].contentClass = " + paramType + ".class;");
            ++i;
        }
    }

    private void generateCustomExceptionThrow(ArrayList faults, CodeGenerator generator) throws Exception {
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            QName messageLink = fault.getMessage();
            WSDLMessage message = this.definitions.getMessage(messageLink.getLocalName(), messageLink.getURI());
            String paramType = this.getExceptionClassName(message, true);
            generator.addLine("if (this.faultParams[" + i + "].content != null) {");
            generator.addLine("  throw (" + paramType + ") this.faultParams[" + i + "].content;");
            generator.addLine("}");
            ++i;
        }
    }

    private void generateCustomExceptionCatch(ArrayList faults, CodeGenerator generator, String exceptionName) throws Exception {
        int i = 0;
        while (i < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i);
            QName messageLink = fault.getMessage();
            WSDLMessage message = this.definitions.getMessage(messageLink.getLocalName(), messageLink.getURI());
            String paramType = this.getExceptionClassName(message, true);
            generator.addLine("} catch (" + paramType + " " + exceptionName + ") {");
            generator.addLine("  throw " + exceptionName + ";");
            ++i;
        }
    }

    private ArrayList getMessageParts(String messageName, String messageNamespace) throws Exception {
        WSDLMessage message = this.definitions.getMessage(messageName, messageNamespace);
        if (message == null) {
            throw new Exception("Message '" + messageName + "' not found in WSDL !");
        }
        return message.getParts();
    }

    private boolean isDocumentStyle(WSDLOperation operation) throws Exception {
        WSDLChannel input = operation.getInput();
        WSDLChannel output = operation.getOutput();
        if (input == null || output == null) {
            return false;
        }
        WSDLMessage inputMessage = this.getMessage(input.getMessage(), operation.getName());
        WSDLMessage outputMessage = this.getMessage(output.getMessage(), operation.getName());
        if (inputMessage.getPartCount() != 1 || outputMessage.getPartCount() != 1) {
            return false;
        }
        WSDLPart ipart = inputMessage.getPart(0);
        WSDLPart opart = outputMessage.getPart(0);
        if (ipart.getStyle() == 2 || opart.getStyle() == 2) {
            return false;
        }
        TypeDefinitionBase itype = this.getPartType(ipart);
        TypeDefinitionBase otype = this.getPartType(opart);
        if (this.schema.isSimple(itype) || this.schema.isSimple(otype)) {
            return false;
        }
        if (this.schema.isDocumentArray((ComplexTypeDefinition)itype)) {
            return false;
        }
        if (this.schema.isDocumentArray((ComplexTypeDefinition)otype)) {
            return false;
        }
        int ikind = this.schema.getComplexTypeKind((ComplexTypeDefinition)itype);
        int okind = this.schema.getComplexTypeKind((ComplexTypeDefinition)otype);
        if (!(ikind != 4 && ikind != 3 || okind != 4 && okind != 3)) {
            FieldInfo info;
            ArrayList inElements = this.schema.getComplexFieldInfo((ComplexTypeDefinition)itype);
            ArrayList outElements = this.schema.getComplexFieldInfo((ComplexTypeDefinition)otype);
            ArrayList outAttribs = this.schema.getComplexAttributeInfo((ComplexTypeDefinition)otype);
            ArrayList inAttribs = this.schema.getComplexAttributeInfo((ComplexTypeDefinition)itype);
            if (inAttribs.size() != 0) {
                return false;
            }
            if (outAttribs.size() != 0 || outElements.size() > 1) {
                return false;
            }
            int i = 0;
            while (i < inElements.size()) {
                info = (FieldInfo)inElements.get(i);
                if (info.getFieldModel() != 1) {
                    return false;
                }
                if (inElements.size() == 1 && itype.getName().equals(info.getTypeLocalName())) {
                    if (itype.getTargetNamespace() != null && itype.getTargetNamespace().equals(info.getTypeUri())) {
                        return false;
                    }
                    if (itype.getTargetNamespace() == info.getTypeUri()) {
                        return false;
                    }
                }
                ++i;
            }
            return outElements.size() == 0 || (info = (FieldInfo)outElements.get(0)).getFieldModel() == 1;
        }
        return false;
    }

    private void processAlternativeOperation(CodeGenerator generator, WSDLOperation operation, boolean generateBody) throws Exception {
        if (!this.isDocumentStyle(operation)) {
            return;
        }
        QName messageInName = operation.getInput().getMessage();
        QName messageOutName = operation.getOutput().getMessage();
        String methodName = this.nameConvertor.attributeToMethodName(operation.getName());
        WSDLMessage inMessage = this.definitions.getMessage(messageInName.getLocalName(), messageInName.getURI());
        WSDLMessage outMessage = this.definitions.getMessage(messageOutName.getLocalName(), messageOutName.getURI());
        WSDLPart inpart = inMessage.getPart(0);
        WSDLPart outpart = outMessage.getPart(0);
        QName inType = inpart.getType();
        QName outType = outpart.getType();
        ComplexTypeDefinition inTypeDefinition = (ComplexTypeDefinition)this.schema.getElementType(inType.getURI(), inType.getLocalName());
        ComplexTypeDefinition outTypeDefinition = (ComplexTypeDefinition)this.schema.getElementType(outType.getURI(), outType.getLocalName());
        String inTypeName = inTypeDefinition.getName();
        if (inTypeName == null) {
            inTypeName = DOM.toXPath((Node)inTypeDefinition.getAssociatedDOMNode());
        }
        String inTypeNamespace = inTypeDefinition.getTargetNamespace();
        ArrayList inFields = this.schema.getComplexFieldInfo(inTypeDefinition);
        ArrayList outFields = this.schema.getComplexFieldInfo(outTypeDefinition);
        generator.addIndent();
        generator.add("public ");
        String requestVariable = "_request_variable";
        String resultVariable = "_result_variable";
        String returnString = "";
        String javaPrimitive = this.schema.getJavaPrimitive((TypeDefinitionBase)inTypeDefinition);
        String requestString = javaPrimitive + " " + requestVariable + " = new " + javaPrimitive + "();";
        if (this.genericMode && (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject == null ? (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject = ClassGenerator.class$("com.sap.engine.services.webservices.espbase.client.dynamic.content.GenericObject")) : class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject).getName().equals(javaPrimitive)) {
            requestString = javaPrimitive + " " + requestVariable + " = new " + (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$impl$GenericObjectImpl == null ? (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$impl$GenericObjectImpl = ClassGenerator.class$("com.sap.engine.services.webservices.espbase.client.dynamic.content.impl.GenericObjectImpl")) : class$com$sap$engine$services$webservices$espbase$client$dynamic$content$impl$GenericObjectImpl).getName() + "(\"" + this.escapeString(inTypeNamespace) + "\",\"" + this.escapeString(inTypeName) + "\");";
        }
        if (outFields.size() != 0) {
            FieldInfo info = (FieldInfo)outFields.get(0);
            String type = info.getTypeJavaName();
            if (info.getMaxOccurs() != 1) {
                type = type + "[]";
            }
            generator.add(type);
            returnString = this.genericMode ? (this.nameConvertor.isPrimitive(type) ? "return ((" + this.nameConvertor.wrap(type) + ") " + resultVariable + "._getField(\"" + this.escapeString(info.fieldLocalName) + "\"))." + type + "Value();" : "return (" + type + ") " + resultVariable + "._getField(\"" + this.escapeString(info.fieldLocalName) + "\");") : "return " + resultVariable + "." + info.getGetterMethod() + "();";
        } else {
            generator.add("void");
        }
        generator.add(" " + methodName + "(");
        boolean flag = false;
        int i = 0;
        while (i < inFields.size()) {
            if (flag) {
                generator.add(", ");
            }
            FieldInfo info = (FieldInfo)inFields.get(i);
            String type = info.getTypeJavaName();
            if (info.getMaxOccurs() != 1) {
                type = type + "[]";
            }
            generator.add(type + " " + this.nameConvertor.attributeToIdentifier(info.getFieldLocalName()));
            flag = true;
            ++i;
        }
        generator.add(") ");
        generator.add(" throws java.rmi.RemoteException");
        ArrayList faults = operation.getFaultList();
        int i2 = 0;
        while (i2 < faults.size()) {
            WSDLFault fault = (WSDLFault)faults.get(i2);
            QName messageName = fault.getMessage();
            WSDLMessage message = this.definitions.getMessage(messageName.getLocalName(), messageName.getURI());
            if (message == null) {
                throw new Exception(" Unable to find message named " + messageName + " linked to wsdl:fault " + fault.getName());
            }
            this.addExceptionMessage(message);
            generator.add(",");
            generator.add(this.getExceptionClassName(message, true));
            ++i2;
        }
        if (!generateBody) {
            generator.add(";");
            generator.addNewLine();
            return;
        }
        generator.add(" {");
        generator.addNewLine();
        generator.startSection();
        generator.addLine(requestString);
        int i3 = 0;
        while (i3 < inFields.size()) {
            FieldInfo info = (FieldInfo)inFields.get(i3);
            String type = info.getTypeJavaName();
            if (info.getMaxOccurs() != 1) {
                type = type + "[]";
            }
            if (this.genericMode) {
                if (this.nameConvertor.isPrimitive(type)) {
                    generator.addLine(requestVariable + "._setField(\"" + this.escapeString(info.fieldLocalName) + "\"," + this.nameConvertor.wrap(this.nameConvertor.getValueAsObject(info.getFieldLocalName(), false, type)) + ");");
                } else {
                    generator.addLine(requestVariable + "._setField(\"" + this.escapeString(info.fieldLocalName) + "\"," + this.nameConvertor.attributeToIdentifier(info.getFieldLocalName()) + ");");
                }
            } else {
                generator.addLine(requestVariable + "." + info.getSetterMethod() + "(" + this.nameConvertor.attributeToIdentifier(info.getFieldLocalName()) + ");");
            }
            ++i3;
        }
        generator.addLine(this.schema.getJavaPrimitive((TypeDefinitionBase)outTypeDefinition) + " " + resultVariable + " = " + methodName + "(" + requestVariable + ");");
        generator.addLine(returnString);
        generator.endSection();
        generator.addLine("}");
        generator.addNewLine();
    }

    private void provideOpMetadata(CodeGenerator generator, WSDLOperation operation, WSDLBinding binding, ClientTransportBinding tbinding, String vName) throws Exception {
        WSDLChannel output;
        WSDLBindingOperation bOperation = binding.getOperation(operation.getName());
        PropertyContext context = new PropertyContext();
        tbinding.getMainBindingConfig(binding, context);
        tbinding.getOperationBindingConfig(bOperation, operation, context, this.definitions);
        generator.addLine("if (\"" + this.escapeString(operation.getName()) + "\".equals(" + vName + ")) {");
        generator.startSection();
        generator.addLine((class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.dynamic.OperationStructure")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure).getName() + " result = new " + (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.dynamic.OperationStructure")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$dynamic$OperationStructure).getName() + "();");
        generator.addLine("result.operationName = \"" + this.escapeString(operation.getName()) + "\";");
        WSDLChannel input = operation.getInput();
        if (input != null) {
            QName messagelink = input.getMessage();
            ArrayList parts = this.getMessageParts(messagelink.getLocalName(), messagelink.getURI());
            this.inputPartsParse(parts, generator, "result");
        }
        if ((output = operation.getOutput()) != null) {
            QName messagelink = output.getMessage();
            ArrayList parts = this.getMessageParts(messagelink.getLocalName(), messagelink.getURI());
            this.outputPartsParse(parts, generator, "result");
        }
        ArrayList faults = operation.getFaultList();
        this.faultPartsParse(faults, generator, "result");
        generator.addComment("Binding Context initialization");
        generator.addLine((class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext).getName() + " bindingConfig = new " + (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext == null ? (class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext")) : class$com$sap$engine$services$webservices$jaxrpc$wsdl2java$PropertyContext).getName() + "();");
        generator.addLine("result.bindingConfig = bindingConfig;");
        generator.addLine("bindingConfig.clear();");
        this.operationBindingInitialization("bindingConfig", context, generator, 0, 0);
        generator.addLine("return result;");
        generator.endSection();
        generator.addLine("}");
        generator.addNewLine();
    }

    private void processOperation(CodeGenerator generator, WSDLOperation operation, WSDLBinding binding, ClientTransportBinding tbinding) throws Exception {
        String paramName;
        WSDLChannel output;
        generator.unRegisterName("returnType");
        generator.unRegisterName("returnName");
        WSDLBindingOperation bOperation = binding.getOperation(operation.getName());
        if (bOperation == null) {
            throw new Exception(" Operation '" + operation.getName() + "' not described in binding '" + binding.getName() + "' !");
        }
        PropertyContext context = new PropertyContext();
        tbinding.getMainBindingConfig(binding, context);
        tbinding.getOperationBindingConfig(bOperation, operation, context, this.definitions);
        String methodName = this.nameConvertor.attributeToMethodName(operation.getName());
        this.generateOperationHeader(generator, methodName, operation);
        generator.add(" {");
        generator.addNewLine();
        generator.startSection();
        generator.addLine("try {");
        generator.startSection();
        generator.addLine("super._beginLogFrame();");
        WSDLChannel input = operation.getInput();
        if (input != null) {
            QName messagelink = input.getMessage();
            ArrayList parts = this.getMessageParts(messagelink.getLocalName(), messagelink.getURI());
            this.inputPartsParse(parts, generator, "this");
        }
        if ((output = operation.getOutput()) != null) {
            QName messagelink = output.getMessage();
            ArrayList parts = this.getMessageParts(messagelink.getLocalName(), messagelink.getURI());
            this.outputPartsParse(parts, generator, "this");
        }
        ArrayList faults = operation.getFaultList();
        this.faultPartsParse(faults, generator, "this");
        if (generator.isRegistered("returnType")) {
            this.nameConvertor.enableCustomReserved();
            paramName = this.nameConvertor.attributeToIdentifier(generator.getValue("returnName"));
            generator.registerName("returnName", paramName);
            generator.addLine("$returnType$ " + paramName + ";");
            this.nameConvertor.disableCustomReserved();
        }
        if (!this.containerMode) {
            generator.addLine("this.transportBinding.setTypeMappingRegistry(this.typeRegistry);");
        }
        generator.addLine("this.transportBinding.startOperation(this.inputParams,this.outputParams,this.faultParams);");
        generator.addComment("Binding Context initialization");
        generator.addLine("this.bindingConfiguration.clear();");
        this.operationBindingInitialization("bindingConfiguration", context, generator, 0, 0);
        generator.addLine("super._fillEndpoint(bindingConfiguration);");
        generator.addLine("_buildOperationContext(\"" + operation.getName() + "\",this.transportBinding);");
        generator.addLine("this.transportBinding.call(this.stubConfiguration,this.globalProtocols,_getOperationProtocols(\"" + operation.getName() + "\"));");
        generator.addLine("_setEndpoint((String) bindingConfiguration.getProperty(com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding.ENDPOINT));");
        this.generateCustomExceptionThrow(faults, generator);
        if (output != null) {
            QName messagelink = output.getMessage();
            WSDLMessage message = this.definitions.getMessage(messagelink.getLocalName(), messagelink.getURI());
            if (message == null) {
                throw new Exception("Message '" + messagelink.getLocalName() + "' not found in WSDL");
            }
            ArrayList parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                WSDLPart part = (WSDLPart)parts.get(i);
                TypeDefinitionBase type = this.getPartType(part);
                String paramName2 = null;
                String paramType = this.schema.getJavaPrimitive(type);
                if (generator.isRegistered("returnType")) {
                    paramName2 = generator.getValue("returnName");
                } else {
                    paramName2 = this.nameConvertor.attributeToIdentifier(part.getName());
                    paramName2 = paramName2 + ".value";
                }
                if (this.nameConvertor.isPrimitive(paramType)) {
                    String perm = this.nameConvertor.wrap(paramType);
                    generator.addLine(paramName2 + " = ((" + perm + ") this.outputParams[" + i + "].content)." + paramType + "Value();");
                } else {
                    generator.addLine(paramName2 + " = (" + paramType + ") this.outputParams[" + i + "].content;");
                }
                ++i;
            }
        }
        if (generator.isRegistered("returnType")) {
            paramName = generator.getValue("returnName");
            generator.addLine("return " + paramName + ";");
        }
        generator.endSection();
        this.nameConvertor.enableCustomReserved();
        String exceptionName = "e";
        exceptionName = this.nameConvertor.attributeToIdentifier(exceptionName);
        this.nameConvertor.disableCustomReserved();
        this.generateCustomExceptionCatch(faults, generator, exceptionName);
        generator.addLine("} catch (javax.xml.rpc.soap.SOAPFaultException " + exceptionName + ") {");
        generator.addLine("  throw " + exceptionName + ";");
        generator.addLine("} catch (java.lang.Exception " + exceptionName + ") {");
        generator.addLine("  throw new RemoteException(\"Service call exception\"," + exceptionName + ");");
        generator.addLine("} finally {");
        generator.addLine("  super._endLogFrame(\"" + operation.getName() + "\");");
        generator.addLine("}");
        generator.endSection();
        generator.addLine("}");
        generator.addNewLine();
    }

    public void markParams(WSDLOperation operation) throws Exception {
        WSDLChannel input = operation.getInput();
        WSDLChannel output = operation.getOutput();
        if (input == null || output == null) {
            return;
        }
        QName inMessageName = input.getMessage();
        QName outMessageName = output.getMessage();
        WSDLMessage inMessage = this.definitions.getMessage(inMessageName);
        WSDLMessage outMessage = this.definitions.getMessage(outMessageName);
        if (inMessage == null || outMessage == null) {
            throw new Exception(" Invalid pointer from operation to message !");
        }
        ArrayList inMessageParts = inMessage.getParts();
        ArrayList outMessageParts = outMessage.getParts();
        if (outMessageParts.size() == 1) {
            return;
        }
        int i = 0;
        while (i < inMessageParts.size()) {
            WSDLPart partIn = (WSDLPart)inMessageParts.get(i);
            int j = 0;
            while (j < outMessageParts.size()) {
                WSDLPart partOut = (WSDLPart)outMessageParts.get(j);
                if (partIn.getName().equals(partOut.getName())) {
                    if (!partIn.getType().equals((Object)partOut.getType())) {
                        throw new Exception(" In/Out parameters of operations must be same type !");
                    }
                    partIn.inout = true;
                    partOut.inout = true;
                }
                ++j;
            }
            ++i;
        }
    }

    public void generateServiceImpl(LogicalPorts logicalPorts, String lpPath, boolean serverCase) throws Exception {
        int i;
        if (logicalPorts.getName() == null) {
            return;
        }
        String interfaceName = this.getClassName(logicalPorts.getName());
        if (logicalPorts.hasInterfaceName()) {
            interfaceName = logicalPorts.getInterfaceName();
        }
        String className = this.nameConvertor.getClassName(interfaceName) + "Impl";
        if (this.packageName != null && this.packageName.length() != 0) {
            logicalPorts.setImplementationName(this.packageName + "." + className);
        } else {
            logicalPorts.setImplementationName(className);
        }
        File outFile = new File(this.packageDir, className + ".java");
        try {
            outFile.createNewFile();
        }
        catch (Exception e) {
            throw new Exception(" Output file " + className + ".java could not be created !");
        }
        this.files.add(outFile);
        this.serviceInterfaces.add(outFile);
        CodeGenerator generator = new CodeGenerator();
        LogicalPortType[] lports = logicalPorts.getLogicalPort();
        this.writePackage(this.packageName, generator);
        generator.addLine();
        String extendsClass = "com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBase";
        if (serverCase) {
            extendsClass = extendsClass + "Server";
        }
        generator.addLine("public class " + className + " extends " + extendsClass + " implements " + interfaceName + " {");
        generator.addLine();
        generator.startSection();
        if (lpPath != null) {
            String ppath = this.escapeString(this.packageName + ".") + this.protocolsFile;
            generator.addLine("public " + className + "() throws java.lang.Exception {");
            generator.addLine("  super();");
            generator.addLine("  java.io.InputStream input;");
            generator.addLine("  input = this.getClass().getClassLoader().getResourceAsStream(\"" + ppath + "\");");
            generator.addLine("  loadProtocolsFromPropertyFile(input);");
            generator.addLine("  input.close();");
            generator.addLine("  init(this.getClass().getClassLoader().getResourceAsStream(\"" + lpPath + "\"));");
            if (this.genericMode) {
                if (this.isRegistryUsed) {
                    generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "(" + 1 + ",this.getClass().getClassLoader().getResourceAsStream(\"" + this.registryPath + "\"),this.getClass().getClassLoader());");
                } else {
                    generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "(" + 1 + ",null,null);");
                }
            } else {
                generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "();");
                if (this.isRegistryUsed) {
                    generator.addLine("  this._typeRegistry.fromXML(this.getClass().getClassLoader().getResourceAsStream(\"" + this.registryPath + "\"),this.getClass().getClassLoader());");
                }
            }
            generator.addLine("}");
            generator.addLine();
            generator.addLine("public " + className + "(" + (class$com$sap$engine$interfaces$webservices$runtime$component$ClientComponentFactory == null ? (class$com$sap$engine$interfaces$webservices$runtime$component$ClientComponentFactory = ClassGenerator.class$("com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory")) : class$com$sap$engine$interfaces$webservices$runtime$component$ClientComponentFactory).getName() + " componentFactory) throws java.lang.Exception {");
            generator.addLine("  super();");
            generator.addLine("  this.componentFactory = componentFactory;");
            generator.addLine("  init(this.getClass().getClassLoader().getResourceAsStream(\"" + lpPath + "\"));");
            if (this.genericMode) {
                if (this.isRegistryUsed) {
                    generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "(" + 1 + ",this.getClass().getClassLoader().getResourceAsStream(\"" + this.registryPath + "\"),this.getClass().getClassLoader());");
                } else {
                    generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "(" + 1 + ",null,null);");
                }
            } else {
                generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "();");
                if (this.isRegistryUsed) {
                    generator.addLine("  this._typeRegistry.fromXML(this.getClass().getClassLoader().getResourceAsStream(\"" + this.registryPath + "\"),this.getClass().getClassLoader());");
                }
            }
            generator.addLine("}");
        } else {
            generator.addLine("public " + className + "() throws java.lang.Exception {");
            generator.addLine("  this._typeRegistry = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl = ClassGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$TypeMappingRegistryImpl).getName() + "();");
            if (this.isRegistryUsed) {
                generator.addLine("  this._typeRegistry.fromXML(this.getClass().getClassLoader().getResourceAsStream(\"" + this.registryPath + "\"),this.getClass().getClassLoader());");
            }
            generator.addLine("}");
        }
        generator.addLine();
        boolean isNewStyle = false;
        String seiName = null;
        if (lports.length > 0) {
            isNewStyle = true;
            seiName = lports[0].getInterfaceName();
            if (seiName == null) {
                isNewStyle = false;
            }
            i = 1;
            while (i < lports.length && isNewStyle) {
                if (!seiName.equals(lports[i].getInterfaceName())) {
                    isNewStyle = false;
                }
                ++i;
            }
        }
        if (isNewStyle) {
            generator.addLine("public " + seiName + " getLogicalPort(String portName) throws javax.xml.rpc.ServiceException {");
            generator.addLine("  return (" + seiName + ") getPort(new javax.xml.namespace.QName(null,portName),null);");
            generator.addLine("}");
            generator.addLine("public " + seiName + " getLogicalPort() throws javax.xml.rpc.ServiceException {");
            generator.addLine("  return (" + seiName + ") getLogicalPort(" + seiName + ".class);");
            generator.addLine("}");
        }
        i = 0;
        while (i < lports.length) {
            if (lports[i].getOriginal()) {
                String bindingName = lports[i].getBindingName();
                String binfingNamespace = lports[i].getBindingUri();
                WSDLBinding binding = this.definitions.getBinding(bindingName, binfingNamespace);
                WSDLPortType portType = this.definitions.getPortType(binding.getType().getName(), binding.getType().getURI());
                String seiInterface = this.portManager.getNewJavaQName(new javax.xml.namespace.QName(portType.getNamespace(), portType.getName()), this.packageName);
                if (lports[i].hasInterfaceName()) {
                    seiInterface = lports[i].getInterfaceName();
                }
                generator.addLine("public " + seiInterface + " get" + this.nameConvertor.attributeToClassName(lports[i].getName()) + "() throws javax.xml.rpc.ServiceException {");
                String qName = "new javax.xml.namespace.QName(null,\"" + lports[i].getName() + "\")";
                generator.addLine("  return (" + seiInterface + ") super.getPort(" + qName + "," + seiInterface + ".class);");
                generator.addLine("}");
                generator.addLine();
            }
            ++i;
        }
        generator.addNewLine();
        generator.addLine("public java.rmi.Remote getLogicalPort(String portName, Class seiClass) throws javax.xml.rpc.ServiceException {");
        String qName = "new javax.xml.namespace.QName(null,portName)";
        generator.addLine("  return super.getPort(" + qName + ",seiClass);");
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public java.rmi.Remote getLogicalPort(Class seiClass) throws javax.xml.rpc.ServiceException {");
        generator.addLine("  return super.getLogicalPort(seiClass);");
        generator.addLine("}");
        generator.addLine();
        generator.endSection();
        generator.addLine("}");
        PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
        output.write(generator.toString());
        output.close();
    }

    public void generateServiceInterfaces(LogicalPorts logicalPorts, boolean getMethods) throws Exception {
        int i;
        if (logicalPorts.getName() == null) {
            return;
        }
        if (this.genericMode) {
            logicalPorts.setInterfaceName((class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ClassGenerator.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service).getName());
            return;
        }
        String className = this.nameConvertor.attributeToClassName(logicalPorts.getName());
        className = this.portManager.resolveJavaName(className, "Service");
        String classQName = className = this.stubManager.resolveJavaName(className, "Service");
        if (this.packageName != null && this.packageName.length() != 0) {
            classQName = this.packageName + "." + classQName;
        }
        logicalPorts.setInterfaceName(classQName);
        File outFile = new File(this.packageDir, className + ".java");
        try {
            outFile.createNewFile();
        }
        catch (Exception e) {
            throw new Exception(" Output file " + className + ".java could not be created !");
        }
        this.files.add(outFile);
        this.serviceInterfaces.add(outFile);
        CodeGenerator generator = new CodeGenerator();
        LogicalPortType[] lports = logicalPorts.getLogicalPort();
        this.writePackage(this.packageName, generator);
        generator.addLine();
        generator.addLine("/**");
        generator.addLine(" * Service Interface (generated by SAP WSDL to Java generator).");
        generator.addLine(" */");
        generator.addLine();
        generator.addLine("public interface " + className + " extends javax.xml.rpc.Service {");
        generator.addLine();
        generator.startSection();
        boolean isNewStyle = false;
        String interfaceName = null;
        if (lports.length > 0) {
            isNewStyle = true;
            interfaceName = lports[0].getInterfaceName();
            i = 1;
            while (i < lports.length) {
                if (!interfaceName.equals(lports[i].getInterfaceName())) {
                    isNewStyle = false;
                    break;
                }
                ++i;
            }
        }
        if (isNewStyle) {
            generator.addLine("public " + interfaceName + " getLogicalPort(String portName) throws javax.xml.rpc.ServiceException;");
            generator.addLine("public " + interfaceName + " getLogicalPort() throws javax.xml.rpc.ServiceException;");
        }
        if (getMethods) {
            i = 0;
            while (i < lports.length) {
                lports[i].setOriginal(true);
                String bindingName = lports[i].getBindingName();
                String bindingNamespace = lports[i].getBindingUri();
                WSDLBinding binding = this.definitions.getBinding(bindingName, bindingNamespace);
                WSDLPortType portType = this.definitions.getPortType(binding.getType().getName(), binding.getType().getURI());
                String seiInterface = this.portManager.getNewJavaQName(new javax.xml.namespace.QName(portType.getNamespace(), portType.getName()), this.packageName);
                if (lports[i].hasInterfaceName()) {
                    seiInterface = lports[i].getInterfaceName();
                }
                generator.addLine("public " + seiInterface + " get" + this.nameConvertor.attributeToClassName(lports[i].getName()) + "() throws javax.xml.rpc.ServiceException ;");
                ++i;
            }
        }
        generator.addLine("public java.rmi.Remote getLogicalPort(String portName, Class seiClass) throws javax.xml.rpc.ServiceException;");
        generator.addLine("public java.rmi.Remote getLogicalPort(Class seiClass) throws javax.xml.rpc.ServiceException;");
        generator.addLine("public String[] getLogicalPortNames();");
        generator.addLine("public com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType getLogicalPortConfiguration(String lpName);");
        generator.addLine();
        generator.endSection();
        generator.addLine("}");
        PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
        output.write(generator.toString());
        output.close();
    }

    private String getExceptionClassName(WSDLMessage message, boolean packageSet) throws Exception {
        if (message.getPartCount() == 1) {
            WSDLPart part = message.getPart(0);
            TypeDefinitionBase type = this.getPartType(part);
            String result = message.getName();
            if (!(this.schema.isSimple(type) || this.schema.isSoapArray(type) || (result = type.getName()) != null && result.length() != 0)) {
                result = part.getType().getLocalName() + "Exception";
            }
            result = this.nameConvertor.attributeToClassName(result);
            if (this.packageName != null && this.packageName.length() != 0 && packageSet) {
                result = this.packageName + "." + result;
            }
            return result;
        }
        throw new Exception(" WSDL:Fault messages should have one part inside according WSDL specification !");
    }

    private void generateExceptions(ArrayList messages) throws Exception {
        int i = 0;
        while (i < messages.size()) {
            WSDLMessage message = (WSDLMessage)messages.get(i);
            WSDLPart part = message.getPart(0);
            TypeDefinitionBase type = this.getPartType(part);
            if (this.schema.isSimple(type) || this.schema.isSoapArray(type)) {
                this.processExceptionSimpleType(message);
            } else {
                this.processExceptionComplexType(message);
            }
            ++i;
        }
    }

    private void writePackage(String packageName, CodeGenerator generator) {
        if (packageName != null && packageName.length() != 0) {
            generator.addLine("package " + packageName + ";");
        }
    }

    private String getClassName(String className) {
        if (this.packageName == null || this.packageName.length() == 0) {
            return this.nameConvertor.attributeToClassName(className);
        }
        return this.packageName + "." + this.nameConvertor.attributeToClassName(className);
    }

    private void processExceptionComplexType(WSDLMessage message) throws Exception {
        CodeGenerator generator = new CodeGenerator();
        ArrayList messageParts = message.getParts();
        String className = this.getExceptionClassName(message, false);
        if (messageParts.size() == 1) {
            FieldInfo field;
            FieldInfo field2;
            WSDLPart part = (WSDLPart)messageParts.get(0);
            TypeDefinitionBase partType = this.getPartType(part);
            String typeName = this.schema.getJavaPrimitive(partType);
            boolean isDocumentArray = false;
            if (partType instanceof ComplexTypeDefinition) {
                isDocumentArray = this.schema.isDocumentArray((ComplexTypeDefinition)partType);
            }
            String t_namespace = partType.getTargetNamespace();
            String t_name = partType.getName();
            if (t_name == null || t_name.length() == 0) {
                t_name = DOM.toXPath((Node)partType.getAssociatedDOMNode());
            }
            String fieldJavaName = this.nameConvertor.attributeToIdentifier(part.getName());
            ArrayList fields = this.schema.getComplexFieldInfo((ComplexTypeDefinition)partType);
            this.writePackage(this.packageName, generator);
            generator.addLine();
            generator.addLine("public class " + className + " extends com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyException {");
            generator.addLine("  private " + typeName + " " + fieldJavaName + ";");
            generator.addLine();
            generator.addLine("  public void init(" + typeName + " " + fieldJavaName + ") {");
            generator.addLine("    this." + fieldJavaName + "=" + fieldJavaName + ";");
            generator.addLine("  }");
            generator.addLine();
            if (fields.size() != 0) {
                generator.addLine("  public " + className + "() {");
                if (isDocumentArray) {
                    generator.addLine("    this." + fieldJavaName + "= new " + typeName.substring(0, typeName.length() - 2) + "[0];");
                } else {
                    generator.addLine("    this." + fieldJavaName + "= new " + typeName + "();");
                }
                generator.addLine("  }");
            }
            generator.addLine();
            generator.addLine("  public Class getContentClass() {");
            generator.addLine("    return " + typeName + ".class;");
            generator.addLine("  }");
            generator.addLine();
            generator.add("  public " + className + "(");
            if (isDocumentArray) {
                field2 = (FieldInfo)fields.get(0);
                generator.add(typeName + " " + this.nameConvertor.attributeToIdentifier(field2.fieldLocalName));
            } else {
                int i = 0;
                while (i < fields.size()) {
                    field = (FieldInfo)fields.get(i);
                    if (field.fieldModel != 1) {
                        throw new Exception("Only Element Field's allowed in Custom WSDL Fault !");
                    }
                    if (i != 0) {
                        generator.add(", ");
                    }
                    if (field.maxOccurs != 1) {
                        generator.add(field.typeJavaName + "[] " + this.nameConvertor.attributeToIdentifier(field.fieldLocalName));
                    } else {
                        generator.add(field.typeJavaName + " " + this.nameConvertor.attributeToIdentifier(field.fieldLocalName));
                    }
                    ++i;
                }
            }
            generator.add(") {");
            generator.addNewLine();
            if (isDocumentArray) {
                field2 = (FieldInfo)fields.get(0);
                generator.addLine("    this." + fieldJavaName + " = " + this.nameConvertor.attributeToIdentifier(field2.fieldLocalName) + ";");
            } else {
                generator.addLine("    this." + fieldJavaName + " = new " + typeName + "();");
                int i = 0;
                while (i < fields.size()) {
                    field = (FieldInfo)fields.get(i);
                    generator.addLine("    this." + fieldJavaName + "." + field.getSetterMethod() + "(" + this.nameConvertor.attributeToIdentifier(field.fieldLocalName) + ");");
                    ++i;
                }
            }
            generator.addLine("  }");
            generator.addLine();
            if (isDocumentArray) {
                FieldInfo field3 = (FieldInfo)fields.get(0);
                String externalGetMethod = this.resolveGetMethod(field3.getGetterMethod(), fields);
                generator.addLine("  public " + typeName + externalGetMethod + "() {");
                generator.addLine("    return this." + fieldJavaName + ";");
                generator.addLine("  }");
            } else {
                int i = 0;
                while (i < fields.size()) {
                    field = (FieldInfo)fields.get(i);
                    if (field.fieldModel != 1) {
                        throw new Exception("Only Element Field's allowed in Custom WSDL Fault !");
                    }
                    String externalGetMethod = this.resolveGetMethod(field.getGetterMethod(), fields);
                    if (field.maxOccurs != 1) {
                        generator.addLine("  public " + field.typeJavaName + "[] " + externalGetMethod + "() {");
                        generator.addLine("    return this." + fieldJavaName + "." + field.getGetterMethod() + "();");
                        generator.addLine("  }");
                    } else {
                        generator.addLine("  public " + field.typeJavaName + " " + externalGetMethod + "() {");
                        generator.addLine("    return this." + fieldJavaName + "." + field.getGetterMethod() + "();");
                        generator.addLine("  }");
                    }
                    ++i;
                }
            }
        } else {
            throw new Exception(" WSDL:Fault messages should have only one part inside according WSDL specification !");
        }
        generator.addLine("}");
        generator.addLine();
        File outFile = new File(this.packageDir, className + ".java");
        this.files.add(outFile);
        PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
        output.write(generator.toString());
        output.close();
    }

    private String resolveGetMethod(String getMethod, ArrayList fields) {
        if (getMethod.equals("getMessage")) {
            getMethod = getMethod + "Internal";
        }
        if (getMethod.equals("getLocalizedMessage")) {
            getMethod = getMethod + "Internal";
        }
        if (getMethod.equals("getClass")) {
            getMethod = getMethod + "Internal";
        }
        String perm = getMethod;
        return perm;
    }

    private void processExceptionSimpleType(WSDLMessage message) throws Exception {
        String fieldName;
        String typeName;
        String className = this.nameConvertor.attributeToClassName(message.getName());
        if (this.nameConvertor.conains(this.packageName, className)) {
            className = className + "New";
        }
        CodeGenerator generator = new CodeGenerator();
        ArrayList messageParts = message.getParts();
        if (messageParts.size() == 1) {
            WSDLPart part = (WSDLPart)messageParts.get(0);
            QName type = part.getType();
            TypeDefinitionBase partType = this.getPartType(part);
            typeName = this.schema.getJavaPrimitive(partType);
            fieldName = part.getName();
            if (part.getStyle() == 1) {
                fieldName = type.getLocalName();
            }
        } else {
            throw new Exception(" WSDL:Fault messages should have only one part inside according WSDL specification !");
        }
        String fieldJavaName = this.nameConvertor.attributeToIdentifier(fieldName);
        String methodName = this.nameConvertor.attributeToMethodName("get" + this.nameConvertor.attributeToClassName(fieldName));
        this.writePackage(this.packageName, generator);
        generator.addLine();
        generator.addLine("public class " + className + " extends com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyException {");
        generator.addLine("  private " + typeName + " " + fieldJavaName + ";");
        generator.addLine();
        generator.addLine("  public " + className + "(" + typeName + " " + fieldJavaName + ") {");
        generator.addLine("    this." + fieldJavaName + "=" + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine();
        generator.addLine("  public " + className + "() {");
        generator.addLine("  }");
        generator.addLine();
        generator.addLine("  public void init(" + typeName + " " + fieldJavaName + ") {");
        generator.addLine("    this." + fieldJavaName + "=" + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine("  public " + typeName + " " + methodName + "() {");
        generator.addLine("    return this." + fieldJavaName + ";");
        generator.addLine("  }");
        generator.addLine("  public Class getContentClass() {");
        generator.addLine("    return " + typeName + ".class;");
        generator.addLine("  }");
        generator.addLine("}");
        generator.addLine();
        File outFile = new File(this.packageDir, className + ".java");
        this.files.add(outFile);
        PrintWriter output = new PrintWriter(new FileOutputStream(outFile), true);
        output.write(generator.toString());
        output.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

