/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.services.webservices.jaxrpc.exceptions.ProxyGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClassDefinition;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.GeneratorEnvironment;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceDefinition;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.InterfaceHandler;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class BeanHandler
implements InterfaceHandler {
    public final String[] homeExtends = new String[]{"EJBHome"};
    public final String[] homeImports = new String[]{"javax.ejb.EJBHome", "java.rmi.RemoteException", "javax.ejb.CreateException"};
    public final String[] extendsInterfaces = new String[]{"EJBObject"};
    public final String[] interfaceImports = new String[]{"javax.ejb.EJBObject", "java.rmi.RemoteException"};
    public final String[] implImports = new String[]{"javax.ejb.SessionBean", "javax.ejb.SessionContext", "javax.ejb.CreateException", "java.rmi.RemoteException"};
    public ArrayList beans = new ArrayList();

    public boolean startGenreration(GeneratorEnvironment environment) {
        this.beans.clear();
        return true;
    }

    public boolean endGeneration(GeneratorEnvironment environment) {
        return true;
    }

    public boolean processPortType(WSDLPortType portType, GeneratorEnvironment environment) {
        InterfaceDefinition idefinition = new InterfaceDefinition();
        ClassDefinition cdefinition = new ClassDefinition();
        InterfaceDefinition hdefinition = new InterfaceDefinition();
        hdefinition.setPackageName(environment.outputPackage);
        idefinition.setPackageName(environment.outputPackage);
        cdefinition.setPackageName(environment.outputPackage);
        NameConvertor convertor = environment.convertor;
        String interfaceName = convertor.attributeToClassName(portType.getName());
        while (convertor.conains(environment.outputPackage, interfaceName)) {
            interfaceName = interfaceName + "Int";
        }
        String className = interfaceName + "Bean";
        while (convertor.conains(environment.outputPackage, className)) {
            className = className + "Impl";
        }
        String homeName = interfaceName + "Home";
        while (convertor.conains(environment.outputPackage, homeName)) {
            homeName = homeName + "H";
        }
        convertor.addClassName(environment.outputPackage, interfaceName);
        convertor.addClassName(environment.outputPackage, className);
        convertor.addClassName(environment.outputPackage, homeName);
        idefinition.setInterfaceName(interfaceName);
        cdefinition.setClassName(className);
        hdefinition.setInterfaceName(homeName);
        QName portName = new QName(portType.getNamespace(), portType.getName());
        environment.registerInterfaceName(portName, idefinition.getQualifiedName());
        hdefinition.setImports(this.homeImports);
        hdefinition.setExtendsInterfaces(this.homeExtends);
        this.fillHomeContent(hdefinition.getContent(), idefinition.getQualifiedName());
        idefinition.setImports(this.interfaceImports);
        idefinition.setExtendsInterfaces(this.extendsInterfaces);
        cdefinition.setImplInterfaces(new String[]{"SessionBean"});
        cdefinition.setImports(this.implImports);
        CodeGenerator icontent = idefinition.getContent();
        CodeGenerator ccontent = cdefinition.getContent();
        this.fillImplementation(ccontent);
        ArrayList operations = portType.getOperations();
        try {
            int i = 0;
            while (i < operations.size()) {
                WSDLOperation operation = (WSDLOperation)operations.get(i);
                environment.iGenerator.checkParams(operation);
                String methodName = convertor.attributeToMethodName(operation.getName());
                String methodHeader = environment.iGenerator.generateOperationHeader(methodName, operation);
                String[] methodExceptions = environment.iGenerator.getExceptions(operation.getFaultList(), methodName);
                environment.registerInterfaceMethod(idefinition.getQualifiedName(), environment.iGenerator.fillOperationInfo(methodName, operation));
                icontent.addIndent();
                ccontent.addIndent();
                icontent.add(methodHeader);
                ccontent.add(methodHeader);
                icontent.add(" throws RemoteException");
                ccontent.add(" throws RemoteException");
                int j = 0;
                while (j < methodExceptions.length) {
                    icontent.add(",");
                    icontent.add(methodExceptions[j]);
                    ccontent.add(",");
                    ccontent.add(methodExceptions[j]);
                    ++j;
                }
                icontent.add(";");
                icontent.addNewLine();
                ccontent.add(" {");
                ccontent.addNewLine();
                if (environment.returnType != null) {
                    String result = environment.iGenerator.getNull(environment.returnType);
                    ccontent.addLine("  return " + result + ";");
                }
                ccontent.addLine("}");
                ++i;
            }
            environment.outputFiles.add(idefinition.save(environment.outputRootDir));
            environment.outputFiles.add(cdefinition.save(environment.outputRootDir));
            environment.outputFiles.add(hdefinition.save(environment.outputRootDir));
            BeanStruct bean = new BeanStruct();
            bean.cname = cdefinition.getQualifiedName();
            bean.iname = idefinition.getQualifiedName();
            bean.hname = hdefinition.getQualifiedName();
            this.beans.add(bean);
        }
        catch (ProxyGeneratorException e) {
            environment.generateException = e;
        }
        return true;
    }

    private void fillImplementation(CodeGenerator generator) {
        generator.addLine("public void ejbRemove() {");
        generator.addLine("}");
        generator.addLine("public void ejbActivate() {");
        generator.addLine("}");
        generator.addLine("public void ejbPassivate() {");
        generator.addLine("}");
        generator.addLine("public void setSessionContext(SessionContext context) {");
        generator.addLine("  myContext = context;");
        generator.addLine("}");
        generator.addLine("private SessionContext myContext;");
        generator.addLine("/**");
        generator.addLine(" * Create Method.");
        generator.addLine(" */");
        generator.addLine("public void ejbCreate() throws CreateException {");
        generator.addLine("  // TODO : Implement");
        generator.addLine("}");
    }

    private void fillHomeContent(CodeGenerator generator, String iname) {
        generator.addLine("/**");
        generator.addLine(" * Create Method.");
        generator.addLine(" */");
        generator.addLine("public " + iname + " create() throws CreateException, RemoteException;");
    }

    public class BeanStruct {
        public String iname;
        public String cname;
        public String hname;
    }
}

