/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.wsdl2java;

import com.sap.engine.interfaces.webservices.runtime.GlobalClientSettings;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.services.webservices.jaxm.soap.IteratorImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProtocolList;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.rpc.Stub;

public class BaseGeneratedStub
implements Stub,
Remote {
    public static final String SECURITY_USERNAME = "javax.xml.rpc.security.auth.username";
    public static final String SECURITY_USERPASS = "javax.xml.rpc.security.auth.password";
    public static final String PORT_ENDPOINT = "javax.xml.rpc.service.endpoint.address";
    public static final String HTTPPROXYPORT = "javax.xml.rpc.http.proxyport";
    public static final String HTTPPROXYHOST = "javax.xml.rpc.http.proxyhost";
    public static final String HTTP_PROXY_USER = "proxyUser";
    public static final String HTTP_PROXY_PASS = "proxyPassword";
    public static final String REQUESTLOGGINGSTREAM = "RequestLogging";
    public static final String RESPONSELOGGINGSTREAM = "ResponseLogging";
    public static final String HTTP_PROXY_RESOLVER_PROPERTY = "HTTPProxyResolver";
    public static final String SOCKETTIMEOUT = "socketTimeout";
    public static final String KEEP_ALIVE = "keepAliveStatus";
    public static final String COMPRESS_RESPONSE = "compressResponse";
    public static final String SAX_RESPONSE_HANDLER = "saxResponseHandler";
    public static final String OBJECT_FACTORY = "objectFactory";
    public static final String HTTP_REQUEST_HEADERS = "httpRequestHeaders";
    public static final String HTTP_RESPONSE_HEADERS = "httpResponseHeaders";
    public static final String HTTP_REDIRECT_SUPPORT = "httpRedirect";
    protected PropertyContext jaxrpcConfig;
    protected PropertyContext stubConfiguration;
    protected PropertyContext bindingConfiguration;
    protected PropertyContext featureConfiguration;
    protected ClientTransportBinding transportBinding;
    protected ServiceParam[] inputParams;
    protected ServiceParam[] outputParams;
    protected ServiceParam[] faultParams;
    protected ProtocolList globalProtocols;
    protected Hashtable localProtocols;
    protected Hashtable localFeatures;
    protected boolean userLogging = false;
    protected boolean logStarted = false;
    protected ByteArrayOutputStream inputLog = new ByteArrayOutputStream();
    protected ByteArrayOutputStream outputLog = new ByteArrayOutputStream();
    protected Location location;

    protected void _beginLogFrame() {
        if (!this.userLogging && this.location != null && this.location.beLogged(100)) {
            this.featureConfiguration.setProperty(REQUESTLOGGINGSTREAM, this.inputLog);
            this.featureConfiguration.setProperty(RESPONSELOGGINGSTREAM, this.outputLog);
            this.logStarted = true;
        }
    }

    protected void _endLogFrame(String methodName) {
        if (this.logStarted) {
            this.featureConfiguration.clearProperty(REQUESTLOGGINGSTREAM);
            this.featureConfiguration.clearProperty(RESPONSELOGGINGSTREAM);
            if (!this.userLogging && this.location != null && this.location.beLogged(100)) {
                this.location.logT(100, "Web Method [" + methodName + "] called.");
                this.location.logT(100, this.inputLog.toString());
                this.location.logT(100, this.outputLog.toString());
            }
            this.inputLog.reset();
            this.outputLog.reset();
            this.logStarted = false;
        }
    }

    public void _setTypeRegistry(TypeMappingRegistryImpl _registry) {
    }

    public void _setLogLocation(Location location) {
        this.location = location;
    }

    public void _clearLogLocation() {
        this.location = null;
    }

    public BaseGeneratedStub() {
        this.stubConfiguration = new PropertyContext();
        this.bindingConfiguration = new PropertyContext();
        this.globalProtocols = new ProtocolList();
        this.localProtocols = new Hashtable();
        this.localFeatures = new Hashtable();
        this.featureConfiguration = new PropertyContext();
        this.jaxrpcConfig = new PropertyContext();
    }

    public ProtocolList _getGlobalProtocols() {
        return this.globalProtocols;
    }

    public ProtocolList _getOperationProtocols(String operationName) {
        return (ProtocolList)this.localProtocols.get(operationName);
    }

    public PropertyContext _getGlobalFeatureConfig() {
        return this.featureConfiguration;
    }

    public void _setGlobalFeatureConfig(PropertyContext context) {
        if (context == null) {
            return;
        }
        this.featureConfiguration = context;
    }

    public PropertyContext _getOperationFeatureConfig(String operationName) {
        return (PropertyContext)this.localFeatures.get(operationName);
    }

    public void _setEndpoint(String url) {
        this.jaxrpcConfig.setProperty(PORT_ENDPOINT, url);
    }

    public String _getEndpoint() {
        return (String)this.jaxrpcConfig.getProperty(PORT_ENDPOINT);
    }

    public void _fillEndpoint(PropertyContext pContext) {
        pContext.setProperty("endpointUrl", this._getEndpoint());
    }

    public Object _getProperty(String s) {
        return this.jaxrpcConfig.getProperty(s);
    }

    public Iterator _getPropertyNames() {
        IteratorImpl result = new IteratorImpl();
        result.init(this.jaxrpcConfig.getProperyKeys());
        return result;
    }

    public void _setProperty(String s, Object o) {
        PropertyContext feature;
        String userName;
        this.jaxrpcConfig.setProperty(s, o);
        if (SECURITY_USERNAME.equals(s) && o != null && o instanceof String && (userName = (String)o).length() != 0 && (feature = this.featureConfiguration.getSubContext("http://www.sap.com/webas/630/soap/features/session/")).isDefined()) {
            feature.clearProperty("SessionCoockie");
            feature.setProperty("maintainSession", "yes");
        }
        if (SECURITY_USERPASS.equals(s) && o != null && o instanceof String && (userName = (String)o).length() != 0 && (feature = this.featureConfiguration.getSubContext("http://www.sap.com/webas/630/soap/features/session/")).isDefined()) {
            feature.clearProperty("SessionCoockie");
            feature.setProperty("maintainSession", "yes");
        }
    }

    public PropertyContext _buildOperationContext(String operationName, ClientTransportBinding binding) {
        this.stubConfiguration.clear();
        this.stubConfiguration.setSubContext("bindingConfig", this.bindingConfiguration);
        this.stubConfiguration.setSubContext("featureConfig", this.featureConfiguration);
        PropertyContext operationFeatures = this._getOperationFeatureConfig(operationName);
        if (operationFeatures != null) {
            this.stubConfiguration.joinProperyContext("featureConfig", operationFeatures);
        }
        this._loadJaxRpcConfig();
        return this.stubConfiguration;
    }

    private void _loadJaxRpcConfig() {
        String keepAliveValue;
        PropertyContext perm;
        PropertyContext perm2;
        String proxyHost;
        Object saxHandler;
        PropertyContext features = this.stubConfiguration.getSubContext("featureConfig");
        String httpRedirect = (String)this.jaxrpcConfig.getProperty(HTTP_REDIRECT_SUPPORT);
        if (httpRedirect != null && httpRedirect.length() != 0) {
            features.setProperty(HTTP_REDIRECT_SUPPORT, "yes");
        } else {
            features.clearProperty(HTTP_REDIRECT_SUPPORT);
        }
        String userName = (String)this.jaxrpcConfig.getProperty(SECURITY_USERNAME);
        if (userName != null) {
            PropertyContext perm3;
            if (userName.length() != 0) {
                perm3 = features.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
                perm3.setProperty("AuthenticationMethod", "BasicAuth");
                perm3.setProperty("AuthenticationCredentialUser", userName);
                perm3.setProperty("AuthenticationCredentialPassword", this.jaxrpcConfig.getProperty(SECURITY_USERPASS));
            } else {
                perm3 = features.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
                perm3.clearProperty("AuthenticationCredentialUser");
                perm3.clearProperty("AuthenticationCredentialPassword");
            }
        }
        if ((saxHandler = this.jaxrpcConfig.getProperty(SAX_RESPONSE_HANDLER)) != null) {
            features.setProperty(SAX_RESPONSE_HANDLER, saxHandler);
        }
        if ((proxyHost = (String)this.jaxrpcConfig.getProperty(HTTPPROXYHOST)) != null) {
            PropertyContext perm4 = features.getSubContext("http://www.sap.com/webas/630/soap/features/proxy");
            if (proxyHost.length() != 0) {
                perm4.setProperty("proxyHost", this.jaxrpcConfig.getProperty(HTTPPROXYHOST));
                perm4.setProperty("proxyPort", this.jaxrpcConfig.getProperty(HTTPPROXYPORT));
            } else {
                perm4.clearProperty("proxyHost");
                perm4.clearProperty("proxyPort");
            }
        }
        String proxyUser = (String)this.jaxrpcConfig.getProperty(HTTP_PROXY_USER);
        String proxyPass = (String)this.jaxrpcConfig.getProperty(HTTP_PROXY_PASS);
        if (proxyUser != null) {
            perm2 = features.getSubContext("http://www.sap.com/webas/630/soap/features/proxy");
            perm2.setProperty(HTTP_PROXY_USER, proxyUser);
            if (proxyPass != null) {
                perm2.setProperty(HTTP_PROXY_PASS, proxyPass);
            } else {
                perm2.setProperty(HTTP_PROXY_PASS, "");
            }
        } else {
            perm2 = features.getSubContext("http://www.sap.com/webas/630/soap/features/proxy");
            perm2.clearProperty(HTTP_PROXY_USER);
            perm2.clearProperty(HTTP_PROXY_PASS);
        }
        if (this.jaxrpcConfig.getProperty(SOCKETTIMEOUT) != null) {
            String timeOut = (String)this.jaxrpcConfig.getProperty(SOCKETTIMEOUT);
            if (timeOut.length() != 0) {
                perm = features.getSubContext("http://www.sap.com/webas/630/soap/features/timeout/");
                perm.setProperty("timeout", timeOut);
            } else {
                perm = features.getSubContext("http://www.sap.com/webas/630/soap/features/timeout/");
                perm.clearProperty("timeout");
            }
        }
        if (this.jaxrpcConfig.getProperty(KEEP_ALIVE) != null) {
            keepAliveValue = (String)this.jaxrpcConfig.getProperty(KEEP_ALIVE);
            if (keepAliveValue.length() != 0) {
                perm = features.getSubContext("http://www.sap.com/webas/630/soap/features/http/keepAlive");
                perm.setProperty(KEEP_ALIVE, keepAliveValue);
            } else {
                perm = features.getSubContext("http://www.sap.com/webas/630/soap/features/http/keepAlive");
                perm.clearProperty(KEEP_ALIVE);
            }
        }
        if (this.jaxrpcConfig.getProperty(COMPRESS_RESPONSE) != null) {
            keepAliveValue = (String)this.jaxrpcConfig.getProperty(COMPRESS_RESPONSE);
            if (keepAliveValue.length() != 0) {
                perm = features.getSubContext("http://www.sap.com/webas/630/soap/features/http/gzip");
                perm.setProperty(COMPRESS_RESPONSE, keepAliveValue);
            } else {
                perm = features.getSubContext("http://www.sap.com/webas/630/soap/features/http/gzip");
                perm.clearProperty(COMPRESS_RESPONSE);
            }
        }
        if (this.jaxrpcConfig.getProperty("javax.xml.rpc.session.maintain") != null) {
            String useSession = (String)this.jaxrpcConfig.getProperty("javax.xml.rpc.session.maintain");
            PropertyContext context = this.featureConfiguration.getSubContext("http://www.sap.com/webas/630/soap/features/session/");
            context.setProperty("SessionMethod", "httpCookies");
            if ("true".equals(useSession)) {
                context.setProperty("maintainSession", "yes");
            } else if ("false".equals(useSession)) {
                context.setProperty("maintainSession", "no");
                context.clearProperty("SessionCoockie");
            }
        }
        if (this.jaxrpcConfig.getProperty(HTTP_REQUEST_HEADERS) != null) {
            this.stubConfiguration.setProperty(HTTP_REQUEST_HEADERS, this.jaxrpcConfig.getProperty(HTTP_REQUEST_HEADERS));
        }
        if (this.jaxrpcConfig.getProperty(HTTP_RESPONSE_HEADERS) != null) {
            this.stubConfiguration.setProperty(HTTP_RESPONSE_HEADERS, this.jaxrpcConfig.getProperty(HTTP_RESPONSE_HEADERS));
        }
        this.stubConfiguration.setProperty("javax.xml.rpc.classloader", this.getClass().getClassLoader());
    }

    public ClientTransportBinding _getTransportBinding() {
        return this.transportBinding;
    }

    public String _getTransportBindingName() {
        if (this.transportBinding != null) {
            return this.transportBinding.getName();
        }
        return null;
    }

    public void _setTransportBinding(ClientTransportBinding binding) {
        this.transportBinding = binding;
    }

    public void _clear() {
        this.globalProtocols.clear();
        this.featureConfiguration.clear();
        Enumeration keys = this.localFeatures.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            PropertyContext context = (PropertyContext)this.localFeatures.get(key);
            context.clear();
            ArrayList protocols = (ArrayList)this.localProtocols.get(key);
            protocols.clear();
        }
    }

    public void _startLogging(OutputStream requestLog, OutputStream responseLog) {
        this.userLogging = true;
        this.featureConfiguration.setProperty(REQUESTLOGGINGSTREAM, requestLog);
        this.featureConfiguration.setProperty(RESPONSELOGGINGSTREAM, responseLog);
    }

    public void _stopLogging() {
        this.featureConfiguration.clearProperty(REQUESTLOGGINGSTREAM);
        this.featureConfiguration.clearProperty(RESPONSELOGGINGSTREAM);
        this.userLogging = false;
    }

    public void _setHTTPProxyResolver(HTTPProxyResolver proxyResolver) {
        if (proxyResolver != null) {
            this.featureConfiguration.setProperty(HTTP_PROXY_RESOLVER_PROPERTY, proxyResolver);
        } else {
            this.featureConfiguration.clearProperty(HTTP_PROXY_RESOLVER_PROPERTY);
        }
    }

    public void _setGlobalClientSettings(GlobalClientSettings globalSettings) {
        if (globalSettings != null) {
            this.featureConfiguration.setProperty("GlobalClientSettings", globalSettings);
        } else {
            this.featureConfiguration.clearProperty("GlobalClientSettings");
        }
    }

    public void _flush() throws RemoteException {
        this.bindingConfiguration.clear();
        this._fillEndpoint(this.bindingConfiguration);
        this._buildOperationContext("", this.transportBinding);
        try {
            this.transportBinding.flush(this.stubConfiguration, this.globalProtocols);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }
}

