/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.util;

import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;

public class PackageBuilder {
    private String additionalClassPath = "";
    private JarUtils jarUtil;
    private String classExt = "class";
    private Vector classFiles;
    private File packageRoot;
    private File packageDir;
    private String packageName;
    private NameConvertor nameConvertor;
    private ArrayList externalPackages = new ArrayList();
    private static ByteArrayOutputStream buferOut;
    private static ByteArrayOutputStream buferErr;
    private static Method sun_tools_javac_Main_compile;
    private static Constructor sun_tools_javac_Main_constructor;
    private FileFilter dirFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private FileFilter javaFileFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".java");
        }
    };
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public PackageBuilder() {
        this.jarUtil = new JarUtils();
        this.classFiles = new Vector();
        buferOut = new ByteArrayOutputStream();
        buferErr = new ByteArrayOutputStream();
        this.nameConvertor = new NameConvertor();
    }

    public void clear() {
        this.externalPackages.clear();
        this.classFiles.clear();
        buferOut.reset();
        buferErr.reset();
        this.packageRoot = null;
        this.packageDir = null;
        this.packageName = null;
    }

    public void setPackageRoot(File packageRoot) {
        this.packageRoot = packageRoot;
    }

    public void addExternalPackage(String param) {
        this.externalPackages.add(param);
    }

    public void setPackageName(String packageName) {
        if (this.packageRoot == null) {
            String currentDir = SystemProperties.getProperty((String)"user.dir");
            this.packageRoot = new File(currentDir);
        }
        this.packageName = packageName;
        this.packageDir = new File(this.packageRoot, File.separator + this.nameConvertor.packageToPath(this.packageName) + File.separator);
    }

    public void addArchiveFile(String packageName, File filePath) throws Exception {
        String jarFileName = this.nameConvertor.packageToPath(packageName) + filePath.getName();
        this.classFiles.add(new InfoObject(jarFileName.substring(1), filePath.getCanonicalPath()));
    }

    private String getClassPath() throws Exception {
        return this.packageRoot.getCanonicalPath() + File.pathSeparator + this.additionalClassPath + " ";
    }

    public void loadPackageClasses(boolean deep) throws Exception {
        this.loadClassFiles(this.packageDir, this.packageName, deep);
        int i = 0;
        while (i < this.externalPackages.size()) {
            String ePackage = (String)this.externalPackages.get(i);
            File pDir = new File(this.packageRoot, File.separator + this.nameConvertor.packageToPath(ePackage) + File.separator);
            this.loadClassFiles(pDir, ePackage, false);
            ++i;
        }
    }

    public void loadPackageFiles(boolean deep, String[] extensions) throws Exception {
        int i = 0;
        while (i < extensions.length) {
            this.loadFiles(this.packageDir, this.packageName, deep, extensions[i]);
            int j = 0;
            while (j < this.externalPackages.size()) {
                String ePackage = (String)this.externalPackages.get(j);
                File pDir = new File(this.packageRoot, File.separator + this.nameConvertor.packageToPath(ePackage) + File.separator);
                this.loadFiles(pDir, ePackage, false, extensions[i]);
                ++j;
            }
            ++i;
        }
    }

    private void loadClassFiles(File filePlace, String jarPlace, boolean deep) throws Exception {
        this.loadFiles(filePlace, jarPlace, deep, this.classExt);
    }

    private void loadFiles(File filePlace, String jarPlace, boolean deep, String extension) throws Exception {
        File[] files = filePlace.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                if (files[i].getName().endsWith(extension)) {
                    this.addArchiveFile(jarPlace, files[i]);
                }
            } else if (files[i].isDirectory() && deep) {
                String nextPlace = jarPlace.length() != 0 ? jarPlace + '.' + files[i].getName() : files[i].getName();
                this.loadFiles(files[i], nextPlace, true, extension);
            }
            ++i;
        }
    }

    public void compilePackage() throws Exception {
        String classPath = this.getClassPath();
        this.compileExternal(classPath, this.packageDir);
        int i = 0;
        while (i < this.externalPackages.size()) {
            String ePackage = (String)this.externalPackages.get(i);
            File pDir = new File(this.packageRoot, File.separator + this.nameConvertor.packageToPath(ePackage) + File.separator);
            this.compileExternal(classPath, pDir);
            ++i;
        }
    }

    public void buildJar(String jarName) throws Exception {
        URL url = new URL(this.packageRoot.toURL(), "file://" + jarName);
        this.jarUtil.makeJarFromFiles(url.toExternalForm().substring(7), this.classFiles);
    }

    public void buildJar(File jarFile) throws Exception {
        this.jarUtil.makeJarFromFiles(jarFile.getCanonicalPath(), this.classFiles);
    }

    public String getAditionalClassPath() {
        return this.additionalClassPath;
    }

    public void setAditionalClassPath(String aditionalClassPath) {
        this.additionalClassPath = aditionalClassPath;
    }

    private void traversThrough(String classPath, File workDir) throws IOException {
        File[] dirs = workDir.listFiles(this.dirFilter);
        int i = 0;
        while (i < dirs.length) {
            this.traversThrough(classPath, dirs[i]);
            ++i;
        }
        File[] javaFiles = workDir.listFiles(this.javaFileFilter);
        String[] javaStringArray = new String[javaFiles.length];
        i = 0;
        while (i < javaFiles.length) {
            javaStringArray[i] = javaFiles[i].getName();
            ++i;
        }
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(errStream, true);
        Object main = null;
        try {
            main = sun_tools_javac_Main_constructor.newInstance(ps, "javac");
        }
        catch (Exception e) {
            main = null;
        }
        if (main != null) {
            PackageBuilder.compileInternal(classPath, workDir.getCanonicalPath(), javaStringArray, main, errStream);
        } else {
            PackageBuilder.compileExternal(classPath, workDir.getCanonicalPath(), javaStringArray, errStream);
        }
    }

    private static void compileExternal(String classPath, String destDir, String[] javaFiles, ByteArrayOutputStream errStream) throws IOException {
        String quote;
        String externalCompiler = System.getProperty("ExternalCompiler", "javac");
        String[] cmd = new String[6];
        try {
            quote = SystemProperties.getProperty((String)"os.name").toUpperCase().startsWith("WINDOWS") ? "\"" : "";
        }
        catch (Exception e) {
            quote = "";
        }
        cmd[0] = externalCompiler;
        cmd[1] = "-nowarn";
        cmd[2] = "-encoding";
        cmd[3] = SystemProperties.getProperty((String)"file.encoding", (String)"UTF8");
        cmd[4] = "-classpath";
        cmd[5] = quote + classPath + File.pathSeparator + SystemProperties.getProperty((String)"java.class.path") + quote;
        int pt = 0;
        int currentFilesForCompile = 0;
        for (int filesForCompile = javaFiles.length; filesForCompile > 0; filesForCompile -= currentFilesForCompile) {
            currentFilesForCompile = filesForCompile;
            if (currentFilesForCompile > 100) {
                currentFilesForCompile = 100;
            }
            String[] cmd1 = new String[currentFilesForCompile + 6];
            System.arraycopy(cmd, 0, cmd1, 0, 6);
            int i = 0;
            while (i < currentFilesForCompile) {
                cmd1[i + 6] = quote + destDir + File.separatorChar + javaFiles[pt++] + quote;
                ++i;
            }
            Process compiler = Runtime.getRuntime().exec(cmd1);
            new StreamReader(compiler.getInputStream(), errStream).start();
            new StreamReader(compiler.getErrorStream(), errStream).start();
            int res = 1;
            try {
                res = compiler.waitFor();
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException("Compilation fails... Build interrupted !");
            }
        }
    }

    private static void compileInternal(String classPath, String destDir, String[] javaFiles, Object main, ByteArrayOutputStream errStream) throws IOException {
        boolean compiled = false;
        String[] cmd = new String[]{"-encoding", SystemProperties.getProperty((String)"file.encoding", (String)"UTF8"), "-classpath", classPath + File.pathSeparator + SystemProperties.getProperty((String)"java.class.path")};
        int filesForCompile = javaFiles.length;
        int pt = 0;
        int currentFilesForCompile = 0;
        while (filesForCompile > 0) {
            currentFilesForCompile = filesForCompile;
            String[] cmd1 = new String[currentFilesForCompile + 4];
            System.arraycopy(cmd, 0, cmd1, 0, 4);
            int i = 0;
            while (i < currentFilesForCompile) {
                cmd1[i + 4] = destDir + File.separatorChar + javaFiles[pt++];
                ++i;
            }
            filesForCompile -= currentFilesForCompile;
            try {
                compiled = (Boolean)sun_tools_javac_Main_compile.invoke(main, new Object[]{cmd1});
            }
            catch (Exception exc) {
                compiled = false;
            }
            String errors = null;
            if (compiled) continue;
            errors = errStream.toString();
            throw new IOException("Error in compilation..." + errors);
        }
    }

    public void compile(String classPath, File dir) throws WSDLException, IOException {
        classPath = classPath != null ? classPath + File.pathSeparator + dir.getCanonicalPath() : dir.getCanonicalPath();
        classPath = classPath + File.pathSeparator + SystemProperties.getProperty((String)"java.class.path");
        this.traversThrough(classPath, dir);
    }

    public void compileExternal(String classPath, File workDir) throws IOException {
        this.traversThrough(classPath, workDir);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sun_tools_javac_Main_compile = null;
        sun_tools_javac_Main_constructor = null;
        try {
            Class<?> sun_tools_javac_Main_class = Class.forName("sun.tools.javac.Main");
            sun_tools_javac_Main_constructor = sun_tools_javac_Main_class.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = PackageBuilder.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = PackageBuilder.class$("java.lang.String")) : class$java$lang$String);
            sun_tools_javac_Main_compile = sun_tools_javac_Main_class.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = PackageBuilder.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream in;
        private OutputStream out;

        public StreamReader(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        public void run() {
            block13: {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                PrintStream output = new PrintStream(this.out, true);
                while ((line = reader.readLine()) != null) {
                    PrintStream printStream = output;
                    synchronized (printStream) {
                        void var1_3;
                        output.println((String)var1_3);
                    }
                }
                Object var7_7 = null;
                try {
                    this.in.close();
                }
                catch (Exception x) {}
                break block13;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var7_8 = null;
                        try {
                            this.in.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        this.in.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }
}

