/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.util;

import com.sap.engine.lib.xml.SystemProperties;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CodeGenerator {
    public static final int INDENT_TAB_SIZE = 2;
    public static final String END_LINE = SystemProperties.getProperty((String)"line.separator");
    public static final char SEPARATOR = '$';
    private String indentRepresentation;
    private int indentSize;
    private StringBuffer bufer;
    private String currentIndent;
    private int sectionNumber;
    private Hashtable replaceMapping;

    public void append(CodeGenerator generator) {
        String content = generator.toString();
        StringTokenizer tokenizer = new StringTokenizer(content, END_LINE);
        while (tokenizer.hasMoreElements()) {
            this.addLine(tokenizer.nextToken());
        }
    }

    public CodeGenerator() {
        this.indentSize = 2;
        this.indentRepresentation = this.getIndent(this.indentSize);
        this.bufer = new StringBuffer();
        this.sectionNumber = 0;
        this.currentIndent = "";
        this.replaceMapping = new Hashtable();
    }

    public CodeGenerator(int indent) {
        this.indentSize = indent;
        this.indentRepresentation = this.getIndent(this.indentSize);
        this.bufer = new StringBuffer();
        this.sectionNumber = 0;
        this.currentIndent = "";
        this.replaceMapping = new Hashtable();
    }

    public void clear(int indent) {
        this.indentSize = indent;
        this.indentRepresentation = this.getIndent(this.indentSize);
        this.bufer.setLength(0);
        this.sectionNumber = 0;
        this.currentIndent = "";
        this.replaceMapping.clear();
    }

    public void clear() {
        this.indentSize = 2;
        this.indentRepresentation = this.getIndent(this.indentSize);
        this.bufer.setLength(0);
        this.sectionNumber = 0;
        this.currentIndent = "";
        this.replaceMapping.clear();
    }

    private String getIndent(int indentSize) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < indentSize) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    private void shiftUpIndent() {
        this.currentIndent = this.indentRepresentation + this.currentIndent;
    }

    private void shiftDownIndent() {
        this.currentIndent = this.currentIndent.substring(this.indentSize);
    }

    public void startSection() {
        ++this.sectionNumber;
        this.shiftUpIndent();
    }

    public void endSection() {
        if (this.sectionNumber > 0) {
            --this.sectionNumber;
            this.shiftDownIndent();
        } else {
            System.err.println(" CodeGenerator Warning ! Incorrect section allignment !");
        }
    }

    public int getSectionCount() {
        return this.sectionNumber;
    }

    public void addLine(String line) {
        this.bufer.append(this.currentIndent).append(this.reEscapeString(line)).append(END_LINE);
    }

    public void addLine() {
        this.bufer.append(END_LINE);
    }

    public void addIndent() {
        this.bufer.append(this.currentIndent);
    }

    public void addNewLine() {
        this.bufer.append(END_LINE);
    }

    public void add(String content) {
        this.bufer.append(this.reEscapeString(content));
    }

    public void addComment(String comment) {
        this.addLine("// " + comment);
    }

    public String toString() {
        return this.bufer.toString();
    }

    public void registerName(String name, String content) {
        if (name.indexOf(36) != -1) {
            throw new IllegalArgumentException(" Can not regisrer name containing '%' in code generator !");
        }
        this.replaceMapping.put(name, content);
    }

    public boolean isRegistered(String name) {
        return this.replaceMapping.get(name) != null;
    }

    public void unRegisterName(String name) {
        this.replaceMapping.remove(name);
    }

    private String reEscapeString(String line) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(line, "$", true);
        String internalToken = null;
        boolean openEscape = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("$")) {
                if (openEscape) {
                    if (internalToken == null) {
                        result.append("$");
                        openEscape = false;
                        continue;
                    }
                    String content = (String)this.replaceMapping.get(internalToken);
                    if (content == null) {
                        throw new IllegalArgumentException("Code Generator can not replace '" + internalToken + "'");
                    }
                    result.append(content);
                    openEscape = false;
                    continue;
                }
                openEscape = true;
                internalToken = null;
                continue;
            }
            if (openEscape) {
                internalToken = token;
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        CodeGenerator generator = new CodeGenerator();
        generator.registerName("ready", "RATATR");
        System.out.println(generator.reEscapeString(" dieideihdei $$ $ready$ "));
    }

    public String getValue(String name) {
        return (String)this.replaceMapping.get(name);
    }
}

