/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.schema2java;

import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaMappingConstants;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.w3c.dom.Node;

final class SchemaToJavaGeneratorForSimpleTypes {
    private static final String THROWS_CLAUSE = "throws java.rmi.MarshalException";
    private SchemaToJavaGenerator s2j;
    private Hashtable baseSerializers;
    private CodeGenerator generator;
    private NameConvertor convertor;
    private boolean containerMode = false;
    public static final String F_LENGTH = "length";
    public static final String F_MINLENGTH = "minLength";
    public static final String F_MAXLENGTH = "maxLength";
    public static final String F_PATTERN = "pattern";
    public static final String F_WHITESPACE = "whiteSpace";
    public static final String F_MININCLUSIVE = "minInclusive";
    public static final String F_MINEXCLUSIVE = "minExclusive";
    public static final String F_MAXINCLUSIVE = "maxInclusive";
    public static final String F_MAXEXCLUSIVE = "maxExclusive";
    public static final String VALIDATOR_NAME = (class$com$sap$engine$services$webservices$jaxrpc$encoding$SimpleValidator == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$SimpleValidator = SchemaToJavaGeneratorForSimpleTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.SimpleValidator")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$SimpleValidator).getName();
    public static final String OUT_EXCEPTION = (class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlMarshalException == null ? (class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlMarshalException = SchemaToJavaGeneratorForSimpleTypes.class$("com.sap.engine.services.webservices.jaxrpc.exceptions.XmlMarshalException")) : class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlMarshalException).getName() + "(\"" + "webservices_3137" + "\"," + "_d_originalUri(),_d_originalLocalName())";
    public static final String IN_EXCEPTION = (class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlUnmarshalException == null ? (class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlUnmarshalException = SchemaToJavaGeneratorForSimpleTypes.class$("com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException")) : class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlUnmarshalException).getName() + "(\"" + "webservices_3138" + "\"," + "_d_originalUri(),_d_originalLocalName())";
    public static final int STRING_TYPE = 1;
    public static final int LONG_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$SimpleValidator;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlMarshalException;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$exceptions$XmlUnmarshalException;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$SimpleMetadata;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$ListSD;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$StringSD;

    public void setContainerMode(boolean flag) {
        this.containerMode = flag;
    }

    protected SchemaToJavaGeneratorForSimpleTypes(SchemaToJavaGenerator s2j) {
        this.s2j = s2j;
        this.generator = new CodeGenerator();
        this.convertor = new NameConvertor();
        this.baseSerializers = new Hashtable();
    }

    public void init() {
        this.baseSerializers.clear();
        this.convertor.clear();
        if (this.s2j.isGenericFrm()) {
            int i = 0;
            while (i < SchemaMappingConstants.BUILTIN_TYPES_JAXRPC11.length) {
                QName xmlType = new QName(SchemaMappingConstants.BUILTIN_TYPES_JAXRPC11[i], "http://www.w3.org/2001/XMLSchema");
                this.baseSerializers.put(xmlType, SchemaMappingConstants.DEFAULT_SERIALIZERS[i]);
                if (!xmlType.getLocalName().equals("anyType") && !xmlType.getLocalName().equals("anySimpleType")) {
                    xmlType = new QName(SchemaMappingConstants.BUILTIN_TYPES_JAXRPC11[i], "http://schemas.xmlsoap.org/soap/encoding/");
                    this.baseSerializers.put(xmlType, SchemaMappingConstants.DEFAULT_SERIALIZERS[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < TypeMappingRegistryImpl.primitiveTypes.length) {
                QName xmlType = new QName(TypeMappingRegistryImpl.primitiveTypes[i], "http://www.w3.org/2001/XMLSchema");
                this.baseSerializers.put(xmlType, TypeMappingRegistryImpl.serializerNames[i]);
                xmlType = new QName(TypeMappingRegistryImpl.primitiveTypes[i], "http://schemas.xmlsoap.org/soap/encoding/");
                this.baseSerializers.put(xmlType, TypeMappingRegistryImpl.serializerNames[i]);
                ++i;
            }
        }
    }

    protected String getBaseClassName(SimpleTypeDefinition simpleType, String className) {
        QName qname;
        String baseType;
        String name = simpleType.getName();
        String uri = simpleType.getTargetNamespace();
        if (name.length() == 0) {
            name = DOM.toXPath((Node)simpleType.getAssociatedDOMNode());
        }
        if ((baseType = (String)this.baseSerializers.get(qname = new QName(name, uri))) == null) {
            baseType = "com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedSimpleType";
        }
        this.baseSerializers.put(qname, className);
        return baseType;
    }

    protected void generateSimpleType(SimpleTypeDefinition t, String className, PrintStream out) {
        if (this.containerMode) {
            this.getBaseClassName(t, className);
            return;
        }
        this.generator.clear();
        if (t.isVarietyList()) {
            this.generateList(t, className, this.generator, this.convertor);
        } else {
            this.generateIt(t, className, this.generator, this.convertor);
        }
        out.print(this.generator.toString());
        out.close();
    }

    protected void generateList(SimpleTypeDefinition simpleType, String className, CodeGenerator generator, NameConvertor convertor) {
        SimpleTypeDefinition itemType;
        String itemName;
        String baseType = this.getBaseClassName(simpleType, className);
        String nonQualifiedClassName = convertor.getLocalClass(className);
        String packageName = convertor.getPackageClass(className);
        generator.clear();
        generator.addLine("/**");
        generator.addLine(" * Generated by SAP Schema-to-Java Generator");
        generator.addLine(" * " + new Date());
        generator.addLine(" * Chavdar Baikov (chavdar.baikov@sap.com)");
        generator.addLine(" */");
        if (packageName != null) {
            generator.addLine();
            generator.addLine("package " + packageName + ";");
        }
        generator.addLine();
        generator.addLine("import javax.xml.namespace.QName;");
        generator.addLine();
        if (this.s2j.isGenericFrm()) {
            generator.addLine("public class " + nonQualifiedClassName + " extends " + baseType + " implements " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$SimpleMetadata == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$SimpleMetadata = SchemaToJavaGeneratorForSimpleTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.SimpleMetadata")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$SimpleMetadata).getName() + " {");
        } else {
            generator.addLine("public class " + nonQualifiedClassName + " extends " + baseType + " {");
        }
        generator.startSection();
        generator.addLine("public " + nonQualifiedClassName + "() {");
        String name = simpleType.getName();
        if (name.length() == 0) {
            name = DOM.toXPath((Node)simpleType.getAssociatedDOMNode());
        }
        if ((itemName = (itemType = simpleType.getItemTypeDefinition()).getName()).length() == 0) {
            itemName = DOM.toXPath((Node)simpleType.getAssociatedDOMNode());
        }
        generator.addLine("  super(\"" + this.escapeString(simpleType.getTargetNamespace()) + "\",\"" + this.escapeString(name) + "\",\"" + this.escapeString(itemType.getTargetNamespace()) + "\",\"" + this.escapeString(itemName) + "\");");
        generator.addLine("}");
        this.generateOriginals(generator, (TypeDefinitionBase)simpleType);
        this.generateGetFacetMethod(generator, simpleType);
        generator.endSection();
        generator.addLine("}");
    }

    protected void generateIt(SimpleTypeDefinition simpleType, String className, CodeGenerator generator, NameConvertor convertor) {
        if (simpleType.isVarietyList()) {
            this.generateList(simpleType, className, generator, convertor);
            return;
        }
        String baseType = this.getBaseClassName(simpleType, className);
        String nonQualifiedClassName = convertor.getLocalClass(className);
        String packageName = convertor.getPackageClass(className);
        generator.clear();
        generator.addLine("/**");
        generator.addLine(" * Generated by SAP Schema-to-Java Generator");
        generator.addLine(" * " + new Date());
        generator.addLine(" * Chavdar Baikov (chavdar.baikov@sap.com)");
        generator.addLine(" */");
        if (packageName != null) {
            generator.addLine();
            generator.addLine("package " + packageName + ";");
        }
        generator.addLine();
        generator.addLine("import java.rmi.MarshalException;");
        generator.addLine("import java.rmi.UnmarshalException;");
        generator.addLine("import org.w3c.dom.Node;");
        generator.addLine("import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;");
        generator.addLine("import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;");
        generator.addLine("import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;");
        generator.addLine("import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;");
        generator.addLine();
        generator.addLine("public class " + nonQualifiedClassName + " extends " + baseType + " {");
        generator.startSection();
        this.generateOriginals(generator, (TypeDefinitionBase)simpleType);
        this.processFacets(generator, simpleType);
        this.generateGetFacetMethod(generator, simpleType);
        generator.endSection();
        generator.addLine("}");
    }

    protected void generateGetFacetMethod(CodeGenerator generator, SimpleTypeDefinition simpleType) {
        Facet[] facets = simpleType.getFacetsArray();
        generator.addLine("public com.sap.engine.services.webservices.espbase.client.dynamic.types.Facet[] _getFacets() {");
        generator.startSection();
        generator.addLine("com.sap.engine.services.webservices.espbase.client.dynamic.types.Facet[] result = new com.sap.engine.services.webservices.espbase.client.dynamic.types.Facet[" + facets.length + "];");
        int i = 0;
        while (i < facets.length) {
            generator.addLine("result[" + i + "] = new com.sap.engine.services.webservices.espbase.client.dynamic.types.Facet(\"" + this.escapeString(facets[i].getName()) + "\",\"" + this.escapeString(facets[i].getValue()) + "\");");
            ++i;
        }
        generator.addLine("return result;");
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        if (simpleType.isVarietyAtomic()) {
            generator.addLine("public int _getTypeVariant() {");
            generator.addLine("  return 0;");
            generator.addLine("}");
        }
        if (simpleType.isVarietyList()) {
            generator.addLine("public int _getTypeVariant() {");
            generator.addLine("  return 1;");
            generator.addLine("}");
        }
        if (simpleType.isVarietyUnion()) {
            generator.addLine("public int _getTypeVariant() {");
            generator.addLine("  return 0;");
            generator.addLine("}");
        }
    }

    private String escapeString(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\'') {
                result.append("\\'");
            } else if (s.charAt(i) == '\"') {
                result.append("\\\"");
            } else if (s.charAt(i) == '\\') {
                result.append("\\\\");
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    protected void generateOriginals(CodeGenerator generator, TypeDefinitionBase t) {
        String name = t.getName();
        String tns = t.getTargetNamespace();
        generator.addLine("public java.lang.String _d_originalLocalName() {");
        generator.startSection();
        generator.addIndent();
        generator.add("return \"");
        if (name.length() == 0) {
            if (this.s2j.isGenericFrm()) {
                generator.add("\";");
            } else {
                generator.add(DOM.toXPath((Node)t.getAssociatedDOMNode()) + "\"; // it was an anonymous type");
            }
        } else {
            generator.add(name + "\";");
        }
        generator.addNewLine();
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public java.lang.String _d_originalUri() {");
        generator.startSection();
        generator.addLine("return \"" + tns + "\";");
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
    }

    private int getType(SimpleTypeDefinition simpleType) {
        while (simpleType != null && !"http://www.w3.org/2001/XMLSchema".equals(simpleType.getTargetNamespace())) {
            if (simpleType.isBuiltIn() || simpleType == simpleType.getBaseTypeDefinitionSimple()) break;
            simpleType = simpleType.getBaseTypeDefinitionSimple();
        }
        int result = 0;
        if (simpleType != null) {
            if ("boolean".equals(simpleType.getName())) {
                return 3;
            }
            if ("string".equals(simpleType.getName())) {
                return 1;
            }
            if ("normalizedString".equals(simpleType.getName())) {
                return 1;
            }
            if ("token".equals(simpleType.getName())) {
                return 1;
            }
            if ("long".equals(simpleType.getName())) {
                return 2;
            }
            if ("byte".equals(simpleType.getName())) {
                return 2;
            }
            if ("short".equals(simpleType.getName())) {
                return 2;
            }
            if ("int".equals(simpleType.getName())) {
                return 2;
            }
            if ("unsignedLong".equals(simpleType.getName())) {
                return 2;
            }
            if ("unsignedInt".equals(simpleType.getName())) {
                return 2;
            }
            if ("unsignedShort".equals(simpleType.getName())) {
                return 2;
            }
            if ("unsignedByte".equals(simpleType.getName())) {
                return 2;
            }
        }
        return result;
    }

    private void processFacets(CodeGenerator generator, SimpleTypeDefinition simpleType) {
        SimpleTypeDefinition base;
        Facet pattern;
        Facet[] facets;
        int type = this.getType(simpleType);
        generator.addLine("public java.lang.Object deserialize(java.lang.String content, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {");
        generator.startSection();
        generator.addLine("java.lang.Object result = super.deserialize(content,context,resultClass);");
        if (type == 1) {
            this.processString(generator, simpleType, "result", IN_EXCEPTION);
        }
        if (type == 2) {
            this.processLong(generator, simpleType, "result", IN_EXCEPTION);
        }
        generator.addLine("return result;");
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public java.lang.Object deserialize(XMLTokenReader reader, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {");
        generator.startSection();
        generator.addLine("java.lang.Object result = super.deserialize(reader,context,resultClass);");
        if (type == 1) {
            this.processString(generator, simpleType, "result", IN_EXCEPTION);
        }
        if (type == 2) {
            this.processLong(generator, simpleType, "result", IN_EXCEPTION);
        }
        generator.addLine("return result;");
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public java.lang.Object deserialize(Node node, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {");
        generator.startSection();
        generator.addLine("java.lang.Object result = super.deserialize(node,context,resultClass);");
        if (type == 1) {
            this.processString(generator, simpleType, "result", IN_EXCEPTION);
        }
        if (type == 2) {
            this.processLong(generator, simpleType, "result", IN_EXCEPTION);
        }
        generator.addLine("return result;");
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public java.lang.String serialize(java.lang.Object obj, SOAPSerializationContext context) throws MarshalException {");
        generator.startSection();
        if (type == 1) {
            this.processString(generator, simpleType, "obj", OUT_EXCEPTION);
        }
        if (type == 2) {
            this.processLong(generator, simpleType, "obj", OUT_EXCEPTION);
        }
        if (type == 3) {
            this.processBooleanS("super.serialize(obj, context);", generator, simpleType, true);
        } else {
            if (simpleType.isVarietyAtomic()) {
                facets = simpleType.getFacetsArray();
                pattern = this.getFacet(facets, F_PATTERN);
                base = simpleType.getBaseTypeDefinitionSimple();
                if (pattern != null && base.isBuiltIn() && base.getName().equals("time") && "[^:]{2}:[^:]{2}:[^:]{2}".equals(pattern.getValue())) {
                    generator.addLine("context.setProperty(SPECIAL_TIME,\"yes\");");
                }
            }
            generator.addLine("return super.serialize(obj, context);");
        }
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public void serialize(java.lang.Object obj, XMLTokenWriter writer, SOAPSerializationContext context) throws MarshalException, java.io.IOException {");
        generator.startSection();
        if (type == 1) {
            this.processString(generator, simpleType, "obj", OUT_EXCEPTION);
        }
        if (type == 2) {
            this.processLong(generator, simpleType, "obj", OUT_EXCEPTION);
        }
        if (type == 3) {
            this.processBooleanS("super.serialize(obj, writer, context);", generator, simpleType, false);
        } else {
            if (simpleType.isVarietyAtomic()) {
                facets = simpleType.getFacetsArray();
                pattern = this.getFacet(facets, F_PATTERN);
                base = simpleType.getBaseTypeDefinitionSimple();
                if (pattern != null && base.isBuiltIn() && base.getName().equals("time") && "[^:]{2}:[^:]{2}:[^:]{2}".equals(pattern.getValue())) {
                    generator.addLine("context.setProperty(SPECIAL_TIME,\"yes\");");
                }
            }
            generator.addLine("super.serialize(obj, writer, context);");
        }
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public void serialize(java.lang.Object obj, Node node, SOAPSerializationContext context) throws MarshalException {");
        generator.startSection();
        if (type == 1) {
            this.processString(generator, simpleType, "obj", OUT_EXCEPTION);
        }
        if (type == 2) {
            this.processLong(generator, simpleType, "obj", OUT_EXCEPTION);
        }
        if (type == 3) {
            this.processBooleanS("super.serialize(obj, node, context);", generator, simpleType, false);
        } else {
            if (simpleType.isVarietyAtomic()) {
                facets = simpleType.getFacetsArray();
                pattern = this.getFacet(facets, F_PATTERN);
                base = simpleType.getBaseTypeDefinitionSimple();
                if (pattern != null && base.isBuiltIn() && base.getName().equals("time") && "[^:]{2}:[^:]{2}:[^:]{2}".equals(pattern.getValue())) {
                    generator.addLine("context.setProperty(SPECIAL_TIME,\"yes\");");
                }
            }
            generator.addLine("super.serialize(obj, node, context);");
        }
        generator.endSection();
        generator.addLine("}");
    }

    private void processLong(CodeGenerator generator, SimpleTypeDefinition simpleType, String varName, String exception) {
        if (simpleType.isVarietyAtomic()) {
            Facet[] facets = simpleType.getFacetsArray();
            Facet facet = null;
            facet = this.getFacet(facets, F_MAXEXCLUSIVE);
            if (facet != null) {
                this.generateMaxExclusive(varName, facet.getValue(), exception, generator);
            }
            if ((facet = this.getFacet(facets, F_MAXINCLUSIVE)) != null) {
                this.generateMaxInclusive(varName, facet.getValue(), exception, generator);
            }
            if ((facet = this.getFacet(facets, F_MINEXCLUSIVE)) != null) {
                this.generateMinExclusive(varName, facet.getValue(), exception, generator);
            }
            if ((facet = this.getFacet(facets, F_MININCLUSIVE)) != null) {
                this.generateMinInclusive(varName, facet.getValue(), exception, generator);
            }
        }
    }

    private void processBooleanS(String superCall, CodeGenerator generator, SimpleTypeDefinition simpleType, boolean result) {
        Facet[] facets;
        Facet pattern;
        if (simpleType.isVarietyAtomic() && (pattern = this.getFacet(facets = simpleType.getFacetsArray(), F_PATTERN)) != null && ("0|1".equals(pattern.getValue()) || "1|0".equals(pattern.getValue()))) {
            generator.addLine("context.setProperty(\"specialBoolean\",\"yes\");");
            if (result) {
                generator.addLine("java.lang.String perm = " + superCall + ";");
            } else {
                generator.addLine(superCall);
            }
            generator.addLine("context.removeProperty(\"specialBoolean\");");
            if (result) {
                generator.addLine("return perm;");
            }
            return;
        }
        if (result) {
            generator.addLine("return " + superCall);
        } else {
            generator.addLine(superCall);
        }
    }

    private void processString(CodeGenerator generator, SimpleTypeDefinition simpleType, String varName, String exception) {
        if (simpleType.isVarietyAtomic()) {
            Facet maxLength;
            Facet minLength;
            Facet length;
            Facet pattern;
            Facet[] facets = simpleType.getFacetsArray();
            Facet whiteSpace = this.getFacet(facets, F_WHITESPACE);
            if (whiteSpace != null) {
                this.generateWhiteSpace(varName, whiteSpace.getValue(), generator);
            }
            if ((pattern = this.getFacet(facets, F_PATTERN)) != null) {
                // empty if block
            }
            if ((length = this.getFacet(facets, F_LENGTH)) != null) {
                this.generateLengthString(varName, length.getValue(), exception, generator);
            }
            if ((minLength = this.getFacet(facets, F_MINLENGTH)) != null) {
                this.generateMinLengthString(varName, minLength.getValue(), exception, generator);
            }
            if ((maxLength = this.getFacet(facets, F_MAXLENGTH)) != null) {
                this.generateMaxLengthString(varName, maxLength.getValue(), exception, generator);
            }
        }
    }

    private void generateLengthString(String varName, String length, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkLengthString(" + varName + "," + length + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateMinLengthString(String varName, String length, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkMinLengthString(" + varName + "," + length + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateMaxLengthString(String varName, String length, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkMaxLengthString(" + varName + "," + length + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generatePatternString(String varName, String pattern, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".validatePattern(" + varName + ",\"" + pattern + "\") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateMinInclusive(String varName, String min, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkMinInclusive(" + varName + "," + min + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateMinExclusive(String varName, String min, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkMinExclusive(" + varName + "," + min + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateMaxInclusive(String varName, String max, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkMaxInclusive(" + varName + "," + max + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateMaxExclusive(String varName, String max, String exception, CodeGenerator generator) {
        generator.addLine(" if (" + VALIDATOR_NAME + ".checkMaxExclusive(" + varName + "," + max + ") == false) {");
        generator.addLine("   throw new " + exception + ";");
        generator.addLine(" }");
    }

    private void generateWhiteSpace(String varName, String wspace, CodeGenerator generator) {
        if ("replace".equals(wspace)) {
            generator.addLine(varName + " = " + VALIDATOR_NAME + ".getReplace(" + varName + ");");
        }
        if ("collapse".equals(wspace)) {
            generator.addLine(varName + " = " + VALIDATOR_NAME + ".getCollapse(" + varName + ");");
        }
    }

    protected Facet getFacet(Facet[] facets, String facetName) {
        int i = 0;
        while (i < facets.length) {
            if (facets[i].getName().equals(facetName)) {
                return facets[i];
            }
            ++i;
        }
        return null;
    }

    public int getResolved(ArrayList simpleTypes, ArrayList classNames) throws SchemaToJavaGeneratorException {
        int i = 0;
        while (i < simpleTypes.size()) {
            QName qname;
            SimpleTypeDefinition type = (SimpleTypeDefinition)simpleTypes.get(i);
            String name = type.getName();
            String uri = type.getTargetNamespace();
            if (name.length() == 0) {
                name = DOM.toXPath((Node)type.getAssociatedDOMNode());
            }
            if (this.baseSerializers.get(qname = new QName(name, uri)) != null) {
                return i;
            }
            SimpleTypeDefinition parentType = null;
            if (type.isVarietyList()) {
                this.baseSerializers.put(qname, (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$ListSD == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$ListSD = SchemaToJavaGeneratorForSimpleTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.ListSD")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$ListSD).getName());
                return i;
            }
            if (type.isVarietyAtomic()) {
                parentType = type.getBaseTypeDefinitionSimple();
            } else if (type.isVarietyUnion()) {
                this.baseSerializers.put(qname, (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$StringSD == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$StringSD = SchemaToJavaGeneratorForSimpleTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.StringSD")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$StringSD).getName());
                return i;
            }
            if (parentType != null) {
                QName pqname;
                String pname = parentType.getName();
                String pUri = parentType.getTargetNamespace();
                if (pname.length() == 0) {
                    pname = DOM.toXPath((Node)parentType.getAssociatedDOMNode());
                }
                if (this.baseSerializers.get(pqname = new QName(pname, pUri)) != null) {
                    String baseSerializer = (String)this.baseSerializers.get(pqname);
                    this.baseSerializers.put(qname, baseSerializer);
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

