/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.schema2java;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.services.webservices.jaxrpc.encoding.AttributeInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo;
import com.sap.engine.services.webservices.jaxrpc.schema2java.MGCounter;
import com.sap.engine.services.webservices.jaxrpc.schema2java.NameCollisionResolver;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SoapArrayInfo;
import com.sap.engine.services.webservices.jaxrpc.util.CodeGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.w3c.dom.Node;

final class SchemaToJavaGeneratorForComplexTypes {
    private boolean smart_mode = false;
    private boolean containerMode = false;
    private CodeGenerator generator = new CodeGenerator();
    private NameConvertor convertor = new NameConvertor();
    private ArrayList fieldInfo = new ArrayList();
    private ArrayList attributeInfo = new ArrayList();
    private static final String BASEGROUP = "com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedModelGroup";
    private static final String BASECOMPLEX = "com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedComplexType";
    private SchemaToJavaGenerator s2j;
    private NameCollisionResolver nameCollisionResolver = new NameCollisionResolver();
    private Hashtable typeFieldInfo = new Hashtable();
    private Hashtable typeAttributeInfo = new Hashtable();
    private Particle pp = null;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public void useSmartMode(boolean mode) {
        this.smart_mode = mode;
    }

    protected SchemaToJavaGeneratorForComplexTypes(SchemaToJavaGenerator s2j) {
        this.s2j = s2j;
    }

    public void clearMetaData() {
        this.typeAttributeInfo.clear();
        this.typeFieldInfo.clear();
    }

    public void setContainerMode(boolean mode) {
        this.containerMode = mode;
    }

    public Hashtable getTypeFieldInfo() {
        return this.typeFieldInfo;
    }

    public Hashtable getTypeAttributeInfo() {
        return this.typeAttributeInfo;
    }

    private void generateComments(CodeGenerator generator) {
        generator.addLine("/**");
        generator.addLine(" * Generated by SAP Schema-to-Java Generator v2.0 on " + new Date());
        generator.addLine(" * Copyright (c) 2002 by SAP Labs Sofia AG.");
        generator.addLine(" * url: http://www.saplabs.bg");
        generator.addLine(" * All rights reserved.");
        generator.addLine(" */");
    }

    private void generateImports(CodeGenerator generator) {
        generator.addLine();
    }

    private void addAttribute(ArrayList atributeInfo, AttributeUse attrib) {
        AttributeInfo attributefield = new AttributeInfo();
        attributefield.required = attrib.isRequired();
        AttributeDeclaration attribdecl = attrib.getAttributeDeclaration();
        TypeDefinitionBase ftd = attribdecl.getTypeDefinition();
        if (ftd == null) {
            attributefield.typeJavaName = "java.lang.Object";
        } else {
            attributefield.typeUri = ftd.getTargetNamespace();
            attributefield.typeName = ftd.getName() == null || ftd.getName().length() == 0 ? DOM.toXPath((Node)ftd.getAssociatedDOMNode()) : ftd.getName();
            attributefield.typeJavaName = ftd instanceof SimpleTypeDefinition ? this.s2j.getJavaPrimitive((TypeDefinitionBase)((SimpleTypeDefinition)ftd)) : this.s2j.getJavaPrimitive(ftd);
        }
        attributefield.defaultValue = attribdecl.getValueConstraintDefault();
        attributefield.defaultValue = attrib.getValueConstraintDefault();
        attributefield.fieldLocalName = attribdecl.getName();
        attributefield.fieldUri = attribdecl.getTargetNamespace();
        attributefield.fieldJavaName = this.convertor.attributeToClassName(attribdecl.getName());
        if ("Class".equals(attributefield.fieldJavaName)) {
            attributefield.fieldJavaName = attributefield.fieldJavaName + "Attribute";
        }
        attributefield.setterMethod = "set" + attributefield.fieldJavaName;
        attributefield.getterMethod = "get" + attributefield.fieldJavaName;
        attributefield.checkMethod = "has" + attributefield.fieldJavaName;
        this.attributeInfo.add(attributefield);
    }

    private void generateCommonMethods(ComplexTypeDefinition ctd, CodeGenerator generator) {
        String name = ctd.getName();
        if (name == null) {
            name = "";
        }
        generator.addLine();
        generator.addLine("public java.lang.String _d_originalUri() {");
        generator.addLine("  return \"" + ctd.getTargetNamespace() + "\";");
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public java.lang.String _d_originalLocalName() {");
        generator.addLine("  return \"" + name + "\";");
        generator.addLine("}");
        generator.addLine();
    }

    private String escapeString(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                result.append("\\\\");
            } else if (s.charAt(i) == '\"') {
                result.append("\\\"");
            } else {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    private String packString(String s) {
        if (s == null) {
            return "null";
        }
        return "\"" + this.escapeString(s) + "\"";
    }

    private void generateAttributeInfo(ArrayList attributeInfo, CodeGenerator generator) {
        generator.addLine("private static com.sap.engine.services.webservices.jaxrpc.encoding.AttributeInfo[] ATTRIBUTEINFO;");
        generator.addLine();
        generator.addLine("private synchronized static void initAttribs() {");
        generator.startSection();
        generator.addComment("Creating attribute fields");
        generator.addLine("if (ATTRIBUTEINFO != null) return;");
        generator.addLine("ATTRIBUTEINFO = new com.sap.engine.services.webservices.jaxrpc.encoding.AttributeInfo[" + attributeInfo.size() + "];");
        int j = 0;
        while (j < attributeInfo.size()) {
            generator.addLine("ATTRIBUTEINFO[" + j + "] = new com.sap.engine.services.webservices.jaxrpc.encoding.AttributeInfo();");
            ++j;
        }
        int i = 0;
        while (i < attributeInfo.size()) {
            AttributeInfo attrib = (AttributeInfo)attributeInfo.get(i);
            generator.addComment("Attribute " + i);
            generator.addLine("ATTRIBUTEINFO[" + i + "].fieldLocalName = " + this.packString(attrib.fieldLocalName) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].fieldUri = " + this.packString(attrib.fieldUri) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].fieldJavaName = " + this.packString(attrib.fieldJavaName) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].typeName = " + this.packString(attrib.typeName) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].typeUri = " + this.packString(attrib.typeUri) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].typeJavaName = " + this.packString(attrib.typeJavaName) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].defaultValue = " + this.packString(attrib.defaultValue) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].required = " + attrib.required + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].setterMethod = " + this.packString(attrib.setterMethod) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].getterMethod = " + this.packString(attrib.getterMethod) + ";");
            generator.addLine("ATTRIBUTEINFO[" + i + "].checkMethod = " + this.packString(attrib.checkMethod) + ";");
            ++i;
        }
        generator.endSection();
        generator.addLine("}");
    }

    private void generateFieldInfo(ArrayList fieldInfo, CodeGenerator generator, String parentClass) {
        generator.addComment("Field information");
        generator.addLine("private static " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo = SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo).getName() + "[] FIELDINFO;");
        generator.addLine();
        generator.addLine("private synchronized static void initFields() {");
        generator.startSection();
        generator.addComment("Creating fields");
        generator.addLine("if (FIELDINFO != null) return;");
        generator.addLine("FIELDINFO = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo = SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo).getName() + "[" + fieldInfo.size() + "];");
        int j = 0;
        while (j < fieldInfo.size()) {
            generator.addLine("FIELDINFO[" + j + "] = new " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo == null ? SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo") : class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo).getName() + "();");
            ++j;
        }
        int i = 0;
        while (i < fieldInfo.size()) {
            FieldInfo field = (FieldInfo)fieldInfo.get(i);
            generator.addComment("Field " + i);
            generator.addLine("FIELDINFO[" + i + "].defaultValue = " + this.packString(field.defaultValue) + ";");
            generator.addLine("FIELDINFO[" + i + "].fieldJavaName = " + this.packString(field.fieldJavaName) + ";");
            generator.addLine("FIELDINFO[" + i + "].fieldLocalName = " + this.packString(field.fieldLocalName) + ";");
            generator.addLine("FIELDINFO[" + i + "].fieldModel = " + field.fieldModel + ";");
            generator.addLine("FIELDINFO[" + i + "].fieldUri = " + this.packString(field.fieldUri) + ";");
            generator.addLine("FIELDINFO[" + i + "].isSoapArray = " + field.isSoapArray + ";");
            generator.addLine("FIELDINFO[" + i + "].maxOccurs = " + field.maxOccurs + ";");
            generator.addLine("FIELDINFO[" + i + "].minOccurs = " + field.minOccurs + ";");
            generator.addLine("FIELDINFO[" + i + "].nillable = " + field.nillable + ";");
            generator.addLine("FIELDINFO[" + i + "].soapArrayDimensions = " + field.soapArrayDimensions + ";");
            generator.addLine("FIELDINFO[" + i + "].soapArrayItemTypeJavaName = " + this.packString(field.soapArrayItemTypeJavaName) + ";");
            generator.addLine("FIELDINFO[" + i + "].soapArrayItemTypeLocalName = " + this.packString(field.soapArrayItemTypeLocalName) + ";");
            generator.addLine("FIELDINFO[" + i + "].soapArrayItemTypeUri = " + this.packString(field.soapArrayItemTypeUri) + ";");
            if (field.fieldModel != 0 && field.fieldModel != 1 && field.fieldModel != 5 && this.s2j.isGenericFrm()) {
                generator.addLine("FIELDINFO[" + i + "].typeJavaName = " + this.packString((class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject == null ? SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.espbase.client.dynamic.content.GenericObject") : class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject).getName()) + ";");
            } else {
                generator.addLine("FIELDINFO[" + i + "].typeJavaName = " + this.packString(field.typeJavaName) + ";");
            }
            generator.addLine("FIELDINFO[" + i + "].typeLocalName = " + this.packString(field.typeLocalName) + ";");
            generator.addLine("FIELDINFO[" + i + "].typeUri = " + this.packString(field.typeUri) + ";");
            generator.addLine("FIELDINFO[" + i + "].getterMethod = " + this.packString(field.getterMethod) + ";");
            generator.addLine("FIELDINFO[" + i + "].setterMethod = " + this.packString(field.setterMethod) + ";");
            generator.addLine("FIELDINFO[" + i + "].checkMethod = " + this.packString(field.checkMethod) + ";");
            if (field.fieldModel != 0 && field.fieldModel != 1 && field.fieldModel != 5) {
                generator.addLine("FIELDINFO[" + i + "].objectValue = new " + field.typeJavaName + "();");
            }
            ++i;
        }
        generator.endSection();
        generator.addLine("}");
        generator.addLine();
    }

    private void initFields(CodeGenerator generator) {
        generator.addLine("static {");
        generator.addLine("  initFields();");
        generator.addLine("}");
    }

    private void initAll(CodeGenerator generator) {
        generator.addLine("static {");
        generator.addLine("  initFields();");
        generator.addLine("  initAttribs();");
        generator.addLine("}");
    }

    private void addFieldElement(ArrayList fieldInfo, ElementDeclaration element, Particle p) {
        SoapArrayInfo sai;
        FieldInfo field = new FieldInfo();
        field.fieldUri = element.getTargetNamespace();
        field.fieldLocalName = element.getName();
        field.fieldModel = 1;
        field.fieldJavaName = this.convertor.attributeToClassName(element.getName());
        if ("Class".equals(field.fieldJavaName)) {
            field.fieldJavaName = field.fieldJavaName + "Element";
        }
        int size = fieldInfo.size();
        int reps = 0;
        int i = 0;
        while (i < size) {
            FieldInfo cf = (FieldInfo)fieldInfo.get(i);
            if (cf.fieldModel == 1 && cf.fieldLocalName != null && cf.fieldLocalName.equals(field.fieldLocalName)) {
                ++reps;
            }
            ++i;
        }
        if (reps == 1) {
            field.fieldJavaName = "Second" + field.fieldJavaName;
        }
        if (reps == 2) {
            field.fieldJavaName = "Third" + field.fieldJavaName;
        }
        field.setterMethod = "set" + field.fieldJavaName;
        field.getterMethod = "get" + field.fieldJavaName;
        field.checkMethod = "has" + field.fieldJavaName;
        field.defaultValue = element.getValueConstraintDefault();
        TypeDefinitionBase fieldTypeDefinition = element.getTypeDefinition();
        field.typeJavaName = "java.lang.Object";
        if (fieldTypeDefinition != null) {
            field.typeUri = fieldTypeDefinition.getTargetNamespace();
            field.typeLocalName = fieldTypeDefinition.getName() == null || fieldTypeDefinition.getName().length() == 0 ? DOM.toXPath((Node)fieldTypeDefinition.getAssociatedDOMNode()) : fieldTypeDefinition.getName();
            field.typeJavaName = this.s2j.getJavaPrimitive(fieldTypeDefinition);
        }
        field.nillable = element.isNillable();
        if (field.nillable && SchemaToJavaGenerator.JAXRPC_WRAPPER_CLASS.containsKey(field.typeJavaName)) {
            field.typeJavaName = (String)SchemaToJavaGenerator.JAXRPC_WRAPPER_CLASS.get(field.typeJavaName);
        }
        field.minOccurs = p == null ? 1 : p.getMinOccurs();
        int n = field.maxOccurs = p == null ? 1 : p.getMaxOccurs();
        if (this.smart_mode && field.minOccurs == 0 && field.maxOccurs == 1 && SchemaToJavaGenerator.JAXRPC_WRAPPER_CLASS.containsKey(field.typeJavaName)) {
            field.typeJavaName = (String)SchemaToJavaGenerator.JAXRPC_WRAPPER_CLASS.get(field.typeJavaName);
        }
        boolean bl = field.isSoapArray = (sai = this.s2j.getSoapArrayInfo(fieldTypeDefinition)) != null;
        if (field.isSoapArray) {
            TypeDefinitionBase it = sai.getItemType();
            field.soapArrayDimensions = sai.getDimensions();
            field.soapArrayItemTypeJavaName = this.s2j.getJavaPrimitive(it);
            field.soapArrayItemTypeLocalName = it.getName();
            field.soapArrayItemTypeUri = it.getTargetNamespace();
        }
        fieldInfo.add(field);
    }

    private void generateAttributeInfoMethods(CodeGenerator generator) {
        generator.addLine();
        generator.addLine("public com.sap.engine.services.webservices.jaxrpc.encoding.AttributeInfo[] _getAttributes() {");
        generator.addLine("  return ATTRIBUTEINFO;");
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public int _getNumberOfAttributes() {");
        generator.addLine("  return ATTRIBUTEINFO.length;");
        generator.addLine("}");
    }

    private void generateFieldInfoMethods(CodeGenerator generator, boolean mg) {
        generator.addLine();
        if (mg) {
            generator.addLine("public " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo = SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo).getName() + "[] _getFields() {");
            generator.addLine("  return FIELDINFO;");
            generator.addLine("}");
        } else {
            generator.addLine("private static boolean init = false;");
            generator.addLine("public synchronized " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo = SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo).getName() + "[] _getFields() {");
            generator.addLine("  if (init == false) {");
            generator.addLine("    " + (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo = SchemaToJavaGeneratorForComplexTypes.class$("com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$FieldInfo).getName() + "[] parent = super._getFields();");
            generator.addLine("    FIELDINFO =  _insertFieldInfo(parent,FIELDINFO);");
            generator.addLine("    init = true;");
            generator.addLine("  }");
            generator.addLine("  return FIELDINFO;");
            generator.addLine("}");
        }
        generator.addLine();
        generator.addLine("public int _getNumberOfFields() {");
        generator.addLine("  return (FIELDINFO.length+super._getNumberOfFields());");
        generator.addLine("}");
    }

    private void processModelGroup(ArrayList fieldInfo, ModelGroup mg, Particle particle, int number) throws SchemaToJavaGeneratorException {
        CodeGenerator modelCode = new CodeGenerator();
        String extendedClass = BASEGROUP;
        String className = "Noname";
        int kind = 0;
        if (mg.isCompositorAll()) {
            className = "All";
            kind = 4;
        }
        if (mg.isCompositorChoice()) {
            className = "Choice";
            kind = 2;
        }
        if (mg.isCompositorSequence()) {
            className = "Sequence";
            kind = 3;
        }
        FieldInfo field = new FieldInfo();
        field.fieldJavaName = className + "Group";
        if (this.s2j.isGenericFrm()) {
            field.fieldJavaName = className;
        }
        if (number != 0) {
            className = className + String.valueOf(number);
            field.fieldJavaName = field.fieldJavaName + String.valueOf(number);
        }
        field.fieldModel = kind;
        field.typeJavaName = className;
        field.checkMethod = "has" + field.fieldJavaName;
        field.setterMethod = "set" + field.fieldJavaName;
        field.getterMethod = "get" + field.fieldJavaName;
        field.minOccurs = particle == null ? 1 : particle.getMinOccurs();
        field.maxOccurs = particle == null ? 1 : particle.getMaxOccurs();
        field.objectValue = modelCode;
        modelCode.startSection();
        modelCode.addLine("public static class " + className + " extends " + extendedClass + " {");
        modelCode.startSection();
        modelCode.addLine();
        modelCode.addLine("public " + className + "() {");
        modelCode.addLine("}");
        modelCode.addLine();
        ArrayList modelFieldInfo = new ArrayList();
        MGCounter mgcounter = new MGCounter();
        Particle[] pa = mg.getParticlesArray();
        int i = 0;
        while (i < pa.length) {
            if (this.pp != pa[i]) {
                this.searchContent(modelFieldInfo, pa[i], 1, mgcounter);
            } else {
                this.fillCounter(pa[i], 1, mgcounter);
            }
            ++i;
        }
        if (!this.containerMode) {
            this.generateType(modelCode, kind);
            modelCode.addLine();
            this.generateFieldInfo(modelFieldInfo, modelCode, null);
            modelCode.addLine();
        }
        this.generateSetGet(modelFieldInfo, null, modelCode, kind);
        if (!this.containerMode) {
            this.generateFieldInfoMethods(modelCode, true);
            modelCode.addLine();
            this.initFields(modelCode);
        }
        modelCode.endSection();
        modelCode.addLine("}");
        modelCode.endSection();
        fieldInfo.add(field);
    }

    private void fillCounter(Particle p, int level, MGCounter mgCounter) {
        Base term;
        if (p == null) {
            return;
        }
        if (mgCounter == null) {
            mgCounter = new MGCounter();
        }
        if ((term = p.getTerm()) instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)term;
            if (level == 0) {
                Particle[] pa = mg.getParticlesArray();
                int i = 0;
                while (i < pa.length) {
                    this.fillCounter(pa[i], level + 1, mgCounter);
                    ++i;
                }
            } else if (p.getMaxOccurs() == 1 && p.getMinOccurs() == 1 && mg.isCompositorSequence()) {
                Particle[] pa = mg.getParticlesArray();
                int i = 0;
                while (i < pa.length) {
                    this.fillCounter(pa[i], level + 1, mgCounter);
                    ++i;
                }
            } else {
                if (mg.isCompositorAll()) {
                    ++mgCounter.allCount;
                }
                if (mg.isCompositorChoice()) {
                    ++mgCounter.choiceCount;
                }
                if (mg.isCompositorSequence()) {
                    ++mgCounter.sequenceCount;
                }
            }
        }
    }

    private void searchContent(ArrayList fieldInfo, Particle p, int level, MGCounter mgCounter) throws SchemaToJavaGeneratorException {
        Base term;
        if (p == null) {
            return;
        }
        if (mgCounter == null) {
            mgCounter = new MGCounter();
        }
        if ((term = p.getTerm()) instanceof ModelGroupDefinition) {
            ModelGroupDefinition mdg = (ModelGroupDefinition)term;
            term = mdg.getModelGroup();
        }
        if (term instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)term;
            if (level == 0 && p.getMinOccurs() == 1 && p.getMinOccurs() == 1) {
                Particle[] pa = mg.getParticlesArray();
                int i = 0;
                while (i < pa.length) {
                    if (this.pp != pa[i]) {
                        if (mg.isCompositorSequence()) {
                            this.searchContent(fieldInfo, pa[i], level, mgCounter);
                        } else {
                            this.searchContent(fieldInfo, pa[i], level, mgCounter);
                        }
                    } else {
                        this.fillCounter(pa[i], level + 1, mgCounter);
                    }
                    ++i;
                }
            } else if (p.getMaxOccurs() == 1 && p.getMinOccurs() == 1 && mg.isCompositorSequence()) {
                Particle[] pa = mg.getParticlesArray();
                int i = 0;
                while (i < pa.length) {
                    if (this.pp != pa[i]) {
                        this.searchContent(fieldInfo, pa[i], level, mgCounter);
                    } else {
                        this.fillCounter(pa[i], level, mgCounter);
                    }
                    ++i;
                }
            } else {
                if (mg.isCompositorAll()) {
                    ++mgCounter.allCount;
                    this.processModelGroup(fieldInfo, mg, p, mgCounter.allCount);
                }
                if (mg.isCompositorChoice()) {
                    ++mgCounter.choiceCount;
                    this.processModelGroup(fieldInfo, mg, p, mgCounter.choiceCount);
                }
                if (mg.isCompositorSequence()) {
                    ++mgCounter.sequenceCount;
                    this.processModelGroup(fieldInfo, mg, p, mgCounter.sequenceCount);
                }
            }
        } else if (term instanceof ElementDeclaration) {
            ElementDeclaration ed = (ElementDeclaration)term;
            this.addFieldElement(fieldInfo, ed, p);
        } else if (term instanceof Wildcard) {
            Wildcard wc = (Wildcard)term;
            this.addWildCard(fieldInfo, wc, p);
        }
    }

    private void addWildCard(ArrayList fieldInfo, Wildcard wc, Particle p) {
        FieldInfo field = new FieldInfo();
        field.fieldUri = "";
        field.fieldLocalName = "";
        field.fieldModel = 5;
        field.fieldJavaName = "_any";
        field.setterMethod = "set" + field.fieldJavaName;
        field.getterMethod = "get" + field.fieldJavaName;
        field.checkMethod = "has" + field.fieldJavaName;
        field.defaultValue = null;
        field.typeJavaName = this.s2j.isGenericFrm() ? (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SchemaToJavaGeneratorForComplexTypes.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).getName() : (class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = SchemaToJavaGeneratorForComplexTypes.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement).getName();
        field.typeUri = "http://www.w3.org/2001/XMLSchema";
        field.typeLocalName = "anyType";
        field.nillable = false;
        field.minOccurs = p == null ? 1 : p.getMinOccurs();
        field.maxOccurs = p == null ? 1 : p.getMaxOccurs();
        field.isSoapArray = false;
        fieldInfo.add(field);
    }

    public void generateType(CodeGenerator generator, int kind) {
        generator.addComment("Returns model Group Type");
        generator.addLine("public int _getModelType() {");
        generator.addLine("  return " + kind + ";");
        generator.addLine("}");
    }

    public void loadComplexType(ComplexTypeDefinition td, String className) throws SchemaToJavaGeneratorException {
        TypeDefinitionBase baseTypeDefinition;
        this.generator.clear();
        this.attributeInfo.clear();
        this.fieldInfo.clear();
        boolean isSimpleBase = false;
        boolean isComplexBase = false;
        SimpleTypeDefinition simpleType = td.getContentTypeSimpleTypeDefinition();
        if (simpleType != null) {
            isSimpleBase = true;
        }
        if ((baseTypeDefinition = td.getBaseTypeDefinition()) != null && !baseTypeDefinition.isBuiltIn() && td.isDerivationMethodExtension()) {
            isComplexBase = true;
        } else if (baseTypeDefinition != null && !baseTypeDefinition.isBuiltIn()) {
            throw new SchemaToJavaGeneratorException("This kind of extension not supported By SAP J2EE Schema to Java Generator");
        }
        AttributeUse[] aus = td.getAttributeUsesArray();
        int i = 0;
        while (i < aus.length) {
            this.addAttribute(this.attributeInfo, aus[i]);
            ++i;
        }
        if (isSimpleBase) {
            FieldInfo field = new FieldInfo();
            String fieldJavaName = "SimpleContent";
            field.fieldUri = td.getTargetNamespace();
            field.fieldModel = 0;
            field.fieldLocalName = "";
            field.fieldJavaName = "" + fieldJavaName;
            field.setterMethod = "set" + fieldJavaName;
            field.getterMethod = "get" + fieldJavaName;
            field.checkMethod = "has" + fieldJavaName;
            field.typeUri = simpleType.getTargetNamespace();
            field.typeLocalName = simpleType.getName();
            field.typeJavaName = this.s2j.getJavaPrimitive((TypeDefinitionBase)simpleType);
            field.nillable = false;
            field.minOccurs = 1;
            field.maxOccurs = 1;
            field.soapArrayDimensions = 0;
            field.isSoapArray = false;
            this.fieldInfo.add(field);
        } else {
            this.pp = null;
            int baseLevel = 1;
            Particle cm = td.getContentTypeContentModel();
            if (cm != null && cm.getTerm() instanceof ModelGroup) {
                ModelGroup mg = (ModelGroup)cm.getTerm();
                if (mg.isCompositorAll() && cm.getMinOccurs() == 1 && cm.getMaxOccurs() == 1) {
                    baseLevel = 0;
                }
                if (mg.isCompositorSequence() && isComplexBase && baseTypeDefinition instanceof ComplexTypeDefinition) {
                    this.checkBaseDefinition((ComplexTypeDefinition)baseTypeDefinition);
                }
                if (mg.isCompositorChoice() && cm.getMinOccurs() == 1 && cm.getMaxOccurs() == 1) {
                    baseLevel = 0;
                }
                this.searchContent(this.fieldInfo, cm, baseLevel, null);
            }
        }
        this.typeAttributeInfo.put(td, this.attributeInfo.clone());
        this.typeFieldInfo.put(td, this.fieldInfo.clone());
    }

    public void generateComplexType(ComplexTypeDefinition td, String className, PrintStream out) throws SchemaToJavaGeneratorException {
        TypeDefinitionBase baseTypeDefinition;
        this.generator.clear();
        this.attributeInfo.clear();
        this.fieldInfo.clear();
        String nonQualifiedClassName = this.convertor.getLocalClass(className);
        String packageName = this.convertor.getPackageClass(className);
        if (packageName != null && packageName.length() != 0) {
            this.generator.addLine();
            this.generator.addLine("package " + packageName + ";");
        }
        this.generateImports(this.generator);
        boolean isSimpleBase = false;
        boolean isComplexBase = false;
        SimpleTypeDefinition simpleType = td.getContentTypeSimpleTypeDefinition();
        if (simpleType != null) {
            isSimpleBase = true;
        }
        String extendedClass = BASECOMPLEX;
        String implemented = "";
        if (this.containerMode) {
            extendedClass = null;
            implemented = " implements java.io.Serializable,java.lang.Cloneable";
        }
        if ((baseTypeDefinition = td.getBaseTypeDefinition()) != null && !baseTypeDefinition.isBuiltIn() && td.isDerivationMethodExtension() && !isSimpleBase) {
            extendedClass = this.s2j.getJavaPrimitiveParent(baseTypeDefinition);
            isComplexBase = true;
        } else if (baseTypeDefinition != null && isSimpleBase && !baseTypeDefinition.isBuiltIn() && td.isDerivationMethodRestriction()) {
            extendedClass = this.s2j.getJavaPrimitiveParent(baseTypeDefinition);
        } else if (baseTypeDefinition != null && !isSimpleBase && !baseTypeDefinition.isBuiltIn()) {
            throw new SchemaToJavaGeneratorException("This kind of extension not supported By SAP J2EE Schema to Java Generator");
        }
        String modifierAbstractOrFinal = "";
        if (td.isAbstract()) {
            modifierAbstractOrFinal = "abstract ";
        } else if (td.isFinalExtension() && td.isFinalRestriction()) {
            modifierAbstractOrFinal = "final ";
        }
        String extendsString = "";
        if (extendedClass != null) {
            extendsString = " extends " + extendedClass;
        }
        this.generator.addLine();
        this.generator.addLine("/**");
        this.generator.addLine(" * Schema complex type representation (generated by SAP Schema to Java generator).");
        String schemaName = td.getName();
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = DOM.toXPath((Node)td.getAssociatedDOMNode());
            this.generator.addLine(" * Represents schema complex type of namespace {" + td.getTargetNamespace() + "} with no name and xpath [" + schemaName + "]");
        } else {
            this.generator.addLine(" * Represents schema complex type {" + td.getTargetNamespace() + "}" + schemaName);
        }
        this.generator.addLine(" */");
        this.generator.addNewLine();
        this.generator.addLine("public " + modifierAbstractOrFinal + " class " + nonQualifiedClassName + extendsString + implemented + " {");
        this.generator.startSection();
        this.generator.addLine();
        if (!this.containerMode) {
            this.generateCommonMethods(td, this.generator);
        }
        AttributeUse[] aus = td.getAttributeUsesArray();
        int i = 0;
        while (i < aus.length) {
            this.addAttribute(this.attributeInfo, aus[i]);
            ++i;
        }
        int kind = 0;
        if (isSimpleBase) {
            if (baseTypeDefinition != null && baseTypeDefinition instanceof SimpleTypeDefinition) {
                FieldInfo field = new FieldInfo();
                String fieldJavaName = "SimpleContent";
                field.fieldUri = td.getTargetNamespace();
                field.fieldModel = 0;
                field.fieldLocalName = "";
                field.fieldJavaName = "" + fieldJavaName;
                field.setterMethod = "set" + fieldJavaName;
                field.getterMethod = "get" + fieldJavaName;
                field.checkMethod = "has" + fieldJavaName;
                field.typeUri = simpleType.getTargetNamespace();
                field.typeLocalName = simpleType.getName();
                field.typeJavaName = this.s2j.getJavaPrimitive((TypeDefinitionBase)simpleType);
                field.nillable = false;
                field.minOccurs = 1;
                field.maxOccurs = 1;
                field.soapArrayDimensions = 0;
                field.isSoapArray = false;
                this.fieldInfo.add(field);
            }
            kind = 0;
        } else {
            kind = 3;
            this.pp = null;
            int baseLevel = 1;
            Particle cm = td.getContentTypeContentModel();
            if (cm != null && cm.getTerm() instanceof ModelGroup) {
                ModelGroup mg = (ModelGroup)cm.getTerm();
                if (mg.isCompositorAll() && cm.getMinOccurs() == 1 && cm.getMaxOccurs() == 1) {
                    kind = 4;
                    baseLevel = 0;
                }
                if (mg.isCompositorSequence()) {
                    kind = 3;
                    if (isComplexBase && baseTypeDefinition instanceof ComplexTypeDefinition) {
                        this.checkBaseDefinition((ComplexTypeDefinition)baseTypeDefinition);
                    }
                }
                if (mg.isCompositorChoice() && cm.getMinOccurs() == 1 && cm.getMaxOccurs() == 1) {
                    baseLevel = 0;
                    kind = 2;
                }
                ModelGroup temp = null;
                if (isComplexBase) {
                    temp = this.getBaseModelGroup(baseTypeDefinition);
                }
                if (temp != mg) {
                    this.searchContent(this.fieldInfo, cm, baseLevel, null);
                }
            }
        }
        if (!this.containerMode) {
            this.generateAttributeInfo(this.attributeInfo, this.generator);
            this.generator.addLine();
            this.generateFieldInfo(this.fieldInfo, this.generator, extendedClass);
            this.generator.addLine();
            this.generateType(this.generator, kind);
        }
        this.generateSetGet(this.fieldInfo, this.attributeInfo, this.generator, kind);
        if (!this.containerMode) {
            this.generateFieldInfoMethods(this.generator, false);
            this.generateAttributeInfoMethods(this.generator);
            this.generator.addLine();
            this.initAll(this.generator);
        }
        this.generator.endSection();
        this.generator.addLine("}");
        out.print(this.generator.toString());
        out.close();
        this.typeAttributeInfo.put(td, this.attributeInfo.clone());
        this.typeFieldInfo.put(td, this.fieldInfo.clone());
    }

    private String getNewArrray(String arrayType) {
        String result = arrayType;
        int brpos = arrayType.indexOf("[");
        result = brpos != -1 ? "new " + arrayType.substring(0, brpos) + "[0]" + arrayType.substring(brpos) : "new " + result + "[0]";
        return result;
    }

    private ModelGroup getBaseModelGroup(TypeDefinitionBase type) {
        Particle cm;
        if (!(type instanceof ComplexTypeDefinition)) {
            return null;
        }
        ComplexTypeDefinition td = (ComplexTypeDefinition)type;
        if (td.getContentTypeSimpleTypeDefinition() == null && (cm = td.getContentTypeContentModel()) != null && cm.getTerm() instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)cm.getTerm();
            return mg;
        }
        return null;
    }

    private void checkBaseDefinition(ComplexTypeDefinition td) throws SchemaToJavaGeneratorException {
        Particle cm;
        this.pp = null;
        if (td.getContentTypeSimpleTypeDefinition() == null && (cm = td.getContentTypeContentModel()) != null && cm.getTerm() instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)cm.getTerm();
            if (mg.isCompositorSequence()) {
                this.pp = cm;
            } else {
                if (mg.isCompositorAll() && cm.getMinOccurs() != 1 && cm.getMaxOccurs() != 1) {
                    this.pp = cm;
                }
                if (mg.isCompositorChoice() && cm.getMinOccurs() != 1 && cm.getMaxOccurs() != 1) {
                    this.pp = cm;
                }
                if (mg.isCompositorAll()) {
                    this.pp = cm;
                }
                if (this.pp == null) {
                    String name = td.getName();
                    if (name == null || name.length() == 0) {
                        name = DOM.toXPath((Node)td.getAssociatedDOMNode());
                    }
                    throw new SchemaToJavaGeneratorException("Extension of complex type [" + td.getTargetNamespace() + "]{" + name + "} is not supported !");
                }
            }
        }
    }

    private String convertBoolean(String dValue) {
        if ("0".equals(dValue)) {
            return "false";
        }
        if ("1".equals(dValue)) {
            return "true";
        }
        return dValue;
    }

    private String getDefaultValue(FieldInfo fieldInfo) {
        if (fieldInfo.defaultValue != null) {
            if ((class$java$lang$String == null ? (class$java$lang$String = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.String")) : class$java$lang$String).getName().equals(fieldInfo.getTypeJavaName())) {
                return this.packString(fieldInfo.getDefaultValue());
            }
            if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName().equals(fieldInfo.getTypeJavaName())) {
                String perm = this.convertBoolean(fieldInfo.defaultValue);
                if (!"true".equalsIgnoreCase(perm) && !"false".equalsIgnoreCase(perm)) {
                    return null;
                }
                return "new Boolean(" + perm + ")";
            }
            if ("boolean".equals(fieldInfo.getTypeJavaName())) {
                String perm = this.convertBoolean(fieldInfo.defaultValue);
                if (!"true".equalsIgnoreCase(perm) && !"false".equalsIgnoreCase(perm)) {
                    return null;
                }
                return perm;
            }
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.Integer")) : class$java$lang$Integer).getName().equals(fieldInfo.typeJavaName)) {
                return "new Integer(" + fieldInfo.defaultValue + ")";
            }
            if ("int".equals(fieldInfo.typeJavaName)) {
                return fieldInfo.defaultValue;
            }
            if ((class$java$lang$Long == null ? (class$java$lang$Long = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.Long")) : class$java$lang$Long).getName().equals(fieldInfo.typeJavaName)) {
                return "new Long(" + fieldInfo.defaultValue + ")";
            }
            if ("long".equals(fieldInfo.typeJavaName)) {
                return fieldInfo.defaultValue;
            }
            if ((class$java$lang$Byte == null ? (class$java$lang$Byte = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.Byte")) : class$java$lang$Byte).getName().equals(fieldInfo.typeJavaName)) {
                return "new Byte(" + fieldInfo.defaultValue + ")";
            }
            if ("byte".equals(fieldInfo.typeJavaName)) {
                return fieldInfo.defaultValue;
            }
            if ((class$java$lang$Double == null ? (class$java$lang$Double = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.Double")) : class$java$lang$Double).getName().equals(fieldInfo.typeJavaName)) {
                return "new Double(" + fieldInfo.defaultValue + ")";
            }
            if ("double".equals(fieldInfo.typeJavaName)) {
                return fieldInfo.defaultValue;
            }
            if ((class$java$lang$Float == null ? (class$java$lang$Float = SchemaToJavaGeneratorForComplexTypes.class$("java.lang.Float")) : class$java$lang$Float).getName().equals(fieldInfo.typeJavaName)) {
                return "new Float(" + fieldInfo.defaultValue + ")";
            }
            if ("float".equals(fieldInfo.typeJavaName)) {
                return fieldInfo.defaultValue + "f";
            }
        }
        return null;
    }

    private void generateSimpleSetGet(FieldInfo field, CodeGenerator generator) {
        String defaultString = this.getDefaultValue(field);
        if (defaultString != null) {
            generator.addLine("private " + field.typeJavaName + " _f_" + field.fieldJavaName + " = " + defaultString + ";");
        } else {
            generator.addLine("private " + field.typeJavaName + " _f_" + field.fieldJavaName + ";");
        }
        generator.addLine();
        generator.addLine("public void " + field.setterMethod + "(" + field.typeJavaName + " _" + field.fieldJavaName + ") {");
        generator.addLine("  this._f_" + field.fieldJavaName + " = _" + field.fieldJavaName + ";");
        generator.addLine("}");
        generator.addLine();
        generator.addLine("public " + field.typeJavaName + " " + field.getterMethod + "() {");
        generator.addLine("  return this._f_" + field.fieldJavaName + ";");
        generator.addLine("}");
    }

    protected void generateSetGet(ArrayList fieldInfo, ArrayList attributeInfo, CodeGenerator generator, int kind) throws SchemaToJavaGeneratorException {
        FieldInfo field;
        int i;
        if (attributeInfo != null) {
            i = 0;
            while (i < attributeInfo.size()) {
                AttributeInfo attribute = (AttributeInfo)attributeInfo.get(i);
                generator.addLine();
                generator.addLine("// Attribute field");
                generator.addLine("private " + attribute.typeJavaName + " _a_" + attribute.fieldJavaName + ";");
                generator.addLine("private boolean _a_has" + attribute.fieldJavaName + ";");
                generator.addLine("// set method");
                generator.addLine("public void " + attribute.setterMethod + "(" + attribute.typeJavaName + " _" + attribute.fieldJavaName + ") {");
                generator.addLine("  this._a_" + attribute.fieldJavaName + " = _" + attribute.fieldJavaName + ";");
                generator.addLine("  this._a_has" + attribute.fieldJavaName + " = true;");
                generator.addLine("}");
                generator.addLine("// clear method");
                generator.addLine("public void clear" + attribute.fieldJavaName + "(" + attribute.typeJavaName + " _" + attribute.fieldJavaName + ") {");
                generator.addLine("  this._a_has" + attribute.fieldJavaName + " = false;");
                generator.addLine("}");
                generator.addLine("// get method");
                generator.addLine("public " + attribute.typeJavaName + " " + attribute.getterMethod + "() {");
                generator.addLine("  return _a_" + attribute.fieldJavaName + ";");
                generator.addLine("}");
                generator.addLine("// has method");
                generator.addLine("public boolean " + attribute.checkMethod + "() {");
                generator.addLine("  return _a_has" + attribute.fieldJavaName + ";");
                generator.addLine("}");
                ++i;
            }
        }
        if (kind == 2) {
            generator.addLine();
            generator.addComment("// Active choice field");
            generator.addLine("private int _c_validField = 0;");
            i = 0;
            while (i < fieldInfo.size()) {
                field = (FieldInfo)fieldInfo.get(i);
                if (field.fieldModel != 1 && (field.minOccurs != 1 || field.maxOccurs != 1)) {
                    throw new SchemaToJavaGeneratorException("Unacceptable choice elements found ! Choice can contain only model groups with min/maxOccurs = 1 !");
                }
                switch (field.fieldModel) {
                    case 2: 
                    case 3: 
                    case 4: {
                        generator.addLine();
                        generator.addComment("Model group field");
                        generator.add(field.objectValue.toString());
                        generator.addNewLine();
                        break;
                    }
                    case 5: {
                        generator.addLine();
                        generator.addComment("Wildcard 'any' field");
                        break;
                    }
                    default: {
                        generator.addLine();
                        generator.addComment("Element field");
                    }
                }
                if (field.maxOccurs != 1) {
                    generator.addLine();
                    generator.addComment("Choice field");
                    generator.addLine("private " + field.typeJavaName + "[] _c_" + field.fieldJavaName + " = new " + field.typeJavaName + "[" + "0" + "];");
                    generator.addLine();
                    generator.addLine("public " + field.typeJavaName + "[] " + field.getterMethod + "() throws Exception {");
                    generator.addLine("  if (_c_validField != " + (i + 1) + ") {");
                    generator.addLine("    throw new Exception(\" Field '" + field.fieldLocalName + "' has not been set !\");");
                    generator.addLine("  } else {");
                    generator.addLine("    return _c_" + field.fieldJavaName + ";");
                    generator.addLine("  }");
                    generator.addLine("}");
                    generator.addLine();
                    generator.addLine("public boolean " + field.checkMethod + "() {");
                    generator.addLine("  return (_c_validField ==" + (i + 1) + ");");
                    generator.addLine("}");
                    generator.addLine();
                    generator.addLine("public void " + field.setterMethod + "(" + field.typeJavaName + "[] _" + field.fieldJavaName + ") {");
                    generator.addLine("  this._c_validField = " + (i + 1) + ";");
                    generator.addLine("  this._c_" + field.fieldJavaName + " = _" + field.fieldJavaName + ";");
                    generator.addLine("}");
                } else {
                    generator.addLine();
                    generator.addComment("Choice field");
                    generator.addLine("private " + field.typeJavaName + " _c_" + field.fieldJavaName + ";");
                    generator.addLine();
                    generator.addLine("public " + field.typeJavaName + " " + field.getterMethod + "() throws Exception {");
                    generator.addLine("  if (_c_validField != " + (i + 1) + ") {");
                    generator.addLine("    throw new Exception(\" Field '" + field.fieldLocalName + "' has not been set !\");");
                    generator.addLine("  } else {");
                    generator.addLine("    return _c_" + field.fieldJavaName + ";");
                    generator.addLine("  }");
                    generator.addLine("}");
                    generator.addLine();
                    generator.addLine("public boolean " + field.checkMethod + "() {");
                    generator.addLine("  return (_c_validField ==" + (i + 1) + ");");
                    generator.addLine("}");
                    generator.addLine();
                    generator.addLine("public void " + field.setterMethod + "(" + field.typeJavaName + " _" + field.fieldJavaName + ") {");
                    generator.addLine("  this._c_validField = " + (i + 1) + ";");
                    generator.addLine("  this._c_" + field.fieldJavaName + " = _" + field.fieldJavaName + ";");
                    generator.addLine("}");
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < fieldInfo.size()) {
                field = (FieldInfo)fieldInfo.get(i);
                switch (field.fieldModel) {
                    case 2: 
                    case 3: 
                    case 4: {
                        generator.addLine();
                        generator.addComment("Model group field");
                        generator.add(field.objectValue.toString());
                        generator.addNewLine();
                        break;
                    }
                    case 5: {
                        generator.addLine();
                        generator.addComment("Wildcard 'any' field");
                        break;
                    }
                    default: {
                        generator.addLine();
                        generator.addComment("Element field");
                    }
                }
                if (field.maxOccurs == 1) {
                    if (field.minOccurs == 0) {
                        if (!this.smart_mode) {
                            generator.addLine("private " + field.typeJavaName + " _f_" + field.fieldJavaName + ";");
                            generator.addLine();
                            generator.addLine("private boolean _f_has" + field.fieldJavaName + ";");
                            generator.addLine("public void " + field.setterMethod + "(" + field.typeJavaName + " _" + field.fieldJavaName + ") {");
                            generator.addLine("  this._f_" + field.fieldJavaName + " = _" + field.fieldJavaName + ";");
                            generator.addLine("  this._f_has" + field.fieldJavaName + " = true;");
                            generator.addLine("}");
                            generator.addLine("public " + field.typeJavaName + " " + field.getterMethod + "() {");
                            generator.addLine("  return this._f_" + field.fieldJavaName + ";");
                            generator.addLine("}");
                            generator.addLine("public boolean " + field.checkMethod + "() {");
                            generator.addLine("  return this._f_has" + field.fieldJavaName + ";");
                            generator.addLine("}");
                            generator.addLine("public void clear" + field.fieldJavaName + "() {");
                            generator.addLine("  this._f_has" + field.fieldJavaName + " = false;");
                            generator.addLine("}");
                        } else {
                            this.generateSimpleSetGet(field, generator);
                        }
                    } else {
                        this.generateSimpleSetGet(field, generator);
                    }
                } else {
                    generator.addLine("private " + field.typeJavaName + "[] _f_" + field.fieldJavaName + " = " + this.getNewArrray(field.typeJavaName) + ";");
                    generator.addLine("public void " + field.setterMethod + "(" + field.typeJavaName + "[] _" + field.fieldJavaName + ") {");
                    generator.addLine("  this._f_" + field.fieldJavaName + " = _" + field.fieldJavaName + ";");
                    generator.addLine("}");
                    generator.addLine("public " + field.typeJavaName + "[] " + field.getterMethod + "() {");
                    generator.addLine("  return _f_" + field.fieldJavaName + ";");
                    generator.addLine("}");
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

