/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.schema2java;

import com.sap.engine.lib.jaxp.MultiSource;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SchemaComponentResult;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.names.XMLNameMapper;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.SDFactoryRegistry;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactoryImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.XMLTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.AbstractTypeSD;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.Array11SD;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaAutoImportURIResolver;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaMappingConstants;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorException;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorForComplexTypes;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGeneratorForSimpleTypes;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SoapArrayInfo;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public final class SchemaToJavaGenerator {
    public static Hashtable JAXRPC_BUILT_IN_TO_JAVA = new Hashtable();
    public static Hashtable JAXRPC_WRAPPER_CLASS;
    public static Hashtable JAVA_TO_SCHEMA_SIMPLE;
    public static final String SOAP_ARRAY_SERIALIZER;
    private boolean containerMode = false;
    private Schema schema;
    private Hashtable hTypeToIdentifier = new Hashtable();
    private Hashtable hTypeToClass = new Hashtable();
    private Hashtable hSoapArrays = new Hashtable();
    private Properties hUriToPackage = new Properties();
    private Hashtable elementToType = new Hashtable();
    private XMLNameMapper xmlNameMapper = new XMLNameMapper();
    private Hashtable anonimousTypeDefinition = new Hashtable();
    private String basePackageName = "";
    private SchemaToJavaGeneratorForSimpleTypes gst = new SchemaToJavaGeneratorForSimpleTypes(this);
    private SchemaToJavaGeneratorForComplexTypes gct = new SchemaToJavaGeneratorForComplexTypes(this);
    private Transformer transformer;
    private Vector schemaSources = new Vector();
    private boolean isInitialized = false;
    private ArrayList files = new ArrayList();
    private Hashtable mirrorMapping = null;
    private Hashtable mirrorLocations = null;
    private SchemaAutoImportURIResolver resolver = null;
    private ArrayList namesUsed = new ArrayList();
    private HashMap applicationSchemaToJavaMapping = new HashMap();
    private HashMap applicationJavaToSchemaMapping = new HashMap();
    private boolean unwrapArrays = true;
    private boolean genericFrm = false;
    private String proxyHost;
    private String proxyPort;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$Array11SD;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$schema2java$SchemaAutoImportURIResolver;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$AnyTypeSD;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject;

    private void clearUsedNames() {
        this.namesUsed.clear();
    }

    private boolean containsUsedName(QName qname) {
        int size = this.namesUsed.size();
        int i = 0;
        while (i < size) {
            QName name = (QName)this.namesUsed.get(i);
            if (name.getNamespaceURI().equals(qname.getNamespaceURI()) && name.getLocalPart().equalsIgnoreCase(qname.getLocalPart())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addUsedName(QName qname) {
        this.namesUsed.add(qname);
    }

    public boolean isGenericFrm() {
        return this.genericFrm;
    }

    public void setGenericFrm(boolean flag) {
        this.genericFrm = flag;
    }

    public void setUnwrapArrays(boolean flag) {
        this.unwrapArrays = flag;
    }

    public void setContainerMode(boolean flag) {
        this.containerMode = flag;
        this.gct.setContainerMode(this.containerMode);
        this.gst.setContainerMode(this.containerMode);
    }

    public void setSmartMode(boolean flag) {
        this.gct.useSmartMode(flag);
    }

    private void clear() {
        this.files.clear();
        this.hTypeToIdentifier.clear();
        this.hTypeToClass.clear();
        this.hSoapArrays.clear();
        this.elementToType.clear();
        this.anonimousTypeDefinition.clear();
        this.gct.getTypeAttributeInfo().clear();
        this.gct.getTypeFieldInfo().clear();
    }

    public SchemaToJavaGenerator() throws SchemaToJavaGeneratorException {
        try {
            TransformerFactoryImpl tf = new TransformerFactoryImpl();
            this.transformer = tf.newTransformer();
            this.resolver = new SchemaAutoImportURIResolver();
            this.transformer.setURIResolver(this.resolver);
        }
        catch (TransformerException te) {
            throw new SchemaToJavaGeneratorException(te);
        }
    }

    public void setApplicationSchemaMapping(HashMap schemaToJavaMapping) {
        if (schemaToJavaMapping != null) {
            this.applicationSchemaToJavaMapping = schemaToJavaMapping;
        }
    }

    public void setApplicationJavaMapping(HashMap javaToSchemaMapping) {
        if (javaToSchemaMapping != null) {
            this.applicationJavaToSchemaMapping = javaToSchemaMapping;
        }
    }

    public void setMirrorLocations(Hashtable mirrorLocations) {
        this.mirrorLocations = mirrorLocations;
    }

    public void setMirrorMapping(Hashtable mirrorMapping) {
        this.mirrorMapping = mirrorMapping;
    }

    public void addSchemaSource(Source source) throws SchemaToJavaGeneratorException {
        this.schemaSources.add(source);
    }

    public void generateAll(File dir, String basePackageName, boolean compile) throws SchemaToJavaGeneratorException {
        this.generateAll(dir, basePackageName);
        if (compile) {
            try {
                this.buidTypes(dir, basePackageName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SchemaToJavaGeneratorException(e.getMessage());
            }
        }
    }

    public Properties getUriToPackageMapping() {
        return this.hUriToPackage;
    }

    public void setUriToPackagetMapping(Properties table) {
        this.hUriToPackage = table;
    }

    private boolean isExtended(ComplexTypeDefinition ct) {
        Enumeration keys = this.hTypeToIdentifier.keys();
        while (keys.hasMoreElements()) {
            ComplexTypeDefinition ct2;
            TypeDefinitionBase baseTypeDefinition;
            TypeDefinitionBase td = (TypeDefinitionBase)keys.nextElement();
            if (!(td instanceof ComplexTypeDefinition) || !ct.equals(baseTypeDefinition = (ct2 = (ComplexTypeDefinition)td).getBaseTypeDefinition())) continue;
            return true;
        }
        return false;
    }

    public void generateAll(File dir, String basePackageName) throws SchemaToJavaGeneratorException {
        PrintStream out;
        File fParent;
        File f;
        this.isInitialized = true;
        this.gst.init();
        this.prepareAll(basePackageName);
        ArrayList<TypeDefinitionBase> simpleTypes = new ArrayList<TypeDefinitionBase>();
        ArrayList<String> simpleClasses = new ArrayList<String>();
        Enumeration enumeration = this.hTypeToIdentifier.keys();
        while (enumeration.hasMoreElements()) {
            TypeDefinitionBase td = (TypeDefinitionBase)enumeration.nextElement();
            if (this.hSoapArrays.containsKey(td)) continue;
            String className = (String)this.hTypeToIdentifier.get(td);
            if (td instanceof SimpleTypeDefinition) {
                if (simpleTypes.contains(td)) continue;
                simpleTypes.add(td);
                simpleClasses.add(className);
                continue;
            }
            ComplexTypeDefinition ct = (ComplexTypeDefinition)td;
            if (ct.isMixed()) continue;
            if (this.isDocumentArray(ct) && this.containerMode && !this.isExtended(ct)) {
                this.gct.loadComplexType((ComplexTypeDefinition)td, className);
                continue;
            }
            if (this.containerMode && "http://schemas.xmlsoap.org/soap/encoding/".equals(ct.getTargetNamespace())) {
                this.gct.loadComplexType((ComplexTypeDefinition)td, className);
                continue;
            }
            if (this.containerMode && "http://schemas.xmlsoap.org/soap/envelope/".equals(td.getTargetNamespace())) continue;
            f = new File(dir, className.replace('.', File.separatorChar) + ".java");
            try {
                fParent = f.getParentFile();
                if (!fParent.exists()) {
                    fParent.mkdirs();
                }
                out = new PrintStream(new FileOutputStream(f));
            }
            catch (IOException ioe) {
                throw new SchemaToJavaGeneratorException(ioe);
            }
            this.files.add(f);
            this.gct.generateComplexType((ComplexTypeDefinition)td, className, out);
        }
        while (simpleTypes.size() != 0) {
            int resolvedIndex = this.gst.getResolved(simpleTypes, simpleClasses);
            if (resolvedIndex == -1) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < simpleTypes.size()) {
                    SimpleTypeDefinition st = (SimpleTypeDefinition)simpleTypes.get(i);
                    buffer.append("{" + st.getTargetNamespace() + "}" + st.getName() + ",");
                    ++i;
                }
                throw new SchemaToJavaGeneratorException("Unable to resolve all simple types :" + buffer.toString());
            }
            SimpleTypeDefinition type = (SimpleTypeDefinition)simpleTypes.remove(resolvedIndex);
            String className = (String)simpleClasses.remove(resolvedIndex);
            if (this.containerMode) continue;
            f = new File(dir, className.replace('.', File.separatorChar) + ".java");
            try {
                fParent = f.getParentFile();
                if (!fParent.exists()) {
                    fParent.mkdirs();
                }
                out = new PrintStream(new FileOutputStream(f));
            }
            catch (IOException ioe) {
                throw new SchemaToJavaGeneratorException(ioe);
            }
            this.files.add(f);
            this.gst.generateSimpleType(type, className, out);
        }
    }

    public File[] getFileList() {
        File[] result = new File[this.files.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (File)this.files.get(i);
            ++i;
        }
        return result;
    }

    public void setHttpProxy(String httpHost, String httpPort) {
        this.proxyHost = httpHost;
        this.proxyPort = httpPort;
    }

    public void clearProxy() {
        this.proxyHost = null;
        this.proxyPort = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareAll(String basePackageName) throws SchemaToJavaGeneratorException {
        String tns;
        String name;
        SchemaComponentResult scr;
        block34: {
            String oldPort;
            String oldHost;
            block35: {
                this.clear();
                this.basePackageName = basePackageName;
                MultiSource ms = new MultiSource();
                int nSchemaSources = this.schemaSources.size();
                if (nSchemaSources == 0) {
                    URL url = (class$com$sap$engine$services$webservices$jaxrpc$schema2java$SchemaAutoImportURIResolver == null ? (class$com$sap$engine$services$webservices$jaxrpc$schema2java$SchemaAutoImportURIResolver = SchemaToJavaGenerator.class$("com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaAutoImportURIResolver")) : class$com$sap$engine$services$webservices$jaxrpc$schema2java$SchemaAutoImportURIResolver).getResource("preloaded/soapenc.xsd");
                    if (url != null) {
                        ms.addSource((Source)new StreamSource(url.toString()));
                    }
                } else {
                    int i = 0;
                    while (i < nSchemaSources) {
                        ms.addSource((Source)this.schemaSources.elementAt(i));
                        ++i;
                    }
                }
                scr = new SchemaComponentResult();
                if (this.mirrorMapping != null && this.mirrorLocations != null) {
                    this.resolver.setLocalMapping(this.mirrorLocations);
                    this.resolver.setRemoteMapping(this.mirrorMapping);
                } else {
                    this.resolver.setLocalMapping(null);
                    this.resolver.setRemoteMapping(null);
                }
                oldHost = "";
                oldPort = "";
                try {
                    try {
                        if (this.proxyHost != null) {
                            oldHost = System.getProperty("http.proxyHost");
                            oldPort = System.getProperty("http.proxyPort");
                            System.setProperty("http.proxyHost", this.proxyHost);
                            System.setProperty("http.proxyPort", this.proxyPort);
                        }
                        this.transformer.transform((Source)ms, (Result)scr);
                    }
                    catch (TransformerException te) {
                        te.printStackTrace();
                        throw new SchemaToJavaGeneratorException(te);
                    }
                    Object var9_8 = null;
                    if (this.proxyHost == null) break block34;
                    if (oldHost != null && oldPort != null) break block35;
                    ((Hashtable)System.getProperties()).remove("http.proxyHost");
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (this.proxyHost == null) throw throwable;
                    if (oldHost != null && oldPort != null) {
                        System.setProperty("http.proxyHost", oldHost);
                        System.setProperty("http.proxyPort", oldPort);
                        throw throwable;
                    }
                    ((Hashtable)System.getProperties()).remove("http.proxyHost");
                    ((Hashtable)System.getProperties()).remove("http.proxyPort");
                    throw throwable;
                }
                ((Hashtable)System.getProperties()).remove("http.proxyPort");
                break block34;
            }
            System.setProperty("http.proxyHost", oldHost);
            System.setProperty("http.proxyPort", oldPort);
        }
        this.schema = scr.getSchema();
        this.clearUsedNames();
        Vector v = new Vector();
        this.schema.getTopLevelTypeDefinitions(v);
        int i = 0;
        while (true) {
            if (i >= v.size()) break;
            TypeDefinitionBase td = (TypeDefinitionBase)v.get(i);
            String name2 = td.getName();
            String tns2 = td.getTargetNamespace();
            this.prepare(td, tns2, name2);
            ++i;
        }
        v.clear();
        this.schema.getTopLevelElementDeclarations(v);
        int i2 = 0;
        while (true) {
            if (i2 >= v.size()) break;
            ElementDeclaration ed = (ElementDeclaration)v.get(i2);
            TypeDefinitionBase td = ed.getTypeDefinition();
            String name3 = ed.getName();
            String tns3 = ed.getTargetNamespace();
            QName qname = new QName(tns3, name3);
            if (this.containsUsedName(qname)) {
                name3 = name3 + "Inner";
                qname = new QName(tns3, name3);
            }
            if (td != null && td.getName().length() == 0 && name3.length() != 0) {
                this.prepare(td, tns3, name3);
                QName temp = new QName(td.getTargetNamespace(), DOM.toXPath((Node)td.getAssociatedDOMNode()));
                this.anonimousTypeDefinition.put(temp, td);
            }
            ++i2;
        }
        v.clear();
        this.schema.getAllComponents(v);
        int nv = v.size();
        int i3 = 0;
        while (true) {
            String tns4;
            String name4;
            if (i3 >= nv) break;
            Object c = v.get(i3);
            if (c instanceof TypeDefinitionBase) {
                TypeDefinitionBase td = (TypeDefinitionBase)c;
                name4 = td.getName();
                tns4 = td.getTargetNamespace();
                if (name4.length() != 0) {
                    this.prepare(td, tns4, name4);
                }
            } else if (c instanceof ElementDeclaration) {
                ElementDeclaration ed = (ElementDeclaration)c;
                if (!ed.isTopLevel()) {
                    TypeDefinitionBase td = ed.getTypeDefinition();
                    name = ed.getName();
                    tns = td.getTargetNamespace();
                    QName qname = new QName(tns, name);
                    if (this.containsUsedName(qname)) {
                        name = name + "Inner";
                        qname = new QName(tns, name);
                    }
                    int num = 2;
                    String temp = name;
                    while (true) {
                        if (!this.containsUsedName(qname)) {
                            name = temp;
                            if (td != null && td.getName().length() == 0 && name.length() != 0) {
                                this.prepare(td, tns, name);
                                QName tqname = new QName(td.getTargetNamespace(), DOM.toXPath((Node)td.getAssociatedDOMNode()));
                                this.anonimousTypeDefinition.put(tqname, td);
                            }
                            break;
                        }
                        temp = name + String.valueOf(num);
                        qname = new QName(tns, temp);
                        ++num;
                    }
                }
            } else if (c instanceof AttributeDeclaration) {
                AttributeDeclaration ad = (AttributeDeclaration)c;
                name4 = ad.getName();
                tns4 = ad.getTargetNamespace();
                TypeDefinitionBase td = ad.getTypeDefinition();
                if (td != null && td.getName().length() == 0 && name4.length() != 0) {
                    this.prepare(td, tns4, name4);
                }
            }
            ++i3;
        }
        ElementDeclaration[] elements = this.schema.getTopLevelElementDeclarationsArray();
        int i4 = 0;
        while (true) {
            if (i4 >= elements.length) break;
            ElementDeclaration ed = elements[i4];
            name = ed.getName();
            tns = ed.getTargetNamespace();
            QName elementName = new QName(tns, name);
            TypeDefinitionBase td = ed.getTypeDefinition();
            String typeName = td.getName();
            if (typeName == null || typeName.length() == 0) {
                typeName = DOM.toXPath((Node)td.getAssociatedDOMNode());
            }
            String typeNamespace = td.getTargetNamespace();
            QName typeqName = new QName(typeNamespace, typeName);
            if (this.elementToType.containsKey(elementName)) {
                throw new SchemaToJavaGeneratorException("The definition of element " + elementName.toString() + " appears twice in wsdl schema. ");
            }
            this.elementToType.put(elementName, typeqName);
            ++i4;
        }
        Enumeration enumeration = this.hSoapArrays.keys();
        while (enumeration.hasMoreElements()) {
            TypeDefinitionBase td = (TypeDefinitionBase)enumeration.nextElement();
            SoapArrayInfo info = (SoapArrayInfo)this.hSoapArrays.get(td);
            if (this.hTypeToClass.get(td) != null) continue;
            this.fillArrayType(td, info, this.hTypeToClass, this.hSoapArrays);
        }
        return;
    }

    private void fillArrayType(TypeDefinitionBase td, SoapArrayInfo arrayInfo, Hashtable typeToClass, Hashtable soapArrays) {
        String itemJavaType;
        block8: {
            TypeDefinitionBase componentType = arrayInfo.getItemType();
            itemJavaType = "java.lang.Object";
            if (componentType.isBuiltIn()) {
                while (true) {
                    if (componentType.isBuiltIn()) {
                        itemJavaType = this.genericFrm ? (String)SchemaMappingConstants.JAXRPC_1_1_SCHEMA_TO_JAVA.get(componentType.getName()) : (String)JAXRPC_BUILT_IN_TO_JAVA.get(componentType.getName());
                        if (itemJavaType != null) break block8;
                        itemJavaType = "java.lang.Object";
                    }
                    if (!(componentType instanceof ComplexTypeDefinition)) {
                        componentType = componentType.getBaseTypeDefinition();
                        continue;
                    }
                    break block8;
                    break;
                }
            }
            itemJavaType = (String)typeToClass.get(componentType);
            if (itemJavaType == null) {
                SoapArrayInfo sInfo = (SoapArrayInfo)soapArrays.get(componentType);
                this.fillArrayType(componentType, sInfo, typeToClass, soapArrays);
                itemJavaType = (String)typeToClass.get(componentType);
            }
            if (itemJavaType == null) {
                itemJavaType = "java.lang.Object";
            }
        }
        StringBuffer sb = new StringBuffer(itemJavaType);
        int j = 0;
        while (j < arrayInfo.getDimensions()) {
            sb.append("[]");
            ++j;
        }
        this.hTypeToClass.put(td, sb.toString());
    }

    private TypeDefinitionBase baseDefinitionSOAPArray(TypeDefinitionBase td) throws SchemaToJavaGeneratorException {
        ArrayList<TypeDefinitionBase> path = new ArrayList<TypeDefinitionBase>();
        path.add(td);
        TypeDefinitionBase btd = td.getBaseTypeDefinition();
        while (btd != null && !btd.isBuiltIn()) {
            if ("Array".equals(btd.getName()) && "http://schemas.xmlsoap.org/soap/encoding/".equals(btd.getTargetNamespace())) {
                td = (TypeDefinitionBase)path.get(path.size() - 1);
                SoapArrayInfo info = new SoapArrayInfo(td);
                int i = 0;
                while (i < path.size()) {
                    td = (TypeDefinitionBase)path.get(i);
                    this.hSoapArrays.put(td, info);
                    if (td.getName() == null || td.getName().length() == 0) {
                        QName qname = new QName(td.getTargetNamespace(), DOM.toXPath((Node)td.getAssociatedDOMNode()));
                        this.anonimousTypeDefinition.put(qname, td);
                    }
                    ++i;
                }
                return (TypeDefinitionBase)path.get(path.size() - 1);
            }
            path.add(btd);
            btd = btd.getBaseTypeDefinition();
        }
        return null;
    }

    private void prepare(TypeDefinitionBase td, String tns, String name) throws SchemaToJavaGeneratorException {
        String tdName;
        if (this.hTypeToIdentifier.containsKey(td)) {
            return;
        }
        if (this.hSoapArrays.containsKey(td)) {
            return;
        }
        this.addUsedName(new QName(tns, name));
        if ((td.isBuiltIn() || "http://schemas.xmlsoap.org/soap/encoding/".equals(td.getTargetNamespace())) && (tdName = td.getName()) != null) {
            String javaTypeName = (String)JAXRPC_BUILT_IN_TO_JAVA.get(tdName);
            if (this.genericFrm) {
                javaTypeName = (String)SchemaMappingConstants.JAXRPC_1_1_SCHEMA_TO_JAVA.get(tdName);
            }
            if (javaTypeName != null) {
                this.hTypeToClass.put(td, javaTypeName);
                return;
            }
        }
        TypeDefinitionBase btd = td.getBaseTypeDefinition();
        if (this.baseDefinitionSOAPArray(td) != null) {
            return;
        }
        if ("java:sap/standard".equals(td.getTargetNamespace())) {
            int i = 0;
            while (i < TypeMappingRegistryImpl.structureTypes.length) {
                if (TypeMappingRegistryImpl.structureTypes[i].equals(td.getName())) {
                    this.hTypeToClass.put(td, "java.util." + td.getName());
                    return;
                }
                ++i;
            }
        }
        if (td instanceof ComplexTypeDefinition && ((ComplexTypeDefinition)td).isMixed()) {
            this.hTypeToClass.put(td, "org.w3c.dom.Node");
            this.hTypeToIdentifier.put(td, (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$AnyTypeSD == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$AnyTypeSD = SchemaToJavaGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.AnyTypeSD")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$AnyTypeSD).getName());
            return;
        }
        String packageName = (String)((Hashtable)this.hUriToPackage).get(td.getTargetNamespace());
        if (packageName == null) {
            int np = ((Hashtable)this.hUriToPackage).size();
            packageName = np == 0 ? this.basePackageName : (this.basePackageName.length() == 0 ? "p" + np : this.basePackageName + ".p" + np);
            ((Hashtable)this.hUriToPackage).put(td.getTargetNamespace(), packageName);
        }
        name = this.xmlNameMapper.toClassIdentifier(name);
        String string = name = packageName.length() == 0 ? name : packageName + "." + name;
        if (td instanceof SimpleTypeDefinition) {
            SimpleTypeDefinition std = (SimpleTypeDefinition)td;
            if (std.isVarietyAtomic()) {
                this.hTypeToClass.put(td, this.getJavaPrimitive((TypeDefinitionBase)std));
            }
            if (std.isVarietyList()) {
                SimpleTypeDefinition itemType = std.getItemTypeDefinition();
                this.hTypeToClass.put(td, this.getJavaPrimitive((TypeDefinitionBase)itemType) + "[]");
            }
            if (std.isVarietyUnion()) {
                this.hTypeToClass.put(td, (class$java$lang$String == null ? (class$java$lang$String = SchemaToJavaGenerator.class$("java.lang.String")) : class$java$lang$String).getName());
            }
        } else {
            this.hTypeToClass.put(td, name);
        }
        if (td instanceof ComplexTypeDefinition && this.genericFrm) {
            this.hTypeToClass.put(td, (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject == null ? (class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject = SchemaToJavaGenerator.class$("com.sap.engine.services.webservices.espbase.client.dynamic.content.GenericObject")) : class$com$sap$engine$services$webservices$espbase$client$dynamic$content$GenericObject).getName());
        }
        this.hTypeToIdentifier.put(td, name);
    }

    private TypeDefinitionBase getDocumentArrayType(ComplexTypeDefinition complexType) {
        Particle p = complexType.getContentTypeContentModel();
        Base term = p.getTerm();
        ModelGroup mg = (ModelGroup)term;
        Particle[] pa = mg.getParticlesArray();
        Base elementTerm = null;
        int i = 0;
        while (i < pa.length) {
            elementTerm = pa[i].getTerm();
            if (elementTerm instanceof ElementDeclaration && pa[i].getMaxOccurs() != 1) {
                return ((ElementDeclaration)elementTerm).getTypeDefinition();
            }
            ++i;
        }
        return null;
    }

    public boolean isDocumentArray(ComplexTypeDefinition complexType) {
        if (!this.unwrapArrays) {
            return false;
        }
        if ("java:sap/standard".equals(complexType.getTargetNamespace())) {
            int i = 0;
            while (i < TypeMappingRegistryImpl.structureTypes.length) {
                if (TypeMappingRegistryImpl.structureTypes[i].equals(complexType.getName())) {
                    return false;
                }
                ++i;
            }
        }
        if (complexType.getContentTypeSimpleTypeDefinition() != null) {
            return false;
        }
        if (complexType.isContentTypeEmpty()) {
            return false;
        }
        if (complexType.isMixed()) {
            return false;
        }
        if (complexType.getAttributeUsesArray().length != 0) {
            return false;
        }
        Particle p = complexType.getContentTypeContentModel();
        if (p == null) {
            return false;
        }
        Base term = p.getTerm();
        if (term instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)term;
            if (p.getMaxOccurs() == 1 && p.getMinOccurs() == 1 && mg.isCompositorSequence()) {
                Particle[] pa = mg.getParticlesArray();
                int resultIndex = -1;
                Base elementTerm = null;
                int i = 0;
                while (i < pa.length) {
                    elementTerm = pa[i].getTerm();
                    if (elementTerm instanceof ElementDeclaration) {
                        if (pa[i].getMaxOccurs() != 1) {
                            if (resultIndex != -1) {
                                resultIndex = -1;
                                break;
                            }
                            resultIndex = i;
                        } else {
                            resultIndex = -1;
                            break;
                        }
                    }
                    if (elementTerm instanceof ModelGroup) {
                        resultIndex = -1;
                        break;
                    }
                    if (elementTerm instanceof Wildcard) {
                        resultIndex = -1;
                        break;
                    }
                    ++i;
                }
                return resultIndex != -1;
            }
            return false;
        }
        return false;
    }

    public String getJavaPrimitive(TypeDefinitionBase td) {
        if (td == null) {
            return "java.lang.Object";
        }
        if (td instanceof SimpleTypeDefinition) {
            if (((SimpleTypeDefinition)td).isVarietyAtomic()) {
                while (true) {
                    if (td == null) {
                        return "java.lang.Object";
                    }
                    if (td.isBuiltIn()) {
                        String s = (String)JAXRPC_BUILT_IN_TO_JAVA.get(td.getName());
                        if (this.genericFrm) {
                            s = (String)SchemaMappingConstants.JAXRPC_1_1_SCHEMA_TO_JAVA.get(td.getName());
                        }
                        return s == null ? "java.lang.Object" : s;
                    }
                    td = td.getBaseTypeDefinition();
                }
            }
            if (((SimpleTypeDefinition)td).isVarietyList()) {
                String s = (String)this.hTypeToClass.get(td);
                return s == null ? "java.lang.Object" : s;
            }
            if (((SimpleTypeDefinition)td).isVarietyUnion()) {
                String s = (String)this.hTypeToClass.get(td);
                return s == null ? "java.lang.String" : s;
            }
            return "java.lang.Object";
        }
        if (this.isDocumentArray((ComplexTypeDefinition)td)) {
            TypeDefinitionBase newtd = this.getDocumentArrayType((ComplexTypeDefinition)td);
            return this.getJavaPrimitive(newtd) + "[]";
        }
        String s = (String)this.hTypeToClass.get(td);
        return s == null ? "java.lang.Object" : s;
    }

    public String getJavaPrimitiveParent(TypeDefinitionBase td) {
        if (td == null) {
            return "java.lang.Object";
        }
        if (td instanceof SimpleTypeDefinition) {
            while (true) {
                if (td == null) {
                    return "java.lang.Object";
                }
                if (td.isBuiltIn()) {
                    String s = (String)JAXRPC_BUILT_IN_TO_JAVA.get(td.getName());
                    if (this.genericFrm) {
                        s = (String)SchemaMappingConstants.JAXRPC_1_1_SCHEMA_TO_JAVA.get(td.getName());
                    }
                    return s == null ? "java.lang.Object" : s;
                }
                td = td.getBaseTypeDefinition();
            }
        }
        String s = (String)this.hTypeToClass.get(td);
        if (this.genericFrm) {
            s = (String)this.hTypeToIdentifier.get(td);
        }
        return s == null ? "java.lang.Object" : s;
    }

    public TypeDefinitionBase getType(QName qname) {
        return this.getType(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public TypeDefinitionBase getType(String u, String l) {
        TypeDefinitionBase td = this.schema.getTopLevelTypeDefinition(u, l);
        if (td == null) {
            td = (TypeDefinitionBase)this.anonimousTypeDefinition.get(new QName(u, l));
        }
        return td;
    }

    public TypeDefinitionBase getElementType(String u, String l) {
        ElementDeclaration ed = this.schema.getTopLevelElementDeclaration(u, l);
        if (ed == null) {
            return null;
        }
        TypeDefinitionBase td = ed.getTypeDefinition();
        return td;
    }

    public boolean isSimple(TypeDefinitionBase t) {
        return t instanceof SimpleTypeDefinition;
    }

    public boolean isSoapArray(TypeDefinitionBase td) {
        return td != null && this.hSoapArrays.containsKey(td);
    }

    public SoapArrayInfo getSoapArrayInfo(TypeDefinitionBase td) {
        return (SoapArrayInfo)this.hSoapArrays.get(td);
    }

    protected XMLNameMapper getXMLNameMapper() {
        return this.xmlNameMapper;
    }

    public Hashtable getHTypeToClass() {
        return this.hTypeToClass;
    }

    public boolean isStructArray(String localName, String uri) {
        int i = 0;
        while (i < TypeMappingRegistryImpl.structureTypes.length) {
            if (TypeMappingRegistryImpl.structureTypes[i].equals(localName) && "java:sap/standard".equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Hashtable getQNameMapping() {
        QName qname;
        String javaName;
        String localName;
        String namespace;
        TypeDefinitionBase currentType;
        Hashtable<QName, String> result = new Hashtable<QName, String>();
        Enumeration keys = this.hTypeToIdentifier.keys();
        while (keys.hasMoreElements()) {
            currentType = (TypeDefinitionBase)keys.nextElement();
            if (!(currentType instanceof SimpleTypeDefinition || currentType.isBuiltIn() || this.hSoapArrays.get(currentType) != null || "http://schemas.xmlsoap.org/soap/encoding/".equals(namespace = currentType.getTargetNamespace()))) {
                localName = currentType.getName() == null || currentType.getName().length() == 0 ? DOM.toXPath((Node)currentType.getAssociatedDOMNode()) : currentType.getName();
                javaName = (String)this.hTypeToIdentifier.get(currentType);
                qname = new QName(namespace, localName);
                if (!this.isStructArray(localName, namespace)) {
                    result.put(qname, javaName);
                }
            }
            if (!(currentType instanceof SimpleTypeDefinition) || currentType.isBuiltIn() || "http://schemas.xmlsoap.org/soap/encoding/".equals(namespace = currentType.getTargetNamespace())) continue;
            localName = currentType.getName() == null || currentType.getName().length() == 0 ? DOM.toXPath((Node)currentType.getAssociatedDOMNode()) : currentType.getName();
            javaName = (String)this.hTypeToIdentifier.get(currentType);
            qname = new QName(namespace, localName);
            result.put(qname, javaName);
        }
        keys = this.hSoapArrays.keys();
        while (keys.hasMoreElements()) {
            currentType = (TypeDefinitionBase)keys.nextElement();
            if (currentType instanceof SimpleTypeDefinition || currentType.isBuiltIn() || this.hSoapArrays.get(currentType) == null || "http://schemas.xmlsoap.org/soap/encoding/".equals(namespace = currentType.getTargetNamespace())) continue;
            localName = currentType.getName() == null || currentType.getName().length() == 0 ? DOM.toXPath((Node)currentType.getAssociatedDOMNode()) : currentType.getName();
            javaName = "com.sap.engine.services.webservices.jaxrpc.encoding.primitive.Array11SD";
            qname = new QName(namespace, localName);
            result.put(qname, javaName);
        }
        return result;
    }

    private void buidTypes(File rootDir, String packageName) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.setPackageRoot(rootDir);
        builder.setPackageName(packageName);
        builder.compilePackage();
    }

    private String getArrayDimensions(QName arrayType) {
        TypeDefinitionBase type = this.getType(arrayType.getNamespaceURI(), arrayType.getLocalPart());
        SoapArrayInfo sainfo = this.getSoapArrayInfo(type);
        return String.valueOf(sainfo.getDimensions());
    }

    private QName getArrayContentType(QName arrayType) {
        TypeDefinitionBase type = this.getType(arrayType.getNamespaceURI(), arrayType.getLocalPart());
        SoapArrayInfo sainfo = this.getSoapArrayInfo(type);
        String fSoapArrayItemTypeUri = null;
        String fSoapArrayItemTypeLocalName = null;
        TypeDefinitionBase it = sainfo.getItemType();
        fSoapArrayItemTypeUri = it.getTargetNamespace();
        fSoapArrayItemTypeLocalName = it.getName();
        return new QName(fSoapArrayItemTypeUri, fSoapArrayItemTypeLocalName);
    }

    private Array11SD getArraySerializer(TypeDefinitionBase type) {
        SoapArrayInfo sainfo = this.getSoapArrayInfo(type);
        String fSoapArrayItemTypeUri = null;
        String fSoapArrayItemTypeLocalName = null;
        TypeDefinitionBase it = sainfo.getItemType();
        fSoapArrayItemTypeUri = it.getTargetNamespace();
        fSoapArrayItemTypeLocalName = it.getName();
        String dimensions = String.valueOf(sainfo.getDimensions());
        return new Array11SD(fSoapArrayItemTypeUri, fSoapArrayItemTypeLocalName, dimensions);
    }

    public void registerTypes(ExtendedTypeMapping typeMapping) {
        Object typeName;
        Hashtable qNames = this.getQNameMapping();
        Enumeration types = qNames.keys();
        boolean success = true;
        while (types.hasMoreElements() && success) {
            QName parent = null;
            QName qName = (QName)types.nextElement();
            String serdesClassName = (String)qNames.get(qName);
            TypeDefinitionBase typeDefinition = this.getType(qName);
            SerializationFactoryImpl factory = null;
            if (typeDefinition instanceof ComplexTypeDefinition && ((ComplexTypeDefinition)typeDefinition).isAbstract()) {
                AbstractTypeSD aserializer = new AbstractTypeSD();
                factory = new SerializationFactoryImpl(qName, aserializer, aserializer);
            } else if (serdesClassName.equals(SOAP_ARRAY_SERIALIZER)) {
                Array11SD array = this.getArraySerializer(typeDefinition);
                factory = new SerializationFactoryImpl(qName, array, array);
            } else {
                String pUri;
                String pName;
                TypeDefinitionBase baseType;
                ComplexTypeDefinition complexType;
                if (typeDefinition instanceof ComplexTypeDefinition && (complexType = (ComplexTypeDefinition)typeDefinition).isMixed()) {
                    serdesClassName = "com.sap.engine.services.webservices.jaxrpc.encoding.primitive.AnyTypeSD";
                }
                factory = new SerializationFactoryImpl(qName, serdesClassName, serdesClassName);
                if (typeDefinition instanceof ComplexTypeDefinition && (complexType = (ComplexTypeDefinition)typeDefinition).getContentTypeSimpleTypeDefinition() == null && (baseType = complexType.getBaseTypeDefinition()) instanceof ComplexTypeDefinition) {
                    pName = baseType.getName();
                    pUri = baseType.getTargetNamespace();
                    if (pName == null || pName.length() == 0) {
                        pName = DOM.toXPath((Node)baseType.getAssociatedDOMNode());
                    }
                    parent = new QName(pUri, pName);
                }
                if (typeDefinition instanceof SimpleTypeDefinition) {
                    SimpleTypeDefinition simpleType = (SimpleTypeDefinition)typeDefinition;
                    if (simpleType.isVarietyAtomic() && !simpleType.isBuiltIn()) {
                        baseType = simpleType.getBaseTypeDefinitionSimple();
                        pName = baseType.getName();
                        pUri = baseType.getTargetNamespace();
                        parent = new QName(pUri, pName);
                    }
                    if (simpleType.isFinalList()) {
                        baseType = simpleType.getItemTypeDefinition();
                        pName = baseType.getName();
                        pUri = baseType.getTargetNamespace();
                        parent = new QName(pUri, pName);
                    }
                }
            }
            XMLTypeMapping mapping = new XMLTypeMapping(qName, factory);
            if (parent != null) {
                mapping.setParentType(parent);
            }
            typeMapping.addXmlTypeMapping(qName, mapping);
        }
        Enumeration keys = this.hTypeToClass.keys();
        while (keys.hasMoreElements()) {
            TypeDefinitionBase type = (TypeDefinitionBase)keys.nextElement();
            String javaClass = this.getJavaPrimitive(type);
            String typeName2 = type.getName();
            String typeNamespace = type.getTargetNamespace();
            if (typeName2 == null || typeName2.length() == 0) {
                typeName2 = DOM.toXPath((Node)type.getAssociatedDOMNode());
            }
            QName qname = new QName(typeNamespace, typeName2);
            typeMapping.registerDefaultJavaType(qname, javaClass);
            typeMapping.registerDefaultSchemaType(javaClass, qname);
        }
        if (!this.genericFrm) {
            int i = 0;
            while (i < TypeMappingRegistryImpl.structureTypes.length) {
                typeName = new QName("java:sap/standard", TypeMappingRegistryImpl.structureTypes[i]);
                String typeJavaName = "java.util." + TypeMappingRegistryImpl.structureTypes[i];
                typeMapping.registerDefaultJavaType((QName)typeName, typeJavaName);
                typeMapping.registerDefaultSchemaType(typeJavaName, (QName)typeName);
                ++i;
            }
            keys = JAXRPC_BUILT_IN_TO_JAVA.keys();
            while (keys.hasMoreElements()) {
                typeName = (String)keys.nextElement();
                QName key = new QName("http://www.w3.org/2001/XMLSchema", (String)typeName);
                String javaPrimitive = (String)JAXRPC_BUILT_IN_TO_JAVA.get(typeName);
                String wrapper = (String)JAXRPC_WRAPPER_CLASS.get(javaPrimitive);
                if (wrapper != null) {
                    javaPrimitive = wrapper;
                }
                typeMapping.registerDefaultJavaType(key, javaPrimitive);
            }
            keys = JAVA_TO_SCHEMA_SIMPLE.keys();
            while (keys.hasMoreElements()) {
                String javaType = (String)keys.nextElement();
                String xmlType = (String)JAVA_TO_SCHEMA_SIMPLE.get(javaType);
                QName qname = new QName("http://www.w3.org/2001/XMLSchema", xmlType);
                typeMapping.registerDefaultSchemaType(javaType, qname);
            }
        }
        keys = this.elementToType.keys();
        while (keys.hasMoreElements()) {
            QName elementName = (QName)keys.nextElement();
            typeName = (QName)this.elementToType.get(elementName);
            typeMapping.setTypeForElement(elementName, (QName)typeName);
        }
        Iterator appKeys = this.applicationSchemaToJavaMapping.keySet().iterator();
        while (appKeys.hasNext()) {
            QName qname = (QName)appKeys.next();
            String javaName = (String)this.applicationSchemaToJavaMapping.get(qname);
            typeMapping.registerDefaultJavaType(qname, javaName);
        }
        appKeys = this.applicationJavaToSchemaMapping.keySet().iterator();
        while (appKeys.hasNext()) {
            String javaName = (String)appKeys.next();
            QName qName = (QName)this.applicationJavaToSchemaMapping.get(javaName);
            typeMapping.registerDefaultSchemaType(javaName, qName);
        }
        typeMapping.initializeRelations();
    }

    public void registerTypes(SDFactoryRegistry factoryRegistry) throws Exception {
        Hashtable perm = this.getQNameMapping();
        Enumeration keys = perm.keys();
        boolean success = true;
        while (keys.hasMoreElements() && success) {
            Object key = keys.nextElement();
            String serdesClassName = (String)perm.get(key);
            try {
                if (serdesClassName.equals("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.Array11SD")) {
                    QName itemType = this.getArrayContentType((QName)key);
                    Array11SD array = new Array11SD(itemType.getNamespaceURI(), itemType.getLocalPart(), this.getArrayDimensions((QName)key));
                    SerializationFactoryImpl factory = new SerializationFactoryImpl((QName)key, array, array);
                    factoryRegistry.add((QName)key, factory);
                    continue;
                }
                SerializationFactoryImpl factory = new SerializationFactoryImpl((QName)key, serdesClassName, serdesClassName);
                factoryRegistry.add((QName)key, factory);
            }
            catch (Exception e) {
                success = false;
                this.unregisterTypes(factoryRegistry);
                throw e;
            }
        }
    }

    public void registerTypes(SDFactoryRegistry factoryRegistry, ClassLoader classLoader) throws Exception {
        Hashtable perm = this.getQNameMapping();
        Enumeration keys = perm.keys();
        boolean success = true;
        while (keys.hasMoreElements() && success) {
            Object key = keys.nextElement();
            String serdesClassName = (String)perm.get(key);
            try {
                if (serdesClassName.equals("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.Array11SD")) {
                    QName itemType = this.getArrayContentType((QName)key);
                    Array11SD array = new Array11SD(itemType.getNamespaceURI(), itemType.getLocalPart(), this.getArrayDimensions((QName)key));
                    SerializationFactoryImpl factory = new SerializationFactoryImpl((QName)key, array, array);
                    factoryRegistry.add((QName)key, factory);
                    continue;
                }
                SerializationFactoryImpl factory = new SerializationFactoryImpl((QName)key, serdesClassName, serdesClassName);
                factory.init(classLoader);
                factoryRegistry.add((QName)key, factory);
            }
            catch (Exception e) {
                success = false;
                this.unregisterTypes(factoryRegistry);
                throw e;
            }
        }
    }

    public void unregisterTypes(TypeMapping typeMapping) {
        SDFactoryRegistry factoryRegistry = ((TypeMappingImpl)typeMapping).getSDFactoryRegistry();
        Hashtable perm = this.getQNameMapping();
        Enumeration keys = perm.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            factoryRegistry.remove((QName)key);
        }
        keys = this.elementToType.keys();
        while (keys.hasMoreElements()) {
            QName elementName = (QName)keys.nextElement();
            ((TypeMappingImpl)typeMapping).removeElement(elementName);
        }
    }

    public void unregisterTypes(SDFactoryRegistry factoryRegistry) {
        Hashtable perm = this.getQNameMapping();
        Enumeration keys = perm.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            factoryRegistry.remove((QName)key);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean isLoaded() {
        return this.isInitialized;
    }

    public ArrayList getComplexFieldInfo(ComplexTypeDefinition ct) {
        if (!this.gct.getTypeFieldInfo().containsKey(ct)) {
            try {
                this.gct.loadComplexType(ct, this.getJavaPrimitive((TypeDefinitionBase)ct));
            }
            catch (SchemaToJavaGeneratorException e) {
                return null;
            }
        }
        return (ArrayList)this.gct.getTypeFieldInfo().get(ct);
    }

    public ArrayList getComplexAttributeInfo(ComplexTypeDefinition ct) {
        if (!this.gct.getTypeFieldInfo().containsKey(ct)) {
            try {
                this.gct.loadComplexType(ct, this.getJavaPrimitive((TypeDefinitionBase)ct));
            }
            catch (SchemaToJavaGeneratorException e) {
                return null;
            }
        }
        return (ArrayList)this.gct.getTypeAttributeInfo().get(ct);
    }

    public int getComplexTypeKind(ComplexTypeDefinition ct) {
        boolean isSimpleBase = false;
        SimpleTypeDefinition simpleType = ct.getContentTypeSimpleTypeDefinition();
        if (simpleType != null) {
            isSimpleBase = true;
        }
        int kind = 0;
        if (isSimpleBase) {
            kind = 0;
        } else {
            kind = 3;
            Particle cm = ct.getContentTypeContentModel();
            if (cm != null && cm.getTerm() instanceof ModelGroup) {
                ModelGroup mg = (ModelGroup)cm.getTerm();
                if (mg.isCompositorAll() && cm.getMinOccurs() == 1 && cm.getMaxOccurs() == 1) {
                    kind = 4;
                }
                if (mg.isCompositorSequence()) {
                    kind = 3;
                }
                if (mg.isCompositorChoice() && cm.getMinOccurs() == 1 && cm.getMaxOccurs() == 1) {
                    kind = 2;
                }
            }
        }
        return kind;
    }

    public Hashtable getJavaToSchemaMapping() {
        Hashtable<String, QName> result = new Hashtable<String, QName>();
        Enumeration keys = this.hTypeToClass.keys();
        while (keys.hasMoreElements()) {
            TypeDefinitionBase type = (TypeDefinitionBase)keys.nextElement();
            String javaClass = this.getJavaPrimitive(type);
            String typeName = type.getName();
            String typeNamespace = type.getTargetNamespace();
            if (typeName == null || typeName.length() == 0) {
                typeName = DOM.toXPath((Node)type.getAssociatedDOMNode());
            }
            QName qname = new QName(typeNamespace, typeName);
            result.put(javaClass, qname);
        }
        keys = JAVA_TO_SCHEMA_SIMPLE.keys();
        while (keys.hasMoreElements()) {
            String javaType = (String)keys.nextElement();
            String xmlType = (String)JAVA_TO_SCHEMA_SIMPLE.get(javaType);
            QName qname = new QName("http://www.w3.org/2001/XMLSchema", xmlType);
            result.put(javaType, qname);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JAXRPC_BUILT_IN_TO_JAVA.put("anyType", "java.lang.Object");
        JAXRPC_BUILT_IN_TO_JAVA.put("anySimpleType", "java.lang.Object");
        JAXRPC_BUILT_IN_TO_JAVA.put("duration", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("dateTime", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("time", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("date", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("gYearMonth", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("gYear", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("gMonthDay", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("gDay", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("gMonth", "java.util.Calendar");
        JAXRPC_BUILT_IN_TO_JAVA.put("boolean", "boolean");
        JAXRPC_BUILT_IN_TO_JAVA.put("base64Binary", "byte[]");
        JAXRPC_BUILT_IN_TO_JAVA.put("hexBinary", "byte[]");
        JAXRPC_BUILT_IN_TO_JAVA.put("float", "float");
        JAXRPC_BUILT_IN_TO_JAVA.put("double", "double");
        JAXRPC_BUILT_IN_TO_JAVA.put("anyURI", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("QName", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("NOTATION", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("string", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("normalizedString", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("token", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("language", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("Name", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("NMTOKEN", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("NCName", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("NMTOKENS", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("ID", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("IDREF", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("ENTITY", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("IDREFS", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("ENTITIES", "java.lang.String");
        JAXRPC_BUILT_IN_TO_JAVA.put("decimal", "java.math.BigDecimal");
        JAXRPC_BUILT_IN_TO_JAVA.put("integer", "java.math.BigInteger");
        JAXRPC_BUILT_IN_TO_JAVA.put("nonPositiveInteger", "java.math.BigInteger");
        JAXRPC_BUILT_IN_TO_JAVA.put("long", "long");
        JAXRPC_BUILT_IN_TO_JAVA.put("nonNegativeInteger", "java.math.BigInteger");
        JAXRPC_BUILT_IN_TO_JAVA.put("negativeInteger", "java.math.BigInteger");
        JAXRPC_BUILT_IN_TO_JAVA.put("int", "int");
        JAXRPC_BUILT_IN_TO_JAVA.put("unsignedLong", "long");
        JAXRPC_BUILT_IN_TO_JAVA.put("positiveInteger", "java.math.BigInteger");
        JAXRPC_BUILT_IN_TO_JAVA.put("short", "short");
        JAXRPC_BUILT_IN_TO_JAVA.put("unsignedInt", "int");
        JAXRPC_BUILT_IN_TO_JAVA.put("byte", "byte");
        JAXRPC_BUILT_IN_TO_JAVA.put("unsignedShort", "short");
        JAXRPC_BUILT_IN_TO_JAVA.put("unsignedByte", "byte");
        JAXRPC_WRAPPER_CLASS = new Hashtable();
        JAXRPC_WRAPPER_CLASS.put("long", "java.lang.Long");
        JAXRPC_WRAPPER_CLASS.put("int", "java.lang.Integer");
        JAXRPC_WRAPPER_CLASS.put("short", "java.lang.Short");
        JAXRPC_WRAPPER_CLASS.put("byte", "java.lang.Byte");
        JAXRPC_WRAPPER_CLASS.put("boolean", "java.lang.Boolean");
        JAXRPC_WRAPPER_CLASS.put("float", "java.lang.Float");
        JAXRPC_WRAPPER_CLASS.put("double", "java.lang.Double");
        JAVA_TO_SCHEMA_SIMPLE = new Hashtable();
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Long", "long");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Integer", "int");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Short", "short");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Byte", "byte");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Boolean", "boolean");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Float", "float");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.Double", "double");
        JAVA_TO_SCHEMA_SIMPLE.put("long", "long");
        JAVA_TO_SCHEMA_SIMPLE.put("int", "int");
        JAVA_TO_SCHEMA_SIMPLE.put("short", "short");
        JAVA_TO_SCHEMA_SIMPLE.put("byte", "byte");
        JAVA_TO_SCHEMA_SIMPLE.put("boolean", "boolean");
        JAVA_TO_SCHEMA_SIMPLE.put("float", "float");
        JAVA_TO_SCHEMA_SIMPLE.put("double", "double");
        JAVA_TO_SCHEMA_SIMPLE.put("byte[]", "base64Binary");
        JAVA_TO_SCHEMA_SIMPLE.put("java.util.Calendar", "dateTime");
        JAVA_TO_SCHEMA_SIMPLE.put("java.lang.String", "string");
        JAVA_TO_SCHEMA_SIMPLE.put((class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaToJavaGenerator.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName(), "integer");
        JAVA_TO_SCHEMA_SIMPLE.put((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SchemaToJavaGenerator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), "decimal");
        SOAP_ARRAY_SERIALIZER = (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$Array11SD == null ? (class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$Array11SD = SchemaToJavaGenerator.class$("com.sap.engine.services.webservices.jaxrpc.encoding.primitive.Array11SD")) : class$com$sap$engine$services$webservices$jaxrpc$encoding$primitive$Array11SD).getName();
    }
}

