/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.schema2java;

import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.NameConvertor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;

public final class CommandLine {
    private static void printUsage() {
        System.out.println("Usage: com.sap.engine.services.webservices.jaxrpc.schema2java.CommandLine <schema_file> [<output_directory_base> [<output_package>]]");
        System.out.println();
        System.out.println("\tIf you do not specify an output directory, it defaults to 'output'.");
        System.out.println("\tIf you do not specify an output package, the default package is assumed.");
        System.out.println("\tTo launch the GUI type:");
        System.out.println("\t\tcom.sap.engine.services.webservices.jaxrpc.schema2java.CommandLine -gui");
    }

    public static void main(String[] args) throws Exception {
        TypeMappingRegistryImpl baseRegistry;
        System.out.println("SAP Schema-to-Java generator");
        System.out.println();
        long t0 = System.currentTimeMillis();
        if (args.length == 0) {
            CommandLine.printUsage();
            return;
        }
        if (args[0].equals("-gui")) {
            return;
        }
        String mappingFile = null;
        String schemaFilename = args[0];
        String outputDirname = args.length > 1 ? args[1] : "output";
        String outputPackage = args.length > 2 ? args[2] : "";
        boolean interfaces = false;
        Properties uriToPackage = null;
        String pmfile = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-p")) {
                pmfile = args[i + 1];
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-i")) {
                interfaces = true;
                if (i2 + 1 >= args.length) break;
                mappingFile = args[i2 + 1];
                break;
            }
            if (args[i2].equals("-x")) {
                if (i2 + 1 >= args.length) break;
                mappingFile = args[i2 + 1];
                break;
            }
            ++i2;
        }
        File outputDir = new File(outputDirname);
        outputDir.mkdirs();
        SchemaToJavaGenerator g = new SchemaToJavaGenerator();
        g.addSchemaSource(new StreamSource(schemaFilename));
        g.setSmartMode(true);
        if (pmfile != null) {
            uriToPackage = new Properties();
            File inputFile = new File(outputDir, pmfile);
            FileInputStream inputStream = new FileInputStream(inputFile);
            uriToPackage.load(inputStream);
            g.setUriToPackagetMapping(uriToPackage);
        }
        NameConvertor convertor = new NameConvertor();
        if (interfaces) {
            g.setContainerMode(true);
        } else if (mappingFile != null) {
            Properties properties = new Properties();
            File inputFile = new File(outputDir, mappingFile);
            FileInputStream inputStream = new FileInputStream(inputFile);
            properties.load(inputStream);
            inputStream.close();
            HashMap<QName, String> hash1 = new HashMap<QName, String>();
            HashMap<String, QName> hash2 = new HashMap<String, QName>();
            Enumeration qnames = ((Hashtable)properties).keys();
            while (qnames.hasMoreElements()) {
                String qnameString = (String)qnames.nextElement();
                QName qname = QName.valueOf(qnameString);
                String javaName = properties.getProperty(qnameString);
                hash1.put(qname, javaName);
                hash2.put(javaName, qname);
            }
            g.setApplicationSchemaMapping(hash1);
            g.setApplicationJavaMapping(hash2);
        }
        g.generateAll(outputDir, outputPackage, true);
        if (!interfaces) {
            baseRegistry = new TypeMappingRegistryImpl();
            g.registerTypes(baseRegistry.getDefaultTypeMappingImpl());
            if (outputPackage.length() != 0) {
                File perm = new File(outputDir, convertor.packageToPath(outputPackage));
                baseRegistry.toXmlFile(new File(perm, "types.xml"));
            } else {
                baseRegistry.toXmlFile(new File(outputDir, "types.xml"));
            }
        } else if (mappingFile != null) {
            baseRegistry = new TypeMappingRegistryImpl();
            g.registerTypes(baseRegistry.getDefaultTypeMappingImpl());
            TypeMappingImpl typeMapping = baseRegistry.getDefaultTypeMappingImpl();
            File outputFile = null;
            if (outputPackage.length() != 0) {
                File perm = new File(outputDir, convertor.packageToPath(outputPackage));
                outputFile = new File(perm, mappingFile);
            } else {
                outputFile = new File(outputDir, mappingFile);
            }
            Enumeration schemaTypes = typeMapping.getRegisteredSchemaTypes();
            Properties properties = new Properties();
            while (schemaTypes.hasMoreElements()) {
                QName type = (QName)schemaTypes.nextElement();
                String javaType = typeMapping.getDefaultJavaType(type);
                properties.setProperty(type.toString(), javaType);
            }
            FileOutputStream output = new FileOutputStream(outputFile);
            properties.store(output, "Generated by SAP Schema to Java generator. Schema to Java mapping file.");
            ((OutputStream)output).close();
        }
        System.out.println("Generated in " + (System.currentTimeMillis() - t0) + "ms");
    }
}

