/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.java2schema;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.services.webservices.jaxrpc.java2schema.JavaToSchemaGenerator;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SchemaInfo {
    private static final String URI_PREFIX = "urn:";
    private static final String PREFIX_BASE = "s";
    private static final String EMPTYNAMESPACE = "";
    private Element schemaElement;
    private Hashtable imports;
    private String targetNamespace;
    private int prefixNom = 0;

    SchemaInfo(String targetNamespace) throws WSDLException {
        try {
            this.targetNamespace = targetNamespace;
            this.imports = new Hashtable();
            SystemProperties.setProperty((String)"javax.xml.parsers.DocumentBuilderFactory", (String)"com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().newDocument();
            this.schemaElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
            this.schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            this.schemaElement.setAttributeNS(EMPTYNAMESPACE, "targetNamespace", targetNamespace);
            this.schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", targetNamespace);
            this.imports.put(targetNamespace, "tns");
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException(e);
        }
    }

    static String getUriFromClass(Class cl, String suffix) {
        String name;
        int i;
        if (cl.isArray()) {
            cl = JavaToSchemaGenerator.getComponentClass(cl);
        }
        if ((i = (name = cl.getName()).lastIndexOf(46)) == -1) {
            return "urn:/" + suffix;
        }
        String packg = name.substring(0, i + 1);
        return URI_PREFIX + packg.replace('.', '/') + suffix;
    }

    String getPrefixForClass(Class cl, String suffix) {
        String uri = SchemaInfo.getUriFromClass(cl, suffix);
        if (this.imports.get(uri) != null) {
            return (String)this.imports.get(uri);
        }
        String newPrefix = PREFIX_BASE + this.prefixNom++;
        this.imports.put(uri, newPrefix);
        return newPrefix;
    }

    String getTargetNamespace() {
        return this.targetNamespace;
    }

    Element getSchemaElement() {
        return this.schemaElement;
    }

    Element normalizeSchema() {
        Enumeration uries = this.imports.keys();
        Node firstChild = this.schemaElement.getFirstChild();
        while (uries.hasMoreElements()) {
            String tempUri = (String)uries.nextElement();
            String tempPrefix = (String)this.imports.get(tempUri);
            if (tempUri.equals(this.targetNamespace)) continue;
            this.schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tempPrefix, tempUri);
            if (tempUri == EMPTYNAMESPACE) continue;
            Element importElement = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:import");
            importElement.setAttributeNS(EMPTYNAMESPACE, "namespace", tempUri);
            this.schemaElement.insertBefore(importElement, firstChild);
        }
        return this.schemaElement;
    }
}

