/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.java2schema;

import com.sap.engine.services.webservices.jaxrpc.java2schema.DataField;
import com.sap.engine.services.webservices.jaxrpc.java2schema.DataFieldList;
import com.sap.engine.services.webservices.jaxrpc.java2schema.NameMappingRegistry;
import com.sap.engine.services.webservices.jaxrpc.java2schema.SchemaInfo;
import com.sap.engine.services.webservices.jaxrpc.java2schema.StandardTypes;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;

public class JavaToSchemaGenerator {
    public static final String SCHEMA_PREFIX = "xs:";
    public static final String SOAPENC_PREFIX = "soapenc:";
    public static final String TNS_STANDALONE = "tns";
    public static final String TNS_PREFIX = "tns:";
    public static final String ARRAY_PREFIX = "ArrayOf";
    public static final String ARRAY_DIMENTION_POSTFIX = "_";
    public static final String LITERAL_NS_SUFFIX = "literal";
    public static final String ENCODED_NS_SUFFIX = "encoded";
    public static final String SCHEMA_COMPLEXTYPE = "xs:complexType";
    public static final String SCHEMA_COMPLEXCONTENT = "xs:complexContent";
    public static final String SCHEMA_RESTRICTION = "xs:restriction";
    public static final String SCHEMA_ATTRIBUTE = "xs:attribute";
    public static final String SCHEMA_ALL = "xs:all";
    public static final String SCHEMA_ELEMENT = "xs:element";
    public static final String SCHEMA_EXTENSION = "xs:extension";
    public static final String SCHEMA_SEQUENCE = "xs:sequence";
    public static final String SCHEMA_NAME = "name";
    public static final String SCHEMA_REF = "ref";
    public static final String SCHEMA_BASE = "base";
    public static final String SCHEMA_TYPE = "type";
    public static final String SCHEMA_NILLABLE = "nillable";
    public static final String SCHEMA_MAXOCCURS = "maxOccurs";
    public static final String SCHEMA_MINOCCURS = "minOccurs";
    public static final String SCHEMA_UNBOUNDED = "unbounded";
    public static final String SOAPENC_ARRAY_TYPE = "soapenc:arrayType";
    public static final String SOAPENC_ARRAY = "soapenc:Array";
    public static final String WSDL_ARRAY_TYPE = "wsdl:arrayType";
    public static final String SOAP11_ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String LITERAL_ENCODING = "literal";
    private Element schemaElement;
    private ArrayList alreadyGenerated;
    private NameMappingRegistry nameRegistry;
    private HashMap nameMapping;
    private Hashtable schemas = new Hashtable();
    private SchemaInfo currentSchema;
    private boolean isLiteralArrayRepresentation = false;
    private String currentSuffix = "encoded";
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Object;

    public JavaToSchemaGenerator() {
        this(new NameMappingRegistry());
    }

    public JavaToSchemaGenerator(NameMappingRegistry nameMappingGegistry) {
        this.alreadyGenerated = new ArrayList();
        this.nameRegistry = nameMappingGegistry;
        this.nameMapping = new HashMap();
    }

    public void setNameMappingRegistry(NameMappingRegistry registry) {
        this.nameRegistry = registry;
    }

    public HashMap getJavaToQNameMappings() {
        return (HashMap)this.nameMapping.clone();
    }

    public Element parseParameterClass(Class cl) throws WSDLException {
        if (this.alreadyGenerated.contains(cl)) {
            return null;
        }
        if (StandardTypes.isStandardType(cl)) {
            return null;
        }
        String schemaUri = SchemaInfo.getUriFromClass(cl, this.currentSuffix);
        SchemaInfo temp = (SchemaInfo)this.schemas.get(schemaUri);
        if (temp == null) {
            temp = new SchemaInfo(schemaUri);
            this.schemas.put(schemaUri, temp);
        }
        this.schemaElement = temp.getSchemaElement();
        this.currentSchema = temp;
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = JavaToSchemaGenerator.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(cl)) {
            this.checkClassAsJaxRpcValueType(cl);
        }
        if (cl.isArray()) {
            Class<?> componentClass = cl.getComponentType();
            if (this.isLiteralArrayRepresentation) {
                this.parseLiteralArray(cl);
            } else {
                this.parseSOAPArray(cl);
            }
            this.alreadyGenerated.add(cl);
            if (!StandardTypes.isStandardType(componentClass)) {
                this.parseParameterClass(componentClass);
            }
        } else {
            DataFieldList list = this.obtainDataFieldList(cl);
            this.parseClassFields(list);
            this.alreadyGenerated.add(cl);
            int i = 0;
            while (i < list.size()) {
                this.parseParameterClass(list.item(i).getDataClass());
                ++i;
            }
        }
        return this.schemaElement;
    }

    public DOMSource[] parseInEncodedMode(Class[] clArray) throws WSDLException {
        int i = 0;
        while (i < clArray.length) {
            this.parseParameterClass(clArray[i]);
            ++i;
        }
        return this.createDomSourcesFromSchemas();
    }

    public DOMSource[] parseInLiteralMode(Class[] clArray) throws WSDLException {
        this.isLiteralArrayRepresentation = true;
        this.currentSuffix = "literal";
        return this.parseInEncodedMode(clArray);
    }

    public void clearState() {
        this.isLiteralArrayRepresentation = false;
        this.currentSuffix = ENCODED_NS_SUFFIX;
        this.nameMapping.clear();
        this.schemas.clear();
        this.alreadyGenerated.clear();
    }

    private void checkClassAsJaxRpcValueType(Class cl) throws WSDLException {
        if (cl.isArray()) {
            return;
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = JavaToSchemaGenerator.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cl)) {
            throw new WSDLException("JAX-RPC Value Type  must not extends java.rmi.Remote. Problematic class: " + cl.getName());
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = JavaToSchemaGenerator.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(cl)) {
            throw new WSDLException("Parameter's class must implement java.io.Serializable. Problematic class: " + cl.getName());
        }
        try {
            cl.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new WSDLException("JAX-RPC Value Type  must have default constructor. Problematic class: " + cl.getName(), e);
        }
        catch (SecurityException se) {
            throw new WSDLException("Could not get information about class: " + cl, se);
        }
    }

    private void parseClassFields(DataFieldList list) throws WSDLException {
        Element complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
        Class dataFieldListClass = list.getDataClass();
        String nameValue = this.getComplexTypeNameValueAttribute(dataFieldListClass);
        complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
        this.nameMapping.put(dataFieldListClass.getName(), new QName(this.currentSchema.getTargetNamespace(), nameValue));
        Element all = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ALL);
        int i = 0;
        while (i < list.size()) {
            DataField tempField = list.item(i);
            Element temp = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ELEMENT);
            temp.setAttributeNS("", SCHEMA_NAME, tempField.getFieldName());
            if (this.setElementTypeAttributeValue(temp, tempField.getDataClass(), false)) {
                list.remove(i--);
            }
            all.appendChild(temp);
            ++i;
        }
        if ((class$java$lang$Exception == null ? (class$java$lang$Exception = JavaToSchemaGenerator.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(dataFieldListClass) && dataFieldListClass.getSuperclass() != (class$java$lang$Exception == null ? (class$java$lang$Exception = JavaToSchemaGenerator.class$("java.lang.Exception")) : class$java$lang$Exception) || !(class$java$lang$Exception == null ? (class$java$lang$Exception = JavaToSchemaGenerator.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(dataFieldListClass) && dataFieldListClass.getSuperclass() != (class$java$lang$Object == null ? (class$java$lang$Object = JavaToSchemaGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
            Element complexContent = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXCONTENT);
            Element extension = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_EXTENSION);
            extension.setAttributeNS("", SCHEMA_BASE, this.currentSchema.getPrefixForClass(dataFieldListClass.getSuperclass(), this.currentSuffix) + ":" + this.getComplexTypeNameValueAttribute(dataFieldListClass.getSuperclass()));
            extension.appendChild(all);
            complexContent.appendChild(extension);
            complexType.appendChild(complexContent);
            list.add(new DataField("", dataFieldListClass.getSuperclass()));
        } else {
            complexType.appendChild(all);
        }
        this.schemaElement.appendChild(complexType);
    }

    private void parseLiteralArray(Class cl) {
        Element complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
        String nameValue = this.getComplexTypeNameValueAttribute(cl);
        complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
        this.nameMapping.put(cl.getName(), new QName(this.currentSchema.getTargetNamespace(), nameValue));
        Element sequence = (Element)complexType.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_SEQUENCE));
        Element arrayElement = (Element)sequence.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ELEMENT));
        arrayElement.setAttributeNS("", SCHEMA_MAXOCCURS, SCHEMA_UNBOUNDED);
        arrayElement.setAttributeNS("", SCHEMA_MINOCCURS, "0");
        arrayElement.setAttributeNS("", SCHEMA_NAME, "item");
        this.setElementTypeAttributeValue(arrayElement, cl.getComponentType(), false);
        this.schemaElement.appendChild(complexType);
    }

    private void parseSOAPArray(Class cl) {
        Element complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
        String nameValue = this.getComplexTypeNameValueAttribute(cl);
        complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
        this.nameMapping.put(cl.getName(), new QName(this.currentSchema.getTargetNamespace(), nameValue));
        Element complexContent = (Element)complexType.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXCONTENT));
        Element restriction = (Element)complexContent.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_RESTRICTION));
        restriction.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenc", SOAP11_ENCODING);
        restriction.setAttributeNS("", SCHEMA_BASE, SOAPENC_ARRAY);
        Element attribute = (Element)restriction.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ATTRIBUTE));
        attribute.setAttributeNS("", SCHEMA_REF, SOAPENC_ARRAY_TYPE);
        this.setElementTypeAttributeValue(attribute, cl.getComponentType(), true);
        this.schemaElement.appendChild(complexType);
    }

    private DataFieldList obtainDataFieldList(Class cl) throws WSDLException {
        DataFieldList list = new DataFieldList(cl);
        this.initFields(list, cl);
        this.initProperties(list, cl);
        return list;
    }

    private void initFields(DataFieldList list, Class cl) {
        Field[] fields = cl.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field tempField = fields[i];
            int fieldModifier = tempField.getModifiers();
            if (Modifier.isPublic(fieldModifier) && !Modifier.isFinal(fieldModifier) && !Modifier.isTransient(fieldModifier)) {
                DataField dtField = new DataField(tempField.getName(), tempField.getType());
                list.add(dtField);
            }
            ++i;
        }
    }

    private void initProperties(DataFieldList list, Class cl) throws WSDLException {
        try {
            PropertyDescriptor[] properties = Introspector.getBeanInfo(cl, cl.getSuperclass()).getPropertyDescriptors();
            int i = 0;
            while (i < properties.length) {
                if (properties[i].getReadMethod() != null && properties[i].getWriteMethod() != null) {
                    DataField df = new DataField(properties[i].getName(), properties[i].getPropertyType());
                    if (list.countains(df)) {
                        throw new WSDLException("There is property and filed with same names. Conflict name is '" + df.getFieldName() + "'");
                    }
                    list.add(df);
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            throw new WSDLException(e);
        }
    }

    private boolean setElementTypeAttributeValue(Element element, Class javaClass, boolean isEncodedArray) {
        if (StandardTypes.isStandardType(javaClass)) {
            if (!isEncodedArray) {
                element.setAttributeNS("", SCHEMA_TYPE, StandardTypes.getMapType(javaClass.getName()));
            } else {
                element.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", WSDL_ARRAY_TYPE, StandardTypes.getMapType(javaClass.getName()) + "[]");
            }
            if (StandardTypes.isNillableStandardType(javaClass.getName())) {
                element.setAttributeNS("", SCHEMA_NILLABLE, "true");
            }
            return true;
        }
        String nameBase = this.getComplexTypeNameValueAttribute(javaClass);
        String prefix = this.currentSchema.getPrefixForClass(javaClass, this.currentSuffix);
        if (!isEncodedArray) {
            element.setAttributeNS("", SCHEMA_TYPE, prefix + ":" + nameBase);
        } else {
            element.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", WSDL_ARRAY_TYPE, prefix + ":" + nameBase + "[]");
        }
        element.setAttributeNS("", SCHEMA_NILLABLE, "true");
        return false;
    }

    private String getComplexTypeNameValueAttribute(Class cl) {
        if (cl.isArray()) {
            Class component = JavaToSchemaGenerator.getComponentClass(cl);
            return ARRAY_PREFIX + this.nameRegistry.getJavaClassMappingName(this.getClearClassName(component)) + this.getArrayPostfix(cl);
        }
        return this.nameRegistry.getJavaClassMappingName(this.getClearClassName(cl));
    }

    private DOMSource[] createDomSourcesFromSchemas() {
        Collection coll = this.schemas.values();
        SchemaInfo[] schemaArray = coll.toArray(new SchemaInfo[coll.size()]);
        DOMSource[] domSources = new DOMSource[schemaArray.length];
        int i = 0;
        while (i < schemaArray.length) {
            DOMSource tempSource;
            domSources[i] = tempSource = new DOMSource(schemaArray[i].normalizeSchema());
            ++i;
        }
        return domSources;
    }

    private String getArrayPostfix(Class cl) {
        int dimention = JavaToSchemaGenerator.getDimention(cl);
        if (dimention > 1) {
            return ARRAY_DIMENTION_POSTFIX + Integer.toString(dimention);
        }
        return "";
    }

    private String getClearClassName(Class cl) {
        String className = cl.getName();
        int p = className.lastIndexOf(".");
        if (p == -1) {
            return className;
        }
        return className.substring(p + 1);
    }

    static int getDimention(Class cl) {
        if (!cl.isArray()) {
            return 0;
        }
        return 1 + JavaToSchemaGenerator.getDimention(cl.getComponentType());
    }

    static Class getComponentClass(Class cl) {
        if (!cl.isArray()) {
            return cl;
        }
        return JavaToSchemaGenerator.getComponentClass(cl.getComponentType());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

