/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding.primitive;

import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.Duration;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;

public class CalendarConverter {
    public static boolean dateTimeZone = false;
    private static final int POOL_SIZE = 25;
    private static SimpleDateFormat[] dateFormatPool = new SimpleDateFormat[25];
    private static int dateSize = 0;
    private static SimpleDateFormat[] timeFormatPool = new SimpleDateFormat[25];
    private static int timeSize = 0;
    private static SimpleDateFormat[] relativeFormatPool = new SimpleDateFormat[25];
    private static int relativeSize = 0;
    private static Hashtable timeZones = new Hashtable();
    public static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private static synchronized TimeZone getTimeZone(String offset) {
        TimeZone result = (TimeZone)timeZones.get(offset);
        if (result == null) {
            result = TimeZone.getTimeZone(offset);
            timeZones.put(offset, result);
        }
        return result;
    }

    private static synchronized SimpleDateFormat getRelativeFormatter() {
        if (relativeSize > 0) {
            SimpleDateFormat result = relativeFormatPool[--relativeSize];
            CalendarConverter.relativeFormatPool[CalendarConverter.relativeSize] = null;
            return result;
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    private static synchronized void returnRelativeFormatter(SimpleDateFormat sd) {
        if (relativeSize < relativeFormatPool.length) {
            CalendarConverter.relativeFormatPool[CalendarConverter.relativeSize] = sd;
            ++relativeSize;
            return;
        }
    }

    private static synchronized SimpleDateFormat getDateFormatter() {
        if (dateSize > 0) {
            SimpleDateFormat result = dateFormatPool[--dateSize];
            CalendarConverter.dateFormatPool[CalendarConverter.dateSize] = null;
            return result;
        }
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private static synchronized void returnDateFormatter(SimpleDateFormat sd) {
        if (dateSize < dateFormatPool.length) {
            CalendarConverter.dateFormatPool[CalendarConverter.dateSize] = sd;
            ++dateSize;
            return;
        }
    }

    private static synchronized SimpleDateFormat getTimeFormatter() {
        if (timeSize > 0) {
            return timeFormatPool[--timeSize];
        }
        return new SimpleDateFormat("HH:mm:ss.SSS");
    }

    private static synchronized void returnTimeFormatter(SimpleDateFormat sd) {
        if (timeSize < timeFormatPool.length) {
            CalendarConverter.timeFormatPool[CalendarConverter.timeSize] = sd;
            ++timeSize;
            return;
        }
    }

    public static final Calendar parseTime(String time) throws Exception {
        return CalendarConverter.parseTime(time, false);
    }

    public static final Calendar parseTime(String time, boolean forceGMT) throws Exception {
        Date sentTime;
        GregorianCalendar calendar = forceGMT ? new GregorianCalendar(CalendarConverter.getTimeZone("GMT")) : new GregorianCalendar();
        SimpleDateFormat df = CalendarConverter.getTimeFormatter();
        df.setCalendar(calendar);
        if (time.indexOf(".") == -1) {
            time = time + ".0";
        }
        try {
            sentTime = df.parse(time);
        }
        catch (Exception e) {
            CalendarConverter.returnTimeFormatter(df);
            throw new Exception("Time could not be parsed correctly [" + time + "]");
        }
        calendar.setTime(sentTime);
        CalendarConverter.returnTimeFormatter(df);
        return calendar;
    }

    public static final String getTimeSpecial(Calendar calendar) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        df.setCalendar(calendar);
        String result = df.format(calendar.getTime());
        CalendarConverter.returnTimeFormatter(df);
        return result;
    }

    public static final String getTime(Calendar calendar) {
        SimpleDateFormat df = CalendarConverter.getTimeFormatter();
        df.setCalendar(calendar);
        String result = df.format(calendar.getTime());
        CalendarConverter.returnTimeFormatter(df);
        return result;
    }

    public static final String getDuration(Duration duration) {
        StringBuffer result = new StringBuffer();
        if (!duration.isPositive()) {
            result.append('-');
        }
        result.append('P');
        if (duration.hasDate()) {
            if (duration.getYears() != 0) {
                result.append(String.valueOf(duration.getYears()));
                result.append('Y');
            }
            if (duration.getMonths() != 0) {
                result.append(String.valueOf(duration.getMonths()));
                result.append('M');
            }
            if (duration.getDays() != 0) {
                result.append(String.valueOf(duration.getDays()));
                result.append('D');
            }
        } else {
            result.append("0Y");
        }
        if (duration.hasTime()) {
            result.append('T');
            if (duration.getHours() != 0) {
                result.append(String.valueOf(duration.getHours()));
                result.append('H');
            }
            if (duration.getMinutes() != 0) {
                result.append(String.valueOf(duration.getMinutes()));
                result.append('M');
            }
            if (duration.getSeconds() != 0 || duration.getPrecision() != 0) {
                result.append(String.valueOf(duration.getSeconds()));
                if (duration.getPrecision() != 0) {
                    result.append('.');
                    result.append(String.valueOf(duration.getPrecision()));
                }
                result.append('S');
            }
        }
        return result.toString();
    }

    private static int getFirstIndex(String str, String chars) throws Exception {
        int result = -1;
        int i = 0;
        while (i < chars.length()) {
            int index = str.indexOf(chars.charAt(i));
            if (index != -1 && result != -1 && index < result) {
                throw new Exception("Symbol [" + chars.charAt(i) + "] can not be before [" + chars.charAt(result) + ") in duration !");
            }
            if (index != -1 && result == -1) {
                result = index;
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static final Duration parseDuration(String string) throws Exception {
        block16: {
            dstring = string.trim();
            result = new Duration();
            if (dstring.startsWith("-")) {
                result.setNegative();
                dstring = dstring.substring(1);
            }
            if ((timeIndex = dstring.indexOf(84)) == -1) break block16;
            time = dstring.substring(timeIndex + 1);
            dstring = dstring.substring(0, timeIndex);
            if (time.length() != 0) ** GOTO lbl29
            throw new Exception("Duration [" + string + "] is not valid !");
lbl-1000:
            // 1 sources

            {
                nextIndex = CalendarConverter.getFirstIndex(time, "HMS");
                if (nextIndex == -1) {
                    throw new Exception("Duration [" + string + "] is not valid !");
                }
                substr = time.substring(0, nextIndex);
                switch (time.charAt(nextIndex)) {
                    case 'H': {
                        result.setHours(Integer.parseInt(substr));
                        break;
                    }
                    case 'M': {
                        result.setMinutes(Integer.parseInt(substr));
                        break;
                    }
                    case 'S': {
                        if (substr.indexOf(46) != -1) {
                            precision = substr.substring(substr.indexOf(46) + 1);
                            substr = substr.substring(0, substr.indexOf(46));
                            result.setPrecision(Integer.parseInt(precision));
                        }
                        result.setSeconds(Integer.parseInt(substr));
                    }
                }
                time = time.substring(nextIndex + 1);
lbl29:
                // 2 sources

                ** while (time.length() != 1)
            }
        }
        if (dstring.length() != 0) ** GOTO lbl47
        throw new Exception("Duration [" + string + "] is not valid !");
lbl-1000:
        // 1 sources

        {
            nextIndex = CalendarConverter.getFirstIndex(dstring, "YMD");
            if (nextIndex == -1) {
                throw new Exception("Duration [" + string + "] is not valid !");
            }
            substr = dstring.substring(0, nextIndex);
            switch (dstring.charAt(nextIndex)) {
                case 'Y': {
                    result.setHours(Integer.parseInt(substr));
                    break;
                }
                case 'M': {
                    result.setMinutes(Integer.parseInt(substr));
                    break;
                }
                case 'D': {
                    result.setSeconds(Integer.parseInt(substr));
                }
            }
            dstring = dstring.substring(nextIndex + 1);
lbl47:
            // 2 sources

            ** while (dstring.length() != 1)
        }
lbl48:
        // 1 sources

        return result;
    }

    private static void appendFormatedNumber(int number, char[] result) {
        if (number < 0) {
            number = -number;
        }
        int index = result.length - 1;
        while (number != 0 && index >= 0) {
            int perm = number % 10;
            result[index] = CHARS[perm];
            number /= 10;
            --index;
        }
        while (index >= 0) {
            result[index] = 48;
            --index;
        }
    }

    private static void appendFormatedNumber(int number, char[] result, int index, int begindex) {
        if (number < 0) {
            number = -number;
        }
        while (number != 0 && index >= begindex) {
            int perm = number % 10;
            result[index] = CHARS[perm];
            number /= 10;
            --index;
        }
        while (index >= begindex) {
            result[index] = 48;
            --index;
        }
    }

    public static final String getDate(Calendar calendar) {
        Calendar workCalendar = (Calendar)calendar.clone();
        char[] perm = new char[6];
        int offset = calendar.get(15) / 60000;
        if (offset >= 0) {
            perm[0] = 43;
        } else {
            offset = -offset;
            perm[0] = 45;
        }
        CalendarConverter.appendFormatedNumber(offset / 60, perm, 2, 1);
        CalendarConverter.appendFormatedNumber(offset % 60, perm, 5, 4);
        perm[3] = 58;
        String soffset = new String(perm);
        SimpleDateFormat df = CalendarConverter.getDateFormatter();
        df.setCalendar(workCalendar);
        workCalendar.setTimeZone(CalendarConverter.getTimeZone("GMT" + soffset));
        if (offset == 0 || !dateTimeZone) {
            soffset = "";
        }
        soffset = df.format(workCalendar.getTime()) + soffset;
        CalendarConverter.returnDateFormatter(df);
        return soffset;
    }

    public static final Calendar parseDate(String time) throws Exception {
        return CalendarConverter.parseDate(time, false);
    }

    public static final Calendar parseDate(String time, boolean useGMTWhenZoneIsMissing) throws Exception {
        int signPos = (time = time.trim()).indexOf(43);
        if (signPos == -1) {
            signPos = time.lastIndexOf(45);
            if (time.indexOf(58) == -1) {
                signPos = -1;
            }
        }
        if (signPos == -1) {
            Date sentTime;
            GregorianCalendar calendar = useGMTWhenZoneIsMissing ? new GregorianCalendar(CalendarConverter.getTimeZone("GMT")) : new GregorianCalendar();
            SimpleDateFormat df = CalendarConverter.getDateFormatter();
            df.setCalendar(calendar);
            try {
                sentTime = df.parse(time);
            }
            catch (Exception e) {
                CalendarConverter.returnDateFormatter(df);
                throw new Exception("Date could not be parsed correctly [" + time + "]");
            }
            calendar.setTime(sentTime);
            CalendarConverter.returnDateFormatter(df);
            return calendar;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat df = CalendarConverter.getDateFormatter();
        df.setCalendar(calendar);
        String mainTime = time.substring(0, signPos);
        String offset = time.substring(signPos);
        try {
            ((Calendar)calendar).setTimeZone(CalendarConverter.getTimeZone("GMT" + offset));
            calendar.setTime(df.parse(mainTime));
        }
        catch (Exception e) {
            CalendarConverter.returnDateFormatter(df);
            throw new Exception("Date could not be parsed Correctly [" + time + "]");
        }
        CalendarConverter.returnDateFormatter(df);
        return calendar;
    }

    public static final String getCanonical(Calendar calendar) {
        Calendar workCalendar = (Calendar)calendar.clone();
        workCalendar.setTimeZone(CalendarConverter.getTimeZone("GMT+00:00"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setCalendar(workCalendar);
        return df.format(workCalendar.getTime());
    }

    public static final String getDateCanonical(Calendar calendar) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setCalendar(calendar);
        return df.format(calendar.getTime()) + "T00:00:00.000Z";
    }

    public static final String getRelative(Calendar calendar) {
        Calendar workCalendar = (Calendar)calendar.clone();
        char[] perm = new char[6];
        int offset = calendar.get(15) / 60000;
        if (offset >= 0) {
            perm[0] = 43;
        } else {
            offset = -offset;
            perm[0] = 45;
        }
        CalendarConverter.appendFormatedNumber(offset / 60, perm, 2, 1);
        CalendarConverter.appendFormatedNumber(offset % 60, perm, 5, 4);
        perm[3] = 58;
        String soffset = new String(perm);
        SimpleDateFormat df = CalendarConverter.getRelativeFormatter();
        df.setCalendar(workCalendar);
        workCalendar.setTimeZone(CalendarConverter.getTimeZone("GMT" + soffset));
        soffset = df.format(workCalendar.getTime()) + soffset;
        CalendarConverter.returnRelativeFormatter(df);
        return soffset;
    }

    public static final Calendar parseRelative(String time) throws Exception {
        int signPos = (time = time.trim()).indexOf(43);
        if (signPos == -1 && (signPos = time.lastIndexOf(45)) < time.indexOf(84)) {
            signPos = -1;
        }
        if (signPos == -1) {
            Date sentTime;
            if (time.indexOf(".") == -1) {
                time = time + ".000";
            }
            GregorianCalendar calendar = new GregorianCalendar();
            SimpleDateFormat df = CalendarConverter.getRelativeFormatter();
            df.setCalendar(calendar);
            try {
                sentTime = df.parse(time);
            }
            catch (Exception e) {
                CalendarConverter.returnRelativeFormatter(df);
                throw new Exception("Time could not be parsed correctly [" + time + "]");
            }
            CalendarConverter.returnRelativeFormatter(df);
            calendar.setTime(sentTime);
            return calendar;
        }
        char sign = time.charAt(signPos);
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        SimpleDateFormat df = CalendarConverter.getRelativeFormatter();
        timeFormat.setCalendar(calendar);
        df.setCalendar(calendar);
        String mainTime = time.substring(0, signPos);
        String offset = time.substring(signPos + 1);
        try {
            timeFormat.parse(offset);
        }
        catch (Exception e) {
            CalendarConverter.returnRelativeFormatter(df);
            throw new Exception(" Zone offset not correct [" + offset + "]");
        }
        try {
            if (mainTime.indexOf(".") == -1) {
                mainTime = mainTime + ".0";
            }
            offset = time.substring(signPos);
            TimeZone x = CalendarConverter.getTimeZone("GMT" + offset);
            ((Calendar)calendar).setTimeZone(x);
            calendar.setTime(df.parse(mainTime));
            CalendarConverter.returnRelativeFormatter(df);
        }
        catch (Exception e) {
            CalendarConverter.returnRelativeFormatter(df);
            throw new Exception("Time could not be parsed Correctly [" + time + "]." + e.getMessage());
        }
        return calendar;
    }

    public static final Calendar parseCanonical(String time) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).setTimeZone(CalendarConverter.getTimeZone("GMT+00:00"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        time = time.substring(0, time.length() - 1);
        if (time.indexOf(46) == -1) {
            time = time + ".000";
        }
        df.setCalendar(calendar);
        try {
            calendar.setTime(df.parse(time));
        }
        catch (Exception e) {
            throw new Exception("Canonical time could not be parsed correctly [" + time + "]");
        }
        return calendar;
    }

    public static final Calendar parseDateTime(String time) throws SchemaException {
        if (time.indexOf("T") == -1 && time.indexOf("t") == -1) {
            try {
                return CalendarConverter.parseDate(time);
            }
            catch (Exception x) {
                throw new SchemaException((Throwable)x);
            }
        }
        if (time.endsWith("Z")) {
            try {
                Calendar result = CalendarConverter.parseCanonical(time);
                return result;
            }
            catch (Exception e) {
                throw new SchemaException((Throwable)e);
            }
        }
        try {
            Calendar result = CalendarConverter.parseRelative(time);
            return result;
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    public static void main(String[] args) {
    }
}

