/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding.primitive;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.Initializer;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.ArrayIterator;
import java.lang.reflect.Array;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArraySD
implements SerializerBase,
DeserializerBase,
Initializer {
    private final String customTypePrefix = "tns";
    private final String arrayItemName = "item";
    private String itemTypeLocal;
    private String itemTypeUri;

    public String[] getInitParams() {
        String[] result = new String[]{this.itemTypeUri, this.itemTypeLocal};
        return result;
    }

    public ArraySD(String itemTypeUri, String itemType) {
        this.itemTypeLocal = itemType;
        this.itemTypeUri = itemTypeUri;
    }

    private Class getArrayComponentClass(Class cl) {
        if (!cl.isArray()) {
            return cl;
        }
        return this.getArrayComponentClass(cl.getComponentType());
    }

    private int getDimensionCount(Class arrayClass) {
        if (!arrayClass.isArray()) {
            return 0;
        }
        return 1 + this.getDimensionCount(arrayClass.getComponentType());
    }

    private int[] getArrayDimensions(Object obj) {
        int dimCount = this.getDimensionCount(obj.getClass());
        int[] result = new int[dimCount];
        Object perm = obj;
        while (dimCount != 0) {
            result[result.length - dimCount] = Array.getLength(perm);
            if (result[result.length - dimCount] == 0) break;
            perm = Array.get(perm, 0);
            --dimCount;
        }
        return result;
    }

    private void soapArraySerialize(Object arr, SerializerBase serializer, Element e, String itemNamespace, int currentLevel, int maxLevel, SOAPSerializationContext context) throws MarshalException {
        if (currentLevel == maxLevel) {
            Element outputelement = e.getOwnerDocument().createElementNS(itemNamespace, "item");
            e.appendChild(outputelement);
            serializer.serialize(arr, outputelement, context);
        } else {
            int element_count = Array.getLength(arr);
            int i = 0;
            while (i < element_count) {
                Object part = Array.get(arr, i);
                this.soapArraySerialize(part, serializer, e, itemNamespace, currentLevel + 1, maxLevel, context);
                ++i;
            }
        }
    }

    public String getArraySize(int[] dimensions) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < dimensions.length) {
            result.append(dimensions[i]);
            if (i != dimensions.length - 1) {
                result.append(' ');
            }
            ++i;
        }
        return result.toString();
    }

    public String getArrayType(int[] dimensions, String qTypeName) {
        StringBuffer result = new StringBuffer();
        result.append(qTypeName);
        result.append('[');
        int i = 0;
        while (i < dimensions.length) {
            result.append(dimensions[i]);
            if (i != dimensions.length - 1) {
                result.append(',');
            }
            ++i;
        }
        result.append(']');
        return result.toString();
    }

    public void serialize(Object obj, Node node, SOAPSerializationContext context) throws MarshalException {
        if (node.getNodeType() != 1) {
            throw new MarshalException(" Can not serialize SOAP Array into non Element node !");
        }
        Element element = (Element)node;
        if (obj == null) {
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            return;
        }
        TypeMapping mapping = context.getTypeMapping();
        Class arrayClass = this.getArrayComponentClass(obj.getClass());
        if (mapping == null || this.itemTypeLocal == null || this.itemTypeUri == null) {
            throw new MarshalException("To serialize SOAP Array you must set SOAPContext properties !");
        }
        int[] dimensions = this.getArrayDimensions(obj);
        SerializerFactory factory = mapping.getSerializer(arrayClass, new QName(this.itemTypeUri, this.itemTypeLocal));
        if (factory == null) {
            throw new MarshalException(" Could not find deserializer for :" + new QName(this.itemTypeUri, this.itemTypeLocal));
        }
        SerializerBase serializer = (SerializerBase)factory.getSerializerAs("com.sap.jaxrpc.multixml");
        this.soapArraySerialize(obj, serializer, element, null, 0, dimensions.length, context);
        if (!"http://www.w3.org/2001/XMLSchema".equals(this.itemTypeUri.toString())) {
            element.setAttribute("xmlns:tns", this.itemTypeUri.toString());
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:itemType", "tns:" + this.itemTypeLocal.toString());
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arraySize", this.getArraySize(dimensions));
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arrayType", this.getArrayType(dimensions, "tns:" + this.itemTypeLocal.toString()));
        } else {
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:itemType", "xs:" + this.itemTypeLocal.toString());
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arraySize", this.getArraySize(dimensions));
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arrayType", this.getArrayType(dimensions, "xs:" + this.itemTypeLocal.toString()));
        }
    }

    public String getMechanismType() {
        return null;
    }

    public Object deserialize(Node node, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        if (node.getNodeType() != 1) {
            throw new UnmarshalException(" Can not serialize SOAP Array into non Element node !");
        }
        Element element = (Element)node;
        Attr nil = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (nil != null) {
            return null;
        }
        SOAPMessageContext soapcontext = (SOAPMessageContext)context;
        TypeMapping mapping = (TypeMapping)soapcontext.getProperty("java.xml.rpc.typeMapping");
        if (mapping == null) {
            throw new UnmarshalException("To deserialize SOAP Array you must set SOAPContext properties !");
        }
        Class resultComponentClass = this.getArrayComponentClass(resultClass);
        int dimensionCount = this.getDimensionCount(resultClass);
        StringBuffer arrayType = new StringBuffer();
        StringBuffer arrayUri = new StringBuffer();
        ArrayIterator iterator = this.createArray(element, resultComponentClass, dimensionCount, arrayType, arrayUri);
        DeserializerFactory factory = mapping.getDeserializer(resultComponentClass, new QName(arrayUri.toString(), arrayType.toString()));
        if (factory == null) {
            throw new UnmarshalException(" Could not find deserializer for :" + new QName(arrayUri.toString(), arrayType.toString()));
        }
        DeserializerBase deserializer = (DeserializerBase)factory.getDeserializerAs("com.sap.jaxrpc.multixml");
        NodeList list = element.getChildNodes();
        int size = list.getLength();
        int i = 0;
        while (i < size) {
            Node elementNode = list.item(i);
            if (elementNode.getNodeType() == 1) {
                if (!iterator.hasMoreElements()) {
                    throw new UnmarshalException(" Element count does not correspond to array size !");
                }
                iterator.setNext(deserializer.deserialize(elementNode, context, resultComponentClass));
            }
            ++i;
        }
        return iterator.getArray();
    }

    private int getArrayType(Element element, StringBuffer itemType, StringBuffer itemUri, StringBuffer arraySize) throws UnmarshalException {
        int result = 0;
        itemType.setLength(0);
        itemUri.setLength(0);
        arraySize.setLength(0);
        Attr typeAttr = element.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/encoding/", "itemType");
        NamedNodeMap attrs = element.getAttributes();
        if (typeAttr == null) {
            Attr arrayType = element.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
            if (arrayType == null) {
                throw new UnmarshalException("Incorrect SOAP array recieved !");
            }
            result = 2;
            String arrayDescription = arrayType.getValue().trim();
            int indexStart = arrayDescription.indexOf(91);
            if (indexStart == -1) {
                throw new UnmarshalException("Illegal array type attribute construction !");
            }
            String qname = arrayDescription.substring(0, indexStart);
            String size = arrayDescription.substring(indexStart);
            String localName = DOM.qnameToLocalName((String)qname);
            String uri = DOM.qnameToURI((String)qname, (Node)element);
            itemType.append(localName);
            itemUri.append(uri);
            arraySize.append(size.trim());
        } else {
            result = 1;
            String qname = typeAttr.getValue().trim();
            String localName = DOM.qnameToLocalName((String)qname);
            String uri = DOM.qnameToURI((String)qname, (Node)element);
            String size = "*";
            String perm = element.getAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arraySize");
            if (perm.length() != 0) {
                size = perm;
            }
            itemType.append(localName);
            itemUri.append(uri);
            arraySize.append(size.trim());
        }
        return result;
    }

    public int[] getDimensions(String description) throws UnmarshalException {
        if (description == null || description.trim().length() == 0) {
            throw new UnmarshalException("Ivalid or unrecognized array size descriptor !");
        }
        String work_string = description.trim();
        if (work_string.charAt(0) != '[' || work_string.charAt(work_string.length() - 1) != ']') {
            throw new UnmarshalException("Invalid array descriptor !");
        }
        if ((work_string = work_string.substring(1, work_string.length() - 1)).length() == 0) {
            throw new UnmarshalException("This array format description is not supported yet !");
        }
        int dimension_count = 0;
        StringTokenizer tokenizer = new StringTokenizer(work_string, ",", false);
        dimension_count = tokenizer.countTokens();
        int[] result = new int[dimension_count];
        int counter = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result[counter] = Integer.parseInt(token);
            ++counter;
        }
        return result;
    }

    public int[] getDimensions(String description, int outerElements) throws UnmarshalException {
        if (description == null || description.trim().length() == 0) {
            throw new UnmarshalException("Ivalid or unrecognized array descriptor !");
        }
        StringTokenizer tokenizer = new StringTokenizer(description, " ");
        int dimensions = tokenizer.countTokens();
        int[] result = new int[dimensions];
        String[] permanent = new String[dimensions];
        while (dimensions != 0) {
            permanent[dimensions - 1] = tokenizer.nextToken().trim();
            if (--dimensions == 0 && "*".equals(permanent[dimensions])) {
                result[0] = outerElements;
                continue;
            }
            try {
                result[dimensions] = Integer.parseInt(permanent[dimensions]);
            }
            catch (NumberFormatException e) {
                throw new UnmarshalException(" Incorrect arraySize attribute in SOAP message !");
            }
            if (result[dimensions] == 0) {
                if (outerElements != 0) {
                    throw new UnmarshalException(" Probably incorrect arraySize attribute. Cannot aligh content of array to array size !");
                }
                return result;
            }
            if (outerElements % result[dimensions] != 0) {
                throw new UnmarshalException(" Probably incorrect arraySize attribute. Cannot aligh content of array to array size !");
            }
            outerElements %= result[dimensions];
        }
        return result;
    }

    public ArrayIterator createArray(Element element, Class resultComponentClass, int dimensionCount, StringBuffer arrayType, StringBuffer arrayURI) throws UnmarshalException {
        arrayType.setLength(0);
        arrayURI.setLength(0);
        StringBuffer arraySize = new StringBuffer();
        int[] dimensions = null;
        Object arrayJavaClass = null;
        switch (this.getArrayType(element, arrayType, arrayURI, arraySize)) {
            case 1: {
                dimensions = this.getDimensions(arraySize.toString(), DOM.getChildElementsAsArray((Node)element).length);
                break;
            }
            case 2: {
                dimensions = this.getDimensions(arraySize.toString());
            }
        }
        if (dimensions.length != dimensionCount) {
            throw new UnmarshalException(" Incorect array dimensions in SOAP !");
        }
        ArrayIterator result = new ArrayIterator(dimensions, resultComponentClass);
        return result;
    }

    public Object deserialize(XMLTokenReader reader, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        return null;
    }

    public void serialize(Object obj, XMLTokenWriter writer, SOAPSerializationContext context) throws MarshalException {
    }

    public String serialize(Object obj, SOAPSerializationContext context) throws MarshalException {
        return null;
    }

    public Object deserialize(String content, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        return null;
    }
}

