/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding.primitive;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Enumeration {
    private int[] arrayDimensions;
    private int[] currentPos;
    private int dimension_count;
    private Object arrPtr;
    private boolean hasNextPosition;
    private Class componentClass = null;

    public ArrayIterator(int[] dimensions, Object array) {
        this.dimension_count = dimensions.length;
        this.arrayDimensions = new int[this.dimension_count];
        this.currentPos = new int[this.dimension_count];
        System.arraycopy(dimensions, 0, this.arrayDimensions, 0, this.dimension_count);
        this.arrPtr = array;
        this.hasNextPosition = true;
    }

    public ArrayIterator(int[] dimensions, Class contentType) {
        this.dimension_count = dimensions.length;
        this.arrayDimensions = new int[this.dimension_count];
        this.currentPos = new int[this.dimension_count];
        System.arraycopy(dimensions, 0, this.arrayDimensions, 0, this.dimension_count);
        this.arrPtr = Array.newInstance(contentType, this.arrayDimensions);
        this.componentClass = contentType;
        this.hasNextPosition = true;
        if (dimensions.length == 0) {
            this.hasNextPosition = false;
        }
        int i = 0;
        while (i < dimensions.length) {
            if (dimensions[i] == 0) {
                this.hasNextPosition = false;
            }
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.dimension_count) {
            this.currentPos[i] = 0;
            ++i;
        }
        this.hasNextPosition = true;
    }

    public Object nextElement() throws NoSuchElementException {
        if (!this.hasNextPosition) {
            throw new NoSuchElementException("Iterator over !");
        }
        int i = 0;
        Object curArr = this.arrPtr;
        while (i < this.dimension_count - 1) {
            curArr = Array.get(curArr, this.currentPos[i]);
            ++i;
        }
        Object result = Array.get(curArr, this.currentPos[i]);
        this.nextPosition();
        return result;
    }

    public void setNext(Object element) {
        int i = 0;
        Object curArr = this.arrPtr;
        while (i < this.dimension_count - 1) {
            curArr = Array.get(curArr, this.currentPos[i]);
            ++i;
        }
        Array.set(curArr, this.currentPos[i], element);
        this.nextPosition();
    }

    public void setPosition(int[] position) throws Exception {
        if (position.length != this.dimension_count) {
            throw new Exception("Invalid position passed : not enough dimension ");
        }
        int i = 0;
        while (i < this.dimension_count) {
            if (position[i] >= this.arrayDimensions[i]) {
                throw new Exception("Invalid position passed : out of array !");
            }
            ++i;
        }
        System.arraycopy(position, 0, this.currentPos, 0, this.dimension_count);
    }

    public void nextPosition() {
        int pos = this.dimension_count - 1;
        while (pos >= 0) {
            if (this.currentPos[pos] < this.arrayDimensions[pos] - 1) {
                int n = pos;
                this.currentPos[n] = this.currentPos[n] + 1;
                int i = pos + 1;
                while (i < this.dimension_count) {
                    this.currentPos[i] = 0;
                    ++i;
                }
                break;
            }
            --pos;
        }
        if (pos == -1) {
            this.hasNextPosition = false;
        }
    }

    public boolean hasMoreElements() {
        if (!this.hasNextPosition) {
            return false;
        }
        int pos = this.dimension_count - 1;
        while (pos >= 0) {
            if (this.currentPos[pos] < this.arrayDimensions[pos]) {
                return true;
            }
            --pos;
        }
        this.hasNextPosition = false;
        return this.hasNextPosition;
    }

    public Object getArray() {
        return this.arrPtr;
    }

    public Class getContentClass() {
        if (this.componentClass == null) {
            throw new RuntimeException("Array Iterator did not created array to know elements Class !");
        }
        return this.componentClass;
    }

    public int[] getDimensions() {
        return this.arrayDimensions;
    }
}

