/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding.primitive;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.jaxrpc.encoding.ArrayBuilder;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedSimpleType;
import com.sap.engine.services.webservices.jaxrpc.encoding.Initializer;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationState;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.primitive.ArrayIterator;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlMarshalException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class Array11SD
extends GeneratedBase
implements Initializer {
    private final String customTypePrefix = "tns";
    private final String arrayItemName = "item";
    private String itemTypeLocal;
    private String itemTypeUri;
    private int maxDimensions = 1;
    private SerializerBase serializer = null;
    private DeserializerBase deserializer = null;

    public String[] getInitParams() {
        String[] result = new String[]{this.itemTypeUri, this.itemTypeLocal, String.valueOf(this.maxDimensions)};
        return result;
    }

    public Array11SD(String itemTypeUri, String itemType, String maxdimesions) {
        this.itemTypeLocal = itemType;
        this.itemTypeUri = itemTypeUri;
        this.maxDimensions = Integer.parseInt(maxdimesions);
    }

    public String serialize(Object obj, SOAPSerializationContext context) throws MarshalException {
        HashSet<Array11SD> usedSerializers = (HashSet<Array11SD>)context.getProperty("usedSerializers");
        if (usedSerializers == null) {
            usedSerializers = new HashSet<Array11SD>();
            context.setProperty("usedSerializers", usedSerializers);
        }
        usedSerializers.add(this);
        XMLTokenWriter output = null;
        if (!(obj instanceof XMLTokenWriter)) {
            throw new MarshalException("Object passes to template generator must be XMLTokenWriter instance");
        }
        output = (XMLTokenWriter)obj;
        TypeMapping typeMapping = context.getTypeMapping();
        if (typeMapping == null) {
            throw new XmlMarshalException("webservices_3107");
        }
        Class arrayClass = this.getArrayComponentClass(obj.getClass(), 0);
        int[] dimensions = new int[this.maxDimensions];
        int contentCount = 1;
        int i = 0;
        while (i < dimensions.length) {
            dimensions[i] = 2;
            contentCount *= dimensions[i];
            ++i;
        }
        if (this.serializer == null) {
            SerializerFactory factory = typeMapping.getSerializer(arrayClass, new QName(this.itemTypeUri, this.itemTypeLocal));
            if (factory == null) {
                throw new XmlMarshalException("webservices_3104", this.itemTypeUri, (Object)this.itemTypeLocal, (Object)arrayClass.getName());
            }
            this.serializer = (SerializerBase)factory.getSerializerAs(null);
        }
        QName arrayType = this.getArraySize(dimensions, this.serializer, typeMapping);
        try {
            if (!"http://www.w3.org/2001/XMLSchema".equals(arrayType.getNamespaceURI())) {
                if (arrayType.getNamespaceURI() != null && arrayType.getNamespaceURI().length() != 0) {
                    output.setPrefixForNamespace("tns", arrayType.getNamespaceURI());
                    output.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "tns:" + arrayType.getLocalPart());
                } else {
                    output.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", arrayType.getLocalPart());
                }
            } else {
                if (output.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") == null) {
                    output.setPrefixForNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                }
                output.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "xs:" + arrayType.getLocalPart());
            }
            int i2 = 0;
            while (i2 < contentCount) {
                output.enter("http://sap-j2ee-engine/templates", "OBJECT");
                output.writeAttribute(null, "name", "item");
                output.enter(null, "item");
                if (this.serializer instanceof GeneratedSimpleType) {
                    output.enter("http://sap-j2ee-engine/templates", "VALUE");
                    output.writeAttribute(null, "type", this.itemTypeLocal);
                    output.leave();
                } else {
                    this.serializer.serialize(output, context);
                }
                output.leave();
                output.leave();
                ++i2;
            }
        }
        catch (IOException e) {
            throw new XmlMarshalException("webservices_3135", (Throwable)e);
        }
        usedSerializers.remove(this);
        return "Check Writer content !";
    }

    public void serialize(Object obj, Node node, SOAPSerializationContext context) throws MarshalException {
        if (node.getNodeType() != 1) {
            throw new MarshalException(" Can not serialize SOAP Array into non Element node !");
        }
        Element element = (Element)node;
        if (obj == null) {
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            return;
        }
        TypeMapping mapping = context.getTypeMapping();
        Class arrayClass = this.getArrayComponentClass(obj.getClass(), 0);
        if (mapping == null || this.itemTypeLocal == null || this.itemTypeUri == null) {
            throw new MarshalException(" SOAP 1.1 Array serializer not properly initialized !");
        }
        int[] dimensions = this.getArrayDimensions(obj);
        SerializerFactory factory = mapping.getSerializer(arrayClass, new QName(this.itemTypeUri, this.itemTypeLocal));
        if (factory == null) {
            throw new MarshalException(" Could not find deserializer for :" + new QName(this.itemTypeUri, this.itemTypeLocal));
        }
        SerializerBase serializer = (SerializerBase)factory.getSerializerAs("com.sap.jaxrpc.multixml");
        this.soapArraySerialize(obj, serializer, element, 0, dimensions.length, context);
        QName arrayType = this.getArraySize(dimensions, serializer, mapping);
        if (!"http://www.w3.org/2001/XMLSchema".equals(arrayType.getNamespaceURI())) {
            element.setAttribute("xmlns:tns", arrayType.getNamespaceURI());
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arrayType", "tns:" + arrayType.getLocalPart());
        } else {
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "SOAP-ENC:arrayType", "xs:" + arrayType.getLocalPart());
        }
    }

    public void serialize(Object obj, XMLTokenWriter writer, SOAPSerializationContext context) throws MarshalException, IOException {
        QName arrayType;
        if (obj == null) {
            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
            writer.leave();
            return;
        }
        TypeMapping mapping = context.getTypeMapping();
        Class arrayClass = this.getArrayComponentClass(obj.getClass(), 0);
        if (mapping == null) {
            throw new XmlMarshalException("webservices_3107");
        }
        int[] dimensions = this.getArrayDimensions(obj);
        if (this.serializer == null) {
            SerializerFactory factory = mapping.getSerializer(arrayClass, new QName(this.itemTypeUri, this.itemTypeLocal));
            if (factory == null) {
                throw new XmlMarshalException("webservices_3104", this.itemTypeUri, (Object)this.itemTypeLocal, (Object)arrayClass.getName());
            }
            this.serializer = (SerializerBase)factory.getSerializerAs(null);
        }
        if (!"http://www.w3.org/2001/XMLSchema".equals((arrayType = this.getArraySize(dimensions, this.serializer, mapping)).getNamespaceURI())) {
            if (arrayType.getNamespaceURI() != null && arrayType.getNamespaceURI().length() != 0) {
                writer.setPrefixForNamespace("tns", arrayType.getNamespaceURI());
                writer.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "tns:" + arrayType.getLocalPart());
            } else {
                writer.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", arrayType.getLocalPart());
            }
        } else {
            if (writer.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") == null) {
                writer.setPrefixForNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            }
            writer.writeAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "xs:" + arrayType.getLocalPart());
        }
        this.soapArraySerialize(obj, this.serializer, writer, 0, dimensions.length, context);
        writer.leave();
    }

    public String getMechanismType() {
        return null;
    }

    public Object deserialize(String content, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        return null;
    }

    public Object deserialize(Node node, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        String nil;
        if (node.getNodeType() != 1) {
            throw new XmlUnmarshalException("webservices_3110");
        }
        Element element = (Element)node;
        String reference = element.getAttribute("href");
        if (reference.startsWith("#")) {
            reference = reference.substring(1);
        }
        if (reference.length() != 0) {
            if (context.isIdResolved(reference)) {
                return context.getIdResolution(reference);
            }
            element = context.getIdContent(reference);
        }
        if ("1".equals(nil = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) || "true".equals(nil)) {
            if (reference.length() != 0) {
                context.setIdResolution(reference, null);
            }
            return null;
        }
        TypeMapping mapping = context.getTypeMapping();
        if (mapping == null) {
            throw new XmlUnmarshalException("webservices_3113");
        }
        Class resultComponentClass = this.getArrayComponentClass(resultClass, 0);
        int dimensionCount = this.maxDimensions;
        StringBuffer arrayType = new StringBuffer();
        ArrayIterator iterator = this.createArray(element, resultComponentClass, dimensionCount, arrayType);
        if (this.deserializer == null) {
            DeserializerFactory factory = mapping.getDeserializer(resultComponentClass, new QName(this.itemTypeUri, this.itemTypeLocal));
            if (factory == null) {
                throw new XmlUnmarshalException("webservices_3105", this.itemTypeUri, (Object)this.itemTypeLocal, (Object)resultClass);
            }
            this.deserializer = (DeserializerBase)factory.getDeserializerAs("com.sap.jaxrpc.multixml");
        }
        NodeList list = element.getChildNodes();
        int size = list.getLength();
        int i = 0;
        while (i < size) {
            Node elementNode = list.item(i);
            if (elementNode.getNodeType() == 1) {
                if (!iterator.hasMoreElements()) {
                    throw new XmlUnmarshalException("webservices_3131");
                }
                Element eNode = (Element)elementNode;
                String nReference = eNode.getAttribute("href");
                if (nReference.startsWith("#")) {
                    nReference = nReference.substring(1);
                }
                if (nReference.length() != 0) {
                    if (context.isIdResolved(nReference)) {
                        iterator.setNext(context.getIdResolution(nReference));
                    } else {
                        eNode = context.getIdContent(nReference);
                        Object result = this.deserializer.deserialize(elementNode, context, resultComponentClass);
                        context.setIdResolution(nReference, result);
                        iterator.setNext(result);
                    }
                } else {
                    iterator.setNext(this.deserializer.deserialize(elementNode, context, resultComponentClass));
                }
            }
            ++i;
        }
        if (reference.length() != 0) {
            context.setIdResolution(reference, iterator.getArray());
        }
        return iterator.getArray();
    }

    public Object deserialize(XMLTokenReader reader, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        if (reader.getState() != 1) {
            throw new XmlUnmarshalException("webservices_3122", "http://schemas.xmlsoap.org/soap/encoding/", (Object)"Array");
        }
        Attributes attributes = reader.getAttributes();
        String attr = attributes.getValue("href");
        if (attr != null) {
            if (attr.startsWith("#")) {
                attr = attr.substring(1);
            }
            SOAPDeserializationState state = context.getStateFor(attr);
            state.setDeserializer(this, resultClass);
            try {
                reader.next();
            }
            catch (ParserException e) {
                throw new XmlUnmarshalException("webservices_3125", e);
            }
            if (state.isComplete()) {
                return state.getInstance();
            }
            return state;
        }
        attr = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if ("true".equals(attr) || "1".equals(attr)) {
            String id = attributes.getValue("id");
            if (id != null) {
                SOAPDeserializationState state = context.getStateFor(id);
                state.setInstance(null);
                state.doneReading();
            }
            try {
                reader.next();
            }
            catch (ParserException e) {
                throw new XmlUnmarshalException("webservices_3125", e);
            }
            return null;
        }
        TypeMapping mapping = context.getTypeMapping();
        if (mapping == null) {
            throw new XmlUnmarshalException("webservices_3113");
        }
        SOAPDeserializationState state = null;
        String id = attributes.getValue("id");
        if (id != null) {
            state = context.getStateFor(id);
            state.setDeserializer(this, resultClass);
        }
        Class resultComponentClass = this.getArrayComponentClass(resultClass, 0);
        int dimensionCount = this.maxDimensions;
        StringBuffer arrayType = new StringBuffer();
        ArrayIterator iterator = this.createArray(attributes, resultComponentClass, dimensionCount, arrayType);
        if (this.deserializer == null) {
            DeserializerFactory factory = mapping.getDeserializer(resultComponentClass, new QName(this.itemTypeUri, this.itemTypeLocal));
            if (factory == null) {
                throw new XmlUnmarshalException("webservices_3105", this.itemTypeUri, (Object)this.itemTypeLocal, (Object)resultClass);
            }
            this.deserializer = (DeserializerBase)factory.getDeserializerAs("com.sap.jaxrpc.multixml");
        }
        ArrayBuilder builder = ArrayBuilder.getArrayBuilder(resultComponentClass, iterator.getDimensions(), context, this.deserializer);
        try {
            reader.next();
            reader.passChars();
        }
        catch (ParserException p) {
            throw new XmlUnmarshalException("webservices_3125", p);
        }
        if (state != null) {
            builder.setState(state);
        }
        builder.setArrayIterator(iterator);
        builder.readContent(reader);
        if (builder.isCompleted()) {
            Object result = builder.getResultObject();
            if (state != null) {
                state.setInstance(result);
                state.doneReading();
            }
            ArrayBuilder.reuse(builder);
            return result;
        }
        return builder.getState();
    }

    private final Class getArrayComponentClass(Class cl, int level) {
        if (level >= this.maxDimensions) {
            return cl;
        }
        if (!cl.isArray()) {
            return cl;
        }
        return this.getArrayComponentClass(cl.getComponentType(), level + 1);
    }

    private final int[] getArrayDimensions(Object obj) {
        int dimCount = this.maxDimensions;
        int[] result = new int[dimCount];
        Object perm = obj;
        while (dimCount != 0) {
            result[result.length - dimCount] = Array.getLength(perm);
            if (result[result.length - dimCount] == 0) break;
            perm = Array.get(perm, 0);
            --dimCount;
        }
        return result;
    }

    private int getDimensionCount(Class arrayClass) {
        int result = 0;
        if (arrayClass.isArray()) {
            result = 1 + this.getDimensionCount(arrayClass.getComponentType());
        }
        if (result > this.maxDimensions) {
            return this.maxDimensions;
        }
        return result;
    }

    private final void soapArraySerialize(Object arr, SerializerBase serializer, XMLTokenWriter writer, int currentLevel, int maxLevel, SOAPSerializationContext context) throws MarshalException, IOException {
        if (currentLevel == maxLevel) {
            writer.enter(null, "item");
            serializer.serialize(arr, writer, context);
        } else {
            int element_count = Array.getLength(arr);
            int i = 0;
            while (i < element_count) {
                Object part = Array.get(arr, i);
                this.soapArraySerialize(part, serializer, writer, currentLevel + 1, maxLevel, context);
                ++i;
            }
        }
    }

    private final void soapArraySerialize(Object arr, SerializerBase serializer, Element e, int currentLevel, int maxLevel, SOAPSerializationContext context) throws MarshalException {
        if (currentLevel == maxLevel) {
            Element outputelement = e.getOwnerDocument().createElementNS(null, "item");
            e.appendChild(outputelement);
            serializer.serialize(arr, outputelement, context);
        } else {
            int element_count = Array.getLength(arr);
            int i = 0;
            while (i < element_count) {
                Object part = Array.get(arr, i);
                this.soapArraySerialize(part, serializer, e, currentLevel + 1, maxLevel, context);
                ++i;
            }
        }
    }

    public String getArraySize(int[] dimensions) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < dimensions.length) {
            result.append(dimensions[i]);
            if (i != dimensions.length - 1) {
                result.append(' ');
            }
            ++i;
        }
        return result.toString();
    }

    public QName getArraySize(int[] dimensions, SerializerBase serializer, TypeMapping typeMapping) throws MarshalException {
        String indexPrefix = "";
        QName itemType = new QName(this.itemTypeUri, this.itemTypeLocal);
        while (serializer instanceof Array11SD) {
            Array11SD arraySD = (Array11SD)serializer;
            int subdimensions = arraySD.getMaxDimensions();
            int i = 0;
            while (i < subdimensions) {
                indexPrefix = indexPrefix + "[]";
                ++i;
            }
            itemType = arraySD.getItemType();
            SerializerFactory sf = typeMapping.getSerializer(this.getClass(), itemType);
            if (sf == null) {
                throw new MarshalException(" Could not find deserializer for :" + new QName(this.itemTypeUri, this.itemTypeLocal));
            }
            serializer = (SerializerBase)sf.getSerializerAs(null);
        }
        StringBuffer result = new StringBuffer();
        result.append(itemType.getLocalPart());
        result.append(indexPrefix);
        result.append('[');
        int i = 0;
        while (i < dimensions.length) {
            result.append(dimensions[i]);
            if (i != dimensions.length - 1) {
                result.append(',');
            }
            ++i;
        }
        result.append(']');
        return new QName(itemType.getNamespaceURI(), result.toString());
    }

    public int getMaxDimensions() {
        return this.maxDimensions;
    }

    public QName getItemType() {
        return new QName(this.itemTypeUri, this.itemTypeLocal);
    }

    public ArrayIterator createArray(Attributes attrib, Class resultComponentClass, int dimensionCount, StringBuffer arrayType) throws UnmarshalException {
        arrayType.setLength(0);
        int[] dimensions = null;
        String arraySize = this.getArrayType(attrib, arrayType);
        dimensions = this.getDimensions(arraySize.toString());
        if (dimensions.length != dimensionCount) {
            throw new XmlUnmarshalException("webservices_3130");
        }
        ArrayIterator result = new ArrayIterator(dimensions, resultComponentClass);
        return result;
    }

    public ArrayIterator createArray(Element element, Class resultComponentClass, int dimensionCount, StringBuffer arrayType) throws UnmarshalException {
        arrayType.setLength(0);
        int[] dimensions = null;
        String arraySize = this.getArrayType(element, arrayType);
        dimensions = this.getDimensions(arraySize.toString());
        if (dimensions.length != dimensionCount) {
            throw new XmlUnmarshalException("webservices_3130");
        }
        ArrayIterator result = new ArrayIterator(dimensions, resultComponentClass);
        return result;
    }

    private String getArrayType(Attributes attribs, StringBuffer itemType) throws UnmarshalException {
        itemType.setLength(0);
        String arrayType = attribs.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        if (arrayType == null) {
            throw new XmlUnmarshalException("webservices_3128");
        }
        String arrayDescription = arrayType.trim();
        int indexStart = arrayDescription.indexOf(91);
        if (indexStart == -1) {
            throw new XmlUnmarshalException("webservices_3129", arrayType);
        }
        itemType.append(arrayDescription.substring(0, indexStart));
        return arrayDescription.substring(indexStart);
    }

    private String getArrayType(Element element, StringBuffer itemType) throws UnmarshalException {
        itemType.setLength(0);
        String arrayType = element.getAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        if (arrayType.length() == 0) {
            throw new XmlUnmarshalException("webservices_3128");
        }
        String arrayDescription = arrayType.trim();
        int indexStart = arrayDescription.indexOf(91);
        if (indexStart == -1) {
            throw new XmlUnmarshalException("webservices_3129", arrayType);
        }
        itemType.append(arrayDescription.substring(0, indexStart));
        return arrayDescription.substring(indexStart);
    }

    public int[] getDimensions(String description) throws UnmarshalException {
        if (description == null || description.trim().length() == 0) {
            throw new XmlUnmarshalException("webservices_3134", description);
        }
        String work_string = description.trim();
        if (work_string.charAt(0) != '[' || work_string.charAt(work_string.length() - 1) != ']') {
            throw new XmlUnmarshalException("webservices_3134", description);
        }
        if ((work_string = work_string.substring(work_string.lastIndexOf("[") + 1, work_string.length() - 1).trim()).length() == 0) {
            throw new XmlUnmarshalException("webservices_3134", description);
        }
        int dimension_count = 0;
        StringTokenizer tokenizer = new StringTokenizer(work_string, ",", false);
        dimension_count = tokenizer.countTokens();
        int[] result = new int[dimension_count];
        int counter = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                result[counter] = Integer.parseInt(token);
            }
            catch (NumberFormatException n) {
                throw new XmlUnmarshalException("webservices_3134", description);
            }
            ++counter;
        }
        return result;
    }

    protected String _d_originalUri() {
        return null;
    }

    protected String _d_originalLocalName() {
        return null;
    }
}

