/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding.primitive;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedSimpleType;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.XMLTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class AbstractTypeSD
extends GeneratedSimpleType
implements SerializerBase,
DeserializerBase {
    private boolean checkAbstract(QName xsiType, TypeMappingImpl typemapping) {
        while (xsiType != null) {
            XMLTypeMapping xmlTypeMapping = typemapping.getXmlTypeMapping(xsiType);
            if (xmlTypeMapping == null) {
                return false;
            }
            if (this == xmlTypeMapping.getDefaultSerializer()) {
                return true;
            }
            xsiType = xmlTypeMapping.getParentType();
        }
        return false;
    }

    public void serialize(Object obj, Node node, SOAPSerializationContext context) throws MarshalException {
        if (obj == null) {
            if (node.getNodeType() == 1) {
                ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            }
        } else {
            Class<?> jClass = obj.getClass();
            TypeMappingImpl typeMapping = (TypeMappingImpl)context.getTypeMapping();
            QName type = typeMapping.getDefaultSchemaType(jClass.getName());
            if (!this.checkAbstract(type, typeMapping)) {
                if (node.getNodeType() == 1) {
                    ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
                }
                return;
            }
            if (type != null) {
                if (this._d_originalUri() != null && this._d_originalUri().length() != 0) {
                    Element element = (Element)node;
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", type.getNamespaceURI());
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "tns:" + type.getLocalPart());
                }
                SerializerBase serializer = context.getSerializer(type, jClass);
                context.setTypeUse(true);
                serializer.serialize(obj, node, context);
            } else if (node.getNodeType() == 1) {
                ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            }
        }
    }

    public void serialize(Object obj, XMLTokenWriter writer, SOAPSerializationContext context) throws MarshalException, IOException {
        if (obj == null) {
            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
            writer.leave();
        } else {
            Class<?> jClass = obj.getClass();
            TypeMappingImpl typeMapping = (TypeMappingImpl)context.getTypeMapping();
            QName type = typeMapping.getDefaultSchemaType(this.getJavaClassDeclaration(jClass));
            if (!this.checkAbstract(type, typeMapping)) {
                writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                writer.leave();
                return;
            }
            if (type != null) {
                SerializerBase serializer = context.getSerializer(type, jClass);
                context.setTypeUse(true);
                serializer.serialize(obj, writer, context);
            } else {
                writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                writer.leave();
            }
        }
    }

    private String getJavaClassDeclaration(Class cl) {
        int dim = 0;
        while (cl.isArray()) {
            cl = cl.getComponentType();
            ++dim;
        }
        String res = cl.getName();
        int i = 0;
        while (i < dim) {
            res = res + "[]";
            ++i;
        }
        return res;
    }

    public String serialize(Object obj, SOAPSerializationContext context) throws MarshalException {
        return obj.toString();
    }

    public String _d_originalUri() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    public String _d_originalLocalName() {
        return "anyType";
    }

    public String getMechanismType() {
        return null;
    }

    public Object deserialize(Node node, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        if (resultClass == null) {
            throw new XmlUnmarshalException("webservices_3111");
        }
        if (node.getNodeType() != 1) {
            throw new XmlUnmarshalException("webservices_3114");
        }
        TypeMappingImpl typeMapping = (TypeMappingImpl)context.getTypeMapping();
        if (typeMapping == null) {
            throw new XmlUnmarshalException("webservices_3113");
        }
        Element element = (Element)node;
        Attr nill = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (nill != null) {
            return null;
        }
        String xsiType = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiType.length() != 0) {
            String localName;
            String uriType = DOM.prefixToURI((String)DOM.qnameToPrefix((String)xsiType), (Node)element);
            QName xmlType = new QName(uriType, localName = DOM.qnameToLocalName((String)xsiType));
            String javaType = typeMapping.getDefaultJavaType(xmlType);
            if (javaType != null) {
                Class resultClassReal = this.loadClass(javaType, context.getApplClassLoader() != null ? context.getApplClassLoader() : this.getClass().getClassLoader());
                if (!resultClass.isAssignableFrom(resultClassReal)) {
                    return null;
                }
                DeserializerBase deserializer = context.getDeserializer(xmlType, resultClassReal.getName());
                return deserializer.deserialize(element, context, resultClassReal);
            }
            if (!Modifier.isAbstract(resultClass.getModifiers())) {
                DeserializerBase deserializer = context.getDeserializer(xmlType, resultClass);
                return deserializer.deserialize(element, context, resultClass);
            }
        }
        return null;
    }

    private Class loadClass(String clDecl, ClassLoader loader) throws UnmarshalException {
        int ind = clDecl.indexOf("[]");
        try {
            if (ind == -1) {
                if (clDecl.equals("byte")) {
                    return Byte.TYPE;
                }
                if (clDecl.equals("char")) {
                    return Character.TYPE;
                }
                if (clDecl.equals("boolean")) {
                    return Boolean.TYPE;
                }
                if (clDecl.equals("short")) {
                    return Short.TYPE;
                }
                if (clDecl.equals("int")) {
                    return Integer.TYPE;
                }
                if (clDecl.equals("float")) {
                    return Float.TYPE;
                }
                if (clDecl.equals("long")) {
                    return Long.TYPE;
                }
                if (clDecl.equals("double")) {
                    return Double.TYPE;
                }
                return loader.loadClass(clDecl);
            }
            int[] arrDim = new int[(clDecl.length() - ind) / 2];
            Class compClass = this.loadClass(clDecl.substring(0, ind), loader);
            return Array.newInstance(compClass, arrDim).getClass();
        }
        catch (ClassNotFoundException e) {
            throw new XmlUnmarshalException("webservices_3136", clDecl, (Object)this.getClass().getName(), (Object)e);
        }
    }

    public Object deserialize(XMLTokenReader reader, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        if (resultClass == null) {
            throw new XmlUnmarshalException("webservices_3111");
        }
        if (reader.getState() != 1) {
            throw new XmlUnmarshalException("webservices_3122", this._d_originalUri(), (Object)this._d_originalLocalName());
        }
        TypeMappingImpl typeMapping = (TypeMappingImpl)context.getTypeMapping();
        if (typeMapping == null) {
            throw new XmlUnmarshalException("webservices_3113");
        }
        Attributes attributes = reader.getAttributes();
        String attr = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if ("true".equals(attr) || "1".equals(attr)) {
            try {
                reader.next();
            }
            catch (ParserException e) {
                throw new XmlUnmarshalException("webservices_3125", e);
            }
            return null;
        }
        String xsiType = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiType != null) {
            String localName;
            String uriType = reader.getPrefixMapping(DOM.qnameToPrefix((String)xsiType));
            QName xmlType = new QName(uriType, localName = DOM.qnameToLocalName((String)xsiType));
            String javaType = typeMapping.getDefaultJavaType(xmlType);
            if (javaType != null) {
                Class resultClassReal = this.loadClass(javaType, context.getApplClassLoader() != null ? context.getApplClassLoader() : this.getClass().getClassLoader());
                if (!resultClass.isAssignableFrom(resultClassReal)) {
                    return null;
                }
                DeserializerBase deserializer = context.getDeserializer(xmlType, resultClassReal.getName());
                return deserializer.deserialize(reader, context, resultClassReal);
            }
            if (!Modifier.isAbstract(resultClass.getModifiers())) {
                DeserializerBase deserializer = context.getDeserializer(xmlType, resultClass);
                return deserializer.deserialize(reader, context, resultClass);
            }
        }
        try {
            reader.passChars();
            reader.next();
            reader.passChars();
        }
        catch (ParserException e) {
            throw new XmlUnmarshalException("webservices_3125", e);
        }
        return null;
    }

    public Object deserialize(String content, SOAPDeserializationContext context, Class resultClass) throws UnmarshalException {
        return content;
    }
}

