/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactory;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactoryImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class XMLTypeMapping
implements Serializable {
    private static final String ONAME = (class$java$lang$Object == null ? (class$java$lang$Object = XMLTypeMapping.class$("java.lang.Object")) : class$java$lang$Object).getName();
    private SerializationFactory defaultFactory;
    private QName xmlTypeName;
    private Hashtable javaTypes;
    private QName parentType;
    static /* synthetic */ Class class$java$lang$Object;

    public XMLTypeMapping() {
        this.defaultFactory = null;
        this.xmlTypeName = null;
        this.javaTypes = null;
        this.parentType = null;
    }

    public QName getParentType() {
        return this.parentType;
    }

    public void setParentType(QName parentType) {
        this.parentType = parentType;
    }

    public QName getXMLName() {
        return this.xmlTypeName;
    }

    public Enumeration getCustom() {
        return this.javaTypes.keys();
    }

    public XMLTypeMapping(QName xmlType, String serializerName, String deserializerName) {
        this.defaultFactory = new SerializationFactoryImpl(xmlType, serializerName, deserializerName);
        this.javaTypes = new Hashtable();
        this.xmlTypeName = xmlType;
    }

    public XMLTypeMapping(QName xmlType, SerializationFactory factory) {
        this.defaultFactory = factory;
        this.javaTypes = new Hashtable();
        this.xmlTypeName = xmlType;
    }

    public XMLTypeMapping cloneSelf() {
        XMLTypeMapping result = new XMLTypeMapping(this.xmlTypeName, this.defaultFactory.cloneSelf());
        Enumeration javaClasses = this.javaTypes.keys();
        while (javaClasses.hasMoreElements()) {
            String key = (String)javaClasses.nextElement();
            result.addFactory(key, ((SerializationFactory)this.javaTypes.get(key)).cloneSelf());
        }
        return result;
    }

    public SerializationFactory getFactory(Class javaClass) {
        Class inputClass = javaClass;
        Object sf = null;
        while (javaClass != null && inputClass != (class$java$lang$Object == null ? XMLTypeMapping.class$("java.lang.Object") : class$java$lang$Object)) {
            sf = this.javaTypes.get(javaClass.getName());
            if (sf != null) {
                if (inputClass != javaClass) {
                    this.addFactory(javaClass.getName(), (SerializationFactory)sf);
                }
                return sf;
            }
            javaClass = javaClass.getSuperclass();
        }
        return this.defaultFactory;
    }

    public SerializationFactory getFactory(String javaClass) {
        SerializationFactory result = (SerializationFactory)this.javaTypes.get(javaClass);
        if (result == null) {
            result = this.defaultFactory;
        }
        return result;
    }

    public SerializationFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    public void addFactory(String javaClass, SerializationFactory factory) {
        this.javaTypes.put(javaClass, factory);
    }

    public void addFactory(Class javaClass, SerializationFactory factory) {
        this.javaTypes.put(javaClass.getName(), factory);
    }

    public boolean isCustom(String javaClass) {
        return this.javaTypes.containsKey(javaClass);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isCustom(Class javaClass) {
        if (!javaClass.isPrimitive() && !javaClass.isInterface()) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.javaTypes.containsKey(javaClass.getName())) {
                return true;
            }
            javaClass = javaClass.getSuperclass();
lbl6:
            // 2 sources

            ** while (javaClass != null && !javaClass.getName().equals((Object)XMLTypeMapping.ONAME))
        }
lbl7:
        // 1 sources

        return false;
    }

    public void releaseFactory(String javaClass) {
        this.javaTypes.remove(javaClass);
    }

    public void releaseFactory(Class javaClass) {
        this.javaTypes.remove(javaClass.getName());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{" + this.xmlTypeName.getNamespaceURI() + "}[" + this.xmlTypeName.getLocalPart() + "] = [");
        Enumeration keys = this.javaTypes.keys();
        while (keys.hasMoreElements()) {
            result.append(keys.nextElement().toString());
            if (!keys.hasMoreElements()) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    public SerializerBase getSerializer(Class javaClass) {
        SerializationFactory factory = this.getFactory(javaClass);
        return (SerializerBase)factory.getSerializerAs(null);
    }

    public SerializerBase getSerializer(String javaClass) {
        SerializationFactory factory = this.getFactory(javaClass);
        return (SerializerBase)factory.getSerializerAs(null);
    }

    public SerializerBase getSerializer(Class inputClass, SOAPSerializationContext context) {
        Class javaClass = inputClass;
        Object sf = null;
        while (javaClass != null && javaClass != (class$java$lang$Object == null ? XMLTypeMapping.class$("java.lang.Object") : class$java$lang$Object)) {
            sf = this.javaTypes.get(javaClass.getName());
            if (sf != null) {
                context.setTypeUse(true);
                if (javaClass != inputClass) {
                    this.addFactory(javaClass.getName(), (SerializationFactory)sf);
                }
                return (SerializerBase)((SerializationFactory)sf).getSerializerAs(null);
            }
            javaClass = javaClass.getSuperclass();
        }
        context.setTypeUse(false);
        return (SerializerBase)this.defaultFactory.getSerializerAs(null);
    }

    public SerializerBase getSerializer(String inputClass, SOAPSerializationContext context) {
        Object sf = null;
        if (inputClass != null && !inputClass.equals(ONAME) && (sf = this.javaTypes.get(inputClass)) != null) {
            context.setTypeUse(true);
            return (SerializerBase)((SerializationFactory)sf).getSerializerAs(null);
        }
        context.setTypeUse(false);
        return (SerializerBase)this.defaultFactory.getSerializerAs(null);
    }

    public DeserializerBase getDeserializer(Class javaClass) {
        SerializationFactory factory = this.getFactory(javaClass);
        return (DeserializerBase)factory.getDeserializerAs(null);
    }

    public DeserializerBase getDeserializer(String javaClass) {
        Object sf = null;
        if (javaClass != null && !javaClass.equals(ONAME) && (sf = this.javaTypes.get(javaClass)) != null) {
            return (DeserializerBase)((SerializationFactory)sf).getSerializerAs(null);
        }
        return (DeserializerBase)this.defaultFactory.getDeserializerAs(null);
    }

    public SerializerBase getDefaultSerializer() {
        return (SerializerBase)this.defaultFactory.getSerializerAs(null);
    }

    public DeserializerBase getDefaultDeserializer() {
        return (DeserializerBase)this.defaultFactory.getDeserializerAs(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

