/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlMarshalException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class XMLMarshaller {
    private TypeMappingRegistryImpl typeMappingRegistry;
    private ExtendedTypeMapping typeMapping;
    private SOAPSerializationContext scontext;
    private SOAPDeserializationContext dcontext;
    private XMLTokenWriterImpl writer;
    private XMLTokenReaderImpl reader;
    private boolean indent = true;
    private Hashtable defaultPrefixes = new Hashtable();

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public XMLMarshaller() {
        this.scontext = new SOAPSerializationContext();
        this.dcontext = new SOAPDeserializationContext();
        this.writer = new XMLTokenWriterImpl();
        this.reader = new XMLTokenReaderImpl();
        try {
            this.reader.getParser().setSoapProcessing(false);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    public XMLParser getParser() {
        try {
            return this.reader.getParser();
        }
        catch (ParserException x) {
            return null;
        }
    }

    public void setEntityResolver(EntityResolver resolver) throws ParserException {
        this.reader.setEntityResolver(resolver);
    }

    public void setDefaultNamespaceMapping(String namespace, String prefix) {
        this.defaultPrefixes.put(namespace, prefix);
    }

    public void clearDefaultNamespaceMapping() {
        this.defaultPrefixes.clear();
    }

    public void removeDefaultNamespaceMapping(String namespace) {
        this.defaultPrefixes.remove(namespace);
    }

    public void init(ExtendedTypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public void init() throws TypeMappingException {
        this.typeMappingRegistry = new TypeMappingRegistryImpl();
        this.typeMapping = (ExtendedTypeMapping)this.typeMappingRegistry.getDefaultTypeMapping();
    }

    public void init(XMLMarshaller rootMarshaller) {
        this.typeMappingRegistry = rootMarshaller.typeMappingRegistry;
        this.typeMapping = rootMarshaller.typeMapping;
    }

    public void init(String typeMappingFile) throws TypeMappingException {
        this.typeMappingRegistry = new TypeMappingRegistryImpl();
        this.typeMappingRegistry.fromXML(typeMappingFile, this.getClass().getClassLoader());
        this.typeMapping = (ExtendedTypeMapping)this.typeMappingRegistry.getDefaultTypeMapping();
    }

    public void init(String typeMappingFile, ClassLoader loader) throws TypeMappingException {
        this.typeMappingRegistry = new TypeMappingRegistryImpl();
        this.typeMappingRegistry.fromXML(typeMappingFile, loader);
        this.typeMapping = (ExtendedTypeMapping)this.typeMappingRegistry.getDefaultTypeMapping();
    }

    public void init(InputStream typeMappingStream) throws TypeMappingException {
        this.typeMappingRegistry = new TypeMappingRegistryImpl();
        this.typeMappingRegistry.fromXML(typeMappingStream, this.getClass().getClassLoader());
        this.typeMapping = (ExtendedTypeMapping)this.typeMappingRegistry.getDefaultTypeMapping();
    }

    public void init(InputStream typeMappingStream, ClassLoader loader) throws TypeMappingException {
        this.typeMappingRegistry = new TypeMappingRegistryImpl();
        this.typeMappingRegistry.fromXML(typeMappingStream, loader);
        this.typeMapping = (ExtendedTypeMapping)this.typeMappingRegistry.getDefaultTypeMapping();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void marshal(Object object, QName schemaelement, String fileName) throws MarshalException {
        FileOutputStream output = null;
        output = new FileOutputStream(fileName);
        this.marshal(object, schemaelement, output);
        Object var7_5 = null;
        if (output == null) return;
        try {
            output.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
        {
            catch (FileNotFoundException e) {
                throw new XmlMarshalException("webservices_3135", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    public Object unmarshal(Class resultClass, QName elementType, Element inputNode) throws UnmarshalException {
        if (inputNode == null) {
            throw new XmlUnmarshalException("webservices_3110");
        }
        this.dcontext.clearContext();
        this.dcontext.setApplicationClassLoader(resultClass.getClassLoader());
        this.dcontext.setExtendedTypeMapping(this.typeMapping);
        DeserializerBase deserializer = this.dcontext.getDeserializer(elementType, resultClass);
        return deserializer.deserialize(inputNode, this.dcontext, resultClass);
    }

    public Object unmarshal(Class resultClass, Element inputNode) throws UnmarshalException {
        if (inputNode == null) {
            throw new XmlUnmarshalException("webservices_3110");
        }
        QName schemaElement = new QName(inputNode.getNamespaceURI(), inputNode.getLocalName());
        QName elementType = this.typeMapping.getTypeForElement(schemaElement);
        this.dcontext.clearContext();
        this.dcontext.setApplicationClassLoader(resultClass.getClassLoader());
        this.dcontext.setExtendedTypeMapping(this.typeMapping);
        DeserializerBase deserializer = this.dcontext.getDeserializer(elementType, resultClass);
        return deserializer.deserialize(inputNode, this.dcontext, resultClass);
    }

    public void marshal(Object object, QName elementType, Element outputNode) throws MarshalException {
        Class<?> oclass = null;
        if (object != null) {
            oclass = object.getClass();
        }
        if (outputNode == null) {
            throw new XmlMarshalException("webservices_3110");
        }
        this.scontext.setTypeMapping(this.typeMapping);
        SerializerBase serializer = this.scontext.getSerializer(elementType, oclass);
        serializer.serialize(object, outputNode, this.scontext);
    }

    public void marshal(Object object, Element outputnode) throws MarshalException {
        Class<?> oclass = null;
        if (object != null) {
            oclass = object.getClass();
        }
        if (outputnode == null) {
            throw new XmlMarshalException("webservices_3141", "null", (Object)"null");
        }
        QName schemaElement = new QName(outputnode.getNamespaceURI(), outputnode.getLocalName());
        QName elementType = this.typeMapping.getTypeForElement(schemaElement);
        if (elementType == null) {
            throw new XmlMarshalException("webservices_3141", schemaElement.getNamespaceURI(), (Object)schemaElement.getLocalPart());
        }
        this.scontext.setTypeMapping(this.typeMapping);
        SerializerBase serializer = this.scontext.getSerializer(elementType, oclass);
        serializer.serialize(object, outputnode, this.scontext);
    }

    public void marshal(Object object, QName schemaelement, OutputStream output) throws MarshalException {
        try {
            this.writer.init(output, "utf-8");
            this.writer.setIndent(this.indent);
            this.writer.writeInitial();
            this.scontext.clearContext();
            Class<?> oclass = null;
            if (object != null) {
                oclass = object.getClass();
            }
            if (schemaelement == null) {
                throw new XmlMarshalException("webservices_3141", "null", (Object)"null");
            }
            QName elementType = this.typeMapping.getTypeForElement(schemaelement);
            if (elementType == null) {
                throw new XmlMarshalException("webservices_3141", schemaelement.getNamespaceURI(), (Object)schemaelement.getLocalPart());
            }
            this.scontext.setTypeMapping(this.typeMapping);
            SerializerBase serializer = this.scontext.getSerializer(elementType, oclass);
            this.writer.enter(schemaelement.getNamespaceURI(), schemaelement.getLocalPart());
            Enumeration keys = this.defaultPrefixes.keys();
            while (keys.hasMoreElements()) {
                String namespace = (String)keys.nextElement();
                String prefix = (String)this.defaultPrefixes.get(namespace);
                this.writer.setPrefixForNamespace(prefix, namespace);
            }
            serializer.serialize(object, (XMLTokenWriter)this.writer, this.scontext);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new XmlMarshalException("webservices_3135", (Throwable)e);
        }
    }

    public void marshal(Object object, QName rootNode, QName schemaType, OutputStream output) throws MarshalException {
        try {
            this.writer.init(output, "utf-8");
            this.writer.setIndent(this.indent);
            this.writer.writeInitial();
            this.scontext.clearContext();
            Class<?> oclass = null;
            if (object != null) {
                oclass = object.getClass();
            }
            this.scontext.setExtendedTypeMapping(this.typeMapping);
            SerializerBase serializer = this.scontext.getSerializer(schemaType, oclass);
            this.writer.enter(rootNode.getNamespaceURI(), rootNode.getLocalPart());
            Enumeration keys = this.defaultPrefixes.keys();
            while (keys.hasMoreElements()) {
                String namespace = (String)keys.nextElement();
                String prefix = (String)this.defaultPrefixes.get(namespace);
                this.writer.setPrefixForNamespace(prefix, namespace);
            }
            serializer.serialize(object, (XMLTokenWriter)this.writer, this.scontext);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new XmlMarshalException("webservices_3135", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void marshal(Object object, QName rootNode, QName schemaType, String fileName) throws MarshalException {
        FileOutputStream output = null;
        output = new FileOutputStream(fileName);
        this.marshal(object, rootNode, schemaType, output);
        Object var8_6 = null;
        if (output == null) return;
        try {
            output.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
        {
            catch (FileNotFoundException e) {
                throw new XmlMarshalException("webservices_3135", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    public Object unmarshal(Class resultClass, QName schemaElement, InputStream input) throws UnmarshalException {
        this.reader.init(input);
        try {
            this.reader.begin();
            this.reader.moveToNextElementStart();
            this.dcontext.clearContext();
            this.dcontext.setApplicationClassLoader(resultClass.getClassLoader());
            this.dcontext.setExtendedTypeMapping(this.typeMapping);
            QName elementType = this.typeMapping.getTypeForElement(schemaElement);
            if (elementType == null) {
                throw new XmlUnmarshalException("webservices_3141", schemaElement.getNamespaceURI(), (Object)schemaElement.getLocalPart());
            }
            if (this.reader.getState() != 1) {
                throw new XmlUnmarshalException("webservices_3122", schemaElement.getNamespaceURI(), (Object)schemaElement.getLocalPart());
            }
            DeserializerBase deserializer = this.dcontext.getDeserializer(elementType, resultClass);
            return deserializer.deserialize((XMLTokenReader)this.reader, this.dcontext, resultClass);
        }
        catch (ParserException e) {
            throw new XmlUnmarshalException("webservices_3125", e);
        }
    }

    public Object unmarshal(Class resultClass, QName schemaElement, String inputFile) throws UnmarshalException {
        try {
            FileInputStream input = new FileInputStream(inputFile);
            Object perm = this.unmarshal(resultClass, schemaElement, input);
            input.close();
            return perm;
        }
        catch (FileNotFoundException e) {
            throw new XmlUnmarshalException("webservices_3125", (Throwable)e);
        }
        catch (IOException e) {
            throw new XmlUnmarshalException("webservices_3125", (Throwable)e);
        }
    }

    public Object unmarshalType(Class resultClass, QName schemaType, InputStream input) throws UnmarshalException {
        this.reader.init(input);
        try {
            this.reader.begin();
            this.reader.moveToNextElementStart();
            this.dcontext.clearContext();
            this.dcontext.setApplicationClassLoader(resultClass.getClassLoader());
            this.dcontext.setExtendedTypeMapping(this.typeMapping);
            if (this.reader.getState() != 1) {
                throw new XmlUnmarshalException("webservices_3122", schemaType.getNamespaceURI(), (Object)schemaType.getLocalPart());
            }
            DeserializerBase deserializer = this.dcontext.getDeserializer(schemaType, resultClass);
            return deserializer.deserialize((XMLTokenReader)this.reader, this.dcontext, resultClass);
        }
        catch (ParserException e) {
            throw new XmlUnmarshalException("webservices_3125", e);
        }
    }

    public Object unmarshalType(Class resultClass, QName schemaElement, String inputFile) throws UnmarshalException {
        try {
            FileInputStream input = new FileInputStream(inputFile);
            Object perm = this.unmarshalType(resultClass, schemaElement, input);
            input.close();
            return perm;
        }
        catch (FileNotFoundException e) {
            throw new XmlUnmarshalException("webservices_3125", (Throwable)e);
        }
        catch (IOException e) {
            throw new XmlUnmarshalException("webservices_3125", (Throwable)e);
        }
    }
}

