/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationFactory;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import com.sap.engine.services.webservices.jaxrpc.util.IteratorImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;

public class SerializationFactoryImpl
implements SerializationFactory {
    public static final String MECHANISM = "com.sap.jaxrpc.multixml";
    private QName xmlType;
    private SerializerBase serializer;
    private DeserializerBase deserializer;
    private String serializerName;
    private String deserializerName;
    private boolean isInitialized;
    private String[] initParams;
    static /* synthetic */ Class class$java$lang$String;

    private Class loadClass(String className, ClassLoader primaryLoader, ClassLoader secondaryLoader) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            result = Class.forName(className, false, primaryLoader);
        }
        catch (ClassNotFoundException e) {
            result = null;
        }
        catch (NoClassDefFoundError e) {
            result = null;
        }
        if (result == null) {
            result = Class.forName(className, false, secondaryLoader);
        }
        return result;
    }

    public SerializationFactoryImpl() {
        this.xmlType = null;
        this.serializer = null;
        this.deserializer = null;
        this.serializerName = null;
        this.deserializerName = null;
        this.isInitialized = false;
        this.initParams = null;
    }

    public SerializationFactoryImpl(QName xmlType, String sdName) {
        if (sdName == null || xmlType == null) {
            throw new IllegalArgumentException("Can not create SerializationFactoryImpl with 'null' params !");
        }
        this.serializerName = sdName;
        this.deserializerName = sdName;
        this.xmlType = xmlType;
        this.isInitialized = false;
        this.initParams = null;
    }

    public SerializationFactoryImpl(String sdName) throws IllegalArgumentException {
        this.serializerName = sdName;
        this.deserializerName = sdName;
        this.isInitialized = false;
        this.initParams = null;
    }

    public SerializationFactoryImpl(String localName, String uri, String sdName) throws IllegalArgumentException {
        if (sdName == null || localName == null) {
            throw new IllegalArgumentException(" Can not create SerializationFactoryImpl with 'null' params !");
        }
        this.serializerName = sdName;
        this.deserializerName = sdName;
        this.xmlType = new QName(localName, uri);
        this.isInitialized = false;
        this.initParams = null;
    }

    public SerializationFactoryImpl(QName xmlType, String serializerName, String deserializerName) throws IllegalArgumentException {
        if (serializerName == null || xmlType == null || deserializerName == null) {
            throw new IllegalArgumentException(" Can not create SerializationFactoryImpl with 'null' params !");
        }
        this.serializerName = serializerName;
        this.deserializerName = deserializerName;
        this.xmlType = xmlType;
        this.isInitialized = false;
        this.initParams = null;
    }

    public SerializationFactoryImpl(QName xmlType, String serializerName, String deserializerName, String initParams) throws IllegalArgumentException {
        if (serializerName == null || xmlType == null || deserializerName == null) {
            throw new IllegalArgumentException(" Can not create SerializationFactoryImpl with 'null' params !");
        }
        this.serializerName = serializerName;
        this.deserializerName = deserializerName;
        this.xmlType = xmlType;
        this.isInitialized = false;
        if (initParams != null && initParams.length() != 0) {
            this.initParams = this.getInitParams(initParams);
        }
    }

    private String[] getInitParams(String initParams) {
        StringTokenizer tokenizer = new StringTokenizer(initParams, ",", false);
        int tokenCount = tokenizer.countTokens();
        String[] result = new String[tokenCount];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public SerializationFactoryImpl(QName xmlType, Serializer serializer, Deserializer deserializer) {
        if (serializer == null || deserializer == null) {
            throw new IllegalArgumentException(" Do not create SerializationFactoryImpl without giving serializer or deserializer !");
        }
        if (!(serializer instanceof SerializerBase) || !(deserializer instanceof DeserializerBase)) {
            throw new IllegalArgumentException(" Both serializer and deserializer must implement SerializerBase and DeserializerBase !");
        }
        this.serializerName = serializer.getClass().getName();
        this.serializer = (SerializerBase)serializer;
        this.deserializer = (DeserializerBase)deserializer;
        this.deserializerName = deserializer.getClass().getName();
        this.xmlType = xmlType;
        this.isInitialized = true;
    }

    private Object getInstanceInitParams(Class serializerClass) throws NoSuchMethodException, TypeMappingException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Class[] p = new Class[this.initParams.length];
        int i = 0;
        while (i < this.initParams.length) {
            p[i] = class$java$lang$String == null ? SerializationFactoryImpl.class$("java.lang.String") : class$java$lang$String;
            ++i;
        }
        Constructor constructor = serializerClass.getConstructor(p);
        if (constructor == null) {
            throw new TypeMappingException("webservices_3302", serializerClass.getName());
        }
        Object object = constructor.newInstance(this.initParams);
        return object;
    }

    public void init(ClassLoader classLoader) throws TypeMappingException {
        if (this.isInitialized) {
            throw new TypeMappingException(" Object is olready initialized and Serializers and Deserializers are loaded. Can not initialize twise !");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(" Do not pass null ClassLoader to init method of SerializationFactoryImpl !");
        }
        try {
            if (this.serializerName.equals(this.deserializerName)) {
                Class serializerClass = null;
                serializerClass = this.loadClass(this.serializerName, classLoader, this.getClass().getClassLoader());
                if (this.initParams != null) {
                    Object object = this.getInstanceInitParams(serializerClass);
                    this.serializer = (SerializerBase)object;
                    this.deserializer = (DeserializerBase)object;
                } else {
                    Object object = null;
                    object = serializerClass.newInstance();
                    this.serializer = object;
                    this.deserializer = object;
                }
            } else {
                Object object;
                Class serializerClass = this.loadClass(this.serializerName, classLoader, this.getClass().getClassLoader());
                if (this.initParams != null) {
                    object = this.getInstanceInitParams(serializerClass);
                    this.serializer = (SerializerBase)object;
                } else {
                    object = serializerClass.newInstance();
                    this.serializer = (SerializerBase)object;
                }
                Class deserializerClass = this.loadClass(this.serializerName, classLoader, this.getClass().getClassLoader());
                if (this.initParams != null) {
                    Object object2 = this.getInstanceInitParams(deserializerClass);
                    this.deserializer = (DeserializerBase)object2;
                } else {
                    Object object3 = deserializerClass.newInstance();
                    this.deserializer = (DeserializerBase)object3;
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new TypeMappingException("webservices_3301", e, this.serializerName);
        }
        catch (InstantiationException e) {
            throw new TypeMappingException("webservices_3302", e, this.serializerName);
        }
        catch (IllegalAccessException e) {
            throw new TypeMappingException("webservices_3301", e, this.serializerName);
        }
        catch (NoSuchMethodException e) {
            throw new TypeMappingException("webservices_3301", e, this.serializerName);
        }
        catch (SecurityException e) {
            throw new TypeMappingException("webservices_3301", e, this.serializerName);
        }
        catch (InvocationTargetException e) {
            throw new TypeMappingException("webservices_3301", e, this.serializerName);
        }
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Serializer getSerializerAs(String s) {
        return this.serializer;
    }

    public SerializerBase getSerializer() {
        return this.serializer;
    }

    public Deserializer getDeserializerAs(String s) {
        return this.deserializer;
    }

    public DeserializerBase getDeserializer() {
        return this.deserializer;
    }

    public Iterator getSupportedMechanismTypes() {
        IteratorImpl result = new IteratorImpl();
        result.addObject(MECHANISM);
        return result;
    }

    public SerializationFactory cloneSelf() {
        SerializationFactoryImpl result = this.isInitialized ? new SerializationFactoryImpl(this.xmlType, this.serializer, this.deserializer) : new SerializationFactoryImpl(this.xmlType, this.serializerName, this.deserializerName);
        return result;
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public String getDeserializerName() {
        return this.deserializerName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

