/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxrpc.encoding;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.services.webservices.espbase.client.dynamic.content.GenericObject;
import com.sap.engine.services.webservices.jaxm.soap.SOAPDocumentImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.ClassInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldDescriptor;
import com.sap.engine.services.webservices.jaxrpc.encoding.FieldInfo;
import com.sap.engine.services.webservices.jaxrpc.encoding.GeneratedModelGroup;
import com.sap.engine.services.webservices.jaxrpc.encoding.InstanceCreator;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationState;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationUtil;
import com.sap.engine.services.webservices.jaxrpc.encoding.XMLTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.exceptions.XmlUnmarshalException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class InstanceBuilder
implements InstanceCreator {
    private Object resultObject;
    private ClassInfo classInfo;
    private FieldInfo[] fields;
    private int type;
    private SOAPDeserializationContext context;
    private SOAPDeserializationState state;
    private boolean completed;
    private int unloaded;
    private HashMapIntObject arrays;
    private boolean[] foundMarker;
    private Object[] oarr = new Object[1];
    private XMLTypeMapping[] fCache;
    private static int cacheSize = 20;
    private static InstanceBuilder[] cache = new InstanceBuilder[cacheSize];
    private static int cacheCount = 0;
    private static ArrayList[] arrcache = new ArrayList[20];
    private static int arrCount = 0;
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public static final synchronized ArrayList getArrayList() {
        if (arrCount == 0) {
            return new ArrayList();
        }
        return arrcache[--arrCount];
    }

    public static final synchronized void returnArrayList(ArrayList array) {
        if (arrCount < arrcache.length) {
            array.clear();
            InstanceBuilder.arrcache[InstanceBuilder.arrCount] = array;
            ++arrCount;
        }
    }

    public InstanceBuilder(Object resultObject, FieldInfo[] fields, SOAPDeserializationContext context, int type, XMLTypeMapping[] fCache) {
        this.resultObject = resultObject;
        this.classInfo = resultObject instanceof GenericObject ? null : ClassInfo.getClassInfo(resultObject.getClass());
        this.fields = fields;
        this.context = context;
        this.state = null;
        this.type = type;
        this.completed = true;
        this.arrays = new HashMapIntObject();
        this.fCache = fCache;
    }

    public void init(Object resultObject, FieldInfo[] fields, SOAPDeserializationContext context, int type, XMLTypeMapping[] fCache) {
        this.resultObject = resultObject;
        this.classInfo = resultObject instanceof GenericObject ? null : ClassInfo.getClassInfo(resultObject.getClass());
        this.fields = fields;
        this.context = context;
        this.state = null;
        this.type = type;
        this.completed = true;
        this.fCache = fCache;
    }

    public static final synchronized InstanceBuilder getInstanceBuilder(Object resultObject, FieldInfo[] fields, SOAPDeserializationContext context, int type, XMLTypeMapping[] fCache) {
        if (cacheCount == 0) {
            return new InstanceBuilder(resultObject, fields, context, type, fCache);
        }
        InstanceBuilder result = cache[--cacheCount];
        result.init(resultObject, fields, context, type, fCache);
        return result;
    }

    public static final void printStat() {
        System.out.println(cacheCount);
    }

    public static final synchronized void returnInstanceBuilder(InstanceBuilder builder) {
        if (cacheCount < cacheSize) {
            builder.resultObject = null;
            builder.classInfo = null;
            builder.fields = null;
            builder.context = null;
            builder.state = null;
            builder.arrays.clear();
            builder.fCache = null;
            InstanceBuilder.cache[InstanceBuilder.cacheCount] = builder;
            builder.oarr[0] = null;
            ++cacheCount;
        }
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    public SOAPDeserializationState getState() {
        return this.state;
    }

    public void setState(SOAPDeserializationState state) {
        state.setInstanceCreator(this);
        this.state = state;
    }

    private final void setArrays() throws UnmarshalException {
        int[] keys = this.arrays.getAllKeys();
        int i = 0;
        while (i < keys.length) {
            FieldInfo field = this.fields[keys[i]];
            if (this.classInfo == null) {
                Class javaClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                ArrayList arr = (ArrayList)this.arrays.get(keys[i]);
                Object resultArr = Array.newInstance(javaClass, arr.size());
                int j = 0;
                while (j < arr.size()) {
                    Array.set(resultArr, j, arr.get(j));
                    ++j;
                }
                if (this.type == 2) {
                    ((GenericObject)this.resultObject)._setField(GenericObject.CHOICE_FIELD, field.getFieldQName());
                    ((GenericObject)this.resultObject)._setField(GenericObject.CHOICE_VALUE, resultArr);
                } else {
                    ((GenericObject)this.resultObject)._setField(field.getFieldQName(), resultArr);
                }
                InstanceBuilder.returnArrayList(arr);
            } else {
                FieldDescriptor descriptor = this.classInfo.getField(field.fieldJavaName);
                Class<?> javaClass = descriptor.getFieldType();
                javaClass = javaClass.getComponentType();
                ArrayList arr = (ArrayList)this.arrays.get(keys[i]);
                Object resultArr = Array.newInstance(javaClass, arr.size());
                int j = 0;
                while (j < arr.size()) {
                    Array.set(resultArr, j, arr.get(j));
                    ++j;
                }
                this._setFieldObject(descriptor, resultArr);
                InstanceBuilder.returnArrayList(arr);
            }
            ++i;
        }
    }

    private final void _setFieldObject(FieldDescriptor field, Object content) throws UnmarshalException {
        Method writeMethod = field.getWriteMethod();
        try {
            if (writeMethod != null) {
                this.oarr[0] = content;
                writeMethod.invoke(this.resultObject, this.oarr);
            } else {
                Field fieldReflect = null;
                fieldReflect = this.resultObject.getClass().getField(field.getName());
                fieldReflect.set(this.resultObject, content);
            }
        }
        catch (NoSuchFieldException e) {
            throw new XmlUnmarshalException("webservices_3102", this.resultObject.getClass().getName(), (Object)field.getName(), (Object)field.getFieldType().getName());
        }
        catch (SecurityException e) {
            throw new XmlUnmarshalException("webservices_3100", writeMethod.getName(), (Object)this.resultObject.getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new XmlUnmarshalException("webservices_3100", writeMethod.getName(), (Object)this.resultObject.getClass().getName());
        }
        catch (IllegalArgumentException e) {
            throw new XmlUnmarshalException("webservices_3101", e, (Object)writeMethod.getName(), (Object)this.resultObject.getClass().getName(), (Object)e.getClass().getName());
        }
        catch (InvocationTargetException e) {
            throw new XmlUnmarshalException("webservices_3101", e, (Object)writeMethod.getName(), (Object)this.resultObject.getClass().getName(), (Object)e.getClass().getName());
        }
    }

    public final void _setFieldObject(Object content, int index, int subindex) throws UnmarshalException {
        if (subindex == -1) {
            SerializationUtil._setFieldObject(this.classInfo.getField(this.fields[index].fieldJavaName), this.resultObject, content);
            --this.unloaded;
            if (this.unloaded == 0) {
                this.setArrays();
                this.completed = true;
            }
        } else {
            ArrayList arr = (ArrayList)this.arrays.get(index);
            arr.set(subindex, content);
            --this.unloaded;
            if (this.unloaded == 0) {
                this.setArrays();
                this.completed = true;
            }
        }
    }

    private boolean readSimple(XMLTokenReader reader) throws UnmarshalException {
        this.completed = true;
        if (this.fields.length == 1) {
            if (this.classInfo == null) {
                if (this.fCache[0] == null) {
                    this.fCache[0] = this.context.getDeserializerAll(this.fields[0].getTypeQName());
                }
                DeserializerBase deserializer = this.fCache[0].getDefaultDeserializer();
                Class fieldClass = SerializationUtil.getJavaClass(this.fields[0].getTypeJavaName());
                Object content = deserializer.deserialize(reader, this.context, fieldClass);
                ((GenericObject)this.resultObject)._setField(GenericObject.SIMPLE_FIELD, content);
            } else {
                FieldDescriptor descriptor = this.classInfo.getField(this.fields[0].fieldJavaName);
                if (descriptor != null) {
                    Class resultClass = descriptor.getFieldType();
                    if (this.fCache[0] == null) {
                        this.fCache[0] = this.context.getDeserializerAll(this.fields[0].getTypeQName());
                    }
                    DeserializerBase deserializer = this.fCache[0].getDefaultDeserializer();
                    Object content = deserializer.deserialize(reader, this.context, resultClass);
                    this._setFieldObject(descriptor, content);
                }
            }
        }
        return this.completed;
    }

    private boolean readChoice(XMLTokenReader reader) throws UnmarshalException {
        this.completed = true;
        try {
            reader.passChars();
        }
        catch (ParserException e) {
            throw new XmlUnmarshalException("webservices_3125", e);
        }
        if (reader.getState() != 1) {
            throw new XmlUnmarshalException("webservices_3122", "http://www.w3.org/2001/XMLSchema", (Object)"choice(construct)");
        }
        CharArray localName = reader.getLocalNameCharArray();
        CharArray uri = reader.getURICharArray();
        boolean flag = false;
        int wildcardIndex = -1;
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].fieldModel == 1 && localName.equals((Object)this.fields[i].fieldLocalName)) {
                this.readElement(i, reader);
                flag = true;
                break;
            }
            if (this.fields[i].fieldModel == 3 && ((GeneratedModelGroup)this.fields[i].objectValue).contains(uri, localName)) {
                this.readModelGroup(i, reader);
                flag = true;
                break;
            }
            if (this.fields[i].fieldModel == 4 && ((GeneratedModelGroup)this.fields[i].objectValue).contains(uri, localName)) {
                this.readModelGroup(i, reader);
                flag = true;
                break;
            }
            if (this.fields[i].fieldModel == 2 && ((GeneratedModelGroup)this.fields[i].objectValue).contains(uri, localName)) {
                this.readModelGroup(i, reader);
                flag = true;
                break;
            }
            if (this.fields[i].fieldModel == 5) {
                wildcardIndex = i;
            }
            ++i;
        }
        if (wildcardIndex >= 0 && !flag) {
            this.readAny(wildcardIndex, reader);
            flag = true;
        }
        if (!flag) {
            throw new XmlUnmarshalException("webservices_3133", uri.toString(), (Object)localName.toString());
        }
        return this.completed;
    }

    /*
     * Unable to fully structure code
     */
    private void readAny(int fieldIndex, XMLTokenReader reader) throws UnmarshalException {
        block26: {
            block27: {
                field = this.fields[fieldIndex];
                if (this.classInfo == null) break block27;
                descriptor = this.classInfo.getField(field.fieldJavaName);
                try {
                    block28: {
                        block29: {
                            if (field.maxOccurs == 1) break block28;
                            if (descriptor == null) break block29;
                            arr = InstanceBuilder.getArrayList();
                            this.arrays.put(fieldIndex, (Object)arr);
                            resultClass = descriptor.getFieldType();
                            if (resultClass.isArray()) ** GOTO lbl25
                            throw new XmlUnmarshalException("webservices_3132", field.fieldJavaName, (Object)this.resultObject.getClass().getName());
lbl-1000:
                            // 1 sources

                            {
                                componentClass = resultClass.getComponentType();
                                content = null;
                                if ((InstanceBuilder.class$javax$xml$soap$SOAPElement == null ? InstanceBuilder.class$("javax.xml.soap.SOAPElement") : InstanceBuilder.class$javax$xml$soap$SOAPElement).isAssignableFrom(componentClass)) {
                                    content = reader.getDOMRepresentation((Document)new SOAPDocumentImpl());
                                } else if ((InstanceBuilder.class$org$w3c$dom$Element == null ? InstanceBuilder.class$("org.w3c.dom.Element") : InstanceBuilder.class$org$w3c$dom$Element).isAssignableFrom(componentClass)) {
                                    content = reader.getDOMRepresentation((Document)new DocumentImpl());
                                }
                                reader.next();
                                reader.passChars();
                                arr.add(content);
lbl25:
                                // 2 sources

                                ** while (reader.getState() == 1)
                            }
lbl26:
                            // 1 sources

                            break block26;
                        }
                        if (field.minOccurs != 0) {
                            fieldType = this.context.getExtendedTypeMapping().getDefaultJavaType(field.getTypeQName());
                            if (fieldType == null) {
                                fieldType = field.typeJavaName;
                            }
                            throw new XmlUnmarshalException("webservices_3116", this.resultObject.getClass(), (Object)field.fieldJavaName, (Object)fieldType);
                        }
                        break block26;
                    }
                    if (descriptor != null) {
                        componentClass = descriptor.getFieldType();
                        content = null;
                        if ((InstanceBuilder.class$javax$xml$soap$SOAPElement == null ? (InstanceBuilder.class$javax$xml$soap$SOAPElement = InstanceBuilder.class$("javax.xml.soap.SOAPElement")) : InstanceBuilder.class$javax$xml$soap$SOAPElement).isAssignableFrom(componentClass)) {
                            content = reader.getDOMRepresentation((Document)new SOAPDocumentImpl());
                        } else if ((InstanceBuilder.class$org$w3c$dom$Element == null ? (InstanceBuilder.class$org$w3c$dom$Element = InstanceBuilder.class$("org.w3c.dom.Element")) : InstanceBuilder.class$org$w3c$dom$Element).isAssignableFrom(componentClass)) {
                            content = reader.getDOMRepresentation((Document)new DocumentImpl());
                        }
                        reader.next();
                        reader.passChars();
                        this._setFieldObject(descriptor, content);
                    } else if (field.minOccurs != 0) {
                        fieldType = this.context.getExtendedTypeMapping().getDefaultJavaType(field.getTypeQName());
                        if (fieldType == null) {
                            fieldType = field.typeJavaName;
                        }
                        throw new XmlUnmarshalException("webservices_3116", this.resultObject.getClass(), (Object)field.fieldJavaName, (Object)fieldType);
                    }
                    break block26;
                }
                catch (ParserException p) {
                    throw new XmlUnmarshalException("webservices_3125", p);
                }
            }
            try {
                if (field.maxOccurs != 1) {
                    arr = InstanceBuilder.getArrayList();
                    this.arrays.put(fieldIndex, (Object)arr);
                    resultClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                    while (reader.getState() == 1) {
                        content = null;
                        if ((InstanceBuilder.class$javax$xml$soap$SOAPElement == null ? InstanceBuilder.class$("javax.xml.soap.SOAPElement") : InstanceBuilder.class$javax$xml$soap$SOAPElement).isAssignableFrom(resultClass)) {
                            content = reader.getDOMRepresentation((Document)new SOAPDocumentImpl());
                        } else if ((InstanceBuilder.class$org$w3c$dom$Element == null ? InstanceBuilder.class$("org.w3c.dom.Element") : InstanceBuilder.class$org$w3c$dom$Element).isAssignableFrom(resultClass)) {
                            content = reader.getDOMRepresentation((Document)new DocumentImpl());
                        }
                        reader.next();
                        reader.passChars();
                        arr.add(content);
                    }
                } else {
                    resultClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                    content = null;
                    if ((InstanceBuilder.class$javax$xml$soap$SOAPElement == null ? (InstanceBuilder.class$javax$xml$soap$SOAPElement = InstanceBuilder.class$("javax.xml.soap.SOAPElement")) : InstanceBuilder.class$javax$xml$soap$SOAPElement).isAssignableFrom(resultClass)) {
                        content = reader.getDOMRepresentation((Document)new SOAPDocumentImpl());
                    } else if ((InstanceBuilder.class$org$w3c$dom$Element == null ? (InstanceBuilder.class$org$w3c$dom$Element = InstanceBuilder.class$("org.w3c.dom.Element")) : InstanceBuilder.class$org$w3c$dom$Element).isAssignableFrom(resultClass)) {
                        content = reader.getDOMRepresentation((Document)new DocumentImpl());
                    }
                    reader.next();
                    reader.passChars();
                    ((GenericObject)this.resultObject)._setField(GenericObject.ANY_FIELD, content);
                }
            }
            catch (ParserException p) {
                throw new XmlUnmarshalException("webservices_3125", p);
            }
        }
    }

    private void appendAny(int fieldIndex, XMLTokenReader reader) throws UnmarshalException {
        FieldInfo field = this.fields[fieldIndex];
        FieldDescriptor descriptor = this.classInfo.getField(field.fieldJavaName);
        try {
            if (field.maxOccurs != 1) {
                if (descriptor != null) {
                    ArrayList arr = (ArrayList)this.arrays.get(fieldIndex);
                    if (arr == null) {
                        arr = InstanceBuilder.getArrayList();
                    }
                    this.arrays.put(fieldIndex, (Object)arr);
                    Class resultClass = descriptor.getFieldType();
                    if (!resultClass.isArray()) {
                        throw new XmlUnmarshalException("webservices_3132", field.fieldJavaName, (Object)this.resultObject.getClass().getName());
                    }
                    Class<?> componentClass = resultClass.getComponentType();
                    Element content = null;
                    content = (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = InstanceBuilder.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(componentClass) ? reader.getDOMRepresentation((Document)new DocumentImpl()) : reader.getDOMRepresentation((Document)((Object)new SOAPDocumentImpl()));
                    reader.next();
                    reader.passChars();
                    arr.add(content);
                }
            } else if (descriptor != null) {
                Class componentClass = descriptor.getFieldType();
                Element content = null;
                content = (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = InstanceBuilder.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).isAssignableFrom(componentClass) ? reader.getDOMRepresentation((Document)new DocumentImpl()) : reader.getDOMRepresentation((Document)((Object)new SOAPDocumentImpl()));
                reader.next();
                reader.passChars();
                this._setFieldObject(descriptor, content);
            }
        }
        catch (ParserException p) {
            throw new XmlUnmarshalException("webservices_3125", p);
        }
    }

    private void readElement(int fieldIndex, XMLTokenReader reader) throws UnmarshalException {
        block45: {
            FieldInfo field = this.fields[fieldIndex];
            if (this.classInfo == null) {
                try {
                    if (field.maxOccurs != 1) {
                        ArrayList arr = InstanceBuilder.getArrayList();
                        this.arrays.put(fieldIndex, (Object)arr);
                        int subindex = 0;
                        Class javaClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                        while (reader.getState() == 1 && reader.getLocalNameCharArray().equals((Object)field.fieldLocalName)) {
                            if (this.fCache[fieldIndex] == null) {
                                this.fCache[fieldIndex] = this.context.getDeserializerAll(field.getTypeQName());
                            }
                            DeserializerBase deserializer = this.fCache[fieldIndex].getDefaultDeserializer();
                            Object content = deserializer.deserialize(reader, this.context, javaClass);
                            reader.next();
                            reader.passChars();
                            if (content != null && content instanceof SOAPDeserializationState) {
                                SOAPDeserializationState currentState = (SOAPDeserializationState)content;
                                if (currentState.isComplete()) {
                                    if (currentState.getInstance() == null && !field.nillable) {
                                        throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                                    }
                                    arr.add(currentState.getInstance());
                                    ++subindex;
                                    continue;
                                }
                                if (this.state == null) {
                                    this.state = new SOAPDeserializationState();
                                    this.state.setInstanceCreator(this);
                                }
                                currentState.registerListener(this.state, fieldIndex, subindex);
                                ++this.unloaded;
                                this.completed = false;
                                ++subindex;
                                arr.add(null);
                                continue;
                            }
                            if (content == null && !field.nillable) {
                                throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                            }
                            arr.add(content);
                            ++subindex;
                        }
                    }
                    Class resultClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                    if (this.fCache[fieldIndex] == null) {
                        this.fCache[fieldIndex] = this.context.getDeserializerAll(field.getTypeQName());
                    }
                    DeserializerBase deserializer = this.fCache[fieldIndex].getDefaultDeserializer();
                    Object content = deserializer.deserialize(reader, this.context, resultClass);
                    reader.next();
                    reader.passChars();
                    if (content != null && content instanceof SOAPDeserializationState) {
                        SOAPDeserializationState currentState = (SOAPDeserializationState)content;
                        if (currentState.isComplete()) {
                            if (currentState.getInstance() == null && !field.nillable) {
                                throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                            }
                            if (this.type == 2) {
                                ((GenericObject)this.resultObject)._setField(GenericObject.CHOICE_FIELD, field.getFieldQName());
                                ((GenericObject)this.resultObject)._setField(GenericObject.CHOICE_VALUE, currentState.getInstance());
                            }
                            ((GenericObject)this.resultObject)._setField(field.getFieldQName(), currentState.getInstance());
                        }
                        if (this.state == null) {
                            this.state = new SOAPDeserializationState();
                            this.state.setInstanceCreator(this);
                        }
                        currentState.registerListener(this.state, fieldIndex, -1);
                        ++this.unloaded;
                        this.completed = false;
                    }
                    if (content == null && !field.nillable) {
                        throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                    }
                    if (this.type == 2) {
                        ((GenericObject)this.resultObject)._setField(GenericObject.CHOICE_FIELD, field.getFieldQName());
                        ((GenericObject)this.resultObject)._setField(GenericObject.CHOICE_VALUE, content);
                    }
                    ((GenericObject)this.resultObject)._setField(field.getFieldQName(), content);
                }
                catch (ParserException p) {
                    throw new XmlUnmarshalException("webservices_3125", p);
                }
            } else {
                FieldDescriptor descriptor = this.classInfo.getField(field.fieldJavaName);
                try {
                    if (field.maxOccurs != 1) {
                        if (descriptor != null) {
                            ArrayList arr = InstanceBuilder.getArrayList();
                            this.arrays.put(fieldIndex, (Object)arr);
                            int subindex = 0;
                            Class resultClass = descriptor.getFieldType();
                            if (!resultClass.isArray()) {
                                throw new XmlUnmarshalException("webservices_3132", field.fieldJavaName, (Object)this.resultObject.getClass().getName());
                            }
                            Class<?> javaClass = resultClass.getComponentType();
                            while (reader.getState() == 1 && reader.getLocalNameCharArray().equals((Object)field.fieldLocalName)) {
                                if (this.fCache[fieldIndex] == null) {
                                    this.fCache[fieldIndex] = this.context.getDeserializerAll(field.getTypeQName());
                                }
                                DeserializerBase deserializer = this.fCache[fieldIndex].getDefaultDeserializer();
                                Object content = deserializer.deserialize(reader, this.context, javaClass);
                                reader.next();
                                reader.passChars();
                                if (content != null && content instanceof SOAPDeserializationState) {
                                    SOAPDeserializationState currentState = (SOAPDeserializationState)content;
                                    if (currentState.isComplete()) {
                                        if (currentState.getInstance() == null && !field.nillable) {
                                            throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                                        }
                                        arr.add(currentState.getInstance());
                                        ++subindex;
                                        continue;
                                    }
                                    if (this.state == null) {
                                        this.state = new SOAPDeserializationState();
                                        this.state.setInstanceCreator(this);
                                    }
                                    currentState.registerListener(this.state, fieldIndex, subindex);
                                    ++this.unloaded;
                                    this.completed = false;
                                    ++subindex;
                                    arr.add(null);
                                    continue;
                                }
                                if (content == null && !field.nillable) {
                                    throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                                }
                                arr.add(content);
                                ++subindex;
                            }
                        } else if (field.minOccurs != 0) {
                            String fieldType = this.context.getExtendedTypeMapping().getDefaultJavaType(field.getTypeQName());
                            if (fieldType == null) {
                                fieldType = field.typeJavaName;
                            }
                            throw new XmlUnmarshalException("webservices_3116", this.resultObject.getClass(), (Object)field.fieldJavaName, (Object)fieldType);
                        }
                        break block45;
                    }
                    if (descriptor != null) {
                        Class resultClass = descriptor.getFieldType();
                        if (this.fCache[fieldIndex] == null) {
                            this.fCache[fieldIndex] = this.context.getDeserializerAll(field.getTypeQName());
                        }
                        DeserializerBase deserializer = this.fCache[fieldIndex].getDefaultDeserializer();
                        Object content = deserializer.deserialize(reader, this.context, resultClass);
                        reader.next();
                        reader.passChars();
                        if (content != null && content instanceof SOAPDeserializationState) {
                            SOAPDeserializationState currentState = (SOAPDeserializationState)content;
                            if (currentState.isComplete()) {
                                if (currentState.getInstance() == null && !field.nillable) {
                                    throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                                }
                                this._setFieldObject(descriptor, currentState.getInstance());
                            } else {
                                if (this.state == null) {
                                    this.state = new SOAPDeserializationState();
                                    this.state.setInstanceCreator(this);
                                }
                                currentState.registerListener(this.state, fieldIndex, -1);
                                ++this.unloaded;
                                this.completed = false;
                            }
                        } else {
                            if (content == null && !field.nillable) {
                                throw new XmlUnmarshalException("webservices_3117", field.fieldLocalName);
                            }
                            this._setFieldObject(descriptor, content);
                        }
                        break block45;
                    }
                    String fieldType = this.context.getExtendedTypeMapping().getDefaultJavaType(field.getTypeQName());
                    if (fieldType == null) {
                        fieldType = field.typeJavaName;
                    }
                    throw new XmlUnmarshalException("webservices_3116", this.classInfo.getJavaClass().getName(), (Object)field.getFieldJavaName(), (Object)fieldType);
                }
                catch (ParserException p) {
                    throw new XmlUnmarshalException("webservices_3125", p);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readModelGroup(int fieldIndex, XMLTokenReader reader) throws UnmarshalException {
        block27: {
            block28: {
                block24: {
                    block25: {
                        block26: {
                            field = this.fields[fieldIndex];
                            gm = (GeneratedModelGroup)field.objectValue;
                            if (this.classInfo == null) break block24;
                            resultClass = this.classInfo.getFieldClass(field.fieldJavaName);
                            if (resultClass == null) break block25;
                            if (field.maxOccurs == 1) break block26;
                            arr = InstanceBuilder.getArrayList();
                            this.arrays.put(fieldIndex, (Object)arr);
                            subindex = 0;
                            if (resultClass.isArray()) ** GOTO lbl37
                            throw new XmlUnmarshalException("webservices_3132", field.fieldJavaName, (Object)this.resultObject.getClass().getName());
lbl-1000:
                            // 1 sources

                            {
                                content = gm.deserialize(reader, this.context, resultClass.getComponentType());
                                try {
                                    reader.passChars();
                                }
                                catch (ParserException p) {
                                    throw new XmlUnmarshalException("webservices_3125", p);
                                }
                                if (content instanceof SOAPDeserializationState) {
                                    currentState = (SOAPDeserializationState)content;
                                    if (currentState.isComplete()) {
                                        arr.add(currentState.getInstance());
                                        ++subindex;
                                        continue;
                                    }
                                    if (this.state == null) {
                                        this.state = new SOAPDeserializationState();
                                        this.state.setInstanceCreator(this);
                                    }
                                    currentState.registerListener(this.state, fieldIndex, subindex);
                                    ++this.unloaded;
                                    this.completed = false;
                                    ++subindex;
                                    continue;
                                }
                                arr.add(content);
                                ++subindex;
lbl37:
                                // 4 sources

                                ** while (reader.getState() == 1 && gm.contains((String)reader.getLocalName()))
                            }
lbl38:
                            // 1 sources

                            break block27;
                        }
                        content = gm.deserialize(reader, this.context, resultClass);
                        if (content instanceof SOAPDeserializationState) {
                            currentState = (SOAPDeserializationState)content;
                            if (currentState.isComplete()) {
                                this._setFieldObject(this.classInfo.getField(field.fieldJavaName), currentState.getInstance());
                            } else {
                                if (this.state == null) {
                                    this.state = new SOAPDeserializationState();
                                    this.state.setInstanceCreator(this);
                                }
                                currentState.registerListener(this.state, fieldIndex, -1);
                                ++this.unloaded;
                                this.completed = false;
                            }
                        } else {
                            this._setFieldObject(this.classInfo.getField(field.fieldJavaName), content);
                        }
                        break block27;
                    }
                    if (field.minOccurs != 0) {
                        fieldType = this.context.getExtendedTypeMapping().getDefaultJavaType(field.getTypeQName());
                        if (fieldType == null) {
                            fieldType = field.typeJavaName;
                        }
                        throw new XmlUnmarshalException("webservices_3116", this.resultObject.getClass().getName(), (Object)field.fieldJavaName, (Object)fieldType);
                    }
                    break block27;
                }
                resultClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                if (field.maxOccurs == 1) break block28;
                arr = InstanceBuilder.getArrayList();
                this.arrays.put(fieldIndex, (Object)arr);
                subindex = 0;
                if (resultClass.isArray()) ** GOTO lbl95
                throw new XmlUnmarshalException("webservices_3132", field.fieldJavaName, (Object)this.resultObject.getClass().getName());
lbl-1000:
                // 1 sources

                {
                    content = gm.deserialize(reader, this.context, resultClass.getComponentType());
                    try {
                        reader.passChars();
                    }
                    catch (ParserException p) {
                        throw new XmlUnmarshalException("webservices_3125", p);
                    }
                    if (content instanceof SOAPDeserializationState) {
                        currentState = (SOAPDeserializationState)content;
                        if (currentState.isComplete()) {
                            arr.add(currentState.getInstance());
                            ++subindex;
                            continue;
                        }
                        if (this.state == null) {
                            this.state = new SOAPDeserializationState();
                            this.state.setInstanceCreator(this);
                        }
                        currentState.registerListener(this.state, fieldIndex, subindex);
                        ++this.unloaded;
                        this.completed = false;
                        ++subindex;
                        continue;
                    }
                    arr.add(content);
                    ++subindex;
lbl95:
                    // 4 sources

                    ** while (reader.getState() == 1 && gm.contains((String)reader.getLocalName()))
                }
lbl96:
                // 1 sources

                break block27;
            }
            content = gm.deserialize(reader, this.context, resultClass);
            if (content instanceof SOAPDeserializationState) {
                currentState = (SOAPDeserializationState)content;
                if (currentState.isComplete()) {
                    ((GenericObject)this.resultObject)._setField(field.getFieldQName(), currentState.getInstance());
                } else {
                    if (this.state == null) {
                        this.state = new SOAPDeserializationState();
                        this.state.setInstanceCreator(this);
                    }
                    currentState.registerListener(this.state, fieldIndex, -1);
                    ++this.unloaded;
                    this.completed = false;
                }
            } else {
                ((GenericObject)this.resultObject)._setField(field.getFieldQName(), content);
            }
        }
    }

    private boolean readAll(XMLTokenReader reader) throws UnmarshalException {
        this.foundMarker = new boolean[this.fields.length];
        int left = this.fields.length;
        while (reader.getState() == 1) {
            try {
                reader.passChars();
            }
            catch (ParserException e) {
                throw new XmlUnmarshalException("webservices_3125", e);
            }
            if (left == 0 || reader.getState() != 1) break;
            CharArray localName = reader.getLocalNameCharArray();
            boolean flag = true;
            int anyIndex = -1;
            int i = 0;
            while (i < this.fields.length) {
                if (localName.equals((Object)this.fields[i].fieldLocalName) && this.fields[i].fieldModel != 5) {
                    if (this.foundMarker[i]) {
                        throw new XmlUnmarshalException("webservices_3143", localName.toString(), (Object)reader.getParentElement());
                    }
                    this.foundMarker[i] = true;
                    this.readElement(i, reader);
                    --left;
                    flag = false;
                    break;
                }
                if (this.fields[i].fieldModel == 5 && !this.foundMarker[i]) {
                    anyIndex = i;
                }
                ++i;
            }
            if (flag && anyIndex != -1) {
                if (this.fields[anyIndex].maxOccurs == 1) {
                    this.foundMarker[anyIndex] = true;
                }
                this.appendAny(anyIndex, reader);
                --left;
                flag = false;
            }
            if (flag) {
                throw new XmlUnmarshalException("webservices_3142", localName.toString(), (Object)reader.getParentElement());
            }
            try {
                reader.passChars();
            }
            catch (ParserException e) {
                throw new XmlUnmarshalException("webservices_3125", e);
            }
        }
        int i = 0;
        while (left > 0 && i < this.fields.length) {
            if (!this.foundMarker[i] && this.fields[i].defaultValue != null) {
                if (this.classInfo == null) {
                    Class resultClass = SerializationUtil.getJavaClass(this.fields[i].getTypeJavaName());
                    if (this.fCache[i] == null) {
                        this.fCache[i] = this.context.getDeserializerAll(this.fields[i].getTypeQName());
                    }
                    DeserializerBase deserializer = this.fCache[i].getDeserializer(resultClass.getName());
                    Object content = deserializer.deserialize(this.fields[i].defaultValue, this.context, resultClass);
                    ((GenericObject)this.resultObject)._setField(this.fields[i].getFieldQName(), content);
                } else {
                    FieldDescriptor descriptor = this.classInfo.getField(this.fields[i].fieldJavaName);
                    if (descriptor != null) {
                        Class resultClass = descriptor.getFieldType();
                        if (this.fCache[i] == null) {
                            this.fCache[i] = this.context.getDeserializerAll(this.fields[i].getTypeQName());
                        }
                        DeserializerBase deserializer = this.fCache[i].getDeserializer(resultClass.getName());
                        Object content = deserializer.deserialize(this.fields[i].defaultValue, this.context, resultClass);
                        this._setFieldObject(descriptor, content);
                    }
                }
            }
            ++i;
        }
        return this.completed;
    }

    private boolean readSequence(XMLTokenReader reader) throws UnmarshalException {
        int sequencePos = 0;
        while (sequencePos < this.fields.length) {
            try {
                reader.passChars();
            }
            catch (ParserException p) {
                throw new XmlUnmarshalException("webservices_3125", p);
            }
            if (reader.getState() != 1) break;
            CharArray localName = reader.getLocalNameCharArray();
            CharArray uri = reader.getURICharArray();
            int nextPos = sequencePos;
            while (nextPos < this.fields.length) {
                FieldInfo field = this.fields[nextPos];
                if (field.fieldModel == 5) {
                    this.readAny(nextPos, reader);
                    break;
                }
                if (field.fieldModel == 1) {
                    if (localName.equals((Object)field.fieldLocalName)) {
                        this.readElement(nextPos, reader);
                        break;
                    }
                    if (this.classInfo == null) {
                        if (field.defaultValue != null) {
                            Class resultClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                            if (this.fCache[nextPos] == null) {
                                this.fCache[nextPos] = this.context.getDeserializerAll(field.getTypeQName());
                            }
                            DeserializerBase deserializer = this.fCache[nextPos].getDeserializer(resultClass.getName());
                            Object content = deserializer.deserialize(field.defaultValue, this.context, resultClass);
                            ((GenericObject)this.resultObject)._setField(field.getFieldQName(), content);
                        } else if (field.getMinOccurs() > 0 && !field.nillable) {
                            int j = nextPos + 1;
                            while (j < this.fields.length) {
                                if (localName.equals((Object)this.fields[j].fieldLocalName)) {
                                    throw new XmlUnmarshalException("webservices_3144", field.fieldUri, (Object)field.fieldLocalName, (Object)reader.getParentElement());
                                }
                                ++j;
                            }
                            throw new XmlUnmarshalException("webservices_3142", localName, (Object)reader.getParentElement());
                        }
                    } else {
                        FieldDescriptor descriptor = this.classInfo.getField(field.fieldJavaName);
                        if (field.defaultValue != null && descriptor != null) {
                            Class resultClass = descriptor.getFieldType();
                            if (this.fCache[nextPos] == null) {
                                this.fCache[nextPos] = this.context.getDeserializerAll(field.getTypeQName());
                            }
                            DeserializerBase deserializer = this.fCache[nextPos].getDeserializer(resultClass.getName());
                            Object content = deserializer.deserialize(field.defaultValue, this.context, resultClass);
                            this._setFieldObject(descriptor, content);
                        } else if (field.getMinOccurs() > 0 && !field.nillable) {
                            int j = nextPos + 1;
                            while (j < this.fields.length) {
                                if (localName.equals((Object)this.fields[j].fieldLocalName)) {
                                    throw new XmlUnmarshalException("webservices_3144", field.fieldUri, (Object)field.fieldLocalName, (Object)reader.getParentElement());
                                }
                                ++j;
                            }
                            throw new XmlUnmarshalException("webservices_3142", localName, (Object)reader.getParentElement());
                        }
                    }
                } else if (((GeneratedModelGroup)field.objectValue).contains(uri, localName)) {
                    this.readModelGroup(nextPos, reader);
                    break;
                }
                ++nextPos;
            }
            sequencePos = nextPos;
            ++sequencePos;
        }
        while (sequencePos < this.fields.length) {
            FieldInfo field = this.fields[sequencePos];
            if (field.fieldModel == 1) {
                if (this.classInfo == null) {
                    if (field.defaultValue != null) {
                        Class resultClass = SerializationUtil.getJavaClass(field.getTypeJavaName());
                        if (this.fCache[sequencePos] == null) {
                            this.fCache[sequencePos] = this.context.getDeserializerAll(field.getTypeQName());
                        }
                        DeserializerBase deserializer = this.fCache[sequencePos].getDeserializer(resultClass.getName());
                        Object content = deserializer.deserialize(field.defaultValue, this.context, resultClass);
                        ((GenericObject)this.resultObject)._setField(field.getFieldQName(), content);
                    } else if (field.getMinOccurs() > 0 && !field.nillable) {
                        throw new XmlUnmarshalException("webservices_3144", field.fieldUri, (Object)field.fieldLocalName, (Object)reader.getParentElement());
                    }
                } else {
                    FieldDescriptor descriptor = this.classInfo.getField(field.fieldJavaName);
                    if (field.defaultValue != null && descriptor != null) {
                        Class resultClass = descriptor.getFieldType();
                        if (this.fCache[sequencePos] == null) {
                            this.fCache[sequencePos] = this.context.getDeserializerAll(field.getTypeQName());
                        }
                        DeserializerBase deserializer = this.fCache[sequencePos].getDeserializer(resultClass.getName());
                        Object content = deserializer.deserialize(field.defaultValue, this.context, resultClass);
                        this._setFieldObject(descriptor, content);
                    } else if (field.getMinOccurs() > 0) {
                        if (descriptor != null) {
                            throw new XmlUnmarshalException("webservices_3144", field.fieldUri, (Object)field.fieldLocalName, (Object)reader.getParentElement());
                        }
                        String fieldType = this.context.getExtendedTypeMapping().getDefaultJavaType(field.getTypeQName());
                        if (fieldType == null) {
                            fieldType = field.typeJavaName;
                        }
                        throw new XmlUnmarshalException("webservices_3116", this.resultObject.getClass(), (Object)field.fieldJavaName, (Object)fieldType);
                    }
                }
            }
            ++sequencePos;
        }
        if (reader.getState() != 2) {
            try {
                reader.passChars();
            }
            catch (ParserException e) {
                throw new XmlUnmarshalException("webservices_3125", e);
            }
        }
        return this.completed;
    }

    public boolean readContent(XMLTokenReader reader) throws UnmarshalException {
        boolean result = false;
        switch (this.type) {
            case 0: {
                result = this.readSimple(reader);
                break;
            }
            case 2: {
                result = this.readChoice(reader);
                break;
            }
            case 3: {
                result = this.readSequence(reader);
                break;
            }
            case 4: {
                result = this.readAll(reader);
            }
        }
        if (result) {
            this.setArrays();
        }
        return result;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

