/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.services.webservices.jaxm.soap.DefaultHostnameVerifier;
import com.sap.engine.services.webservices.jaxm.soap.HostnameVerifier;
import com.sap.tc.logging.Location;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.SSLTransport;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CRLNumber;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.PolicyConstraints;
import iaik.x509.extensions.PolicyMappings;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeBaseUrl;
import iaik.x509.extensions.netscape.NetscapeCaPolicyUrl;
import iaik.x509.extensions.netscape.NetscapeCaRevocationUrl;
import iaik.x509.extensions.netscape.NetscapeCertRenewalUrl;
import iaik.x509.extensions.netscape.NetscapeComment;
import iaik.x509.extensions.netscape.NetscapeRevocationUrl;
import iaik.x509.extensions.netscape.NetscapeSSLServerName;
import java.util.Enumeration;
import java.util.Vector;

public final class V3ChainVerifier
extends ChainVerifier {
    private boolean trustV1 = true;
    private HostnameVerifier myVerifier = DefaultHostnameVerifier.getNonStrictInstance();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$webservices$jaxm$soap$V3ChainVerifier == null ? (class$com$sap$engine$services$webservices$jaxm$soap$V3ChainVerifier = V3ChainVerifier.class$("com.sap.engine.services.webservices.jaxm.soap.V3ChainVerifier")) : class$com$sap$engine$services$webservices$jaxm$soap$V3ChainVerifier));
    static /* synthetic */ Class class$com$sap$engine$services$webservices$jaxm$soap$V3ChainVerifier;

    public void trustV1Certificates(boolean trust) {
        this.trustV1 = trust;
    }

    public void setHostnameVerifier(HostnameVerifier v) {
        this.myVerifier = v;
    }

    public boolean verifyChain(java.security.cert.X509Certificate[] certs, SSLTransport transport) {
        String me = "verifyChain ()";
        LOCATION.entering("verifyChain ()", new Object[]{certs, transport});
        if (this.size() == 0) {
            LOCATION.errorT("Connections are not possible without trusted certificates.");
            LOCATION.exiting();
            return false;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Chain to verify:");
            int i = 0;
            while (i < certs.length) {
                LOCATION.debugT("cert [" + i + "]");
                LOCATION.debugT(" Subject: " + certs[i].getSubjectDN().toString());
                LOCATION.debugT(" Issuer: " + certs[i].getIssuerDN().toString());
                LOCATION.debugT(" Serial: " + certs[i].getSerialNumber().toString(16));
                LOCATION.debugT(" Not before: " + certs[i].getNotBefore().toString());
                LOCATION.debugT(" Not after: " + certs[i].getNotAfter().toString());
                ++i;
            }
        }
        if (certs.length == 3 && certs[2].getSubjectDN().equals(certs[0].getIssuerDN())) {
            java.security.cert.X509Certificate _cert = certs[1];
            certs[1] = certs[2];
            certs[2] = _cert;
            LOCATION.warningT("chain resorted");
        }
        if (!super.verifyChain(certs, transport)) {
            LOCATION.errorT("Chain rejected by default verifier. IAIK log has more details.");
            LOCATION.exiting();
            return false;
        }
        int i = 0;
        while (i < certs.length) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Certificate: " + certs[i]);
            }
            if (certs[i].getVersion() == 0) {
                LOCATION.debugT("Chain contains V1 certificate");
                if (!this.trustV1) {
                    LOCATION.errorT("V1 certificate rejected");
                    LOCATION.exiting();
                    return false;
                }
            } else {
                Enumeration extensions = ((X509Certificate)certs[i]).listExtensions();
                if (extensions != null) {
                    while (extensions.hasMoreElements()) {
                        V3Extension ext = (V3Extension)extensions.nextElement();
                        ObjectID oid = ext.getObjectID();
                        if (oid.equals((Object)BasicConstraints.oid)) {
                            BasicConstraints bc = (BasicConstraints)ext;
                            LOCATION.debugT("BasicConstraints: " + bc);
                            if (bc.ca()) {
                                int pathLen;
                                if (i == 0) {
                                    LOCATION.infoT("Extension error: certificate at index 0 is marked CA certificate.");
                                }
                                if ((pathLen = bc.getPathLenConstraint()) == -1 || pathLen >= i - 1) continue;
                                LOCATION.errorT("Extension error: pathLenConstraint violated!");
                                LOCATION.exiting();
                                return false;
                            }
                            if (i == 0) continue;
                            LOCATION.errorT("Extension error: certificate at index " + i + " is marked as non-CA certificate");
                            LOCATION.exiting();
                            return false;
                        }
                        if (oid.equals((Object)KeyUsage.oid)) {
                            int usage;
                            KeyUsage ku = (KeyUsage)ext;
                            LOCATION.debugT("KeyUsage: " + ku);
                            if (i <= 0 || ((usage = ku.get()) & 0x20) != 0) continue;
                            LOCATION.errorT("Extension error: keyusage does not allow certificate signing");
                            LOCATION.exiting();
                            return false;
                        }
                        if (oid.equals((Object)AuthorityKeyIdentifier.oid)) continue;
                        if (oid.equals((Object)CRLDistributionPoints.oid)) {
                            LOCATION.warningT("CRLDistributionPoint: " + ext + " ignored");
                            continue;
                        }
                        if (oid.equals((Object)CRLNumber.oid) || oid.equals((Object)ExtendedKeyUsage.oid) || oid.equals((Object)IssuerAltName.oid) || oid.equals((Object)PolicyMappings.oid) || oid.equals((Object)ReasonCode.oid) || oid.equals((Object)PolicyConstraints.oid) || oid.equals((Object)SubjectAltName.oid) || oid.equals((Object)SubjectKeyIdentifier.oid) || oid.equals((Object)NetscapeBaseUrl.oid) || oid.equals((Object)NetscapeCaPolicyUrl.oid)) continue;
                        if (oid.equals((Object)NetscapeCaRevocationUrl.oid)) {
                            LOCATION.warningT("NetscapeCaRevocationUrl: " + ext + " ignored");
                            continue;
                        }
                        if (oid.equals((Object)NetscapeCertRenewalUrl.oid) || oid.equals((Object)NetscapeComment.oid)) continue;
                        if (oid.equals((Object)NetscapeRevocationUrl.oid)) {
                            LOCATION.warningT("NetscapeRevocationUrl: " + ext + " ignored");
                            continue;
                        }
                        if (oid.equals((Object)NetscapeSSLServerName.oid)) continue;
                        if (ext.isCritical()) {
                            LOCATION.errorT("Unhandled CRITICAL extension: " + ext.getObjectID());
                            return false;
                        }
                        LOCATION.infoT("Unhandled uncritical extension: " + ext.getObjectID());
                    }
                } else {
                    LOCATION.debugT("No extensions in certificate");
                }
            }
            ++i;
        }
        LOCATION.exiting();
        return true;
    }

    static String[] getTLSServerName(X509Certificate cert) {
        Vector<String> v = new Vector<String>();
        try {
            Name name;
            Object[] obj;
            NetscapeSSLServerName sslName;
            SubjectAltName altName = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
            if (altName != null) {
                GeneralNames names = altName.getGeneralNames();
                Enumeration e = names.getNames();
                while (e.hasMoreElements()) {
                    GeneralName name2 = (GeneralName)e.nextElement();
                    if (name2.getType() != 2) continue;
                    v.addElement(name2.getName().toString());
                }
            }
            if ((sslName = (NetscapeSSLServerName)cert.getExtension(NetscapeSSLServerName.oid)) != null) {
                v.addElement(sslName.getSSLServerName());
            }
            if ((obj = (name = (Name)cert.getSubjectDN()).getRDNValues(ObjectID.commonName)) != null) {
                int i = 0;
                while (i < obj.length) {
                    v.addElement(obj[i].toString());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int n = v.size();
        Object[] r = new String[n];
        v.copyInto(r);
        return r;
    }

    protected boolean verifyServer(java.security.cert.X509Certificate[] certs, SSLTransport transport) {
        String transportName = transport.getRemotePeerName();
        if (transportName == null) {
            return true;
        }
        String[] names = V3ChainVerifier.getTLSServerName((X509Certificate)certs[0]);
        if (names == null) {
            return true;
        }
        if (names.length == 0) {
            return !this.checkServerName;
        }
        transportName = transportName.toLowerCase();
        int i = 0;
        while (i < names.length) {
            if (this.myVerifier.verify(transportName, names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

