/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.services.webservices.jaxm.soap.ElementStack;
import com.sap.engine.services.webservices.jaxm.soap.SOAPBodyImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPElementImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPEnvelopeImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPFaultImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPHeaderImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPTextImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPTextStack;
import java.io.Serializable;
import org.w3c.dom.Document;

public class SOAPPool
implements Serializable {
    private SOAPTextStack textNodesPool = new SOAPTextStack(10);
    private ElementStack soapElementPool = new ElementStack(10);
    private int createdNodes = 0;
    private int pooledNodes = 0;

    public final SOAPElementImpl createElement(Document owner, String tagName) {
        SOAPElementImpl result = null;
        if (this.soapElementPool.isEmpty()) {
            ++this.createdNodes;
            result = new SOAPElementImpl(owner);
            result.init(null, tagName, true, null, true);
        } else {
            ++this.pooledNodes;
            result = this.soapElementPool.pop();
            result.init(null, tagName, true, null, true);
            result.setOwner(owner, false);
        }
        return result;
    }

    public final SOAPElementImpl createElementNS(Document owner, String namespaceURI, String qualifiedName) {
        String localName = DOM.qnameToLocalName((String)qualifiedName);
        if (namespaceURI != null && namespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            if (localName.equalsIgnoreCase("Envelope")) {
                ++this.createdNodes;
                SOAPEnvelopeImpl envelope = new SOAPEnvelopeImpl(owner);
                envelope.init("http://schemas.xmlsoap.org/soap/envelope/", qualifiedName, null);
                return envelope;
            }
            if (localName.equalsIgnoreCase("Header")) {
                return this.createHeader(owner, qualifiedName);
            }
            if (localName.equalsIgnoreCase("Body")) {
                ++this.createdNodes;
                SOAPBodyImpl body = new SOAPBodyImpl(owner);
                body.init("http://schemas.xmlsoap.org/soap/envelope/", qualifiedName, null);
                return body;
            }
            if (localName.equalsIgnoreCase("Fault")) {
                return this.createFault(owner, qualifiedName);
            }
        }
        SOAPElementImpl result = null;
        if (this.soapElementPool.isEmpty()) {
            ++this.createdNodes;
            result = new SOAPElementImpl(owner);
            result.init(namespaceURI, qualifiedName, true, null, false);
        } else {
            ++this.pooledNodes;
            result = this.soapElementPool.pop();
            result.init(namespaceURI, qualifiedName, true, null, false);
            result.setOwner(owner, false);
        }
        return result;
    }

    public final SOAPTextImpl createTextNode(Document owner, String content, boolean isComment) {
        SOAPTextImpl result = null;
        if (this.textNodesPool.isEmpty()) {
            ++this.createdNodes;
            result = new SOAPTextImpl(owner);
            result.init(content, isComment, null);
        } else {
            ++this.pooledNodes;
            result = this.textNodesPool.pop();
            result.init(content, isComment, null);
            result.setOwner(owner, false);
        }
        return result;
    }

    public final SOAPBodyImpl createBody(Document owner, String qname) {
        ++this.createdNodes;
        SOAPBodyImpl body = new SOAPBodyImpl(owner);
        body.init("http://schemas.xmlsoap.org/soap/envelope/", qname, null);
        return body;
    }

    public final SOAPFaultImpl createFault(Document owner, String qname) {
        ++this.createdNodes;
        SOAPFaultImpl fault = new SOAPFaultImpl(owner);
        fault.init("http://schemas.xmlsoap.org/soap/envelope/", qname, null);
        return fault;
    }

    public final SOAPEnvelopeImpl createEnvelope(Document owner, String qname) {
        ++this.createdNodes;
        SOAPEnvelopeImpl envelope = new SOAPEnvelopeImpl(owner);
        envelope.init("http://schemas.xmlsoap.org/soap/envelope/", qname, null);
        return envelope;
    }

    public final SOAPHeaderImpl createHeader(Document owner, String qname) {
        ++this.createdNodes;
        SOAPHeaderImpl header = new SOAPHeaderImpl(owner);
        header.init("http://schemas.xmlsoap.org/soap/envelope/", qname, null);
        return header;
    }

    public final void printInfo() {
        System.out.println("Objects requested :" + (this.pooledNodes + this.createdNodes));
        System.out.println("Objects created :" + this.createdNodes);
        System.out.println("Objects saved :" + this.pooledNodes);
        System.out.println("Pool1 size :" + this.textNodesPool.size());
        System.out.println("Pool2 size :" + this.soapElementPool.size());
    }

    public final void reuseText(SOAPTextImpl textNode) {
    }

    public final void reuseElement(SOAPElementImpl elementNode) {
    }
}

