/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.jaxm.soap.MessageFactoryImpl;
import com.sap.engine.services.webservices.jaxm.soap.SAPSoapException;
import com.sap.engine.services.webservices.jaxm.soap.SOAPMessageImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.messaging.Endpoint;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPConnectionImpl
extends SOAPConnection {
    private MessageFactoryImpl messageFactory = new MessageFactoryImpl();
    private String userName = null;
    private String password = "";
    private String proxyUserName = null;
    private String proxyPassword = "";
    private String proxyHost = SystemProperties.getProperty((String)"http.proxyHost", null);
    private int proxyPort = Integer.parseInt(SystemProperties.getProperty((String)"http.proxyPort", (String)"-1"));
    private String excludeList;
    private boolean closed = false;
    private HTTPSocket socket = null;
    private URL oldURL = null;
    private String oldProxyHost = null;
    private int oldProxyPort = -1;
    private int socketTimeout = 60000;

    public SOAPConnectionImpl() {
        this.proxyUserName = SystemProperties.getProperty((String)"http.proxyUserName", null);
        this.proxyPassword = SystemProperties.getProperty((String)"http.proxyPassword", null);
        this.excludeList = SystemProperties.getProperty((String)"http.nonProxyHosts", null);
        String socketTimeOutProp = SystemProperties.getProperty((String)"http.socketTimeout", null);
        if (socketTimeOutProp != null) {
            this.socketTimeout = Integer.parseInt(socketTimeOutProp.trim());
        }
    }

    private synchronized boolean useProxyForAddress(String address) {
        if (this.excludeList == null) {
            return true;
        }
        if (SOAPConnectionImpl.useProxyForSpecificAddress(address = address.toLowerCase(), this.excludeList)) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(address);
                int i = 0;
                while (i < addresses.length) {
                    InetAddress addr = addresses[i];
                    if (!SOAPConnectionImpl.useProxyForSpecificAddress(addr.getHostAddress(), this.excludeList)) {
                        return false;
                    }
                    if (!SOAPConnectionImpl.useProxyForSpecificAddress(addr.getHostName(), this.excludeList)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            catch (UnknownHostException uhe) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkExcludeList(String address, String excludeList, String separator) {
        StringTokenizer tokenizer = new StringTokenizer(excludeList, separator, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int starIndex = token.indexOf("*");
            if (starIndex != -1) {
                String start = token.substring(0, starIndex);
                String end = token.substring(starIndex + 1);
                if (!address.startsWith(start) || !address.endsWith(end)) continue;
                return false;
            }
            if (!token.equals(address)) continue;
            return false;
        }
        return true;
    }

    private static boolean useProxyForSpecificAddress(String address, String excludeList) {
        if ("localhost".equals(address) || "127.0.0.1".equals(address)) {
            return false;
        }
        if (excludeList == null || excludeList.trim().length() == 0) {
            return true;
        }
        if (!SOAPConnectionImpl.checkExcludeList(address, excludeList, ";")) {
            return false;
        }
        return SOAPConnectionImpl.checkExcludeList(address, excludeList, "|");
    }

    public synchronized void setProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public synchronized void setProxyExcludeList(String excludeList) {
        this.excludeList = excludeList;
    }

    public synchronized String getProxyExcludeList() {
        return this.excludeList;
    }

    public synchronized void setUserName(String userName) {
        SerializationUtil.checkAuthenticationInformation(userName);
        this.userName = userName;
    }

    public synchronized void setUserPassword(String password) {
        SerializationUtil.checkAuthenticationInformation(password);
        this.password = password;
    }

    private void clearSocket() {
        if (this.socket != null) {
            try {
                try {
                    this.socket.disconnect();
                }
                catch (IOException x) {
                    this.socket = null;
                    Object var3_2 = null;
                    this.socket = null;
                }
                Object var3_1 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    private void clearSettings() {
        this.oldURL = null;
        this.oldProxyHost = null;
        this.oldProxyPort = -1;
    }

    public synchronized SOAPMessage call(SOAPMessage message, Endpoint endpoint) throws SOAPException {
        try {
            if (this.closed) {
                throw new NestedSOAPException("webservices_3714");
            }
            this.createHTTPSocket(endpoint);
            return this.call(message);
        }
        catch (IOException e) {
            this.clearSocket();
            this.clearSettings();
            throw new SAPSoapException("IOError while transmiting message ! See nested Exception !", e);
        }
    }

    public SOAPMessage call(SOAPMessage message) throws SOAPException {
        try {
            if (message.saveRequired()) {
                message.saveChanges();
            }
            MimeHeaders mimeheaders = message.getMimeHeaders();
            Iterator iterator = mimeheaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeheader = (MimeHeader)iterator.next();
                this.socket.setHeader(mimeheader.getName(), mimeheader.getValue());
            }
            OutputStream outputstream = this.socket.getOutputStream();
            message.writeTo(outputstream);
            outputstream.flush();
            int http_response = this.socket.getResponseCode();
            if (http_response != 200) {
                if (http_response == 500) {
                    if (this.socket.getContentType() == null || this.socket.getContentType().indexOf("text/xml") == -1) {
                        String responseMessage = this.socket.getResponseMessage();
                        this.clearSocket();
                        this.clearSettings();
                        throw new NestedSOAPException("webservices_3711", responseMessage);
                    }
                    InputStream inputstream = this.socket.getInputStream();
                    SOAPMessageImpl messageReply = (SOAPMessageImpl)this.messageFactory.createMessage(inputstream);
                    return messageReply;
                }
                String responseMessage = this.socket.getResponseMessage();
                this.clearSocket();
                this.clearSettings();
                throw new NestedSOAPException("webservices_3711", responseMessage);
            }
            MimeHeaders mimeheaders1 = new MimeHeaders();
            Enumeration en = this.socket.getHeaderNames();
            while (en.hasMoreElements()) {
                String current = (String)en.nextElement();
                String[] currentHeaderValues = this.socket.getHeader(current);
                int i = 0;
                while (i < currentHeaderValues.length) {
                    mimeheaders1.addHeader(current, currentHeaderValues[i]);
                    ++i;
                }
            }
            InputStream inputstream = this.socket.getInputStream();
            SOAPMessage message1 = this.messageFactory.createMessage(mimeheaders1, inputstream);
            return message1;
        }
        catch (IOException e) {
            this.clearSocket();
            this.clearSettings();
            throw new NestedSOAPException("webservices_3709", e);
        }
        catch (SOAPException x) {
            this.clearSocket();
            this.clearSettings();
            throw x;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            try {
                try {
                    this.socket.disconnect();
                }
                catch (IOException p) {
                    this.socket = null;
                    Object var3_2 = null;
                    this.socket = null;
                }
                Object var3_1 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    public synchronized void close() throws SOAPException {
        if (this.closed) {
            throw new NestedSOAPException("webservices_3715");
        }
        this.closed = true;
        if (this.socket != null) {
            try {
                try {
                    this.socket.disconnect();
                }
                catch (IOException e) {
                    throw new NestedSOAPException("webservices_3708", e);
                }
                Object var3_1 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    private static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }

    private synchronized void createHTTPSocket(Endpoint endpoint) throws IOException {
        URL url = new URL(endpoint.toString());
        boolean createNew = true;
        if (this.socket != null && url.equals(this.oldURL) && this.socket.isAlive()) {
            if (this.proxyHost != null && this.proxyHost.equals(this.oldProxyHost) && this.oldProxyPort == this.proxyPort) {
                createNew = false;
            }
            if (this.proxyHost == null && this.oldProxyHost == null) {
                createNew = false;
            }
        }
        if (createNew) {
            this.clearSocket();
            this.clearSettings();
            this.socket = new HTTPSocket(url);
            this.socket.setRequestMethod("POST");
            if (this.userName != null && this.userName.length() != 0) {
                this.socket.setHeader("Authorization", "Basic " + SOAPConnectionImpl.encodeAuth(this.userName, this.password));
            }
            if (this.proxyHost != null && this.useProxyForAddress(url.getHost())) {
                this.socket.setProxy(this.proxyHost, this.proxyPort);
                if (this.proxyUserName != null && this.proxyPassword != null && this.proxyUserName.length() > 0) {
                    this.socket.setHeader("Proxy-Authorization", "Basic " + SOAPConnectionImpl.encodeAuth(this.proxyUserName, this.proxyPassword));
                }
                this.oldProxyHost = this.proxyHost;
                this.oldProxyPort = this.proxyPort;
            }
            this.socket.setSocketTimeout(this.socketTimeout);
            this.oldURL = url;
        } else {
            this.socket.setRequestMethod("POST");
            if (this.userName != null && this.userName.length() != 0) {
                this.socket.setHeader("Authorization", "Basic " + SOAPConnectionImpl.encodeAuth(this.userName, this.password));
            }
            if (this.proxyHost != null && this.useProxyForAddress(url.getHost()) && this.proxyUserName != null && this.proxyPassword != null && this.proxyUserName.length() > 0) {
                this.socket.setHeader("Proxy-Authorization", "Basic " + SOAPConnectionImpl.encodeAuth(this.proxyUserName, this.proxyPassword));
            }
        }
    }

    public synchronized SOAPMessage call(SOAPMessage soapMessage, Object o) throws SOAPException {
        if (this.closed) {
            throw new NestedSOAPException("webservices_3714");
        }
        if (o instanceof Endpoint) {
            return this.call(soapMessage, (Endpoint)o);
        }
        if (o instanceof String) {
            return this.call(soapMessage, new Endpoint((String)o));
        }
        if (o instanceof URL) {
            return this.call(soapMessage, new Endpoint(((URL)o).toString()));
        }
        return null;
    }
}

