/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends BufferedInputStream {
    private int contentCount;

    public LimitedInputStream(InputStream inputStream, int contentCount) {
        super(inputStream);
        this.contentCount = contentCount;
    }

    public synchronized int read() throws IOException {
        if (this.contentCount == 0) {
            return -1;
        }
        --this.contentCount;
        return super.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int readBytes;
        if (this.contentCount == 0) {
            return -1;
        }
        if (len > this.contentCount) {
            len = this.contentCount;
        }
        if ((readBytes = super.read(b, off, len)) == -1) {
            this.contentCount = 0;
            return -1;
        }
        this.contentCount -= readBytes;
        return readBytes;
    }

    public synchronized int available() throws IOException {
        int aval = super.available();
        if (aval >= this.contentCount) {
            return this.contentCount;
        }
        return aval;
    }
}

