/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class InputStreamLogger
extends BufferedInputStream {
    private OutputStream log;
    private CharArray buf = new CharArray();
    private boolean parseHeaders = true;
    private OutputStream realLogger;

    public InputStreamLogger(InputStream in, OutputStream log) {
        super(in);
        this.log = log;
    }

    public InputStreamLogger(InputStream in, int size, OutputStream log) {
        super(in, size);
        this.log = log;
    }

    public synchronized int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            if (this.parseHeaders) {
                if (res != 10 && res != 13) {
                    this.buf.append((char)res);
                } else if (res == 13) {
                    if (this.buf.length() == 0) {
                        this.log.write(res);
                        this.log.flush();
                    }
                } else {
                    String headerLine = this.buf.toString();
                    this.buf.clear();
                    if (headerLine.toLowerCase().startsWith("set-cookie:")) {
                        this.log.write("Set-Cookie: <value is hidden>".getBytes());
                    } else {
                        this.log.write(headerLine.getBytes());
                    }
                    this.log.write(res);
                    this.log.flush();
                }
            } else {
                this.log.write(res);
                this.log.flush();
            }
        }
        return res;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.log.write(b, off, res);
            this.log.flush();
        }
        return res;
    }

    public void close() throws IOException {
        super.close();
        this.flushMarkedData();
        this.log.flush();
    }

    public void setParseHeaders(boolean parseHeaders) {
        this.parseHeaders = parseHeaders;
    }

    private void flushMarkedData() throws IOException {
        if (this.realLogger != null && this.log != this.realLogger) {
            byte[] data = ((ByteArrayOutputStream)this.log).toByteArray();
            this.log = this.realLogger;
            this.realLogger = null;
            this.log.write(data);
        }
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        try {
            this.flushMarkedData();
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            pw.flush();
            String s = sw.toString();
            pw.close();
            throw new RuntimeException(s);
        }
        if (this.realLogger == null) {
            this.realLogger = this.log;
        }
        this.log = new ByteArrayOutputStream(readlimit);
    }

    public synchronized void reset() throws IOException {
        super.reset();
        ((ByteArrayOutputStream)this.log).reset();
    }
}

