/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;

public class AttachmentPartImpl
extends AttachmentPart {
    MimeHeaders headers = new MimeHeaders();
    private DataHandler dataHandler;

    public void addMimeHeader(String s, String s1) {
        this.headers.addHeader(s, s1);
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    public Object getContent() throws SOAPException {
        try {
            if (this.dataHandler == null) {
                throw new NestedSOAPException("webservices_3716");
            }
            return this.dataHandler.getContent();
        }
        catch (IOException ioexception) {
            throw new NestedSOAPException("webservices_3709", ioexception);
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new NestedSOAPException("webservices_3717");
        }
        return this.dataHandler;
    }

    public Iterator getMatchingMimeHeaders(String[] as) {
        return this.headers.getMatchingHeaders(as);
    }

    public String[] getMimeHeader(String s) {
        return this.headers.getHeader(s);
    }

    public Iterator getNonMatchingMimeHeaders(String[] as) {
        return this.headers.getNonMatchingHeaders(as);
    }

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteArrayOutputStream perm = new ByteArrayOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)perm);
        }
        catch (IOException e) {
            throw new NestedSOAPException("webservices_3710", e);
        }
        return perm.size();
    }

    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    public void removeMimeHeader(String s) {
        this.headers.removeHeader(s);
    }

    public void setContent(Object obj, String s) throws IllegalArgumentException {
        if ("text/xml".equals(s) && obj instanceof StreamSource) {
            StreamSource src = (StreamSource)obj;
            DataSource dsrc = new DataSource(src){
                StreamSource x;
                private final /* synthetic */ StreamSource val$src;
                {
                    this.x = this.val$src = val$src;
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$src.getInputStream();
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getContentType() {
                    return "text/xml";
                }

                public String getName() {
                    return "No Name";
                }
            };
            this.setDataHandler(new DataHandler(dsrc));
        } else {
            this.setDataHandler(new DataHandler(obj, s));
        }
    }

    public void setDataHandler(DataHandler datahandler) throws IllegalArgumentException {
        if (datahandler == null) {
            throw new IllegalArgumentException("NULL is not allowed as data handler.");
        }
        this.dataHandler = datahandler;
    }

    public void setMimeHeader(String s, String s1) {
        this.headers.setHeader(s, s1);
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart mimebodypart = new MimeBodyPart();
            mimebodypart.setDataHandler(this.dataHandler);
            AttachmentPartImpl.copyMimeHeaders(this.headers, mimebodypart);
            mimebodypart.setHeader("Content-Type", this.dataHandler.getContentType());
            return mimebodypart;
        }
        catch (MessagingException e) {
            throw new NestedSOAPException("webservices_3710", e);
        }
    }

    static void copyMimeHeaders(MimeHeaders mimeheaders, MimeBodyPart mimebodypart) throws SOAPException {
        Iterator iterator = mimeheaders.getAllHeaders();
        while (iterator.hasNext()) {
            try {
                MimeHeader mimeheader = (MimeHeader)iterator.next();
                mimebodypart.addHeader(mimeheader.getName(), mimeheader.getValue());
            }
            catch (MessagingException exception) {
                throw new NestedSOAPException("webservices_3710", exception);
            }
        }
    }

    boolean hasAllHeaders(MimeHeaders mimeheaders) {
        Iterator iterator = mimeheaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeheader = (MimeHeader)iterator.next();
            String[] as = this.headers.getHeader(mimeheader.getName());
            boolean flag = false;
            int i = 0;
            while (i < as.length) {
                if (mimeheader.getValue().equalsIgnoreCase(as[i])) {
                    flag = true;
                    break;
                }
                ++i;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }
}

