/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.messaging;

import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.jaxm.messaging.ProviderMetaDataImpl;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.jaxm.soap.MessageFactoryImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPBodyImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPEnvelopeImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPFaultImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPMessageImpl;
import com.sap.engine.services.webservices.jaxm.soap.SOAPPartImpl;
import com.sap.engine.services.webservices.jaxm.soap.accessor.NestedSOAPException;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Iterator;
import javax.xml.messaging.Endpoint;
import javax.xml.messaging.JAXMException;
import javax.xml.messaging.ProviderConnection;
import javax.xml.messaging.ProviderMetaData;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class ProviderConnectionImpl
implements ProviderConnection {
    static Class clz = null;
    private MessageFactoryImpl messageFactory;
    private String userName = null;
    private String password = "";
    private String proxyHost = null;
    private int proxyPort = -1;
    private ProviderMetaData metadata = new ProviderMetaDataImpl();

    public ProviderConnectionImpl() {
        this.messageFactory = new MessageFactoryImpl();
    }

    public ProviderMetaData getMetaData() {
        return this.metadata;
    }

    public MessageFactory createMessageFactory(String s) {
        return this.messageFactory;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setUserName(String userName) {
        SerializationUtil.checkAuthenticationInformation(userName);
        this.userName = userName;
    }

    public void setUserPassword(String password) {
        SerializationUtil.checkAuthenticationInformation(password);
        this.password = password;
    }

    public SOAPMessage call(SOAPMessage message, Endpoint endpoint) throws SOAPException {
        try {
            HTTPSocket httpsock = this.createHTTPSocket(endpoint, ((SOAPMessageImpl)message).getSOAPAction());
            if (message.saveRequired()) {
                message.saveChanges();
            }
            MimeHeaders mimeheaders = message.getMimeHeaders();
            Iterator iterator = mimeheaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeheader = (MimeHeader)iterator.next();
                httpsock.setHeader(mimeheader.getName(), mimeheader.getValue());
            }
            System.out.println(" Tova e message ");
            OutputStream outputstream = httpsock.getOutputStream();
            message.writeTo(outputstream);
            outputstream.flush();
            int http_response = httpsock.getResponseCode();
            if (http_response != 200) {
                if (http_response == 500) {
                    String faultString;
                    try {
                        InputStream inputstream = httpsock.getInputStream();
                        SOAPMessageImpl messageReply = (SOAPMessageImpl)this.messageFactory.createMessage(inputstream);
                        SOAPPartImpl partReply = (SOAPPartImpl)messageReply.getSOAPPart();
                        SOAPEnvelopeImpl envelopeReply = (SOAPEnvelopeImpl)partReply.getEnvelope();
                        SOAPBodyImpl bodyReply = (SOAPBodyImpl)envelopeReply.getBody();
                        SOAPFaultImpl faultReply = (SOAPFaultImpl)bodyReply.getFault();
                        faultString = "SOAP Fault response :";
                        faultString = faultString + "\nFault Code: " + faultReply.getFaultCode();
                        faultString = faultString + "\nFault String: " + faultReply.getFaultString();
                    }
                    catch (Exception e) {
                        throw new UnknownServiceException(httpsock.getResponseMessage());
                    }
                    throw new SOAPException(faultString);
                }
                throw new SOAPException(httpsock.getResponseMessage());
            }
            MimeHeaders mimeheaders1 = new MimeHeaders();
            mimeheaders1.setHeader("Content-Type", httpsock.getContentType());
            mimeheaders1.setHeader("Content-Length", Integer.toString(httpsock.getContentLength()));
            InputStream inputstream = httpsock.getInputStream();
            System.out.println((Object)this.messageFactory);
            SOAPMessage message1 = this.messageFactory.createMessage(mimeheaders1, inputstream);
            inputstream.close();
            httpsock.disconnect();
            return message1;
        }
        catch (Exception exception) {
            if (exception instanceof SOAPException) {
                throw (SOAPException)exception;
            }
            throw new NestedSOAPException("webservices_3708", exception);
        }
    }

    public void close() throws JAXMException {
    }

    private static String encodeAuth(String userName, String password) {
        byte[] result = BASE64Encoder.encode((byte[])(userName + ":" + password).getBytes());
        return new String(result, 0, result.length);
    }

    public HTTPSocket createHTTPSocket(Endpoint endpoint, String soapAction) throws Exception {
        URL url = new URL(endpoint.toString());
        HTTPSocket sock = new HTTPSocket(url);
        sock.setRequestMethod("POST");
        if (this.userName != null && this.userName.length() != 0) {
            sock.setHeader("Authorization", "Basic " + ProviderConnectionImpl.encodeAuth(this.userName, this.password));
        }
        if (this.proxyHost != null) {
            sock.setProxy(this.proxyHost, this.proxyPort);
        }
        return sock;
    }

    public void send(SOAPMessage message) throws JAXMException {
        throw new JAXMException("Send not implemented, use call instead!");
    }
}

