/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.query;

import com.sap.engine.lib.xml.parser.handlers.SimpleAttr;
import com.sap.engine.services.webservices.espbase.query.SearchConfig;
import com.sap.engine.services.webservices.espbase.query.ThreadSystem;
import com.sap.engine.services.webservices.espbase.query.WSDLObject;
import com.sap.engine.services.webservices.espbase.query.WSDLReader;
import com.sap.engine.services.webservices.espbase.query.WSEndpoint;
import com.sap.engine.services.webservices.espbase.query.WSEndpointImpl;
import com.sap.engine.services.webservices.espbase.query.WSInterface;
import com.sap.engine.services.webservices.espbase.query.WSInterfaceImpl;
import com.sap.engine.services.webservices.espbase.query.WSQuery;
import com.sap.engine.services.webservices.espbase.query.exceptions.ObjectNotExistsException;
import com.sap.engine.services.webservices.espbase.query.exceptions.TechnicalException;
import com.sap.engine.services.webservices.espbase.query.exceptions.TimeOutException;
import com.sap.engine.services.webservices.espbase.query.exceptions.TrimmedResponseException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import com.sap.engine.services.webservices.tools.WSDLDownloadResolver;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLImport;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import com.sap.engine.services.webservices.wsil.WSILParser;
import com.sap.engine.services.webservices.wsil.descriptors.DescriptionType;
import com.sap.engine.services.webservices.wsil.descriptors.Inspection;
import com.sap.engine.services.webservices.wsil.descriptors.ServiceType;
import com.sap.engine.services.webservices.wsil.descriptors.sapdesc.p5.EndpointType;
import com.sap.engine.services.webservices.wsil.descriptors.sapdesc.p5.SapWSdescriptionType;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSQueryImpl
implements WSQuery {
    public static final String DESTINATION_DEFAULT_URL_PUBLIC_ID = "DESTINATION_DEFAULT_URL_PUBLIC_ID";
    private static int MAX_THREAD_COUNT = 20;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$webservices$espbase$query$WSQueryImpl == null ? (class$com$sap$engine$services$webservices$espbase$query$WSQueryImpl = WSQueryImpl.class$("com.sap.engine.services.webservices.espbase.query.WSQueryImpl")) : class$com$sap$engine$services$webservices$espbase$query$WSQueryImpl));
    private ThreadSystem threadSystem;
    private String wsilURL;
    private EntityResolver metaDataResolver;
    private ArrayList serviceTypes;
    private HashMap wsdlDefinitions;
    private boolean isSapWSdescriptionType;
    private boolean useOlderWsilSchema;
    private Object monitor = new Object();
    private int startedThreads = 0;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$query$WSQueryImpl;

    WSQueryImpl(EntityResolver metaDataResolver, ThreadSystem threadSystem) {
        this.threadSystem = threadSystem;
        this.metaDataResolver = metaDataResolver;
    }

    WSQueryImpl(String wsilURL, EntityResolver metaDataResolver) {
        this.wsilURL = wsilURL;
        this.metaDataResolver = metaDataResolver;
    }

    public void setUseOlderWsilSchema() {
        this.useOlderWsilSchema = true;
    }

    public boolean isSapWSdescriptionType() {
        return this.isSapWSdescriptionType;
    }

    public WSDLObject createWSDLObject(String wsdlURL) {
        return new WSDLObject(wsdlURL, this.metaDataResolver);
    }

    public WSEndpoint[] findWSEndpoints(QName interfaceQName, SearchConfig searchConfig) throws TimeOutException, TrimmedResponseException, IOException, NullPointerException, ObjectNotExistsException, TechnicalException {
        ArrayList serviceTypes;
        HashMap wsdlDefinitions;
        if (interfaceQName == null || interfaceQName.getNamespaceURI() == null || interfaceQName.getLocalPart() == null) {
            throw new NullPointerException();
        }
        if (searchConfig == null) {
            searchConfig = SearchConfig.getDefaultSearchConfig();
        }
        WSQueryImpl wSQueryImpl = this;
        synchronized (wSQueryImpl) {
            this.initialize(searchConfig);
            wsdlDefinitions = this.wsdlDefinitions;
            serviceTypes = this.serviceTypes;
        }
        ArrayList result = new ArrayList();
        if (!this.isSapWSdescriptionType) {
            int i = 0;
            while (i < serviceTypes.size()) {
                String wsdlServiceURL = WSQueryImpl.getWSDL((ServiceType)serviceTypes.get(i));
                WSDLDefinitions wsdlDefinition = (WSDLDefinitions)wsdlDefinitions.get(wsdlServiceURL);
                ArrayList services = wsdlDefinition.getServices();
                if (services.size() > 0) {
                    WSQueryImpl.accumulateEndpoint(wsdlServiceURL, interfaceQName, null, searchConfig, wsdlDefinition, services, result, this.metaDataResolver);
                }
                ++i;
            }
        } else {
            WSQueryImpl.accumulateEndpoint(wsdlDefinitions, interfaceQName, result, searchConfig, this.metaDataResolver);
        }
        if (result.size() == 0) {
            throw new ObjectNotExistsException(interfaceQName.toString());
        }
        return result.toArray(new WSEndpoint[result.size()]);
    }

    public WSEndpoint[] findWSEndpoints(WSInterface wsInterface, SearchConfig searchConfig) throws TimeOutException, TrimmedResponseException, IOException, NullPointerException, ObjectNotExistsException, TechnicalException {
        if (wsInterface == null) {
            throw new NullPointerException();
        }
        return this.findWSEndpoints(wsInterface.getName(), searchConfig);
    }

    public WSInterface[] findWSInterfaces(SearchConfig searchConfig) throws TimeOutException, TrimmedResponseException, IOException, TechnicalException {
        ArrayList serviceTypes;
        HashMap wsdlDefinitions;
        if (searchConfig == null) {
            searchConfig = SearchConfig.getDefaultSearchConfig();
        }
        WSQueryImpl wSQueryImpl = this;
        synchronized (wSQueryImpl) {
            this.initialize(searchConfig);
            wsdlDefinitions = this.wsdlDefinitions;
            serviceTypes = this.serviceTypes;
        }
        ArrayList result = new ArrayList();
        if (!this.isSapWSdescriptionType) {
            int i = 0;
            while (i < serviceTypes.size()) {
                String wsdlServiceURL = WSQueryImpl.getWSDL((ServiceType)serviceTypes.get(i));
                WSQueryImpl.getWSInterface(wsdlServiceURL, (WSDLDefinitions)wsdlDefinitions.get(wsdlServiceURL), result, searchConfig);
                ++i;
            }
        } else {
            WSQueryImpl.getWSInterface(wsdlDefinitions, result, searchConfig, this.metaDataResolver);
        }
        return result.toArray(new WSInterface[result.size()]);
    }

    private void initialize(SearchConfig searchConfig) throws TimeOutException, TechnicalException, IOException {
        Inspection.Sequence1[] sequence = null;
        InputStream inputStream = null;
        boolean wsdlDestination = false;
        if (this.metaDataResolver != null) {
            InputSource inputSource = null;
            try {
                inputSource = this.metaDataResolver.resolveEntity(null, this.wsilURL);
            }
            catch (SAXException e) {
                throw new TechnicalException(e);
            }
            if (inputSource != null && (inputStream = inputSource.getByteStream()) instanceof InnerInputStream && ((InnerInputStream)inputStream).getType() == 1) {
                wsdlDestination = true;
                DescriptionType descrType = new DescriptionType();
                descrType.setReferencedNamespace("http://schemas.xmlsoap.org/wsdl/");
                descrType.setLocation(((InnerInputStream)inputStream).getUrlToRequest());
                ServiceType service = new ServiceType();
                service.setDescription(new DescriptionType[]{descrType});
                Inspection.Sequence1.Choice1 choice = new Inspection.Sequence1.Choice1();
                choice.setService(service);
                Inspection.Sequence1 seq = new Inspection.Sequence1();
                seq.setChoiceGroup1(choice);
                sequence = new Inspection.Sequence1[]{seq};
            }
        }
        if (!wsdlDestination) {
            if (inputStream == null) {
                inputStream = new URL(this.wsilURL).openStream();
            }
            try {
                Inspection inspection = WSILParser.loadInspection(inputStream);
                inputStream.close();
                sequence = inspection.getSequenceGroup1();
            }
            catch (TypeMappingException e) {
                throw new TechnicalException((Throwable)((Object)e));
            }
        }
        ArrayList<ServiceType> newServiceTypes = new ArrayList<ServiceType>();
        ArrayList<ServiceType> successfulServiceTypes = new ArrayList<ServiceType>();
        HashMap<String, SapWSdescriptionType> newWsdlDefinitions = new HashMap<String, SapWSdescriptionType>();
        int i = 0;
        while (i < sequence.length) {
            Inspection.Sequence1 element = sequence[i];
            Inspection.Sequence1.Choice1 choice = element.getChoiceGroup1();
            if (choice.hasService()) {
                try {
                    ServiceType serviceType = choice.getService();
                    newServiceTypes.add(serviceType);
                }
                catch (Exception e) {
                    location.catching((Throwable)e);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < newServiceTypes.size()) {
            SapWSdescriptionType wSdescriptionType;
            ServiceType serviceType = (ServiceType)newServiceTypes.get(i2);
            String wsdlServiceURL = WSQueryImpl.getWSDL(serviceType);
            if (!this.useOlderWsilSchema && (wSdescriptionType = WSQueryImpl.getSapWSdescriptionType(serviceType)) != null) {
                newWsdlDefinitions.put(wsdlServiceURL, wSdescriptionType);
                this.isSapWSdescriptionType = true;
            } else if (this.wsdlDefinitions != null && this.wsdlDefinitions.containsKey(wsdlServiceURL)) {
                newWsdlDefinitions.put(wsdlServiceURL, (SapWSdescriptionType)this.wsdlDefinitions.get(wsdlServiceURL));
                successfulServiceTypes.add(serviceType);
            } else {
                EntityResolver nextMetaDataResolver = this.metaDataResolver;
                if (nextMetaDataResolver instanceof WSDLDownloadResolver) {
                    nextMetaDataResolver = (EntityResolver)((WSDLDownloadResolver)nextMetaDataResolver).clone();
                }
                WSDLReader reader = new WSDLReader(wsdlServiceURL, inputStream, nextMetaDataResolver, newWsdlDefinitions, successfulServiceTypes, serviceType, this);
                Object object = this.monitor;
                synchronized (object) {
                    if (this.startedThreads == MAX_THREAD_COUNT) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException e) {
                            throw new TechnicalException(e);
                        }
                    }
                    ++this.startedThreads;
                }
                if (wsdlDestination) {
                    reader.run();
                    reader.checkForException();
                } else if (this.threadSystem != null) {
                    this.threadSystem.startThread(reader, false);
                } else {
                    Thread next = new Thread(reader);
                    next.start();
                }
            }
            ++i2;
        }
        this.waitMain(searchConfig.getTimeOut());
        this.serviceTypes = successfulServiceTypes;
        this.wsdlDefinitions = newWsdlDefinitions;
    }

    void notifyMain() {
        Object object = this.monitor;
        synchronized (object) {
            --this.startedThreads;
            this.monitor.notify();
        }
    }

    void waitMain(int timeout) throws TimeOutException {
        long start = System.currentTimeMillis();
        if (this.startedThreads > 0) {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    while (this.startedThreads > 0) {
                        this.monitor.wait();
                        long end = System.currentTimeMillis();
                        if (end - start <= (long)timeout) continue;
                        throw new TimeOutException(timeout + "");
                    }
                }
                catch (InterruptedException e) {
                    location.catching((Throwable)e);
                }
            }
        }
    }

    private static String getWSDL(ServiceType service) {
        DescriptionType[] descriptionTypes = service.getDescription();
        int i = 0;
        while (i < descriptionTypes.length) {
            DescriptionType descrType = descriptionTypes[i];
            if (descrType.getReferencedNamespace().equals("http://schemas.xmlsoap.org/wsdl/")) {
                return descrType.getLocation();
            }
            ++i;
        }
        return null;
    }

    private static SapWSdescriptionType getSapWSdescriptionType(ServiceType service) throws TechnicalException {
        DescriptionType[] descriptionTypes = service.getDescription();
        int i = 0;
        while (i < descriptionTypes.length) {
            DescriptionType descrType = descriptionTypes[i];
            if (descrType.getReferencedNamespace().equals("http://www.sap.com/ws/2006/01/inspection/")) {
                try {
                    return WSILParser.loadSapWSdescriptionType(descrType.get_any());
                }
                catch (TypeMappingException e) {
                    throw new TechnicalException((Throwable)((Object)e));
                }
                catch (TransformerException e) {
                    throw new TechnicalException(e);
                }
                catch (IOException e) {
                    throw new TechnicalException(e);
                }
            }
            ++i;
        }
        return null;
    }

    private static String getAttributeValue(ArrayList attributes, String key) {
        int i = 0;
        while (i < attributes.size()) {
            SimpleAttr attr = (SimpleAttr)attributes.get(i);
            if (attr.localName.equals(key)) {
                return attr.value;
            }
            ++i;
        }
        return null;
    }

    private static String getImportLocation(ArrayList imports, String namespace) {
        int i = 0;
        while (i < imports.size()) {
            WSDLImport imp = (WSDLImport)imports.get(i);
            if (imp.getNamespace().equals(namespace)) {
                return imp.getLocation();
            }
            ++i;
        }
        return null;
    }

    private static void getWSInterface(HashMap definitions, ArrayList wsInterfaces, SearchConfig searchConfig, EntityResolver metaDataEntityResolver) throws TrimmedResponseException, TechnicalException {
        short maxCount = searchConfig.getMaxCount();
        String namespacePattern = searchConfig.getNameSpace();
        String namePattern = searchConfig.getNamePattern();
        boolean caseSensitive = searchConfig.isCaseSensitive();
        Iterator iter = definitions.entrySet().iterator();
        while (iter.hasNext()) {
            SapWSdescriptionType sapWSdescriptionType = (SapWSdescriptionType)iter.next().getValue();
            String namespace = sapWSdescriptionType.getServiceDefinition().getWsdlNamespace();
            String name = sapWSdescriptionType.getServiceDefinition().getWsdlName();
            if (!WSQueryImpl.match(namespacePattern, namespace, caseSensitive) || !WSQueryImpl.match(namePattern, name, caseSensitive)) continue;
            if (maxCount == wsInterfaces.size()) {
                throw new TrimmedResponseException(maxCount + "", wsInterfaces.toArray(new WSInterface[wsInterfaces.size()]));
            }
            WSInterfaceImpl wsInterface = new WSInterfaceImpl(new QName(namespace, name), sapWSdescriptionType.getService().getWsdl(), metaDataEntityResolver);
            wsInterfaces.add(wsInterface);
        }
    }

    private static void getWSInterface(String wsdlServiceURL, WSDLDefinitions definitions, ArrayList wsInterfaces, SearchConfig searchConfig) throws TrimmedResponseException, TechnicalException {
        short maxCount = searchConfig.getMaxCount();
        String namespacePattern = searchConfig.getNameSpace();
        String namePattern = searchConfig.getNamePattern();
        boolean caseSensitive = searchConfig.isCaseSensitive();
        ArrayList portTypes = definitions.getPortTypes();
        int i = 0;
        while (i < portTypes.size()) {
            if (maxCount == wsInterfaces.size()) {
                throw new TrimmedResponseException(maxCount + "", wsInterfaces.toArray(new WSInterface[wsInterfaces.size()]));
            }
            WSDLPortType portType = (WSDLPortType)portTypes.get(i);
            WSInterface wsInterface = WSQueryImpl.getWSInterface(wsdlServiceURL, definitions, namespacePattern, namePattern, caseSensitive, portType);
            if (wsInterface != null) {
                wsInterfaces.add(wsInterface);
            }
            ++i;
        }
    }

    private static boolean match(String pattern, String string, boolean caseSensitive) {
        if (pattern == null) {
            return true;
        }
        if (!caseSensitive) {
            pattern = pattern.toLowerCase();
            string = string.toLowerCase();
        }
        return WSQueryImpl.match(pattern, 0, string, 0);
    }

    private static boolean match(String pattern, int patternStart, String string, int stringStart) {
        int s = stringStart;
        int p = patternStart;
        while (true) {
            boolean pEnd;
            boolean sEnd = s >= string.length();
            boolean bl = pEnd = p >= pattern.length();
            if (sEnd && pEnd) {
                return true;
            }
            if (sEnd || pEnd) {
                return false;
            }
            if (pattern.charAt(p) != '?') {
                if (pattern.charAt(p) == '*') {
                    ++p;
                    int i = string.length();
                    while (i >= s) {
                        if (WSQueryImpl.match(pattern, p, string, i)) {
                            return true;
                        }
                        --i;
                    }
                    return false;
                }
                if (pattern.charAt(p) != string.charAt(s)) {
                    return false;
                }
            }
            ++p;
            ++s;
        }
    }

    private static WSInterface getWSInterface(String wsdlServiceURL, WSDLDefinitions definitions, String namespacePattern, String namePattern, boolean caseSensitive, WSDLPortType portType) {
        String namespace = portType.getNamespace();
        String name = portType.getName();
        if (!WSQueryImpl.match(namespacePattern, namespace, caseSensitive) || !WSQueryImpl.match(namePattern, name, caseSensitive)) {
            return null;
        }
        WSDLObject wsdlObject = new WSDLObject(wsdlServiceURL, definitions);
        return new WSInterfaceImpl(new QName(namespace, name), wsdlObject);
    }

    private static void accumulateEndpoint(HashMap definitions, QName wsQName, ArrayList endpointsArray, SearchConfig searchConfig, EntityResolver metaDataResolver) throws TrimmedResponseException {
        Iterator iter = definitions.entrySet().iterator();
        while (iter.hasNext()) {
            SapWSdescriptionType sapWSdescriptionType = (SapWSdescriptionType)iter.next().getValue();
            String namespace = sapWSdescriptionType.getServiceDefinition().getWsdlNamespace();
            String name = sapWSdescriptionType.getServiceDefinition().getWsdlName();
            if (!namespace.equals(wsQName.getNamespaceURI()) || !name.equals(wsQName.getLocalPart())) continue;
            WSQueryImpl.accumulateEndpoint(sapWSdescriptionType, endpointsArray, searchConfig, metaDataResolver);
        }
    }

    private static void accumulateEndpoint(SapWSdescriptionType sapWSdescriptionType, ArrayList endpointsArray, SearchConfig searchConfig, EntityResolver metaDataResolver) throws TrimmedResponseException {
        short maxCount = searchConfig.getMaxCount();
        String namespacePattern = searchConfig.getNameSpace();
        String namePattern = searchConfig.getNamePattern();
        boolean caseSensitive = searchConfig.isCaseSensitive();
        EndpointType[] endpoints = sapWSdescriptionType.getServiceDefinition().getEndpoint();
        int i = 0;
        while (i < endpoints.length) {
            EndpointType endpoint = endpoints[i];
            String bindingDataNamespace = endpoint.getBinding().getWsdlNamespace();
            String bindingDataName = endpoint.getBinding().getWsdlName();
            if (WSQueryImpl.match(namespacePattern, bindingDataNamespace, caseSensitive) && WSQueryImpl.match(namePattern, bindingDataName, caseSensitive)) {
                if (maxCount == endpointsArray.size()) {
                    throw new TrimmedResponseException(maxCount + "", endpointsArray.toArray(new WSEndpoint[endpointsArray.size()]));
                }
                WSInterfaceImpl wsInterface = new WSInterfaceImpl(new QName(sapWSdescriptionType.getServiceDefinition().getWsdlNamespace(), sapWSdescriptionType.getServiceDefinition().getWsdlName()), sapWSdescriptionType.getService().getWsdl(), metaDataResolver);
                WSEndpointImpl wsEndpoint = new WSEndpointImpl(new QName(bindingDataNamespace, bindingDataName), endpoint.getEndpointURL(), endpoint.getBinding().getWsdl(), metaDataResolver, endpoint.getPortName(), new QName(sapWSdescriptionType.getService().getWsdlNamespace(), sapWSdescriptionType.getService().getName()), wsInterface);
                endpointsArray.add(wsEndpoint);
            }
            ++i;
        }
    }

    private static void accumulateEndpoint(String wsdlServiceURL, QName wsQName, WSInterface wsInterface, SearchConfig searchConfig, WSDLDefinitions definition, ArrayList services, ArrayList endpoints, EntityResolver metaDataResolver) throws TrimmedResponseException {
        int j = 0;
        while (j < services.size()) {
            WSDLService service = (WSDLService)services.get(j);
            ArrayList array = service.getPorts();
            int i = 0;
            while (i < array.size()) {
                WSDLPortType wsdlPortType = (WSDLPortType)definition.getPortTypes().get(0);
                if (wsQName.getNamespaceURI().equals(wsdlPortType.getNamespace()) && wsQName.getLocalPart().equals(wsdlPortType.getName())) {
                    short maxCount = searchConfig.getMaxCount();
                    String namespacePattern = searchConfig.getNameSpace();
                    String namePattern = searchConfig.getNamePattern();
                    boolean caseSensitive = searchConfig.isCaseSensitive();
                    WSDLPort port = (WSDLPort)array.get(i);
                    String bindingDataName = port.getBinding().getLocalName();
                    String bindingDataNamespace = port.getBinding().getURI();
                    if (WSQueryImpl.match(namespacePattern, bindingDataNamespace, caseSensitive) && WSQueryImpl.match(namePattern, bindingDataName, caseSensitive)) {
                        if (maxCount == endpoints.size()) {
                            throw new TrimmedResponseException(maxCount + "", endpoints.toArray(new WSEndpoint[endpoints.size()]));
                        }
                        QName bindingName = new QName(bindingDataNamespace, bindingDataName);
                        QName serviceName = new QName(service.getNamespace(), service.getName());
                        ArrayList attributes = port.getExtension().getAttributes();
                        String endpointURL = WSQueryImpl.getAttributeValue(attributes, "location");
                        String bindingWsdlUrl = WSQueryImpl.getImportLocation(definition.getImportDeclaratuions(), bindingName.getNamespaceURI());
                        if (bindingWsdlUrl == null) {
                            bindingWsdlUrl = wsdlServiceURL;
                        }
                        if (wsInterface == null) {
                            WSDLObject wsdlObject = new WSDLObject(wsdlServiceURL, definition);
                            wsInterface = new WSInterfaceImpl(new QName(wsdlPortType.getNamespace(), wsdlPortType.getName()), wsdlObject);
                        }
                        endpoints.add(new WSEndpointImpl(bindingName, endpointURL, bindingWsdlUrl, metaDataResolver, port.getName(), serviceName, wsInterface));
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InnerInputStream
    extends InputStream {
        Method closeMethod_Connection;
        private InputStream inner;
        private Object connection;
        private int type;
        private String urlToRequest;

        public InnerInputStream(Object connection, InputStream inner, Method closeMethod_Connection, int type, String urlToRequest) {
            this.connection = connection;
            this.inner = inner;
            this.closeMethod_Connection = closeMethod_Connection;
            this.type = type;
            this.urlToRequest = urlToRequest;
        }

        public int getType() {
            return this.type;
        }

        public String getUrlToRequest() {
            return this.urlToRequest;
        }

        public int read() throws IOException {
            return this.inner.read();
        }

        public int available() throws IOException {
            return this.inner.available();
        }

        public void close() throws IOException {
            this.inner.close();
            try {
                this.closeMethod_Connection.invoke(this.connection, null);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.toString());
            }
        }

        public synchronized void mark(int readlimit) {
            this.inner.mark(readlimit);
        }

        public boolean markSupported() {
            return this.inner.markSupported();
        }

        public int read(byte[] b) throws IOException {
            return this.inner.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.inner.read(b, off, len);
        }

        public synchronized void reset() throws IOException {
            this.inner.reset();
        }

        public long skip(long n) throws IOException {
            return this.inner.skip(n);
        }

        public boolean equals(Object obj) {
            return this.inner.equals(obj);
        }

        public int hashCode() {
            return this.inner.hashCode();
        }

        public String toString() {
            return this.inner.toString();
        }
    }
}

